/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.functions.StringTemplate;

public record BooleanDialogInputImpl(String key, Component label, boolean initial, String onTrue, String onFalse) implements BooleanDialogInput
{

    public static final class BuilderImpl
    implements BooleanDialogInput.Builder {
        private final String key;
        private final Component label;
        private boolean initial = false;
        private String onTrue = "true";
        private String onFalse = "false";

        public BuilderImpl(String key, Component label) {
            Preconditions.checkArgument((boolean)StringTemplate.isValidVariableName(key), (Object)"key must be a valid input name");
            this.key = key;
            this.label = label;
        }

        public BooleanDialogInput.Builder initial(boolean initial) {
            this.initial = initial;
            return this;
        }

        public BooleanDialogInput.Builder onTrue(String onTrue) {
            this.onTrue = onTrue;
            return this;
        }

        public BooleanDialogInput.Builder onFalse(String onFalse) {
            this.onFalse = onFalse;
            return this;
        }

        public BooleanDialogInput build() {
            return new BooleanDialogInputImpl(this.key, this.label, this.initial, this.onTrue, this.onFalse);
        }
    }
}

