/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import io.papermc.paper.registry.RegistryBuilder;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.set.RegistryValueSet;
import io.papermc.paper.registry.set.RegistryValueSetBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Keyed;

public class RegistryValueSetBuilderImpl<M, API extends Keyed, BUILDER extends RegistryBuilder<API>>
implements RegistryValueSetBuilder<API, BUILDER> {
    private final RegistryKey<API> registryKey;
    private final Conversions conversions;
    private final List<API> instances = new ArrayList<API>();

    public RegistryValueSetBuilderImpl(RegistryKey<API> registryKey, Conversions conversions) {
        this.registryKey = registryKey;
        this.conversions = conversions;
    }

    public RegistryValueSetBuilder<API, BUILDER> add(Consumer<RegistryBuilderFactory<API, ? extends BUILDER>> builder) {
        this.instances.add(this.conversions.createApiInstanceFromBuilder(this.registryKey, builder));
        return this;
    }

    public RegistryValueSet<API> build() {
        return RegistrySet.valueSet(this.registryKey, this.instances);
    }
}

