/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.collect.ForwardingSet;
import java.util.Collection;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class SizeLimitedSet<E>
extends ForwardingSet<E> {
    private final Set<E> delegate;
    private final int maxSize;

    public SizeLimitedSet(Set<E> delegate, int maxSize) {
        this.delegate = delegate;
        this.maxSize = maxSize;
    }

    public boolean add(E element) {
        if (this.size() >= this.maxSize) {
            return false;
        }
        return super.add(element);
    }

    public boolean addAll(Collection<? extends @Nullable E> collection) {
        if (collection.size() + this.size() >= this.maxSize) {
            return false;
        }
        boolean edited = false;
        for (E element : collection) {
            edited |= super.add(element);
        }
        return edited;
    }

    protected Set<E> delegate() {
        return this.delegate;
    }
}

