/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUtil {
    public static FoundRectangle getLargestRectangleAround(BlockPos centerPos, Direction.Axis axis1, int max1, Direction.Axis axis2, int max2, Predicate<BlockPos> posPredicate) {
        IntBounds intBounds;
        int i2;
        BlockPos.MutableBlockPos mutableBlockPos = centerPos.mutable();
        Direction direction = Direction.get(Direction.AxisDirection.NEGATIVE, axis1);
        Direction opposite = direction.getOpposite();
        Direction direction1 = Direction.get(Direction.AxisDirection.NEGATIVE, axis2);
        Direction opposite1 = direction1.getOpposite();
        int limit = BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos), direction, max1);
        int limit1 = BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos), opposite, max1);
        int i = limit;
        IntBounds[] intBoundss = new IntBounds[limit + 1 + limit1];
        intBoundss[limit] = new IntBounds(BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos), direction1, max2), BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos), opposite1, max2));
        int i1 = intBoundss[limit].min;
        for (i2 = 1; i2 <= limit; ++i2) {
            intBounds = intBoundss[i - (i2 - 1)];
            intBoundss[i - i2] = new IntBounds(BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos).move(direction, i2), direction1, intBounds.min), BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos).move(direction, i2), opposite1, intBounds.max));
        }
        for (i2 = 1; i2 <= limit1; ++i2) {
            intBounds = intBoundss[i + i2 - 1];
            intBoundss[i + i2] = new IntBounds(BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos).move(opposite, i2), direction1, intBounds.min), BlockUtil.getLimit(posPredicate, mutableBlockPos.set(centerPos).move(opposite, i2), opposite1, intBounds.max));
        }
        i2 = 0;
        int i3 = 0;
        int i4 = 0;
        int i5 = 0;
        int[] ints = new int[intBoundss.length];
        for (int i6 = i1; i6 >= 0; --i6) {
            int i9;
            int i8;
            IntBounds intBounds1;
            for (int i7 = 0; i7 < intBoundss.length; ++i7) {
                intBounds1 = intBoundss[i7];
                i8 = i1 - intBounds1.min;
                i9 = i1 + intBounds1.max;
                ints[i7] = i6 >= i8 && i6 <= i9 ? i9 + 1 - i6 : 0;
            }
            Pair<IntBounds, Integer> maxRectangleLocation = BlockUtil.getMaxRectangleLocation(ints);
            intBounds1 = (IntBounds)maxRectangleLocation.getFirst();
            i8 = 1 + intBounds1.max - intBounds1.min;
            i9 = (Integer)maxRectangleLocation.getSecond();
            if (i8 * i9 <= i4 * i5) continue;
            i2 = intBounds1.min;
            i3 = i6;
            i4 = i8;
            i5 = i9;
        }
        return new FoundRectangle(centerPos.relative(axis1, i2 - i).relative(axis2, i3 - i1), i4, i5);
    }

    private static int getLimit(Predicate<BlockPos> posPredicate, BlockPos.MutableBlockPos centerPos, Direction direction, int max) {
        int i;
        for (i = 0; i < max && posPredicate.test(centerPos.move(direction)); ++i) {
        }
        return i;
    }

    @VisibleForTesting
    static Pair<IntBounds, Integer> getMaxRectangleLocation(int[] heights) {
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        IntArrayList intStack = new IntArrayList();
        intStack.push(0);
        for (int i3 = 1; i3 <= heights.length; ++i3) {
            int i4;
            int n = i4 = i3 == heights.length ? 0 : heights[i3];
            while (!intStack.isEmpty()) {
                int i5 = heights[intStack.topInt()];
                if (i4 >= i5) {
                    intStack.push(i3);
                    break;
                }
                intStack.popInt();
                int i6 = intStack.isEmpty() ? 0 : intStack.topInt() + 1;
                if (i5 * (i3 - i6) <= i2 * (i1 - i)) continue;
                i1 = i3;
                i = i6;
                i2 = i5;
            }
            if (!intStack.isEmpty()) continue;
            intStack.push(i3);
        }
        return new Pair((Object)new IntBounds(i, i1 - 1), (Object)i2);
    }

    public static Optional<BlockPos> getTopConnectedBlock(BlockGetter level, BlockPos pos, Block baseBlock, Direction direction, Block endBlock) {
        BlockState blockState;
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        do {
            mutableBlockPos.move(direction);
        } while ((blockState = level.getBlockState(mutableBlockPos)).is(baseBlock));
        return blockState.is(endBlock) ? Optional.of(mutableBlockPos) : Optional.empty();
    }

    public static class IntBounds {
        public final int min;
        public final int max;

        public IntBounds(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "IntBounds{min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class FoundRectangle {
        public final BlockPos minCorner;
        public final int axis1Size;
        public final int axis2Size;

        public FoundRectangle(BlockPos minCorner, int axis1Size, int axis2Size) {
            this.minCorner = minCorner;
            this.axis1Size = axis1Size;
            this.axis2Size = axis2Size;
        }
    }
}

