/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.PaperCommandSourceStack;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.PermissionSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.spigotmc.SpigotConfig;

public class CommandSourceStack
implements ExecutionCommandSource<CommandSourceStack>,
PermissionSource,
SharedSuggestionProvider,
PaperCommandSourceStack {
    public static final SimpleCommandExceptionType ERROR_NOT_PLAYER = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable("permissions.requires.player"));
    public static final SimpleCommandExceptionType ERROR_NOT_ENTITY = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable("permissions.requires.entity"));
    public final CommandSource source;
    private final Vec3 worldPosition;
    private final ServerLevel level;
    private final int permissionLevel;
    private final String textName;
    private final net.minecraft.network.chat.Component displayName;
    private final MinecraftServer server;
    private final boolean silent;
    @Nullable
    private final Entity entity;
    private final CommandResultCallback resultCallback;
    private final EntityAnchorArgument.Anchor anchor;
    private final Vec2 rotation;
    private final CommandSigningContext signingContext;
    private final TaskChainer chatMessageChainer;
    public boolean bypassSelectorPermissions = false;

    public CommandSourceStack(CommandSource source, Vec3 worldPosition, Vec2 rotation, ServerLevel level, int permissionLevel, String textName, net.minecraft.network.chat.Component displayName, MinecraftServer server, @Nullable Entity entity) {
        this(source, worldPosition, rotation, level, permissionLevel, textName, displayName, server, entity, false, CommandResultCallback.EMPTY, EntityAnchorArgument.Anchor.FEET, CommandSigningContext.ANONYMOUS, TaskChainer.immediate(server));
    }

    protected CommandSourceStack(CommandSource source, Vec3 worldPosition, Vec2 rotation, ServerLevel level, int permissionLevel, String textName, net.minecraft.network.chat.Component displayName, MinecraftServer server, @Nullable Entity entity, boolean silent, CommandResultCallback resultCallback, EntityAnchorArgument.Anchor anchor, CommandSigningContext signingContext, TaskChainer chatMessageChainer) {
        this.source = source;
        this.worldPosition = worldPosition;
        this.level = level;
        this.silent = silent;
        this.entity = entity;
        this.permissionLevel = permissionLevel;
        this.textName = textName;
        this.displayName = displayName;
        this.server = server;
        this.resultCallback = resultCallback;
        this.anchor = anchor;
        this.rotation = rotation;
        this.signingContext = signingContext;
        this.chatMessageChainer = chatMessageChainer;
    }

    public CommandSourceStack withSource(CommandSource source) {
        return this.source == source ? this : new CommandSourceStack(source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withEntity(Entity entity) {
        return this.entity == entity ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, entity.getPlainTextName(), entity.getDisplayName(), this.server, entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withPosition(Vec3 pos) {
        return this.worldPosition.equals(pos) ? this : new CommandSourceStack(this.source, pos, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withLocation(Location location) {
        return this.getLocation().equals((Object)location) ? this : new CommandSourceStack(this.source, new Vec3(location.x(), location.y(), location.z()), new Vec2(location.getPitch(), location.getYaw()), ((CraftWorld)location.getWorld()).getHandle(), this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withRotation(Vec2 rotation) {
        return this.rotation.equals(rotation) ? this : new CommandSourceStack(this.source, this.worldPosition, rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    @Override
    public CommandSourceStack withCallback(CommandResultCallback callback) {
        return Objects.equals(this.resultCallback, callback) ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, callback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withCallback(CommandResultCallback callback, BinaryOperator<CommandResultCallback> operator) {
        CommandResultCallback commandResultCallback = (CommandResultCallback)operator.apply(this.resultCallback, callback);
        return this.withCallback(commandResultCallback);
    }

    public CommandSourceStack withSuppressedOutput() {
        return !this.silent && !this.source.alwaysAccepts() ? new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, true, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer) : this;
    }

    public CommandSourceStack withPermission(int permissionLevel) {
        return permissionLevel == this.permissionLevel ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withMaximumPermission(int permissionLevel) {
        return permissionLevel <= this.permissionLevel ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withAnchor(EntityAnchorArgument.Anchor anchor) {
        return anchor == this.anchor ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack withLevel(ServerLevel level) {
        if (level == this.level) {
            return this;
        }
        double teleportationScale = DimensionType.getTeleportationScale(this.level.dimensionType(), level.dimensionType());
        Vec3 vec3 = new Vec3(this.worldPosition.x * teleportationScale, this.worldPosition.y, this.worldPosition.z * teleportationScale);
        return new CommandSourceStack(this.source, vec3, this.rotation, level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, this.signingContext, this.chatMessageChainer);
    }

    public CommandSourceStack facing(Entity entity, EntityAnchorArgument.Anchor anchor) {
        return this.facing(anchor.apply(entity));
    }

    public CommandSourceStack facing(Vec3 lookPos) {
        Vec3 vec3 = this.anchor.apply(this);
        double d = lookPos.x - vec3.x;
        double d1 = lookPos.y - vec3.y;
        double d2 = lookPos.z - vec3.z;
        double squareRoot = Math.sqrt(d * d + d2 * d2);
        float f = Mth.wrapDegrees((float)(-(Mth.atan2(d1, squareRoot) * 180.0 / 3.1415927410125732)));
        float f1 = Mth.wrapDegrees((float)(Mth.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f);
        return this.withRotation(new Vec2(f, f1));
    }

    public CommandSourceStack withSigningContext(CommandSigningContext signingContext, TaskChainer chatMessageChainer) {
        return signingContext == this.signingContext && chatMessageChainer == this.chatMessageChainer ? this : new CommandSourceStack(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.resultCallback, this.anchor, signingContext, chatMessageChainer);
    }

    public net.minecraft.network.chat.Component getDisplayName() {
        return this.displayName;
    }

    public String getTextName() {
        return this.textName;
    }

    @Override
    public boolean hasPermission(int level) {
        return this.permissionLevel >= level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceRespectPermissionLevel() {
        if (this.source == CommandSource.NULL) return true;
        CommandSource commandSource = this.source;
        if (!(commandSource instanceof BaseCommandBlock)) return false;
        BaseCommandBlock commandBlock = (BaseCommandBlock)((Object)commandSource);
        if (!commandBlock.getLevel().paperConfig().commandBlocks.forceFollowPermLevel) return false;
        return true;
    }

    public boolean hasPermission(int i, String bukkitPermission) {
        BooleanSupplier hasBukkitPerm = () -> this.source == CommandSource.NULL || this.getBukkitSender().hasPermission(bukkitPermission);
        if (this.getServer() == null || !this.getServer().server.ignoreVanillaPermissions) {
            boolean hasPermLevel;
            boolean bl = hasPermLevel = this.permissionLevel >= i;
            if (this.forceRespectPermissionLevel()) {
                return hasPermLevel && hasBukkitPerm.getAsBoolean();
            }
            return hasPermLevel || hasBukkitPerm.getAsBoolean();
        }
        return hasBukkitPerm.getAsBoolean();
    }

    public boolean testPermission(int i, String bukkitPermission) {
        if (this.hasPermission(i, bukkitPermission)) {
            return true;
        }
        Component permissionMessage = this.getLevel().getServer().server.permissionMessage();
        if (!permissionMessage.equals((Object)Component.empty())) {
            this.sendFailure(PaperAdventure.asVanilla(permissionMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<permission>").replacement(bukkitPermission).build())));
        }
        return false;
    }

    public Vec3 getPosition() {
        return this.worldPosition;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public Entity getEntityOrException() throws CommandSyntaxException {
        if (this.entity == null) {
            throw ERROR_NOT_ENTITY.create();
        }
        return this.entity;
    }

    public ServerPlayer getPlayerOrException() throws CommandSyntaxException {
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer;
        }
        throw ERROR_NOT_PLAYER.create();
    }

    @Nullable
    public ServerPlayer getPlayer() {
        ServerPlayer serverPlayer;
        Entity entity = this.entity;
        return entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null;
    }

    public boolean isPlayer() {
        return this.entity instanceof ServerPlayer;
    }

    public Vec2 getRotation() {
        return this.rotation;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public EntityAnchorArgument.Anchor getAnchor() {
        return this.anchor;
    }

    public CommandSigningContext getSigningContext() {
        return this.signingContext;
    }

    public TaskChainer getChatMessageChainer() {
        return this.chatMessageChainer;
    }

    public boolean shouldFilterMessageTo(ServerPlayer receiver) {
        ServerPlayer player = this.getPlayer();
        return receiver != player && (player != null && player.isTextFilteringEnabled() || receiver.isTextFilteringEnabled());
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean shouldFilter, ChatType.Bound boundChatType) {
        if (!this.silent) {
            ServerPlayer player = this.getPlayer();
            if (player != null) {
                player.sendChatMessage(message, shouldFilter, boundChatType);
            } else {
                this.source.sendSystemMessage(boundChatType.decorate(message.content()));
            }
        }
    }

    public void sendSystemMessage(net.minecraft.network.chat.Component message) {
        if (!this.silent) {
            ServerPlayer player = this.getPlayer();
            if (player != null) {
                player.sendSystemMessage(message);
            } else {
                this.source.sendSystemMessage(message);
            }
        }
    }

    public void sendSuccess(@Nullable String message) {
        this.sendSuccess(message, false);
    }

    public void sendSuccess(@Nullable String message, boolean broadcastToOps) {
        if (message == null) {
            return;
        }
        this.sendSuccess(MiniMessage.miniMessage().deserialize((Object)message), broadcastToOps);
    }

    public void sendSuccess(@Nullable Component message) {
        this.sendSuccess(message, false);
    }

    public void sendSuccess(@Nullable Component message, boolean broadcastToOps) {
        if (message == null) {
            return;
        }
        this.sendSuccess(() -> PaperAdventure.asVanilla(message), broadcastToOps);
    }

    public void sendSuccess(Supplier<net.minecraft.network.chat.Component> messageSupplier, boolean allowLogging) {
        boolean flag1;
        boolean flag = this.source.acceptsSuccess() && !this.silent;
        boolean bl = flag1 = allowLogging && this.source.shouldInformAdmins() && !this.silent;
        if (flag || flag1) {
            net.minecraft.network.chat.Component component = messageSupplier.get();
            if (flag) {
                this.source.sendSystemMessage(component);
            }
            if (flag1) {
                this.broadcastToAdmins(component);
            }
        }
    }

    private void broadcastToAdmins(net.minecraft.network.chat.Component message) {
        MutableComponent component = net.minecraft.network.chat.Component.translatable("chat.type.admin", this.getDisplayName(), message).withStyle(ChatFormatting.GRAY, ChatFormatting.ITALIC);
        if (this.server.getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
            for (ServerPlayer serverPlayer : this.server.getPlayerList().getPlayers()) {
                if (serverPlayer.commandSource() == this.source || !serverPlayer.getBukkitEntity().hasPermission("minecraft.admin.command_feedback")) continue;
                serverPlayer.sendSystemMessage(component);
            }
        }
        if (this.source != this.server && this.server.getGameRules().getBoolean(GameRules.RULE_LOGADMINCOMMANDS) && !SpigotConfig.silentCommandBlocks) {
            this.server.sendSystemMessage(component);
        }
    }

    public void sendFailure(net.minecraft.network.chat.Component message) {
        this.sendFailure(message, true);
    }

    public void sendFailure(net.minecraft.network.chat.Component message, boolean withStyle) {
        if (this.source.acceptsFailure() && !this.silent) {
            this.source.sendSystemMessage(withStyle ? net.minecraft.network.chat.Component.empty().append(message).withStyle(ChatFormatting.RED) : message);
        }
    }

    @Override
    public CommandResultCallback callback() {
        return this.resultCallback;
    }

    @Override
    public Collection<String> getOnlinePlayerNames() {
        ServerPlayer sourcePlayer;
        Entity entity = this.entity;
        return entity instanceof ServerPlayer && !(sourcePlayer = (ServerPlayer)entity).getBukkitEntity().hasPermission("paper.bypass-visibility.tab-completion") ? this.getServer().getPlayerList().getPlayers().stream().filter(serverPlayer -> sourcePlayer.getBukkitEntity().canSee(serverPlayer.getBukkitEntity())).map(serverPlayer -> serverPlayer.getGameProfile().name()).toList() : Lists.newArrayList((Object[])this.server.getPlayerNames());
    }

    @Override
    public Collection<String> getAllTeams() {
        return this.server.getScoreboard().getTeamNames();
    }

    @Override
    public Stream<ResourceLocation> getAvailableSounds() {
        return BuiltInRegistries.SOUND_EVENT.stream().map(SoundEvent::location);
    }

    @Override
    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> context) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> registryKey, SharedSuggestionProvider.ElementSuggestionType type, SuggestionsBuilder builder, CommandContext<?> context) {
        if (registryKey == Registries.RECIPE) {
            return SharedSuggestionProvider.suggestResource(this.server.getRecipeManager().getRecipes().stream().map(recipeHolder -> recipeHolder.id().location()), builder);
        }
        if (registryKey == Registries.ADVANCEMENT) {
            Collection<AdvancementHolder> allAdvancements = this.server.getAdvancements().getAllAdvancements();
            return SharedSuggestionProvider.suggestResource(allAdvancements.stream().map(AdvancementHolder::id), builder);
        }
        return this.getLookup(registryKey).map(holderLookup -> {
            this.suggestRegistryElements((HolderLookup<?>)holderLookup, type, builder);
            return builder.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    private Optional<? extends HolderLookup<?>> getLookup(ResourceKey<? extends Registry<?>> registryKey) {
        Optional optional = this.registryAccess().lookup(registryKey);
        return optional.isPresent() ? optional : this.server.reloadableRegistries().lookup().lookup(registryKey);
    }

    @Override
    public Set<ResourceKey<Level>> levels() {
        return this.server.levelKeys();
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.server.registryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    @Override
    public CommandDispatcher<CommandSourceStack> dispatcher() {
        return this.getServer().getFunctions().getDispatcher();
    }

    @Override
    public void handleError(CommandExceptionType exceptionType, Message message, boolean success, @Nullable TraceCallbacks tracer) {
        if (tracer != null) {
            tracer.onError(message.getString());
        }
        if (!success) {
            this.sendFailure(ComponentUtils.fromMessage(message));
        }
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public CommandSourceStack getHandle() {
        return this;
    }

    @Override
    public CommandSender getBukkitSender() {
        return this.source.getBukkitSender(this);
    }
}

