/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.commands.functions.CommandFunction;

public record StringTemplate(List<String> segments, List<String> variables) {
    public static StringTemplate fromString(String input) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder builder1 = ImmutableList.builder();
        int len = input.length();
        int i = 0;
        int index = input.indexOf(36);
        while (index != -1) {
            if (index != len - 1 && input.charAt(index + 1) == '(') {
                builder.add((Object)input.substring(i, index));
                int index1 = input.indexOf(41, index + 1);
                if (index1 == -1) {
                    throw new IllegalArgumentException("Unterminated macro variable");
                }
                String sub = input.substring(index + 2, index1);
                if (!StringTemplate.isValidVariableName(sub)) {
                    throw new IllegalArgumentException("Invalid macro variable name '" + sub + "'");
                }
                builder1.add((Object)sub);
                i = index1 + 1;
                index = input.indexOf(36, i);
                continue;
            }
            index = input.indexOf(36, index + 1);
        }
        if (i == 0) {
            throw new IllegalArgumentException("No variables in macro");
        }
        if (i != len) {
            builder.add((Object)input.substring(i));
        }
        return new StringTemplate((List<String>)builder.build(), (List<String>)builder1.build());
    }

    public static boolean isValidVariableName(String variableName) {
        for (int i = 0; i < variableName.length(); ++i) {
            char c = variableName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public String substitute(List<String> arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.variables.size(); ++i) {
            stringBuilder.append(this.segments.get(i)).append(arguments.get(i));
            CommandFunction.checkCommandLineLength(stringBuilder);
        }
        if (this.segments.size() > this.variables.size()) {
            stringBuilder.append(this.segments.getLast());
        }
        CommandFunction.checkCommandLineLength(stringBuilder);
        return stringBuilder.toString();
    }
}

