/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.commands.PermissionCheck;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final byte NUMBER_FLAG_MIN = 1;
    private static final byte NUMBER_FLAG_MAX = 2;

    public static int createNumberFlags(boolean min, boolean max) {
        int i = 0;
        if (min) {
            i |= 1;
        }
        if (max) {
            i |= 2;
        }
        return i;
    }

    public static boolean numberHasMin(byte number) {
        return (number & 1) != 0;
    }

    public static boolean numberHasMax(byte number) {
        return (number & 2) != 0;
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeArgumentCap(JsonObject json, ArgumentTypeInfo<A, T> type, ArgumentTypeInfo.Template<A> template) {
        type.serializeToJson(template, json);
    }

    private static <T extends ArgumentType<?>> void serializeArgumentToJson(JsonObject json, T type) {
        ArgumentTypeInfo.Template<T> template = ArgumentTypeInfos.unpack(type);
        json.addProperty("type", "argument");
        json.addProperty("parser", String.valueOf(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getKey(template.type())));
        JsonObject jsonObject = new JsonObject();
        ArgumentUtils.serializeArgumentCap(jsonObject, template.type(), template);
        if (!jsonObject.isEmpty()) {
            json.add("properties", (JsonElement)jsonObject);
        }
    }

    public static <S> JsonObject serializeNodeToJson(CommandDispatcher<S> dispatcher, CommandNode<S> node) {
        Collection<String> path;
        Object rootCommandNode;
        JsonObject jsonObject = new JsonObject();
        CommandNode<S> commandNode = node;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, LiteralCommandNode.class, ArgumentCommandNode.class}, commandNode2, n)) {
            case 0: {
                rootCommandNode = (RootCommandNode)commandNode2;
                jsonObject.addProperty("type", "root");
                break;
            }
            case 1: {
                LiteralCommandNode literalCommandNode = (LiteralCommandNode)commandNode2;
                jsonObject.addProperty("type", "literal");
                break;
            }
            case 2: {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode2;
                ArgumentUtils.serializeArgumentToJson(jsonObject, argumentCommandNode.getType());
                break;
            }
            default: {
                LOGGER.error("Could not serialize node {} ({})!", node, node.getClass());
                jsonObject.addProperty("type", "unknown");
            }
        }
        Collection<CommandNode<S>> children = node.getChildren();
        if (!children.isEmpty()) {
            JsonObject jsonObject1 = new JsonObject();
            rootCommandNode = children.iterator();
            while (rootCommandNode.hasNext()) {
                CommandNode commandNode3 = (CommandNode)rootCommandNode.next();
                jsonObject1.add(commandNode3.getName(), (JsonElement)ArgumentUtils.serializeNodeToJson(dispatcher, commandNode3));
            }
            jsonObject.add("children", (JsonElement)jsonObject1);
        }
        if (node.getCommand() != null) {
            jsonObject.addProperty("executable", Boolean.valueOf(true));
        }
        if ((rootCommandNode = node.getRequirement()) instanceof PermissionCheck) {
            PermissionCheck permissionCheck = (PermissionCheck)rootCommandNode;
            jsonObject.addProperty("required_level", (Number)permissionCheck.requiredLevel());
        }
        if (node.getRedirect() != null && !(path = dispatcher.getPath(node.getRedirect())).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : path) {
                jsonArray.add(string);
            }
            jsonObject.add("redirect", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public static <T> Set<ArgumentType<?>> findUsedArgumentTypes(CommandNode<T> node) {
        ReferenceOpenHashSet set = new ReferenceOpenHashSet();
        HashSet set1 = new HashSet();
        ArgumentUtils.findUsedArgumentTypes(node, set1, set);
        return set1;
    }

    private static <T> void findUsedArgumentTypes(CommandNode<T> node, Set<ArgumentType<?>> types, Set<CommandNode<T>> nodes) {
        if (nodes.add(node)) {
            if (node instanceof ArgumentCommandNode) {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
                types.add(argumentCommandNode.getType());
            }
            node.getChildren().forEach(childNode -> ArgumentUtils.findUsedArgumentTypes(childNode, types, nodes));
            CommandNode<T> redirect = node.getRedirect();
            if (redirect != null) {
                ArgumentUtils.findUsedArgumentTypes(redirect, types, nodes);
            }
        }
    }
}

