/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class SingletonArgumentInfo<A extends ArgumentType<?>>
implements ArgumentTypeInfo<A, Template> {
    private final Template template;

    private SingletonArgumentInfo(Function<CommandBuildContext, A> constructor) {
        this.template = new Template(constructor);
    }

    public static <T extends ArgumentType<?>> SingletonArgumentInfo<T> contextFree(Supplier<T> argumentTypeSupplier) {
        return new SingletonArgumentInfo<ArgumentType>(context -> (ArgumentType)argumentTypeSupplier.get());
    }

    public static <T extends ArgumentType<?>> SingletonArgumentInfo<T> contextAware(Function<CommandBuildContext, T> argumentType) {
        return new SingletonArgumentInfo<T>(argumentType);
    }

    @Override
    public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
    }

    @Override
    public void serializeToJson(Template template, JsonObject json) {
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
        return this.template;
    }

    @Override
    public Template unpack(A argument) {
        return this.template;
    }

    public final class Template
    implements ArgumentTypeInfo.Template<A> {
        private final Function<CommandBuildContext, A> constructor;

        public Template(Function<CommandBuildContext, A> constructor) {
            this.constructor = constructor;
        }

        @Override
        public A instantiate(CommandBuildContext context) {
            return (ArgumentType)this.constructor.apply(context);
        }

        @Override
        public ArgumentTypeInfo<A, ?> type() {
            return SingletonArgumentInfo.this;
        }
    }
}

