/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class IntegerArgumentInfo
implements ArgumentTypeInfo<IntegerArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        boolean flag = template.min != Integer.MIN_VALUE;
        boolean flag1 = template.max != Integer.MAX_VALUE;
        buffer.writeByte(ArgumentUtils.createNumberFlags(flag, flag1));
        if (flag) {
            buffer.writeInt(template.min);
        }
        if (flag1) {
            buffer.writeInt(template.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
        byte _byte = buffer.readByte();
        int i = ArgumentUtils.numberHasMin(_byte) ? buffer.readInt() : Integer.MIN_VALUE;
        int i1 = ArgumentUtils.numberHasMax(_byte) ? buffer.readInt() : Integer.MAX_VALUE;
        return new Template(i, i1);
    }

    @Override
    public void serializeToJson(Template template, JsonObject json) {
        if (template.min != Integer.MIN_VALUE) {
            json.addProperty("min", (Number)template.min);
        }
        if (template.max != Integer.MAX_VALUE) {
            json.addProperty("max", (Number)template.max);
        }
    }

    @Override
    public Template unpack(IntegerArgumentType argument) {
        return new Template(argument.getMinimum(), argument.getMaximum());
    }

    public final class Template
    implements ArgumentTypeInfo.Template<IntegerArgumentType> {
        final int min;
        final int max;

        Template(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public IntegerArgumentType instantiate(CommandBuildContext context) {
            return IntegerArgumentType.integer((int)this.min, (int)this.max);
        }

        @Override
        public ArgumentTypeInfo<IntegerArgumentType, ?> type() {
            return IntegerArgumentInfo.this;
        }
    }
}

