/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.codec.StreamCodec;

public record Rotations(float x, float y, float z) {
    public static final Codec<Rotations> CODEC = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize(list, 3).map(list1 -> new Rotations(((Float)list1.get(0)).floatValue(), ((Float)list1.get(1)).floatValue(), ((Float)list1.get(2)).floatValue())), rotations -> List.of(Float.valueOf(rotations.x()), Float.valueOf(rotations.y()), Float.valueOf(rotations.z())));
    public static final StreamCodec<ByteBuf, Rotations> STREAM_CODEC = new StreamCodec<ByteBuf, Rotations>(){

        @Override
        public Rotations decode(ByteBuf buffer) {
            return new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        @Override
        public void encode(ByteBuf buffer, Rotations value) {
            buffer.writeFloat(value.x);
            buffer.writeFloat(value.y);
            buffer.writeFloat(value.z);
        }
    };
    private static boolean SKIP_VALIDATION = false;

    public Rotations {
        if (SKIP_VALIDATION) {
            x = !Float.isInfinite(x) && !Float.isNaN(x) ? x % 360.0f : 0.0f;
            y = !Float.isInfinite(y) && !Float.isNaN(y) ? y % 360.0f : 0.0f;
            z = !Float.isInfinite(z) && !Float.isNaN(z) ? z % 360.0f : 0.0f;
        }
    }

    public static Rotations createWithoutValidityChecks(float x, float y, float z) {
        SKIP_VALIDATION = true;
        Rotations rotations = new Rotations(x, y, z);
        SKIP_VALIDATION = false;
        return rotations;
    }
}

