/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentMap
extends Iterable<TypedDataComponent<?>>,
DataComponentGetter {
    public static final DataComponentMap EMPTY = new DataComponentMap(){

        @Override
        @Nullable
        public <T> T get(DataComponentType<? extends T> component) {
            return null;
        }

        @Override
        public Set<DataComponentType<?>> keySet() {
            return Set.of();
        }

        @Override
        public Iterator<TypedDataComponent<?>> iterator() {
            return Collections.emptyIterator();
        }
    };
    public static final Codec<DataComponentMap> CODEC = DataComponentMap.makeCodecFromMap(DataComponentType.VALUE_MAP_CODEC);

    public static Codec<DataComponentMap> makeCodec(Codec<DataComponentType<?>> codec) {
        return DataComponentMap.makeCodecFromMap(Codec.dispatchedMap(codec, DataComponentType::codecOrThrow));
    }

    public static Codec<DataComponentMap> makeCodecFromMap(Codec<Map<DataComponentType<?>, Object>> codec) {
        return codec.flatComapMap(Builder::buildFromMapTrusted, map -> {
            int size = map.size();
            if (size == 0) {
                return DataResult.success((Object)Reference2ObjectMaps.emptyMap());
            }
            Reference2ObjectArrayMap map1 = new Reference2ObjectArrayMap(size);
            for (TypedDataComponent<?> typedDataComponent : map) {
                if (typedDataComponent.type().isTransient()) continue;
                map1.put(typedDataComponent.type(), typedDataComponent.value());
            }
            return DataResult.success((Object)map1);
        });
    }

    public static DataComponentMap composite(final DataComponentMap map1, final DataComponentMap map2) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> component) {
                T object = map2.get(component);
                return object != null ? object : map1.get(component);
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.union(map1.keySet(), map2.keySet());
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<DataComponentType<?>> keySet();

    default public boolean has(DataComponentType<?> component) {
        return this.get(component) != null;
    }

    @Override
    default public Iterator<TypedDataComponent<?>> iterator() {
        return Iterators.transform(this.keySet().iterator(), dataComponentType -> Objects.requireNonNull(this.getTyped(dataComponentType)));
    }

    default public Stream<TypedDataComponent<?>> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.size(), 1345), false);
    }

    default public int size() {
        return this.keySet().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public DataComponentMap filter(final Predicate<DataComponentType<?>> predicate) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> component) {
                return predicate.test(component) ? (T)DataComponentMap.this.get(component) : null;
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.filter(DataComponentMap.this.keySet(), predicate::test);
            }
        };
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Object> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public <T> Builder set(DataComponentType<T> component, @Nullable T value) {
            this.setUnchecked(component, value);
            return this;
        }

        <T> void setUnchecked(DataComponentType<T> component, @Nullable Object value) {
            if (value != null) {
                this.map.put(component, value);
            } else {
                this.map.remove(component);
            }
        }

        public Builder addAll(DataComponentMap components) {
            for (TypedDataComponent<?> typedDataComponent : components) {
                this.map.put(typedDataComponent.type(), typedDataComponent.value());
            }
            return this;
        }

        public DataComponentMap build() {
            return Builder.buildFromMapTrusted(this.map);
        }

        private static DataComponentMap buildFromMapTrusted(Map<DataComponentType<?>, Object> map) {
            if (map.isEmpty()) {
                return EMPTY;
            }
            return map.size() < 8 ? new SimpleMap((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectArrayMap(map)) : new SimpleMap((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectOpenHashMap(map));
        }

        record SimpleMap(Reference2ObjectMap<DataComponentType<?>, Object> map) implements DataComponentMap
        {
            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> component) {
                return (T)this.map.get(component);
            }

            @Override
            public boolean has(DataComponentType<?> component) {
                return this.map.containsKey(component);
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return this.map.keySet();
            }

            @Override
            public Iterator<TypedDataComponent<?>> iterator() {
                return Iterators.transform((Iterator)Reference2ObjectMaps.fastIterator(this.map), TypedDataComponent::fromEntryUnchecked);
            }

            @Override
            public int size() {
                return this.map.size();
            }

            @Override
            public String toString() {
                return this.map.toString();
            }
        }
    }
}

