/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.inventory.ItemStack;

public class EquipmentDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    public static final EquipmentDispenseItemBehavior INSTANCE = new EquipmentDispenseItemBehavior();

    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item, this) ? item : super.execute(blockSource, item);
    }

    @Deprecated
    @DoNotUse
    public static boolean dispenseEquipment(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item, null);
    }

    public static boolean dispenseEquipment(BlockSource blockSource, net.minecraft.world.item.ItemStack item, @Nullable DispenseItemBehavior currentBehavior) {
        EquipmentSlot equipmentSlotForItem;
        BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
        List<net.minecraft.world.entity.LivingEntity> entitiesOfClass = blockSource.level().getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, new AABB(blockPos), entity -> entity.canEquipWithDispenser(item));
        if (entitiesOfClass.isEmpty()) {
            return false;
        }
        net.minecraft.world.entity.LivingEntity livingEntity = entitiesOfClass.getFirst();
        EquipmentSlot equipmentSlot = equipmentSlotForItem = blockSource.level().purpurConfig.dispenserApplyCursedArmor ? livingEntity.getEquipmentSlotForItem(item) : livingEntity.getEquipmentSlotForDispenserItem(item);
        if (equipmentSlotForItem == null) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemStack = item.copyWithCount(1);
        ServerLevel world = blockSource.level();
        CraftBlock block = CraftBlock.at(world, blockSource.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemStack);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)livingEntity.getBukkitEntity()));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior dispenseItemBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
            if (dispenseItemBehavior != DispenseItemBehavior.NOOP && (currentBehavior == null || dispenseItemBehavior != currentBehavior)) {
                dispenseItemBehavior.dispense(blockSource, eventStack);
                return true;
            }
        }
        livingEntity.setItemSlot(equipmentSlotForItem, CraftItemStack.asNMSCopy(event.getItem()));
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setGuaranteedDrop(equipmentSlotForItem);
            mob.setPersistenceRequired();
        }
        if (shrink) {
            item.shrink(1);
        }
        return true;
    }
}

