/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public interface RecipeBuilder {
    public static final ResourceLocation ROOT_RECIPE_ADVANCEMENT = ResourceLocation.withDefaultNamespace("recipes/root");

    public RecipeBuilder unlockedBy(String var1, Criterion<?> var2);

    public RecipeBuilder group(@Nullable String var1);

    public Item getResult();

    public void save(RecipeOutput var1, ResourceKey<Recipe<?>> var2);

    default public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceKey.create(Registries.RECIPE, RecipeBuilder.getDefaultRecipeId(this.getResult())));
    }

    default public void save(RecipeOutput recipeOutput, String id) {
        ResourceLocation defaultRecipeId = RecipeBuilder.getDefaultRecipeId(this.getResult());
        ResourceLocation resourceLocation = ResourceLocation.parse(id);
        if (resourceLocation.equals(defaultRecipeId)) {
            throw new IllegalStateException("Recipe " + id + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(recipeOutput, ResourceKey.create(Registries.RECIPE, resourceLocation));
    }

    public static ResourceLocation getDefaultRecipeId(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey(item.asItem());
    }

    public static CraftingBookCategory determineBookCategory(RecipeCategory category) {
        return switch (category) {
            case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case RecipeCategory.TOOLS, RecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
            case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }
}

