/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class NbtToSnbt
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Iterable<Path> inputFolders;
    private final PackOutput output;

    public NbtToSnbt(PackOutput output, Collection<Path> inputFolders) {
        this.inputFolders = inputFolders;
        this.output = output;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput output) {
        Path outputFolder = this.output.getOutputFolder();
        ArrayList<CompletionStage> list = new ArrayList<CompletionStage>();
        for (Path path : this.inputFolders) {
            list.add(CompletableFuture.supplyAsync(() -> {
                try {
                    CompletableFuture<Void> var4;
                    try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                        var4 = CompletableFuture.allOf((CompletableFuture[])stream.filter(path1 -> path1.toString().endsWith(".nbt")).map(path1 -> CompletableFuture.runAsync(() -> NbtToSnbt.convertStructure(output, path1, NbtToSnbt.getName(path, path1), outputFolder), Util.ioPool())).toArray(CompletableFuture[]::new));
                    }
                    return var4;
                }
                catch (IOException var8) {
                    LOGGER.error("Failed to read structure input directory", (Throwable)var8);
                    return CompletableFuture.completedFuture(null);
                }
            }, Util.backgroundExecutor().forName("NbtToSnbt")).thenCompose(completableFuture -> completableFuture));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    @Override
    public final String getName() {
        return "NBT -> SNBT";
    }

    private static String getName(Path inputFolder, Path nbtPath) {
        String string = inputFolder.relativize(nbtPath).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".nbt".length());
    }

    @Nullable
    public static Path convertStructure(CachedOutput output, Path nbtPath, String name, Path directoryPath) {
        try {
            Path var7;
            try (InputStream inputStream = Files.newInputStream(nbtPath, new OpenOption[0]);
                 FastBufferedInputStream inputStream1 = new FastBufferedInputStream(inputStream);){
                Path path = directoryPath.resolve(name + ".snbt");
                NbtToSnbt.writeSnbt(output, path, NbtUtils.structureToSnbt(NbtIo.readCompressed(inputStream1, NbtAccounter.unlimitedHeap())));
                LOGGER.info("Converted {} from NBT to SNBT", (Object)name);
                var7 = path;
            }
            return var7;
        }
        catch (IOException var12) {
            LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{name, nbtPath, var12});
            return null;
        }
    }

    public static void writeSnbt(CachedOutput output, Path path, String contents) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
        hashingOutputStream.write(contents.getBytes(StandardCharsets.UTF_8));
        hashingOutputStream.write(10);
        output.writeIfNeeded(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
    }
}

