/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TerrainProvider {
    private static final float DEEP_OCEAN_CONTINENTALNESS = -0.51f;
    private static final float OCEAN_CONTINENTALNESS = -0.4f;
    private static final float PLAINS_CONTINENTALNESS = 0.1f;
    private static final float BEACH_CONTINENTALNESS = -0.15f;
    private static final BoundedFloatFunction<Float> NO_TRANSFORM = BoundedFloatFunction.IDENTITY;
    private static final BoundedFloatFunction<Float> AMPLIFIED_OFFSET = BoundedFloatFunction.createUnlimited(f -> f < 0.0f ? f : f * 2.0f);
    private static final BoundedFloatFunction<Float> AMPLIFIED_FACTOR = BoundedFloatFunction.createUnlimited(f -> 1.25f - 6.25f / (f + 5.0f));
    private static final BoundedFloatFunction<Float> AMPLIFIED_JAGGEDNESS = BoundedFloatFunction.createUnlimited(f -> f * 2.0f);

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> overworldOffset(I continents, I erosion, I ridgesFolded, boolean amplified) {
        BoundedFloatFunction<Float> boundedFloatFunction = amplified ? AMPLIFIED_OFFSET : NO_TRANSFORM;
        CubicSpline<C, I> cubicSpline = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, boundedFloatFunction);
        CubicSpline<C, I> cubicSpline1 = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, boundedFloatFunction);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, boundedFloatFunction);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, boundedFloatFunction);
        return CubicSpline.builder(continents, boundedFloatFunction).addPoint(-1.1f, 0.044f).addPoint(-1.02f, -0.2222f).addPoint(-0.51f, -0.2222f).addPoint(-0.44f, -0.12f).addPoint(-0.18f, -0.12f).addPoint(-0.16f, cubicSpline).addPoint(-0.15f, cubicSpline).addPoint(-0.1f, cubicSpline1).addPoint(0.25f, cubicSpline2).addPoint(1.0f, cubicSpline3).build();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> overworldFactor(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        BoundedFloatFunction<Float> boundedFloatFunction = amplified ? AMPLIFIED_FACTOR : NO_TRANSFORM;
        return CubicSpline.builder(continents, NO_TRANSFORM).addPoint(-0.19f, 3.95f).addPoint(-0.15f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 6.25f, true, NO_TRANSFORM)).addPoint(-0.1f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 5.47f, true, boundedFloatFunction)).addPoint(0.03f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 5.08f, true, boundedFloatFunction)).addPoint(0.06f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 4.69f, false, boundedFloatFunction)).build();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> overworldJaggedness(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        BoundedFloatFunction<Float> boundedFloatFunction = amplified ? AMPLIFIED_JAGGEDNESS : NO_TRANSFORM;
        float f = 0.65f;
        return CubicSpline.builder(continents, boundedFloatFunction).addPoint(-0.11f, 0.0f).addPoint(0.03f, TerrainProvider.buildErosionJaggednessSpline(erosion, ridges, ridgesFolded, 1.0f, 0.5f, 0.0f, 0.0f, boundedFloatFunction)).addPoint(0.65f, TerrainProvider.buildErosionJaggednessSpline(erosion, ridges, ridgesFolded, 1.0f, 1.0f, 1.0f, 0.0f, boundedFloatFunction)).build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildErosionJaggednessSpline(I erosion, I ridges, I ridgesFolded, float highErosionHighWeirdness, float lowErosionHighWeirdness, float highErosionMidWeirdness, float lowErosionMidWeirdness, BoundedFloatFunction<Float> transform) {
        float f = -0.5775f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.buildRidgeJaggednessSpline(ridges, ridgesFolded, highErosionHighWeirdness, highErosionMidWeirdness, transform);
        CubicSpline<C, I> cubicSpline1 = TerrainProvider.buildRidgeJaggednessSpline(ridges, ridgesFolded, lowErosionHighWeirdness, lowErosionMidWeirdness, transform);
        return CubicSpline.builder(erosion, transform).addPoint(-1.0f, cubicSpline).addPoint(-0.78f, cubicSpline1).addPoint(-0.5775f, cubicSpline1).addPoint(-0.375f, 0.0f).build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildRidgeJaggednessSpline(I ridges, I ridgesFolded, float highWeirdnessMagnitude, float midWeirdnessMagnitude, BoundedFloatFunction<Float> transform) {
        float f = NoiseRouterData.peaksAndValleys(0.4f);
        float f1 = NoiseRouterData.peaksAndValleys(0.56666666f);
        float f2 = (f + f1) / 2.0f;
        CubicSpline.Builder<C, I> builder = CubicSpline.builder(ridgesFolded, transform);
        builder.addPoint(f, 0.0f);
        if (midWeirdnessMagnitude > 0.0f) {
            builder.addPoint(f2, TerrainProvider.buildWeirdnessJaggednessSpline(ridges, midWeirdnessMagnitude, transform));
        } else {
            builder.addPoint(f2, 0.0f);
        }
        if (highWeirdnessMagnitude > 0.0f) {
            builder.addPoint(1.0f, TerrainProvider.buildWeirdnessJaggednessSpline(ridges, highWeirdnessMagnitude, transform));
        } else {
            builder.addPoint(1.0f, 0.0f);
        }
        return builder.build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildWeirdnessJaggednessSpline(I ridges, float magnitude, BoundedFloatFunction<Float> transform) {
        float f = 0.63f * magnitude;
        float f1 = 0.3f * magnitude;
        return CubicSpline.builder(ridges, transform).addPoint(-0.01f, f).addPoint(0.01f, f1).build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> getErosionFactor(I erosion, I ridges, I ridgesFolded, float value, boolean higherValues, BoundedFloatFunction<Float> transform) {
        CubicSpline cubicSpline = CubicSpline.builder(ridges, transform).addPoint(-0.2f, 6.3f).addPoint(0.2f, value).build();
        CubicSpline.Builder builder = CubicSpline.builder(erosion, transform).addPoint(-0.6f, cubicSpline).addPoint(-0.5f, CubicSpline.builder(ridges, transform).addPoint(-0.05f, 6.3f).addPoint(0.05f, 2.67f).build()).addPoint(-0.35f, cubicSpline).addPoint(-0.25f, cubicSpline).addPoint(-0.1f, CubicSpline.builder(ridges, transform).addPoint(-0.05f, 2.67f).addPoint(0.05f, 6.3f).build()).addPoint(0.03f, cubicSpline);
        if (higherValues) {
            CubicSpline cubicSpline1 = CubicSpline.builder(ridges, transform).addPoint(0.0f, value).addPoint(0.1f, 0.625f).build();
            CubicSpline cubicSpline2 = CubicSpline.builder(ridgesFolded, transform).addPoint(-0.9f, value).addPoint(-0.69f, cubicSpline1).build();
            builder.addPoint(0.35f, value).addPoint(0.45f, cubicSpline2).addPoint(0.55f, cubicSpline2).addPoint(0.62f, value);
        } else {
            CubicSpline cubicSpline1 = CubicSpline.builder(ridgesFolded, transform).addPoint(-0.7f, cubicSpline).addPoint(-0.15f, 1.37f).build();
            CubicSpline cubicSpline2 = CubicSpline.builder(ridgesFolded, transform).addPoint(0.45f, cubicSpline).addPoint(0.7f, 1.56f).build();
            builder.addPoint(0.05f, cubicSpline2).addPoint(0.4f, cubicSpline2).addPoint(0.45f, cubicSpline1).addPoint(0.55f, cubicSpline1).addPoint(0.58f, value);
        }
        return builder.build();
    }

    private static float calculateSlope(float y1, float y2, float x1, float x2) {
        return (y2 - y1) / (x2 - x1);
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildMountainRidgeSplineWithPoints(I ridgesFolded, float magnitude, boolean useMaxSlope, BoundedFloatFunction<Float> transform) {
        CubicSpline.Builder builder = CubicSpline.builder(ridgesFolded, transform);
        float f = -0.7f;
        float f1 = -1.0f;
        float f2 = TerrainProvider.mountainContinentalness(-1.0f, magnitude, -0.7f);
        float f3 = 1.0f;
        float f4 = TerrainProvider.mountainContinentalness(1.0f, magnitude, -0.7f);
        float f5 = TerrainProvider.calculateMountainRidgeZeroContinentalnessPoint(magnitude);
        float f6 = -0.65f;
        if (-0.65f < f5 && f5 < 1.0f) {
            float f7 = TerrainProvider.mountainContinentalness(-0.65f, magnitude, -0.7f);
            float f8 = -0.75f;
            float f9 = TerrainProvider.mountainContinentalness(-0.75f, magnitude, -0.7f);
            float f10 = TerrainProvider.calculateSlope(f2, f9, -1.0f, -0.75f);
            builder.addPoint(-1.0f, f2, f10);
            builder.addPoint(-0.75f, f9);
            builder.addPoint(-0.65f, f7);
            float f11 = TerrainProvider.mountainContinentalness(f5, magnitude, -0.7f);
            float f12 = TerrainProvider.calculateSlope(f11, f4, f5, 1.0f);
            float f13 = 0.01f;
            builder.addPoint(f5 - 0.01f, f11);
            builder.addPoint(f5, f11, f12);
            builder.addPoint(1.0f, f4, f12);
        } else {
            float f7 = TerrainProvider.calculateSlope(f2, f4, -1.0f, 1.0f);
            if (useMaxSlope) {
                builder.addPoint(-1.0f, Math.max(0.2f, f2));
                builder.addPoint(0.0f, Mth.lerp(0.5f, f2, f4), f7);
            } else {
                builder.addPoint(-1.0f, f2, f7);
            }
            builder.addPoint(1.0f, f4, f7);
        }
        return builder.build();
    }

    private static float mountainContinentalness(float heightFactor, float magnitude, float cutoffHeight) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - magnitude) * 0.5f;
        float f3 = 0.5f * (1.0f - magnitude);
        float f4 = (heightFactor + 1.17f) * 0.46082947f;
        float f5 = f4 * f2 - f3;
        return heightFactor < cutoffHeight ? Math.max(f5, -0.2222f) : Math.max(f5, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float input) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - input) * 0.5f;
        float f3 = 0.5f * (1.0f - input);
        return f3 / (0.46082947f * f2) - 1.17f;
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> buildErosionOffsetSpline(I erosion, I ridgesFolded, float ridgeBaseOffset, float ridgeMidOffset, float ridgePeakOffset, float magnitude, float ridgeInnerOffset, float ridgeOuterOffset, boolean extended, boolean useMaxSlope, BoundedFloatFunction<Float> transform) {
        float f = 0.6f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.buildMountainRidgeSplineWithPoints(ridgesFolded, Mth.lerp(magnitude, 0.6f, 1.5f), useMaxSlope, transform);
        CubicSpline<C, I> cubicSpline1 = TerrainProvider.buildMountainRidgeSplineWithPoints(ridgesFolded, Mth.lerp(magnitude, 0.6f, 1.0f), useMaxSlope, transform);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.buildMountainRidgeSplineWithPoints(ridgesFolded, magnitude, useMaxSlope, transform);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.ridgeSpline(ridgesFolded, ridgeBaseOffset - 0.15f, 0.5f * magnitude, Mth.lerp(0.5f, 0.5f, 0.5f) * magnitude, 0.5f * magnitude, 0.6f * magnitude, 0.5f, transform);
        CubicSpline<C, I> cubicSpline4 = TerrainProvider.ridgeSpline(ridgesFolded, ridgeBaseOffset, ridgeInnerOffset * magnitude, ridgeMidOffset * magnitude, 0.5f * magnitude, 0.6f * magnitude, 0.5f, transform);
        CubicSpline<C, I> cubicSpline5 = TerrainProvider.ridgeSpline(ridgesFolded, ridgeBaseOffset, ridgeInnerOffset, ridgeInnerOffset, ridgeMidOffset, ridgePeakOffset, 0.5f, transform);
        CubicSpline<C, I> cubicSpline6 = TerrainProvider.ridgeSpline(ridgesFolded, ridgeBaseOffset, ridgeInnerOffset, ridgeInnerOffset, ridgeMidOffset, ridgePeakOffset, 0.5f, transform);
        CubicSpline cubicSpline7 = CubicSpline.builder(ridgesFolded, transform).addPoint(-1.0f, ridgeBaseOffset).addPoint(-0.4f, cubicSpline5).addPoint(0.0f, ridgePeakOffset + 0.07f).build();
        CubicSpline<C, I> cubicSpline8 = TerrainProvider.ridgeSpline(ridgesFolded, -0.02f, ridgeOuterOffset, ridgeOuterOffset, ridgeMidOffset, ridgePeakOffset, 0.0f, transform);
        CubicSpline.Builder<C, I> builder = CubicSpline.builder(erosion, transform).addPoint(-0.85f, cubicSpline).addPoint(-0.7f, cubicSpline1).addPoint(-0.4f, cubicSpline2).addPoint(-0.35f, cubicSpline3).addPoint(-0.1f, cubicSpline4).addPoint(0.2f, cubicSpline5);
        if (extended) {
            builder.addPoint(0.4f, cubicSpline6).addPoint(0.45f, cubicSpline7).addPoint(0.55f, cubicSpline7).addPoint(0.58f, cubicSpline6);
        }
        builder.addPoint(0.7f, cubicSpline8);
        return builder.build();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> ridgeSpline(I ridgesFolded, float y1, float y2, float y3, float y4, float y5, float minSmoothing, BoundedFloatFunction<Float> transform) {
        float max = Math.max(0.5f * (y2 - y1), minSmoothing);
        float f = 5.0f * (y3 - y2);
        return CubicSpline.builder(ridgesFolded, transform).addPoint(-1.0f, y1, max).addPoint(-0.4f, y2, Math.min(max, f)).addPoint(0.0f, y3, f).addPoint(0.4f, y4, 2.0f * (y4 - y3)).addPoint(1.0f, y5, 0.7f * (y5 - y4)).build();
    }
}

