/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public final class ListTag
extends AbstractList<Tag>
implements CollectionTag {
    private static final String WRAPPER_MARKER = "";
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListTag load(DataInput input, NbtAccounter accounter) throws IOException {
            ListTag var3;
            accounter.pushDepth();
            try {
                var3 = 1.loadList(input, accounter);
            }
            finally {
                accounter.popDepth();
            }
            return var3;
        }

        private static ListTag loadList(DataInput input, NbtAccounter accounter) throws IOException {
            accounter.accountBytes(36L);
            byte _byte = input.readByte();
            int listCount = 1.readListCount(input);
            if (_byte == 0 && listCount > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            accounter.accountBytes(4L, listCount);
            TagType<?> type = TagTypes.getType(_byte);
            ListTag listTag = new ListTag(new ArrayList<Tag>(listCount));
            for (int i = 0; i < listCount; ++i) {
                listTag.addAndUnwrap((Tag)type.load(input, accounter));
            }
            return listTag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            StreamTagVisitor.ValueResult var4;
            accounter.pushDepth();
            try {
                var4 = 1.parseList(input, visitor, accounter);
            }
            finally {
                accounter.popDepth();
            }
            return var4;
        }

        private static StreamTagVisitor.ValueResult parseList(DataInput input, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            accounter.accountBytes(36L);
            TagType<?> type = TagTypes.getType(input.readByte());
            int listCount = 1.readListCount(input);
            switch (visitor.visitList(type, listCount)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    type.skip(input, listCount, accounter);
                    return visitor.visitContainerEnd();
                }
            }
            accounter.accountBytes(4L, listCount);
            int i = 0;
            while (true) {
                block16: {
                    int i1;
                    block15: {
                        if (i >= listCount) break block15;
                        block4 : switch (visitor.visitElement(type, i)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                type.skip(input, accounter);
                                break;
                            }
                            case SKIP: {
                                type.skip(input, accounter);
                                break block16;
                            }
                            default: {
                                switch (type.parse(input, visitor, accounter)) {
                                    case HALT: {
                                        return StreamTagVisitor.ValueResult.HALT;
                                    }
                                    case BREAK: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((i1 = listCount - 1 - i) > 0) {
                        type.skip(input, i1, accounter);
                    }
                    return visitor.visitContainerEnd();
                }
                ++i;
            }
        }

        private static int readListCount(DataInput dataInput) throws IOException {
            int _int = dataInput.readInt();
            if (_int < 0) {
                throw new NbtFormatException("ListTag length cannot be negative: " + _int);
            }
            return _int;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput input, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                TagType<?> type = TagTypes.getType(input.readByte());
                int _int = input.readInt();
                type.skip(input, _int, accounter);
            }
            finally {
                accounter.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }
    };
    private final List<Tag> list;

    public ListTag() {
        this(new ArrayList<Tag>());
    }

    public ListTag(List<Tag> list) {
        this.list = list;
    }

    private static Tag tryUnwrap(CompoundTag tag) {
        Tag tag1;
        if (tag.size() == 1 && (tag1 = tag.get(WRAPPER_MARKER)) != null) {
            return tag1;
        }
        return tag;
    }

    private static boolean isWrapper(CompoundTag tag) {
        return tag.size() == 1 && tag.contains(WRAPPER_MARKER);
    }

    private static Tag wrapIfNeeded(byte elementType, Tag tag) {
        CompoundTag compoundTag;
        if (elementType != 10) {
            return tag;
        }
        return tag instanceof CompoundTag && !ListTag.isWrapper(compoundTag = (CompoundTag)tag) ? compoundTag : ListTag.wrapElement(tag);
    }

    private static CompoundTag wrapElement(Tag tag) {
        return new CompoundTag(Map.of(WRAPPER_MARKER, tag));
    }

    @Override
    public void write(DataOutput output) throws IOException {
        byte b = this.identifyRawElementType();
        output.writeByte(b);
        output.writeInt(this.list.size());
        for (Tag tag : this.list) {
            ListTag.wrapIfNeeded(b, tag).write(output);
        }
    }

    @VisibleForTesting
    public byte identifyRawElementType() {
        byte b = 0;
        for (Tag tag : this.list) {
            byte id = tag.getId();
            if (b == 0) {
                b = id;
                continue;
            }
            if (b == id) continue;
            return 10;
        }
        return b;
    }

    public void addAndUnwrap(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.add(ListTag.tryUnwrap(compoundTag));
        } else {
            this.add(tag);
        }
    }

    @Override
    public int sizeInBytes() {
        int i = 36;
        i += 4 * this.list.size();
        for (Tag tag : this.list) {
            i += tag.sizeInBytes();
        }
        return i;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.visitList(this);
        return stringTagVisitor.build();
    }

    @Override
    public Tag remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Optional<CompoundTag> getCompound(int index) {
        Optional<CompoundTag> optional;
        Tag tag = this.getNullable(index);
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            optional = Optional.of(compoundTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public CompoundTag getCompoundOrEmpty(int index) {
        return this.getCompound(index).orElseGet(CompoundTag::new);
    }

    public Optional<ListTag> getList(int index) {
        Optional<ListTag> optional;
        Tag tag = this.getNullable(index);
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            optional = Optional.of(listTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public ListTag getListOrEmpty(int index) {
        return this.getList(index).orElseGet(ListTag::new);
    }

    public Optional<Short> getShort(int index) {
        return this.getOptional(index).flatMap(Tag::asShort);
    }

    public short getShortOr(int index, short defaultValue) {
        short s;
        Tag tag = this.getNullable(index);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            s = numericTag.shortValue();
        } else {
            s = defaultValue;
        }
        return s;
    }

    public Optional<Integer> getInt(int index) {
        return this.getOptional(index).flatMap(Tag::asInt);
    }

    public int getIntOr(int index, int defaultValue) {
        int n;
        Tag tag = this.getNullable(index);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            n = numericTag.intValue();
        } else {
            n = defaultValue;
        }
        return n;
    }

    public Optional<int[]> getIntArray(int index) {
        Optional<int[]> optional;
        Tag tag = this.getNullable(index);
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            optional = Optional.of(intArrayTag.getAsIntArray());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<long[]> getLongArray(int index) {
        Optional<long[]> optional;
        Tag tag = this.getNullable(index);
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            optional = Optional.of(longArrayTag.getAsLongArray());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<Double> getDouble(int index) {
        return this.getOptional(index).flatMap(Tag::asDouble);
    }

    public double getDoubleOr(int index, double defaultValue) {
        double d;
        Tag tag = this.getNullable(index);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            d = numericTag.doubleValue();
        } else {
            d = defaultValue;
        }
        return d;
    }

    public Optional<Float> getFloat(int index) {
        return this.getOptional(index).flatMap(Tag::asFloat);
    }

    public float getFloatOr(int index, float defaultValue) {
        float f;
        Tag tag = this.getNullable(index);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            f = numericTag.floatValue();
        } else {
            f = defaultValue;
        }
        return f;
    }

    public Optional<String> getString(int index) {
        return this.getOptional(index).flatMap(Tag::asString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStringOr(int index, String defaultValue) {
        String string;
        Tag tag = this.getNullable(index);
        if (!(tag instanceof StringTag)) {
            string = defaultValue;
            return string;
        }
        StringTag stringTag = (StringTag)tag;
        try {
            String string2;
            String var8;
            string = var8 = (string2 = stringTag.value());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Nullable
    private Tag getNullable(int index) {
        return index >= 0 && index < this.list.size() ? this.list.get(index) : null;
    }

    private Optional<Tag> getOptional(int index) {
        return Optional.ofNullable(this.getNullable(index));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int index) {
        return this.list.get(index);
    }

    @Override
    public Tag set(int i, Tag tag) {
        return this.list.set(i, tag);
    }

    @Override
    public void add(int i, Tag tag) {
        this.list.add(i, tag);
    }

    @Override
    public boolean setTag(int index, Tag tag) {
        this.list.set(index, tag);
        return true;
    }

    @Override
    public boolean addTag(int index, Tag tag) {
        this.list.add(index, tag);
        return true;
    }

    @Override
    public ListTag copy() {
        ArrayList<Tag> list = new ArrayList<Tag>(this.list.size());
        for (Tag tag : this.list) {
            list.add(tag.copy());
        }
        return new ListTag(list);
    }

    @Override
    public Optional<ListTag> asList() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof ListTag && Objects.equals(this.list, ((ListTag)other).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public Stream<Tag> stream() {
        return super.stream();
    }

    public Stream<CompoundTag> compoundStream() {
        return this.stream().mapMulti((tag, consumer) -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                consumer.accept(compoundTag);
            }
        });
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitList(this);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        byte b = this.identifyRawElementType();
        switch (visitor.visitList(TagTypes.getType(b), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return visitor.visitContainerEnd();
            }
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Tag tag = ListTag.wrapIfNeeded(b, this.list.get(i));
            switch (visitor.visitElement(tag.getType(), i)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return visitor.visitContainerEnd();
                }
                default: {
                    switch (tag.accept(visitor)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return visitor.visitContainerEnd();
                        }
                    }
                }
                case SKIP: 
            }
        }
        return visitor.visitContainerEnd();
    }
}

