/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

public class CipherDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private final VelocityCipher cipher;

    public CipherDecoder(VelocityCipher cipher) {
        this.cipher = cipher;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuf compatible = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.cipher, (ByteBuf)in);
        try {
            this.cipher.process(compatible);
            out.add(compatible);
        }
        catch (Exception e) {
            compatible.release();
            throw e;
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.cipher.close();
    }
}

