/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ConnectionEvent;
import io.papermc.paper.util.IntervalledCounter;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.CipherDecoder;
import net.minecraft.network.CipherEncoder;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.CompressionEncoder;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.LocalFrameDecoder;
import net.minecraft.network.LocalFrameEncoder;
import net.minecraft.network.MonitoredLocalFrameDecoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.Varint21FrameDecoder;
import net.minecraft.network.Varint21LengthFieldPrepender;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.CryptException;
import net.minecraft.util.Mth;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Connection
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float AVERAGE_PACKETS_SMOOTHING = 0.75f;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker ROOT_MARKER = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker PACKET_MARKER = Util.make(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), marker -> marker.add(ROOT_MARKER));
    public static final Marker PACKET_RECEIVED_MARKER = Util.make(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), marker -> marker.add(PACKET_MARKER));
    public static final Marker PACKET_SENT_MARKER = Util.make(MarkerFactory.getMarker((String)"PACKET_SENT"), marker -> marker.add(PACKET_MARKER));
    public static final Supplier<NioEventLoopGroup> NETWORK_WORKER_GROUP = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(LOGGER)).build()));
    public static final Supplier<EpollEventLoopGroup> NETWORK_EPOLL_WORKER_GROUP = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(LOGGER)).build()));
    public static final Supplier<DefaultEventLoopGroup> LOCAL_WORKER_GROUP = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(LOGGER)).build()));
    private static final ProtocolInfo<ServerHandshakePacketListener> INITIAL_PROTOCOL = HandshakeProtocols.SERVERBOUND;
    private final PacketFlow receiving;
    private volatile boolean sendLoginDisconnect = true;
    private final Queue<WrappedConsumer> pendingActions = Queues.newConcurrentLinkedQueue();
    public Channel channel;
    public SocketAddress address;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    @Nullable
    private volatile PacketListener disconnectListener;
    @Nullable
    private volatile PacketListener packetListener;
    @Nullable
    private DisconnectionDetails disconnectionDetails;
    private boolean encrypted;
    private boolean disconnectionHandled;
    private int receivedPackets;
    private int sentPackets;
    private float averageReceivedPackets;
    private float averageSentPackets;
    private int tickCount;
    private boolean handlingFault;
    @Nullable
    private volatile DisconnectionDetails delayedDisconnect;
    @Nullable
    BandwidthDebugMonitor bandwidthDebugMonitor;
    public String hostname = "";
    public int protocolVersion;
    public InetSocketAddress virtualHost;
    private static boolean enableExplicitFlush = Boolean.getBoolean("paper.explicit-flush");
    protected final Object PACKET_LIMIT_LOCK = new Object();
    @Nullable
    protected final IntervalledCounter allPacketCounts;
    protected final Map<Class<? extends Packet<?>>, IntervalledCounter> packetSpecificLimits;
    private boolean stopReadingPackets;
    @Nullable
    public SocketAddress haProxyAddress;
    @Nullable
    public Optional<Component> legacySavedLoginEventResultOverride;
    public boolean handledLegacyLoginEvent;
    @Nullable
    public ServerPlayer savedPlayerForLegacyEvents;
    @Nullable
    public PlayerResourcePackStatusEvent.Status resourcePackStatus;
    public boolean isPending;
    public boolean queueImmunity;
    private static final int MAX_PER_TICK = GlobalConfiguration.get().misc.maxJoinsPerTick;
    private static int joinAttemptsThisTick;
    private static int currTick;
    private static int tickSecond;

    public final ServerPlayer getPlayer() {
        PacketListener packetListener = this.packetListener;
        if (packetListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl impl = (ServerGamePacketListenerImpl)packetListener;
            return impl.player;
        }
        packetListener = this.packetListener;
        if (packetListener instanceof ServerCommonPacketListenerImpl) {
            ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener;
            return null;
        }
        return null;
    }

    private void killForPacketSpam() {
        this.sendPacket(new ClientboundDisconnectPacket(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage)), PacketSendListener.thenRun(() -> this.disconnect(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage))), true);
        this.setReadOnly();
        this.stopReadingPackets = true;
    }

    public Connection(PacketFlow receiving) {
        this.allPacketCounts = GlobalConfiguration.get().packetLimiter.allPackets.isEnabled() ? new IntervalledCounter((long)(GlobalConfiguration.get().packetLimiter.allPackets.interval() * 1.0E9)) : null;
        this.packetSpecificLimits = new HashMap();
        this.isPending = true;
        this.receiving = receiving;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channel = ctx.channel();
        this.address = this.channel.remoteAddress();
        this.preparing = false;
        if (this.delayedDisconnect != null) {
            this.disconnect(this.delayedDisconnect);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.disconnect(Component.translatable("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable exception) {
        Throwable throwable;
        if (exception instanceof EncoderException && (throwable = exception.getCause()) instanceof PacketEncoder.PacketTooLargeException) {
            PacketEncoder.PacketTooLargeException packetTooLargeException = (PacketEncoder.PacketTooLargeException)throwable;
            Packet<?> packet = packetTooLargeException.getPacket();
            if (packet.packetTooLarge(this)) {
                ProtocolSwapHandler.handleOutboundTerminalPacket(ctx, packet);
                return;
            }
            if (packet.isSkippable()) {
                LOGGER.debug("Skipping packet due to errors", exception.getCause());
                ProtocolSwapHandler.handleOutboundTerminalPacket(ctx, packet);
                return;
            }
            exception = exception.getCause();
        }
        if (exception instanceof SkipPacketException) {
            LOGGER.debug("Skipping packet due to errors", exception.getCause());
        } else {
            boolean flag = !this.handlingFault;
            this.handlingFault = true;
            if (this.channel.isOpen()) {
                ServerPlayer player = this.getPlayer();
                if (exception instanceof TimeoutException) {
                    LOGGER.debug("Timeout", exception);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.TIMED_OUT;
                    }
                    this.disconnect(Component.translatable("disconnect.timeout"));
                } else {
                    MutableComponent component = Component.translatable("disconnect.genericReason", "Internal Exception: " + String.valueOf(exception));
                    PacketListener packetListener = this.packetListener;
                    DisconnectionDetails disconnectionDetails = packetListener != null ? packetListener.createDisconnectionInfo(component, exception) : new DisconnectionDetails(component);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.ERRONEOUS_STATE;
                    }
                    if (flag) {
                        boolean doesDisconnectExist;
                        LOGGER.debug("Failed to sent packet", exception);
                        boolean bl = doesDisconnectExist = this.packetListener.protocol() != ConnectionProtocol.STATUS && this.packetListener.protocol() != ConnectionProtocol.HANDSHAKING;
                        if (this.getSending() == PacketFlow.CLIENTBOUND && doesDisconnectExist) {
                            Packet packet = (Packet)((Object)(this.sendLoginDisconnect ? new ClientboundLoginDisconnectPacket(component) : new ClientboundDisconnectPacket(component)));
                            this.send(packet, PacketSendListener.thenRun(() -> this.disconnect(disconnectionDetails)));
                        } else {
                            this.disconnect(disconnectionDetails);
                        }
                        this.setReadOnly();
                    } else {
                        LOGGER.debug("Double fault", exception);
                        this.disconnect(disconnectionDetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            TraceUtil.printStackTrace(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Packet<?> packet) {
        if (this.channel.isOpen()) {
            PacketListener packetListener = this.packetListener;
            if (packetListener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (this.stopReadingPackets) {
                return;
            }
            if (this.allPacketCounts != null || GlobalConfiguration.get().packetLimiter.overrides.containsKey(packet.getClass())) {
                long time = System.nanoTime();
                Object object = this.PACKET_LIMIT_LOCK;
                synchronized (object) {
                    if (this.allPacketCounts != null) {
                        this.allPacketCounts.updateAndAdd(1L, time);
                        if (this.allPacketCounts.getRate() >= GlobalConfiguration.get().packetLimiter.allPackets.maxPacketRate()) {
                            this.killForPacketSpam();
                            return;
                        }
                    }
                    for (Class<?> check = packet.getClass(); check != Object.class; check = check.getSuperclass()) {
                        GlobalConfiguration.PacketLimiter.PacketLimit packetSpecificLimit = GlobalConfiguration.get().packetLimiter.overrides.get(check);
                        if (packetSpecificLimit == null || !packetSpecificLimit.isEnabled()) continue;
                        IntervalledCounter counter = this.packetSpecificLimits.computeIfAbsent(check, clazz -> new IntervalledCounter((long)(packetSpecificLimit.interval() * 1.0E9)));
                        counter.updateAndAdd(1L, time);
                        if (!(counter.getRate() >= packetSpecificLimit.maxPacketRate())) continue;
                        switch (packetSpecificLimit.action()) {
                            case DROP: {
                                return;
                            }
                            case KICK: {
                                String playerName;
                                String deobfedPacketName = ObfHelper.INSTANCE.deobfClassName(check.getName());
                                PacketListener packetListener2 = this.packetListener;
                                if (packetListener2 instanceof ServerCommonPacketListenerImpl) {
                                    ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener2;
                                    playerName = impl.getOwner().name();
                                } else {
                                    playerName = this.getLoggableAddress(MinecraftServer.getServer().logIPs());
                                }
                                LOGGER.warn("{} kicked for packet spamming: {}", (Object)playerName, (Object)deobfedPacketName.substring(deobfedPacketName.lastIndexOf(".") + 1));
                                this.killForPacketSpam();
                                return;
                            }
                        }
                    }
                }
            }
            if (packetListener.shouldHandleMessage(packet)) {
                try {
                    Connection.genericsFtw(packet, packetListener);
                }
                catch (RunningOnDifferentThreadException time) {
                }
                catch (ServerStopRejectedExecutionException time) {
                }
                catch (RejectedExecutionException var6) {
                    this.disconnect(Component.translatable("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException var7) {
                    LOGGER.error("Received {} that couldn't be processed", packet.getClass(), (Object)var7);
                    this.disconnect(Component.translatable("multiplayer.disconnect.invalid_packet"));
                }
                ++this.receivedPackets;
            }
        }
    }

    private static <T extends PacketListener> void genericsFtw(Packet<T> packet, PacketListener listener) {
        packet.handle(listener);
    }

    private void validateListener(ProtocolInfo<?> protocolInfo, PacketListener packetListener) {
        Objects.requireNonNull(packetListener, "packetListener");
        PacketFlow packetFlow = packetListener.flow();
        if (packetFlow != this.receiving) {
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + String.valueOf((Object)this.receiving) + ", but listener is " + String.valueOf((Object)packetFlow));
        }
        ConnectionProtocol connectionProtocol = packetListener.protocol();
        if (protocolInfo.id() != connectionProtocol) {
            throw new IllegalStateException("Listener protocol (" + String.valueOf((Object)connectionProtocol) + ") does not match requested one " + String.valueOf(protocolInfo));
        }
    }

    private static void syncAfterConfigurationChange(ChannelFuture future) {
        try {
            future.syncUninterruptibly();
        }
        catch (Exception var2) {
            if (var2 instanceof ClosedChannelException) {
                LOGGER.info("Connection closed during protocol change");
            }
            throw var2;
        }
    }

    public <T extends PacketListener> void setupInboundProtocol(ProtocolInfo<T> protocolInfo, T packetInfo) {
        this.validateListener(protocolInfo, packetInfo);
        if (protocolInfo.flow() != this.getReceiving()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)protocolInfo.id()));
        }
        this.packetListener = packetInfo;
        this.disconnectListener = null;
        UnconfiguredPipelineHandler.InboundConfigurationTask inboundConfigurationTask = UnconfiguredPipelineHandler.setupInboundProtocol(protocolInfo);
        BundlerInfo bundlerInfo = protocolInfo.bundlerInfo();
        if (bundlerInfo != null) {
            PacketBundlePacker packetBundlePacker = new PacketBundlePacker(bundlerInfo);
            inboundConfigurationTask = inboundConfigurationTask.andThen(ctx -> ctx.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetBundlePacker));
        }
        Connection.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)inboundConfigurationTask));
    }

    public void setupOutboundProtocol(ProtocolInfo<?> protocolInfo) {
        if (protocolInfo.flow() != this.getSending()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)protocolInfo.id()));
        }
        UnconfiguredPipelineHandler.OutboundConfigurationTask outboundConfigurationTask = UnconfiguredPipelineHandler.setupOutboundProtocol(protocolInfo);
        BundlerInfo bundlerInfo = protocolInfo.bundlerInfo();
        if (bundlerInfo != null) {
            PacketBundleUnpacker packetBundleUnpacker = new PacketBundleUnpacker(bundlerInfo);
            outboundConfigurationTask = outboundConfigurationTask.andThen(ctx -> ctx.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetBundleUnpacker));
        }
        boolean flag = protocolInfo.id() == ConnectionProtocol.LOGIN;
        Connection.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)outboundConfigurationTask.andThen(ctx -> {
            this.sendLoginDisconnect = flag;
        })));
    }

    public void setListenerForServerboundHandshake(PacketListener packetListener) {
        if (this.packetListener != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.receiving != PacketFlow.SERVERBOUND || packetListener.flow() != PacketFlow.SERVERBOUND || packetListener.protocol() != INITIAL_PROTOCOL.id()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.packetListener = packetListener;
    }

    public void initiateServerboundStatusConnection(String hostName, int port, ClientStatusPacketListener packetListener) {
        this.initiateServerboundConnection(hostName, port, StatusProtocols.SERVERBOUND, StatusProtocols.CLIENTBOUND, packetListener, ClientIntent.STATUS);
    }

    public void initiateServerboundPlayConnection(String hostName, int port, ClientLoginPacketListener packetListener) {
        this.initiateServerboundConnection(hostName, port, LoginProtocols.SERVERBOUND, LoginProtocols.CLIENTBOUND, packetListener, ClientIntent.LOGIN);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundPlayConnection(String hostName, int port, ProtocolInfo<S> serverboundProtocol, ProtocolInfo<C> clientbountProtocol, C packetListener, boolean isTransfer) {
        this.initiateServerboundConnection(hostName, port, serverboundProtocol, clientbountProtocol, packetListener, isTransfer ? ClientIntent.TRANSFER : ClientIntent.LOGIN);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundConnection(String hostName, int port, ProtocolInfo<S> serverboundProtocol, ProtocolInfo<C> clientboundProtocol, C packetListener, ClientIntent intention) {
        if (serverboundProtocol.id() != clientboundProtocol.id()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.disconnectListener = packetListener;
        this.runOnceConnected(connection -> {
            this.setupInboundProtocol(clientboundProtocol, packetListener);
            connection.sendPacket(new ClientIntentionPacket(SharedConstants.getCurrentVersion().protocolVersion(), hostName, port, intention), null, true);
            this.setupOutboundProtocol(serverboundProtocol);
        });
    }

    public void send(Packet<?> packet) {
        this.send(packet, null);
    }

    public void send(Packet<?> packet, @Nullable ChannelFutureListener sendListener) {
        this.send(packet, sendListener, true);
    }

    public void send(Packet<?> packet, @Nullable ChannelFutureListener sendListener, boolean flush) {
        boolean connected = this.isConnected();
        if (!connected && !this.preparing) {
            return;
        }
        packet.onPacketDispatch(this.getPlayer());
        if (connected && (InnerUtil.canSendImmediate(this, packet) || MCUtil.isMainThread() && packet.isReady() && this.pendingActions.isEmpty() && (packet.getExtraPackets() == null || packet.getExtraPackets().isEmpty()))) {
            this.sendPacket(packet, sendListener, flush);
        } else {
            boolean hasExtraPackets;
            List<Packet<?>> extraPackets = InnerUtil.buildExtraPackets(packet);
            boolean bl = hasExtraPackets = extraPackets != null && !extraPackets.isEmpty();
            if (!hasExtraPackets) {
                this.pendingActions.add(new PacketSendAction(packet, sendListener, flush));
            } else {
                ArrayList<PacketSendAction> actions = new ArrayList<PacketSendAction>(1 + extraPackets.size());
                actions.add(new PacketSendAction(packet, null, false));
                int i = 0;
                int len = extraPackets.size();
                while (i < len) {
                    Packet<?> extraPacket = extraPackets.get(i);
                    boolean end = ++i == len;
                    actions.add(new PacketSendAction(extraPacket, (ChannelFutureListener)(end ? sendListener : null), end));
                }
                this.pendingActions.addAll(actions);
            }
            this.flushQueue();
        }
    }

    public void runOnceConnected(Consumer<Connection> action) {
        if (this.isConnected()) {
            this.flushQueue();
            action.accept(this);
        } else {
            this.pendingActions.add(new WrappedConsumer(action));
        }
    }

    private void sendPacket(Packet<?> packet, @Nullable ChannelFutureListener sendListener, boolean flush) {
        ++this.sentPackets;
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSendPacket(packet, sendListener, flush);
        } else {
            this.channel.eventLoop().execute(() -> this.doSendPacket(packet, sendListener, flush));
        }
    }

    private void doSendPacket(Packet<?> packet, @Nullable ChannelFutureListener sendListener, boolean flush) {
        ServerPlayer player = this.getPlayer();
        if (!this.isConnected()) {
            packet.onPacketDispatchFinish(player, null);
            return;
        }
        try {
            ChannelFuture channelFuture;
            if (sendListener != null) {
                channelFuture = flush ? this.channel.writeAndFlush(packet) : this.channel.write(packet);
                channelFuture.addListener((GenericFutureListener)sendListener);
            } else {
                channelFuture = flush ? this.channel.writeAndFlush(packet, this.channel.voidPromise()) : this.channel.write(packet, this.channel.voidPromise());
            }
            if (packet.hasFinishListener()) {
                channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> packet.onPacketDispatchFinish(player, (ChannelFuture)future)));
            }
        }
        catch (Exception e) {
            LOGGER.error("NetworkException: {}", (Object)player, (Object)e);
            this.disconnect(Component.translatable("disconnect.genericReason", "Internal Exception: " + e.getMessage()));
            packet.onPacketDispatchFinish(player, null);
        }
    }

    public void flushChannel() {
        if (this.isConnected()) {
            this.flush();
        } else {
            this.pendingActions.add(new WrappedConsumer(Connection::flush));
        }
    }

    private void flush() {
        if (this.channel.eventLoop().inEventLoop()) {
            this.channel.flush();
        } else {
            this.channel.eventLoop().execute(() -> this.channel.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushQueue() {
        if (!this.isConnected()) {
            return true;
        }
        if (MCUtil.isMainThread()) {
            return this.processQueue();
        }
        if (this.isPending) {
            Queue<WrappedConsumer> queue = this.pendingActions;
            synchronized (queue) {
                return this.processQueue();
            }
        }
        return false;
    }

    private boolean processQueue() {
        if (this.pendingActions.isEmpty()) {
            return true;
        }
        Iterator iterator = this.pendingActions.iterator();
        while (iterator.hasNext()) {
            WrappedConsumer queued = (WrappedConsumer)iterator.next();
            if (queued == null) {
                return true;
            }
            if (queued.isConsumed()) continue;
            if (queued instanceof PacketSendAction) {
                PacketSendAction packetSendAction = (PacketSendAction)queued;
                Packet<?> packet = packetSendAction.packet;
                if (!packet.isReady()) {
                    return false;
                }
            }
            iterator.remove();
            if (!queued.tryMarkConsumed()) continue;
            queued.accept(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        block15: {
            TickablePacketListener tickablePacketListener;
            block16: {
                PacketListener packetListener;
                this.flushQueue();
                if (currTick != MinecraftServer.currentTick) {
                    currTick = MinecraftServer.currentTick;
                    if (PurpurConfig.maxJoinsPerSecond) {
                        if (++tickSecond > 20) {
                            tickSecond = 0;
                            joinAttemptsThisTick = 0;
                        }
                    } else {
                        joinAttemptsThisTick = 0;
                    }
                }
                if (!((packetListener = this.packetListener) instanceof TickablePacketListener)) break block15;
                tickablePacketListener = (TickablePacketListener)packetListener;
                PacketListener packetListener2 = this.packetListener;
                if (!(packetListener2 instanceof ServerLoginPacketListenerImpl)) break block16;
                ServerLoginPacketListenerImpl loginPacketListener = (ServerLoginPacketListenerImpl)packetListener2;
                if (loginPacketListener.state == ServerLoginPacketListenerImpl.State.VERIFYING && joinAttemptsThisTick++ >= MAX_PER_TICK) break block15;
            }
            PacketProcessor.packetProcessing.push(this.packetListener);
            try {
                tickablePacketListener.tick();
            }
            finally {
                PacketProcessor.packetProcessing.pop();
            }
        }
        if (!this.isConnected() && !this.disconnectionHandled) {
            this.handleDisconnection();
        }
        if (this.channel != null && enableExplicitFlush) {
            this.channel.eventLoop().execute(() -> this.channel.flush());
        }
        if (this.tickCount++ % 20 == 0) {
            this.tickSecond();
        }
        if (this.bandwidthDebugMonitor != null) {
            this.bandwidthDebugMonitor.tick();
        }
    }

    protected void tickSecond() {
        this.averageSentPackets = Mth.lerp(0.75f, this.sentPackets, this.averageSentPackets);
        this.averageReceivedPackets = Mth.lerp(0.75f, this.receivedPackets, this.averageReceivedPackets);
        this.sentPackets = 0;
        this.receivedPackets = 0;
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public String getLoggableAddress(boolean logIps) {
        if (this.address == null) {
            return "local";
        }
        return logIps ? this.address.toString() : "IP hidden";
    }

    public void disconnect(Component reason) {
        this.disconnect(new DisconnectionDetails(reason));
    }

    public void disconnect(DisconnectionDetails disconnectionDetails) {
        this.preparing = false;
        this.clearPacketQueue();
        if (this.channel == null) {
            this.delayedDisconnect = disconnectionDetails;
        }
        if (this.isConnected()) {
            this.channel.close();
            this.disconnectionDetails = disconnectionDetails;
        }
    }

    public boolean isMemoryConnection() {
        return this.channel instanceof LocalChannel || this.channel instanceof LocalServerChannel;
    }

    public PacketFlow getReceiving() {
        return this.receiving;
    }

    public PacketFlow getSending() {
        return this.receiving.getOpposite();
    }

    public static Connection connectToServer(InetSocketAddress address, boolean useEpollIfAvailable, @Nullable LocalSampleLogger sampleLogger) {
        Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        if (sampleLogger != null) {
            connection.setBandwidthLogger(sampleLogger);
        }
        ChannelFuture channelFuture = Connection.connect(address, useEpollIfAvailable, connection);
        channelFuture.syncUninterruptibly();
        return connection;
    }

    public static ChannelFuture connect(InetSocketAddress address, boolean useEpollIfAvailable, final Connection connection) {
        EventLoopGroup eventLoopGroup;
        Class<NioSocketChannel> clazz;
        if (Epoll.isAvailable() && useEpollIfAvailable) {
            clazz = EpollSocketChannel.class;
            eventLoopGroup = (EventLoopGroup)NETWORK_EPOLL_WORKER_GROUP.get();
        } else {
            clazz = NioSocketChannel.class;
            eventLoopGroup = (EventLoopGroup)NETWORK_WORKER_GROUP.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelPipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                Connection.configureSerialization(channelPipeline, PacketFlow.CLIENTBOUND, false, connection.bandwidthDebugMonitor);
                connection.configurePacketHandler(channelPipeline);
            }
        })).channel(clazz)).connect(address.getAddress(), address.getPort());
    }

    private static String outboundHandlerName(boolean clientbound) {
        return clientbound ? "encoder" : "outbound_config";
    }

    private static String inboundHandlerName(boolean serverbound) {
        return serverbound ? "decoder" : "inbound_config";
    }

    public void configurePacketHandler(ChannelPipeline pipeline) {
        pipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
                super.write(channelHandlerContext, object, channelPromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void configureSerialization(ChannelPipeline pipeline, PacketFlow flow, boolean memoryOnly, @Nullable BandwidthDebugMonitor bandwidthDebugMonitor) {
        PacketFlow opposite = flow.getOpposite();
        boolean flag = flow == PacketFlow.SERVERBOUND;
        boolean flag1 = opposite == PacketFlow.SERVERBOUND;
        pipeline.addLast("splitter", (ChannelHandler)Connection.createFrameDecoder(bandwidthDebugMonitor, memoryOnly)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(Connection.inboundHandlerName(flag), flag ? new PacketDecoder<ServerHandshakePacketListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.Inbound()).addLast("prepender", (ChannelHandler)Connection.createFrameEncoder(memoryOnly)).addLast(Connection.outboundHandlerName(flag1), flag1 ? new PacketEncoder<ServerHandshakePacketListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.Outbound());
    }

    private static ChannelOutboundHandler createFrameEncoder(boolean memoryOnly) {
        return memoryOnly ? new LocalFrameEncoder() : new Varint21LengthFieldPrepender();
    }

    private static ChannelInboundHandler createFrameDecoder(@Nullable BandwidthDebugMonitor bandwidthDebugMonitor, boolean memoryOnly) {
        if (!memoryOnly) {
            return new Varint21FrameDecoder(bandwidthDebugMonitor);
        }
        return bandwidthDebugMonitor != null ? new MonitoredLocalFrameDecoder(bandwidthDebugMonitor) : new LocalFrameDecoder();
    }

    public static void configureInMemoryPipeline(ChannelPipeline pipeline, PacketFlow flow) {
        Connection.configureSerialization(pipeline, flow, true, null);
    }

    public static Connection connectToLocalServer(SocketAddress address) {
        final Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)LOCAL_WORKER_GROUP.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelPipeline = channel.pipeline();
                Connection.configureInMemoryPipeline(channelPipeline, PacketFlow.CLIENTBOUND);
                connection.configurePacketHandler(channelPipeline);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return connection;
    }

    public void setEncryptionKey(SecretKey key) throws CryptException {
        if (!this.encrypted) {
            try {
                VelocityCipher decryptionCipher = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
                VelocityCipher encryptionCipher = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
                this.encrypted = true;
                this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new CipherDecoder(decryptionCipher));
                this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new CipherEncoder(encryptionCipher));
            }
            catch (GeneralSecurityException e) {
                throw new CryptException(e);
            }
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return this.channel == null;
    }

    @Nullable
    public PacketListener getPacketListener() {
        return this.packetListener;
    }

    @Nullable
    public DisconnectionDetails getDisconnectionDetails() {
        return this.disconnectionDetails;
    }

    public void setReadOnly() {
        if (this.channel != null) {
            this.channel.config().setAutoRead(false);
        }
    }

    public void enableAutoRead() {
        if (this.channel != null) {
            this.channel.config().setAutoRead(true);
        }
    }

    public void setupCompression(int threshold, boolean validateDecompressed) {
        if (threshold >= 0) {
            VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(GlobalConfiguration.get().misc.compressionLevel.or(-1));
            ChannelHandler channelHandler = this.channel.pipeline().get("decompress");
            if (channelHandler instanceof CompressionDecoder) {
                CompressionDecoder compressionDecoder = (CompressionDecoder)channelHandler;
                compressionDecoder.setThreshold(compressor, threshold, validateDecompressed);
            } else {
                this.channel.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new CompressionDecoder(compressor, threshold, validateDecompressed));
            }
            channelHandler = this.channel.pipeline().get("compress");
            if (channelHandler instanceof CompressionEncoder) {
                CompressionEncoder compressionEncoder = (CompressionEncoder)channelHandler;
                compressionEncoder.setThreshold(threshold);
            } else {
                this.channel.pipeline().addAfter("prepender", "compress", (ChannelHandler)new CompressionEncoder(compressor, threshold));
            }
            this.channel.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_THRESHOLD_SET);
        } else {
            if (this.channel.pipeline().get("decompress") instanceof CompressionDecoder) {
                this.channel.pipeline().remove("decompress");
            }
            if (this.channel.pipeline().get("compress") instanceof CompressionEncoder) {
                this.channel.pipeline().remove("compress");
            }
            this.channel.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_DISABLED);
        }
    }

    public void handleDisconnection() {
        if (this.channel != null && !this.channel.isOpen() && !this.disconnectionHandled) {
            PacketListener packetListener1;
            this.disconnectionHandled = true;
            PacketListener packetListener = this.getPacketListener();
            PacketListener packetListener2 = packetListener1 = packetListener != null ? packetListener : this.disconnectListener;
            if (packetListener1 != null) {
                DisconnectionDetails disconnectionDetails = Objects.requireNonNullElseGet(this.getDisconnectionDetails(), () -> new DisconnectionDetails(Component.translatable("multiplayer.disconnect.generic")));
                packetListener1.onDisconnect(disconnectionDetails);
            }
            this.clearPacketQueue();
            if (packetListener instanceof ServerCommonPacketListenerImpl) {
                ServerCommonPacketListenerImpl commonPacketListener = (ServerCommonPacketListenerImpl)packetListener;
                GameProfile profile = commonPacketListener.getOwner();
                new PlayerConnectionCloseEvent(profile.id(), profile.name(), ((InetSocketAddress)this.address).getAddress(), false).callEvent();
            } else if (packetListener instanceof ServerLoginPacketListenerImpl) {
                ServerLoginPacketListenerImpl loginListener = (ServerLoginPacketListenerImpl)packetListener;
                switch (loginListener.state) {
                    case VERIFYING: 
                    case WAITING_FOR_DUPE_DISCONNECT: 
                    case PROTOCOL_SWITCHING: 
                    case ACCEPTED: {
                        GameProfile profile = loginListener.authenticatedProfile;
                        new PlayerConnectionCloseEvent(profile.id(), profile.name(), ((InetSocketAddress)this.address).getAddress(), false).callEvent();
                    }
                }
            }
        }
    }

    public float getAverageReceivedPackets() {
        return this.averageReceivedPackets;
    }

    public float getAverageSentPackets() {
        return this.averageSentPackets;
    }

    public void setBandwidthLogger(LocalSampleLogger bandwidthLogger) {
        this.bandwidthDebugMonitor = new BandwidthDebugMonitor(bandwidthLogger);
    }

    public void clearPacketQueue() {
        ServerPlayer player = this.getPlayer();
        for (Consumer consumer : this.pendingActions) {
            if (!(consumer instanceof PacketSendAction)) continue;
            PacketSendAction packetSendAction = (PacketSendAction)consumer;
            Packet<?> packet = packetSendAction.packet;
            if (!packet.hasFinishListener()) continue;
            packet.onPacketDispatchFinish(player, null);
        }
        this.pendingActions.clear();
    }

    private static class InnerUtil {
        private InnerUtil() {
        }

        @Nullable
        private static List<Packet<?>> buildExtraPackets(Packet<?> packet) {
            List<Packet<?>> extra = packet.getExtraPackets();
            if (extra == null || extra.isEmpty()) {
                return null;
            }
            ArrayList ret = new ArrayList(1 + extra.size());
            InnerUtil.buildExtraPackets0(extra, ret);
            return ret;
        }

        private static void buildExtraPackets0(List<Packet<?>> extraPackets, List<Packet<?>> into) {
            for (Packet<?> extra : extraPackets) {
                into.add(extra);
                List<Packet<?>> extraExtra = extra.getExtraPackets();
                if (extraExtra == null || extraExtra.isEmpty()) continue;
                InnerUtil.buildExtraPackets0(extraExtra, into);
            }
        }

        private static boolean canSendImmediate(Connection networkManager, Packet<?> packet) {
            return networkManager.isPending || networkManager.packetListener.protocol() != ConnectionProtocol.PLAY || packet instanceof ClientboundKeepAlivePacket || packet instanceof ClientboundPlayerChatPacket || packet instanceof ClientboundSystemChatPacket || packet instanceof ClientboundDisguisedChatPacket || packet instanceof ClientboundCommandSuggestionsPacket || packet instanceof ClientboundSetTitleTextPacket || packet instanceof ClientboundSetSubtitleTextPacket || packet instanceof ClientboundSetActionBarTextPacket || packet instanceof ClientboundSetTitlesAnimationPacket || packet instanceof ClientboundClearTitlesPacket || packet instanceof ClientboundSoundPacket || packet instanceof ClientboundSoundEntityPacket || packet instanceof ClientboundStopSoundPacket || packet instanceof ClientboundLevelParticlesPacket || packet instanceof ClientboundPlayerInfoUpdatePacket || packet instanceof ClientboundPlayerInfoRemovePacket || packet instanceof ClientboundBossEventPacket || packet instanceof ClientboundPongResponsePacket;
        }
    }

    private static final class PacketSendAction
    extends WrappedConsumer {
        private final Packet<?> packet;

        private PacketSendAction(Packet<?> packet, @Nullable ChannelFutureListener channelFutureListener, boolean flush) {
            super(connection -> connection.sendPacket(packet, channelFutureListener, flush));
            this.packet = packet;
        }
    }

    private static class WrappedConsumer
    implements Consumer<Connection> {
        private final Consumer<Connection> delegate;
        private final AtomicBoolean consumed = new AtomicBoolean(false);

        private WrappedConsumer(Consumer<Connection> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(Connection connection) {
            this.delegate.accept(connection);
        }

        public boolean tryMarkConsumed() {
            return this.consumed.compareAndSet(false, true);
        }

        public boolean isConsumed() {
            return this.consumed.get();
        }
    }
}

