/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import org.slf4j.Logger;

public class PacketProcessor
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Queue<ListenerAndPacket<?>> packetsToBeHandled = Queues.newConcurrentLinkedQueue();
    private final Thread runningThread;
    private boolean closed;
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public PacketProcessor(Thread runningThread) {
        this.runningThread = runningThread;
    }

    public final boolean executeSinglePacket() {
        if (this.closed) {
            return false;
        }
        ListenerAndPacket<?> task = this.packetsToBeHandled.poll();
        if (task == null) {
            return false;
        }
        task.handle();
        return true;
    }

    public boolean isSameThread() {
        return Thread.currentThread() == this.runningThread;
    }

    public <T extends PacketListener> void scheduleIfPossible(T listener, Packet<T> packet) {
        if (this.closed) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        boolean isEmpty = this.packetsToBeHandled.isEmpty();
        ListenerAndPacket<T> toAdd = new ListenerAndPacket<T>(listener, packet);
        this.packetsToBeHandled.add(toAdd);
        if (isEmpty || this.packetsToBeHandled.peek() == toAdd) {
            LockSupport.unpark(this.runningThread);
        }
    }

    public void processQueuedPackets() {
        if (!this.closed) {
            while (!this.packetsToBeHandled.isEmpty()) {
                this.packetsToBeHandled.poll().handle();
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> listeners = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            listeners.add(listener);
        }
        return listeners;
    }

    record ListenerAndPacket<T extends PacketListener>(T listener, Packet<T> packet) {
        public void handle() {
            packetProcessing.push((PacketListener)this.listener);
            try {
                T t = this.listener;
                if (t instanceof ServerCommonPacketListenerImpl) {
                    ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)t;
                    if (serverCommonPacketListener.processedDisconnect) {
                        return;
                    }
                }
                if (this.listener.shouldHandleMessage(this.packet)) {
                    try {
                        this.packet.handle(this.listener);
                    }
                    catch (Exception var3) {
                        ReportedException reportedException;
                        if (var3 instanceof ReportedException && (reportedException = (ReportedException)var3).getCause() instanceof OutOfMemoryError) {
                            throw PacketUtils.makeReportedException(var3, this.packet, this.listener);
                        }
                        this.listener.onPacketError(this.packet, var3);
                    }
                } else {
                    LOGGER.debug("Ignoring packet due to disconnection: {}", this.packet);
                }
            }
            finally {
                totalMainThreadPacketsProcessed.getAndIncrement();
                packetProcessing.pop();
            }
        }
    }
}

