/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;

public class VarInt {
    public static final int MAX_VARINT_SIZE = 5;
    private static final int DATA_BITS_MASK = 127;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int DATA_BITS_PER_BYTE = 7;
    private static final int[] VARINT_EXACT_BYTE_LENGTHS = new int[33];

    public static int getByteSize(int data) {
        return VARINT_EXACT_BYTE_LENGTHS[Integer.numberOfLeadingZeros(data)];
    }

    public static int getByteSizeOld(int data) {
        for (int i = 1; i < 5; ++i) {
            if ((data & -1 << i * 7) != 0) continue;
            return i;
        }
        return 5;
    }

    public static boolean hasContinuationBit(byte data) {
        return (data & 0x80) == 128;
    }

    public static int read(ByteBuf buffer) {
        byte _byte;
        int i = 0;
        int i1 = 0;
        do {
            _byte = buffer.readByte();
            i |= (_byte & 0x7F) << i1++ * 7;
            if (i1 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while (VarInt.hasContinuationBit(_byte));
        return i;
    }

    public static ByteBuf write(ByteBuf buffer, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buffer.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buffer.writeShort(w);
        } else {
            VarInt.writeOld(buffer, value);
        }
        return buffer;
    }

    public static ByteBuf writeOld(ByteBuf buffer, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buffer.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        buffer.writeByte(value);
        return buffer;
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            VarInt.VARINT_EXACT_BYTE_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        VarInt.VARINT_EXACT_BYTE_LENGTHS[32] = 1;
    }
}

