/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;

public class IdDispatchCodec<B extends ByteBuf, V, T>
implements StreamCodec<B, V> {
    private static final int UNKNOWN_TYPE = -1;
    private final Function<V, ? extends T> typeGetter;
    private final List<Entry<B, V, T>> byId;
    private final Object2IntMap<T> toId;

    IdDispatchCodec(Function<V, ? extends T> typeGetter, List<Entry<B, V, T>> byId, Object2IntMap<T> toId) {
        this.typeGetter = typeGetter;
        this.byId = byId;
        this.toId = toId;
    }

    @Override
    public V decode(B buffer) {
        int i = VarInt.read(buffer);
        if (i >= 0 && i < this.byId.size()) {
            Entry<B, V, T> entry = this.byId.get(i);
            try {
                return (V)entry.serializer.decode(buffer);
            }
            catch (Exception var5) {
                if (var5 instanceof DontDecorateException) {
                    throw var5;
                }
                throw new DecoderException("Failed to decode packet '" + String.valueOf(entry.type) + "'", (Throwable)var5);
            }
        }
        throw new DecoderException("Received unknown packet id " + i);
    }

    @Override
    public void encode(B buffer, V value) {
        T object = this.typeGetter.apply(value);
        int orDefault = this.toId.getOrDefault(object, -1);
        if (orDefault == -1) {
            throw new EncoderException("Sending unknown packet '" + String.valueOf(object) + "'");
        }
        VarInt.write(buffer, orDefault);
        Entry<B, V, T> entry = this.byId.get(orDefault);
        try {
            StreamCodec streamCodec = entry.serializer;
            streamCodec.encode(buffer, value);
        }
        catch (Exception var7) {
            if (var7 instanceof DontDecorateException) {
                throw var7;
            }
            throw new EncoderException("Failed to encode packet '" + String.valueOf(object) + "'", (Throwable)var7);
        }
    }

    public static <B extends ByteBuf, V, T> Builder<B, V, T> builder(Function<V, ? extends T> typeGetter) {
        return new Builder(typeGetter);
    }

    record Entry<B, V, T>(StreamCodec<? super B, ? extends V> serializer, T type) {
    }

    public static interface DontDecorateException {
    }

    public static class Builder<B extends ByteBuf, V, T> {
        private final List<Entry<B, V, T>> entries = new ArrayList<Entry<B, V, T>>();
        private final Function<V, ? extends T> typeGetter;

        Builder(Function<V, ? extends T> typeGetter) {
            this.typeGetter = typeGetter;
        }

        public Builder<B, V, T> add(T type, StreamCodec<? super B, ? extends V> serializer) {
            this.entries.add(new Entry<B, V, T>(serializer, type));
            return this;
        }

        public IdDispatchCodec<B, V, T> build() {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap();
            map.defaultReturnValue(-2);
            for (Entry<B, V, T> entry : this.entries) {
                int size = map.size();
                int i = map.putIfAbsent(entry.type, size);
                if (i == -2) continue;
                throw new IllegalStateException("Duplicate registration for type " + String.valueOf(entry.type));
            }
            return new IdDispatchCodec<B, V, T>(this.typeGetter, List.copyOf(this.entries), map);
        }
    }
}

