/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.server.level.ServerPlayer;

public interface Packet<T extends PacketListener> {
    public PacketType<? extends Packet<T>> type();

    public void handle(T var1);

    default public boolean hasLargePacketFallback() {
        return false;
    }

    default public boolean packetTooLarge(Connection manager) {
        return false;
    }

    default public boolean isSkippable() {
        return false;
    }

    default public boolean isTerminal() {
        return false;
    }

    public static <B extends ByteBuf, T extends Packet<?>> StreamCodec<B, T> codec(StreamMemberEncoder<B, T> encoder, StreamDecoder<B, T> decoder) {
        return StreamCodec.ofMember(encoder, decoder);
    }

    default public void onPacketDispatch(@Nullable ServerPlayer player) {
    }

    default public void onPacketDispatchFinish(@Nullable ServerPlayer player, @Nullable ChannelFuture future) {
    }

    default public boolean hasFinishListener() {
        return false;
    }

    default public boolean isReady() {
        return true;
    }

    @Nullable
    default public List<Packet<?>> getExtraPackets() {
        return null;
    }
}

