/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.time.Schedule;
import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.time.TickTime;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import dev.omega24.upnp4j.UPnP4J;
import dev.omega24.upnp4j.util.Protocol;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.event.world.WorldDifficultyChangeEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.EntityScheduler;
import io.papermc.paper.threadedregions.RegionizedServerInitEvent;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import io.papermc.paper.world.PaperWorldLoader;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.FileUtil;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.nbt.Tag;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DemoMode;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.progress.ChunkLoadStatusView;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.ServerConnectionListener;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.CommandStorage;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.help.SimpleHelpMap;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.util.CraftDifficulty;
import org.bukkit.craftbukkit.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.entity.RidableMoveEvent;
import org.purpurmc.purpur.task.BeehiveTask;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends ReentrantBlockableEventLoop<TickTask>
implements ServerInfo,
CommandSource,
ChunkIOErrorReporter,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger LOGGER;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String VANILLA_BRAND = "vanilla";
    private static final float AVERAGE_TICK_TIME_SMOOTHING = 0.8f;
    private static final int TICK_STATS_SPAN = 100;
    private static final long OVERLOADED_THRESHOLD_NANOS;
    private static final int OVERLOADED_TICKS_THRESHOLD = 20;
    private static final long OVERLOADED_WARNING_INTERVAL_NANOS;
    private static final int OVERLOADED_TICKS_WARNING_INTERVAL = 100;
    private static final long STATUS_EXPIRE_TIME_NANOS;
    private static final long PREPARE_LEVELS_DEFAULT_DELAY_NANOS;
    private static final int MAX_STATUS_PLAYER_SAMPLE = 12;
    public static final int SPAWN_POSITION_SEARCH_RADIUS = 5;
    private static final int AUTOSAVE_INTERVAL = 6000;
    private static final int MIMINUM_AUTOSAVE_TICKS = 100;
    private static final int MAX_TICK_LATENCY = 3;
    public static final int ABSOLUTE_MAX_WORLD_SIZE = 29999984;
    public static final LevelSettings DEMO_SETTINGS;
    public static final NameAndId ANONYMOUS_PLAYER_PROFILE;
    public LevelStorageSource.LevelStorageAccess storageSource;
    public final PlayerDataStorage playerDataStorage;
    private final List<Runnable> tickables = Lists.newArrayList();
    private MetricsRecorder metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    private Consumer<ProfileResults> onMetricsRecordingStopped = results -> this.stopRecordingMetrics();
    private Consumer<Path> onMetricsRecordingFinished = path -> {};
    private boolean willStartRecordingMetrics;
    @Nullable
    private TimeProfiler debugCommandProfiler;
    private boolean debugCommandProfilerDelayStart;
    private ServerConnectionListener connection;
    @Nullable
    private ServerStatus status;
    @Nullable
    private ServerStatus.Favicon statusIcon;
    private final RandomSource random = RandomSource.create();
    public final DataFixer fixerUpper;
    private String localIp;
    private int port = -1;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private Map<ResourceKey<Level>, ServerLevel> levels = Maps.newLinkedHashMap();
    private PlayerList playerList;
    private volatile boolean running = true;
    private volatile boolean isRestarting = false;
    private boolean stopped;
    private int tickCount;
    private int ticksUntilAutosave = 6000;
    protected final Proxy proxy;
    private boolean onlineMode;
    private boolean preventProxyConnections;
    private Component motd;
    private int playerIdleTimeout;
    private final long[] tickTimesNanos = new long[100];
    private long aggregatedTickTimesNanos = 0L;
    @Nullable
    private KeyPair keyPair;
    @Nullable
    private GameProfile singleplayerProfile;
    private boolean isDemo;
    private volatile boolean isReady;
    private long lastOverloadWarningNanos;
    protected final Services services;
    private final NotificationManager notificationManager;
    private long lastServerStatus;
    public final Thread serverThread;
    private long lastTickNanos = Util.getNanos();
    private long taskExecutionStartNanos = Util.getNanos();
    private long idleTimeNanos;
    private long nextTickTimeNanos = Util.getNanos();
    private boolean waitingForNextTick = false;
    private long delayedTasksMaxNextTickTimeNanos;
    private boolean mayHaveDelayedTasks;
    private final PackRepository packRepository;
    private final ServerScoreboard scoreboard = new ServerScoreboard(this);
    @Nullable
    private CommandStorage commandStorage;
    private final CustomBossEvents customBossEvents = new CustomBossEvents();
    private final ServerFunctionManager functionManager;
    private boolean enforceWhitelist;
    private boolean usingWhitelist;
    private float smoothedTickTimeMillis;
    public final Executor executor;
    @Nullable
    private String serverId;
    public ReloadableResources resources;
    private final StructureTemplateManager structureTemplateManager;
    private final ServerTickRateManager tickRateManager;
    private final ServerDebugSubscribers debugSubscribers = new ServerDebugSubscribers(this);
    protected WorldData worldData;
    private LevelData.RespawnData effectiveRespawnData = LevelData.RespawnData.DEFAULT;
    public PotionBrewing potionBrewing;
    private FuelValues fuelValues;
    private int emptyTicks;
    private volatile boolean isSaving;
    private static final AtomicReference<RuntimeException> fatalException;
    private final SuppressedExceptionCollector suppressedExceptions = new SuppressedExceptionCollector();
    private final DiscontinuousFrame tickFrame;
    private final PacketProcessor packetProcessor;
    public final WorldLoader.DataLoadContext worldLoaderContext;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public static final long startTimeMillis;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    public volatile boolean hasFullyShutdown;
    public volatile boolean abnormalExit;
    public volatile Thread shutdownThread;
    public final PaperConfigurations paperConfigurations;
    public boolean isIteratingOverLevels = false;
    private final Set<String> pluginsBlockingSleep = new HashSet<String>();
    public static final long SERVER_INIT;
    public boolean lagging = false;
    protected boolean upnp = false;
    public final TickData tickTimes1s = new TickData(TimeUnit.SECONDS.toNanos(1L));
    public final TickData tickTimes5s = new TickData(TimeUnit.SECONDS.toNanos(5L));
    public final TickData tickTimes10s = new TickData(TimeUnit.SECONDS.toNanos(10L));
    public final TickData tickTimes15s = new TickData(TimeUnit.SECONDS.toNanos(15L));
    public final TickData tickTimes1m = new TickData(TimeUnit.MINUTES.toNanos(1L));
    public final TickData tickTimes5m = new TickData(TimeUnit.MINUTES.toNanos(5L));
    public final TickData tickTimes15m = new TickData(TimeUnit.MINUTES.toNanos(15L));
    private final Schedule tickSchedule = new Schedule(0L);
    private long lastTickStart;
    private long currentTickStart;
    private long scheduledTickStart;
    private long taskExecutionTime;
    private final Object statsLock = new Object();
    @Nullable
    private double[] tps;
    @Nullable
    private TickData.MSPTData msptData5s;
    private volatile Throwable chunkSystemCrash;
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private long lastMidTickExecute;
    private long lastMidTickExecuteFailure;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    private final Object stopLock = new Object();
    public final EntityScheduler.EntitySchedulerTickList entitySchedulerTickList = new EntityScheduler.EntitySchedulerTickList();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(LOGGER)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTickTime(TickTime time) {
        Object object = this.statsLock;
        synchronized (object) {
            this.tickTimes1s.addDataFrom(time);
            this.tickTimes5s.addDataFrom(time);
            this.tickTimes10s.addDataFrom(time);
            this.tickTimes15s.addDataFrom(time);
            this.tickTimes1m.addDataFrom(time);
            this.tickTimes5m.addDataFrom(time);
            this.tickTimes15m.addDataFrom(time);
            this.clearTickTimeStatistics();
        }
    }

    private void clearTickTimeStatistics() {
        this.msptData5s = null;
        this.tps = null;
    }

    private static double getTPS(TickData tickData, long tickInterval) {
        Double avg = tickData.getTPSAverage(null, tickInterval);
        if (avg == null) {
            return 1.0E9 / (double)tickInterval;
        }
        return avg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getTPS() {
        Object object = this.statsLock;
        synchronized (object) {
            double[] tps = this.tps;
            if (tps == null) {
                this.tps = tps = this.computeTPS();
            }
            return (double[])tps.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TickData.MSPTData getMSPTData5s() {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.msptData5s == null) {
                this.msptData5s = this.tickTimes5s.getMSPTData(null, this.tickRateManager().nanosecondsPerTick());
            }
            return this.msptData5s;
        }
    }

    public double[] computeTPS() {
        long interval = this.tickRateManager().nanosecondsPerTick();
        return new double[]{MinecraftServer.getTPS(this.tickTimes5s, interval), MinecraftServer.getTPS(this.tickTimes1m, interval), MinecraftServer.getTPS(this.tickTimes5m, interval), MinecraftServer.getTPS(this.tickTimes15m, interval)};
    }

    public static <S extends MinecraftServer> S spin(Function<Thread, S> threadFunction) {
        MCTypeRegistry.init();
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicReference.get()).runServer(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, exception) -> LOGGER.error("Uncaught exception in server thread", exception));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer minecraftServer = (MinecraftServer)threadFunction.apply(thread);
        atomicReference.set(minecraftServer);
        thread.start();
        return (S)minecraftServer;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (ServerLevel world : this.getAllLevels()) {
            long currTime = System.nanoTime();
            if (currTime - world.moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.getChunkSource().pollTask()) {
                world.moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    @Override
    public final void moonrise$issueEmergencySave() {
        LOGGER.warn("Performing emergency save...");
        LOGGER.info("Saving all players...");
        this.getPlayerList().saveAll();
        LOGGER.info("Saved all players");
        LOGGER.info("Saving all worlds...");
        for (ServerLevel world : this.getAllLevels()) {
            LOGGER.info("Saving chunks in world '" + WorldUtil.getWorldName(world) + "'...");
            world.moonrise$issueEmergencySave();
            LOGGER.info("Saved chunks in world '" + WorldUtil.getWorldName(world) + "'...");
        }
        LOGGER.info("Saved all worlds");
        LOGGER.warn("Performed emergency save");
    }

    public MinecraftServer(OptionSet options, WorldLoader.DataLoadContext worldLoaderContext, Thread serverThread, LevelStorageSource.LevelStorageAccess storageSource, PackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer fixerUpper, Services services, LevelLoadListener levelLoadListener) {
        super("Server");
        SERVER = this;
        this.registries = worldStem.registries();
        this.worldData = worldStem.worldData();
        this.proxy = proxy;
        this.packRepository = packRepository;
        this.resources = new ReloadableResources(worldStem.resourceManager(), worldStem.dataPackResources());
        this.services = services;
        this.tickRateManager = new ServerTickRateManager(this);
        this.storageSource = storageSource;
        this.playerDataStorage = storageSource.createPlayerStorage();
        this.fixerUpper = fixerUpper;
        this.functionManager = new ServerFunctionManager(this, this.resources.managers.getFunctionLibrary());
        HolderLookup.RegistryLookup holderGetter = this.registries.compositeAccess().lookupOrThrow(Registries.BLOCK).filterFeatures(this.worldData.enabledFeatures());
        this.structureTemplateManager = new StructureTemplateManager(worldStem.resourceManager(), storageSource, fixerUpper, holderGetter);
        this.serverThread = serverThread;
        this.executor = Util.backgroundExecutor();
        this.potionBrewing = PotionBrewing.bootstrap(this.worldData.enabledFeatures());
        this.resources.managers.getRecipeManager().finalizeRecipeLoading(this.worldData.enabledFeatures());
        this.fuelValues = FuelValues.vanillaBurnTimes(this.registries.compositeAccess(), this.worldData.enabledFeatures());
        this.tickFrame = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.notificationManager = new NotificationManager();
        this.packetProcessor = new PacketProcessor(serverThread);
        this.options = options;
        this.worldLoaderContext = worldLoaderContext;
        LogManagerShutdownThread.unhook();
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paper().configurations();
    }

    private void readScoreboard(DimensionDataStorage dataStorage) {
        dataStorage.computeIfAbsent(ServerScoreboard.TYPE);
    }

    protected abstract boolean initServer() throws IOException;

    public ChunkLoadStatusView createChunkLoadStatusView(final int radius) {
        return new ChunkLoadStatusView(){
            @Nullable
            private ChunkMap chunkMap;
            private int centerChunkX;
            private int centerChunkZ;

            @Override
            public void moveTo(ResourceKey<Level> dimension, ChunkPos chunkPos) {
                ServerLevel level = MinecraftServer.this.getLevel(dimension);
                this.chunkMap = level != null ? level.getChunkSource().chunkMap : null;
                this.centerChunkX = chunkPos.x;
                this.centerChunkZ = chunkPos.z;
            }

            @Override
            @Nullable
            public ChunkStatus get(int x, int z) {
                return this.chunkMap == null ? null : this.chunkMap.getLatestStatus(ChunkPos.asLong(x + this.centerChunkX - radius, z + this.centerChunkZ - radius));
            }

            @Override
            public int radius() {
                return radius;
            }
        };
    }

    protected void loadLevel(String levelId) {
        boolean flag = !JvmProfiler.INSTANCE.isRunning() && SharedConstants.DEBUG_JFR_PROFILING_ENABLE_LEVEL_LOADING && JvmProfiler.INSTANCE.start(Environment.from(this));
        ProfiledDuration profiledDuration = JvmProfiler.INSTANCE.onWorldLoadedStarted();
        PaperWorldLoader loader = PaperWorldLoader.create(this, levelId);
        loader.loadInitialWorlds();
        if (profiledDuration != null) {
            profiledDuration.finish(true);
        }
        if (flag) {
            try {
                JvmProfiler.INSTANCE.stop();
            }
            catch (Throwable var4) {
                LOGGER.warn("Failed to stop JFR profiling", var4);
            }
        }
    }

    protected void initPostWorld() {
        ServerScoreboard scoreboard = this.getScoreboard();
        Collection toRemove = scoreboard.getPlayerTeams().stream().filter(team -> team.getName().startsWith("collideRule_")).map(PlayerTeam::getName).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.removePlayerTeam(scoreboard.getPlayerTeam(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.getPlayerList().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            PlayerTeam collideTeam = scoreboard.addPlayerTeam(this.getPlayerList().collideRuleTeamName);
            collideTeam.setSeeFriendlyInvisibles(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.spark.registerCommandBeforePlugins(this.server);
        this.server.spark.enableAfterPlugins(this.server);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        this.server.getCommandMap().registerServerAliases();
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.connection.acceptConnections();
    }

    protected void forceDifficulty() {
    }

    public void createLevel(LevelStem levelStem, PaperWorldLoader.WorldLoadingInfo loadingInfo, LevelStorageSource.LevelStorageAccess levelStorageAccess, PrimaryLevelData serverLevelData) {
        ServerLevel serverLevel;
        WorldOptions worldOptions = serverLevelData.worldGenOptions();
        long seed = worldOptions.seed();
        long l = BiomeManager.obfuscateSeed(seed);
        ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner(serverLevelData));
        ChunkGenerator chunkGenerator = this.server.getGenerator(loadingInfo.name());
        BiomeProvider biomeProvider = this.server.getBiomeProvider(loadingInfo.name());
        CraftWorldInfo worldInfo = new CraftWorldInfo(serverLevelData, levelStorageAccess, World.Environment.getEnvironment((int)loadingInfo.dimension()), levelStem.type().value(), levelStem.generator(), this.registryAccess());
        if (biomeProvider == null && chunkGenerator != null) {
            biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ResourceKey<Level> dimensionKey = ResourceKey.create(Registries.DIMENSION, loadingInfo.stemKey().location());
        if (loadingInfo.stemKey() == LevelStem.OVERWORLD) {
            serverLevel = new ServerLevel(this, this.executor, levelStorageAccess, serverLevelData, dimensionKey, levelStem, serverLevelData.isDebugWorld(), l, (List<CustomSpawner>)list, true, null, World.Environment.getEnvironment((int)loadingInfo.dimension()), chunkGenerator, biomeProvider);
            this.worldData = serverLevelData;
            this.worldData.setGameType(((DedicatedServer)this).getProperties().gameMode.get());
            DimensionDataStorage dataStorage = serverLevel.getDataStorage();
            this.readScoreboard(dataStorage);
            this.commandStorage = new CommandStorage(dataStorage);
            this.server.scoreboardManager = new CraftScoreboardManager(this, serverLevel.getScoreboard());
        } else {
            ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && levelStem.type().is(BuiltinDimensionTypes.OVERWORLD) ? list : Collections.emptyList();
            serverLevel = new ServerLevel(this, this.executor, levelStorageAccess, serverLevelData, dimensionKey, levelStem, this.worldData.isDebugWorld(), l, (List<CustomSpawner>)spawners, true, this.overworld().getRandomSequences(), World.Environment.getEnvironment((int)loadingInfo.dimension()), chunkGenerator, biomeProvider);
        }
        this.addLevel(serverLevel);
        this.initWorld(serverLevel, serverLevelData, worldOptions);
    }

    public void initWorld(ServerLevel serverLevel, PrimaryLevelData serverLevelData, WorldOptions worldOptions) {
        boolean isDebugWorld = this.worldData.isDebugWorld();
        if (serverLevel.generator != null) {
            serverLevel.getWorld().getPopulators().addAll(serverLevel.generator.getDefaultPopulators((World)serverLevel.getWorld()));
        }
        this.initWorldBorder(serverLevelData, serverLevel);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)serverLevel.getWorld()));
        if (!serverLevelData.isInitialized()) {
            try {
                MinecraftServer.setInitialSpawn(serverLevel, serverLevelData, worldOptions.generateBonusChest(), isDebugWorld, serverLevel.levelLoadListener);
                serverLevelData.setInitialized(true);
                if (isDebugWorld) {
                    this.setupDebugLevel(this.worldData);
                }
            }
            catch (Throwable var27) {
                CrashReport crashReport = CrashReport.forThrowable(var27, "Exception initializing level");
                try {
                    serverLevel.fillReportDetails(crashReport);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            serverLevelData.setInitialized(true);
        }
        GlobalPos globalPos = this.selectLevelLoadFocusPos();
        serverLevel.levelLoadListener.updateFocus(globalPos.dimension(), new ChunkPos(globalPos.pos()));
        if (serverLevelData.getCustomBossEvents() != null) {
            this.getCustomBossEvents().load(serverLevelData.getCustomBossEvents(), this.registryAccess());
        }
    }

    private void initWorldBorder(PrimaryLevelData serverLevelData, ServerLevel serverLevel) {
        ServerLevel serverLevel1 = serverLevel;
        Optional<WorldBorder.Settings> legacyWorldBorderSettings = serverLevelData.getLegacyWorldBorderSettings();
        if (legacyWorldBorderSettings.isPresent()) {
            WorldBorder.Settings settings = legacyWorldBorderSettings.get();
            DimensionDataStorage dataStorage1 = serverLevel1.getDataStorage();
            if (dataStorage1.get(WorldBorder.TYPE) == null) {
                double coordinateScale = serverLevel1.dimensionType().coordinateScale();
                WorldBorder.Settings settings1 = new WorldBorder.Settings(settings.centerX() / coordinateScale, settings.centerZ() / coordinateScale, settings.damagePerBlock(), settings.safeZone(), settings.warningBlocks(), settings.warningTime(), settings.size(), settings.lerpTime(), settings.lerpTarget());
                dataStorage1.set(WorldBorder.TYPE, settings1.toWorldBorder());
            }
            serverLevelData.setLegacyWorldBorderSettings(Optional.empty());
        }
        serverLevel.getWorldBorder().world = serverLevel;
        serverLevel.getWorldBorder().setAbsoluteMaxSize(this.getAbsoluteMaxWorldSize());
        this.getPlayerList().addWorldborderListener(serverLevel);
    }

    private static void setInitialSpawn(ServerLevel level, ServerLevelData levelData, boolean generateBonusChest, boolean debug, LevelLoadListener levelLoadListener) {
        if (SharedConstants.DEBUG_ONLY_GENERATE_HALF_THE_WORLD && SharedConstants.DEBUG_WORLD_RECREATE) {
            levelData.setSpawn(LevelData.RespawnData.of(level.dimension(), new BlockPos(0, 64, -100), 0.0f, 0.0f));
        } else if (debug) {
            levelData.setSpawn(LevelData.RespawnData.of(level.dimension(), BlockPos.ZERO.above(80), 0.0f, 0.0f));
        } else {
            ServerChunkCache chunkSource = level.getChunkSource();
            if (level.generator != null) {
                Random rand = new Random(level.getSeed());
                Location spawn = level.generator.getFixedSpawnLocation((World)level.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != level.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + levelData.getLevelName() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    levelData.setSpawn(new LevelData.RespawnData(GlobalPos.of(level.dimension(), new BlockPos(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ())), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            ChunkPos chunkPos = new ChunkPos(chunkSource.randomState().sampler().findSpawnPosition());
            levelLoadListener.start(LevelLoadListener.Stage.PREPARE_GLOBAL_SPAWN, 0);
            levelLoadListener.updateFocus(level.dimension(), chunkPos);
            int spawnHeight = chunkSource.getGenerator().getSpawnHeight(level);
            if (spawnHeight < level.getMinY()) {
                BlockPos worldPosition = chunkPos.getWorldPosition();
                spawnHeight = level.getHeight(Heightmap.Types.WORLD_SURFACE, worldPosition.getX() + 8, worldPosition.getZ() + 8);
            }
            levelData.setSpawn(LevelData.RespawnData.of(level.dimension(), chunkPos.getWorldPosition().offset(8, spawnHeight, 8), 0.0f, 0.0f));
            int i = 0;
            int i1 = 0;
            int i2 = 0;
            int i3 = -1;
            for (int i4 = 0; i4 < Mth.square(11); ++i4) {
                BlockPos spawnPosInChunk;
                if (i >= -5 && i <= 5 && i1 >= -5 && i1 <= 5 && (spawnPosInChunk = PlayerSpawnFinder.getSpawnPosInChunk(level, new ChunkPos(chunkPos.x + i, chunkPos.z + i1))) != null) {
                    levelData.setSpawn(LevelData.RespawnData.of(level.dimension(), spawnPosInChunk, 0.0f, 0.0f));
                    break;
                }
                if (i == i1 || i < 0 && i == -i1 || i > 0 && i == 1 - i1) {
                    int i5 = i2;
                    i2 = -i3;
                    i3 = i5;
                }
                i += i2;
                i1 += i3;
            }
            if (generateBonusChest) {
                level.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.get(MiscOverworldFeatures.BONUS_CHEST)).ifPresent(holder -> ((ConfiguredFeature)holder.value()).place(level, chunkSource.getGenerator(), level.random, levelData.getRespawnData().pos()));
            }
            levelLoadListener.finish(LevelLoadListener.Stage.PREPARE_GLOBAL_SPAWN);
        }
    }

    private void setupDebugLevel(WorldData worldData) {
        worldData.setDifficulty(Difficulty.PEACEFUL);
        worldData.setDifficultyLocked(true);
        ServerLevelData serverLevelData = worldData.overworldData();
        serverLevelData.setRaining(false);
        serverLevelData.setThundering(false);
        serverLevelData.setClearWeatherTime(1000000000);
        serverLevelData.setDayTime(6000L);
        serverLevelData.setGameType(GameType.SPECTATOR);
    }

    public void prepareLevel(ServerLevel serverLevel) {
        this.forceTicks = true;
        ChunkLoadCounter chunkLoadCounter = new ChunkLoadCounter();
        chunkLoadCounter.track(serverLevel, () -> {
            TicketStorage ticketStorage = serverLevel.getDataStorage().get(TicketStorage.TYPE);
            if (ticketStorage != null) {
                ticketStorage.activateAllDeactivatedTickets();
            }
        });
        serverLevel.levelLoadListener.start(LevelLoadListener.Stage.LOAD_INITIAL_CHUNKS, chunkLoadCounter.totalChunks());
        do {
            serverLevel.levelLoadListener.update(LevelLoadListener.Stage.LOAD_INITIAL_CHUNKS, chunkLoadCounter.readyChunks(), chunkLoadCounter.totalChunks());
            this.executeModerately();
        } while (chunkLoadCounter.pendingChunks() > 0);
        serverLevel.levelLoadListener.finish(LevelLoadListener.Stage.LOAD_INITIAL_CHUNKS);
        serverLevel.setSpawnSettings(serverLevel.serverLevelData.getDifficulty() != Difficulty.PEACEFUL && serverLevel.getGameRules().getBoolean(GameRules.RULE_SPAWN_MONSTERS));
        this.updateEffectiveRespawnData();
        this.forceTicks = false;
        new WorldLoadEvent((World)serverLevel.getWorld()).callEvent();
    }

    protected GlobalPos selectLevelLoadFocusPos() {
        return this.worldData.overworldData().getRespawnData().globalPos();
    }

    public GameType getDefaultGameType() {
        return this.worldData.getGameType();
    }

    public boolean isHardcore() {
        return this.worldData.isHardcore();
    }

    public abstract int operatorUserPermissionLevel();

    public abstract int getFunctionCompilationLevel();

    public abstract boolean shouldRconBroadcast();

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag = false;
        for (ServerLevel serverLevel : this.getAllLevels()) {
            if (!suppressLogs) {
                LOGGER.info("Saving chunks for level '{}'/{}", (Object)serverLevel, (Object)serverLevel.dimension().location());
            }
            serverLevel.save(null, flush, SharedConstants.DEBUG_DONT_SAVE_WORLD || serverLevel.noSave && !force, close);
            flag = true;
        }
        if (flush) {
            for (ServerLevel serverLevel : this.getAllLevels()) {
                LOGGER.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)serverLevel.getChunkSource().chunkMap.getStorageName());
            }
            LOGGER.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEverything(boolean suppressLogs, boolean flush, boolean force) {
        boolean var4;
        try {
            this.isSaving = true;
            this.getPlayerList().saveAll();
            var4 = this.saveAllChunks(suppressLogs, flush, force);
        }
        finally {
            this.isSaving = false;
        }
        return var4;
    }

    @Override
    public void close() {
        this.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        Iterator<ServerLevel> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        this.packetProcessor.close();
        if (this.metricsRecorder.isRecording()) {
            this.cancelRecordingMetrics();
        }
        LOGGER.info("Stopping server");
        Commands.COMMAND_SENDING_POOL.shutdownNow();
        if (this.upnp) {
            if (UPnP4J.close((int)this.getPort(), (Protocol)Protocol.TCP)) {
                LOGGER.info("[UPnP] Port {} closed", (Object)this.getPort());
            } else {
                LOGGER.error("[UPnP] Failed to close port {}", (Object)this.getPort());
            }
        }
        if (this.server != null) {
            this.server.spark.disable();
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.getConnection().stop();
        this.isSaving = true;
        if (this.playerList != null) {
            LOGGER.info("Saving players");
            this.playerList.saveAll();
            this.playerList.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.info("Saving worlds");
        for (ServerLevel serverLevel : this.getAllLevels()) {
            if (serverLevel == null) continue;
            serverLevel.noSave = false;
        }
        for (ServerLevel world : this.getAllLevels()) {
            world.getChunkSource().deactivateTicketsOnClosing();
        }
        this.saveAllChunks(false, true, false, true);
        this.isSaving = false;
        this.resources.close();
        try {
            this.storageSource.close();
        }
        catch (IOException var4) {
            LOGGER.error("Failed to unlock level {}", (Object)this.storageSource.getLevelId(), (Object)var4);
        }
        MCUtil.ASYNC_EXECUTOR.shutdown();
        try {
            MCUtil.ASYNC_EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            LOGGER.info("Saving usercache.json");
            this.services().nameToIdCache().save(false);
        }
        LOGGER.info("Waiting for all RegionFile I/O tasks to complete...");
        MoonriseRegionFileIO.flush(this);
        LOGGER.info("All RegionFile I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
        Util.shutdownExecutors();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.onServerExit();
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void halt(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        BossBarTask.stopAll();
        BeehiveTask.instance().unregister();
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.running = false;
        if (waitForShutdown) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException var3) {
                LOGGER.error("Error while shutting down", (Throwable)var3);
            }
        }
    }

    private void initTickSchedule() {
        long interval = this.isPaused() || !this.tickRateManager.isSprinting() ? this.tickRateManager.nanosecondsPerTick() : 0L;
        this.tickSchedule.setNextPeriod(this.nextTickTimeNanos, interval);
        this.lastTickStart = Long.MIN_VALUE;
        this.scheduledTickStart = this.tickSchedule.getDeadline(interval);
    }

    private void recordEndOfTick() {
        long prevStart = this.lastTickStart;
        long currStart = this.currentTickStart;
        this.lastTickStart = this.currentTickStart;
        long scheduledStart = this.scheduledTickStart;
        this.scheduledTickStart = this.nextTickTimeNanos;
        long now = Util.getNanos();
        TickTime time = new TickTime(prevStart, scheduledStart, currStart, 0L, now, 0L, this.taskExecutionTime, 0L, false);
        this.taskExecutionTime = 0L;
        this.addTickTime(time);
    }

    private void runAllTasksAtTickStart() {
        this.startMeasuringTaskExecutionTime();
        ProfilerFiller profiler = Profiler.get();
        profiler.push("moonrise:run_all_tasks");
        profiler.push("moonrise:run_all_server");
        while (super.pollTask()) {
            this.moonrise$executeMidTickTasks();
            this.packetProcessor.executeSinglePacket();
        }
        profiler.popPush("moonrise:run_all_packets");
        while (this.packetProcessor.executeSinglePacket()) {
            this.moonrise$executeMidTickTasks();
        }
        profiler.popPush("moonrise:run_all_chunk");
        for (ServerLevel world : this.getAllLevels()) {
            profiler.push(world.toString() + " " + String.valueOf(world.dimension().location()));
            profiler.push("moonrise:distance_manager_update");
            world.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
            profiler.popPush("moonrise:legacy_chunk_tasks");
            world.getChunkSource().mainThreadProcessor.executeAllRecentInternalTasks();
            profiler.popPush("moonrise:chunk_system_tasks");
            world.moonrise$getChunkTaskScheduler().executeAllRecentlyQueuedMainThreadTasks();
            profiler.pop();
            profiler.pop();
        }
        profiler.pop();
        profiler.pop();
        this.finishMeasuringTaskExecutionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTaskExecutionTimeWhileWaiting() {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("moonrise:execute_tasks_until_tick");
        this.waitingForNextTick = true;
        boolean isLoggingEnabled = this.isTickTimeLoggingEnabled();
        try {
            long deadline = this.nextTickTimeNanos;
            while (true) {
                long start;
                if ((start = Util.getNanos()) - deadline >= 0L) {
                } else {
                    while (this.pollTask() && Util.getNanos() - deadline < 0L) {
                    }
                    long now = Util.getNanos();
                    this.taskExecutionTime += now - start;
                    long toWait = deadline - now;
                    if (toWait > 0L) {
                        LockSupport.parkNanos("waiting for tick or tasks", toWait);
                        if (!isLoggingEnabled) continue;
                        this.idleTimeNanos += Util.getNanos() - now;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.waitingForNextTick = false;
        }
        profiler.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runServer() {
        try {
            if (!this.initServer()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.nextTickTimeNanos = Util.getNanos();
            this.initTickSchedule();
            this.statusIcon = this.loadStatusIcon().orElse(null);
            this.status = this.buildServerStatus();
            this.server.spark.enableBeforePlugins();
            LOGGER.info("Running delayed init tasks");
            new RegionizedServerInitEvent().callEvent();
            this.server.getScheduler().mainThreadHeartbeat();
            long actualDoneTimeMs = System.currentTimeMillis() - Main.BOOT_TIME.toEpochMilli();
            LOGGER.info("Done ({})! For help, type \"help\"", (Object)String.format(Locale.ROOT, "%.3fs", (double)actualDoneTimeMs / 1000.0));
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            if (GlobalConfiguration.isFirstStart) {
                LOGGER.info("*************************************************************************************");
                LOGGER.info("This is the first time you're starting this server.");
                LOGGER.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                LOGGER.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                LOGGER.info("*************************************************************************************");
            }
            if (!Boolean.getBoolean("Purpur.IReallyDontWantStartupCommands") && !PurpurConfig.startupCommands.isEmpty()) {
                LOGGER.info("Purpur: Running startup commands specified in purpur.yml.");
                for (String startupCommand : PurpurConfig.startupCommands) {
                    LOGGER.info("Purpur: Running the following command: \"{}\"", (Object)startupCommand);
                    ((DedicatedServer)this).handleConsoleInput(startupCommand, this.createCommandSourceStack());
                }
            }
            while (this.running) {
                boolean flag;
                long l;
                long tickStart = System.nanoTime();
                if (!this.isPaused() && this.tickRateManager.isSprinting() && this.tickRateManager.checkShouldSprintThisTick()) {
                    l = 0L;
                    this.tickSchedule.setNextPeriod(tickStart, l);
                } else {
                    l = this.tickRateManager.nanosecondsPerTick();
                    long ticksBehind = Math.max(1L, this.tickSchedule.getPeriodsAhead(l, tickStart));
                    long catchup = Math.max(1, PurpurConfig.tpsCatchup ? 5 : 1);
                    boolean bl = this.lagging = this.getTPS()[0] < PurpurConfig.laggingThreshold;
                    if (ticksBehind > catchup) {
                        long difference = ticksBehind - catchup;
                        this.tickSchedule.advanceBy(difference, l);
                    }
                    this.tickSchedule.advanceBy(1L, l);
                }
                this.lastOverloadWarningNanos = this.nextTickTimeNanos = this.tickSchedule.getDeadline(l);
                this.currentTickStart = tickStart;
                ++currentTick;
                boolean bl = flag = l == 0L;
                if (this.debugCommandProfilerDelayStart) {
                    this.debugCommandProfilerDelayStart = false;
                    this.debugCommandProfiler = new TimeProfiler(Util.getNanos(), this.tickCount);
                }
                try (Profiler.Scope scope = Profiler.use(this.createProfiler());){
                    ProfilerFiller profilerFiller = Profiler.get();
                    profilerFiller.push("tick");
                    this.tickFrame.start();
                    this.runAllTasksAtTickStart();
                    this.tickServer(flag ? () -> false : this::haveTime);
                    Throwable crash = this.chunkSystemCrash;
                    if (crash != null) {
                        this.chunkSystemCrash = null;
                        throw new RuntimeException("Chunk system crash propagated to tick()", crash);
                    }
                    this.tickFrame.end();
                    this.recordEndOfTick();
                    profilerFiller.popPush("nextTickWait");
                    this.mayHaveDelayedTasks = true;
                    this.delayedTasksMaxNextTickTimeNanos = Math.max(Util.getNanos() + l, this.nextTickTimeNanos);
                    this.startMeasuringTaskExecutionTime();
                    this.recordTaskExecutionTimeWhileWaiting();
                    this.finishMeasuringTaskExecutionTime();
                    if (flag) {
                        this.tickRateManager.endTickWork();
                    }
                    profilerFiller.pop();
                    this.logFullTickTime();
                }
                finally {
                    this.endMetricsRecordingTick();
                }
                this.isReady = true;
                JvmProfiler.INSTANCE.onServerTick(this.smoothedTickTimeMillis);
            }
        }
        catch (Throwable var69) {
            LOGGER.error("Encountered an unexpected exception", var69);
            CrashReport crashReport = MinecraftServer.constructOrExtractCrashReport(var69);
            this.fillSystemReport(crashReport.getSystemReport());
            Path path = this.getServerDirectory().resolve("crash-reports").resolve("crash-" + Util.getFilenameFormattedDateTime() + "-server.txt");
            if (crashReport.saveToFile(path, ReportType.CRASH)) {
                LOGGER.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                LOGGER.error("We were unable to save this crash report to disk.");
            }
            this.onServerCrash(crashReport);
        }
        finally {
            try {
                this.stopped = true;
                this.stopServer();
            }
            catch (Throwable var64) {
                LOGGER.error("Exception stopping the server", var64);
            }
        }
    }

    private void logFullTickTime() {
        long nanos = Util.getNanos();
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logSample(nanos - this.lastTickNanos);
        }
        this.lastTickNanos = nanos;
    }

    private void startMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            this.taskExecutionStartNanos = Util.getNanos();
            this.idleTimeNanos = 0L;
        }
    }

    private void finishMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            SampleLogger tickTimeLogger = this.getTickTimeLogger();
            tickTimeLogger.logPartialSample(Util.getNanos() - this.taskExecutionStartNanos - this.idleTimeNanos, TpsDebugDimensions.SCHEDULED_TASKS.ordinal());
            tickTimeLogger.logPartialSample(this.idleTimeNanos, TpsDebugDimensions.IDLE.ordinal());
        }
    }

    private static CrashReport constructOrExtractCrashReport(Throwable cause) {
        CrashReport report;
        ReportedException reportedException = null;
        for (Throwable throwable = cause; throwable != null; throwable = throwable.getCause()) {
            ReportedException reportedException1;
            if (!(throwable instanceof ReportedException)) continue;
            reportedException = reportedException1 = (ReportedException)throwable;
        }
        if (reportedException != null) {
            report = reportedException.getReport();
            if (reportedException != cause) {
                report.addCategory("Wrapped in").setDetailError("Wrapping exception", cause);
            }
        } else {
            report = new CrashReport("Exception in server tick loop", cause);
        }
        return report;
    }

    private boolean haveTime() {
        return this.forceTicks || this.runningTask() || Util.getNanos() < (this.mayHaveDelayedTasks ? this.delayedTasksMaxNextTickTimeNanos : this.nextTickTimeNanos);
    }

    private void executeModerately() {
        this.runAllTasks();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean throwIfFatalException() {
        RuntimeException runtimeException = fatalException.get();
        if (runtimeException != null) {
            throw runtimeException;
        }
        return true;
    }

    public static void setFatalException(RuntimeException fatalException) {
        MinecraftServer.fatalException.compareAndSet(null, fatalException);
    }

    @Override
    public void managedBlock(BooleanSupplier isDone) {
        super.managedBlock(() -> MinecraftServer.throwIfFatalException() && isDone.getAsBoolean());
    }

    public NotificationManager notificationManager() {
        return this.notificationManager;
    }

    protected void waitUntilNextTick() {
        ProfilerFiller profilerFiller = Profiler.get();
        this.waitingForNextTick = true;
        try {
            this.managedBlock(() -> Util.getNanos() - this.nextTickTimeNanos >= 0L);
        }
        finally {
            this.waitingForNextTick = false;
        }
    }

    @Override
    public void waitForTasks() {
        boolean isTickTimeLoggingEnabled = this.isTickTimeLoggingEnabled();
        long l = isTickTimeLoggingEnabled ? Util.getNanos() : 0L;
        long l1 = this.waitingForNextTick ? this.nextTickTimeNanos - Util.getNanos() : 100000L;
        LockSupport.parkNanos("waiting for tasks", l1);
        if (isTickTimeLoggingEnabled) {
            this.idleTimeNanos += Util.getNanos() - l;
        }
    }

    @Override
    public TickTask wrapRunnable(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.tickCount, runnable);
    }

    @Override
    protected boolean shouldRun(TickTask runnable) {
        return runnable.getTick() + 1 < this.tickCount || this.haveTime();
    }

    @Override
    public boolean pollTask() {
        boolean flag;
        this.mayHaveDelayedTasks = flag = this.packetProcessor.executeSinglePacket() | this.pollTaskInternal();
        return flag;
    }

    private boolean pollTaskInternal() {
        if (super.pollTask()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.tickRateManager.isSprinting() || this.shouldRunAllTasks() || this.haveTime()) {
            for (ServerLevel serverLevel : this.getAllLevels()) {
                if (!serverLevel.getChunkSource().pollTask()) continue;
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void doRunTask(TickTask task) {
        Profiler.get().incrementCounter("runTask");
        super.doRunTask(task);
    }

    private Optional<ServerStatus.Favicon> loadStatusIcon() {
        Optional<Path> optional = Optional.of(this.getFile("server-icon.png")).filter(path -> Files.isRegularFile(path, new LinkOption[0])).or(() -> this.storageSource.getIconFile().filter(path -> Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                return Optional.of(new ServerStatus.Favicon(byteArrayOutputStream.toByteArray()));
            }
            catch (Exception var3) {
                LOGGER.error("Couldn't load server icon", (Throwable)var3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> getWorldScreenshotFile() {
        return this.storageSource.getIconFile();
    }

    public Path getServerDirectory() {
        return Path.of("", new String[0]);
    }

    public void onServerCrash(CrashReport report) {
    }

    public void onServerExit() {
    }

    public boolean isPaused() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickServer(BooleanSupplier hasTimeLeft) {
        WatchdogThread.tick();
        long nanos = Util.getNanos();
        int i = this.pauseWhenEmptySeconds() * 20;
        this.removeDisabledPluginsBlockingSleep();
        if (i > 0) {
            this.emptyTicks = this.playerList.getPlayerCount() == 0 && !this.tickRateManager.isSprinting() && this.pluginsBlockingSleep.isEmpty() ? ++this.emptyTicks : 0;
            if (this.emptyTicks >= i) {
                Runnable task;
                this.server.spark.tickStart();
                if (this.emptyTicks == i) {
                    LOGGER.info("Server empty for {} seconds, pausing", (Object)this.pauseWhenEmptySeconds());
                    this.autoSave();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                while ((task = this.processQueue.poll()) != null) {
                    task.run();
                }
                for (ServerLevel level : this.levels.values()) {
                    level.getChunkSource().tick(() -> true, false);
                }
                this.server.spark.executeMainThreadTasks();
                this.tickConnection();
                this.server.spark.tickEnd((double)(System.nanoTime() - this.currentTickStart) / 1000000.0);
                return;
            }
        }
        this.server.spark.tickStart();
        new ServerTickStartEvent(this.tickCount + 1).callEvent();
        ++this.tickCount;
        this.tickRateManager.tick();
        this.tickChildren(hasTimeLeft);
        if (nanos - this.lastServerStatus >= STATUS_EXPIRE_TIME_NANOS) {
            this.lastServerStatus = nanos;
            this.status = this.buildServerStatus();
        }
        --this.ticksUntilAutosave;
        ProfilerFiller profiler = Profiler.get();
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        profiler.push("save");
        boolean fullSave = this.autosavePeriod > 0 && this.tickCount % this.autosavePeriod == 0;
        try {
            this.isSaving = true;
            if (playerSaveInterval > 0) {
                this.playerList.saveAll(playerSaveInterval);
            }
            for (ServerLevel level : this.getAllLevels()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.isSaving = false;
        }
        profiler.pop();
        ProfilerFiller profilerFiller = Profiler.get();
        this.server.spark.executeMainThreadTasks();
        long endTime = System.nanoTime();
        long remaining = this.nextTickTimeNanos - endTime;
        new ServerTickEndEvent(this.tickCount, (double)(endTime - this.currentTickStart) / 1000000.0, remaining).callEvent();
        this.server.spark.tickEnd((double)(endTime - this.currentTickStart) / 1000000.0);
        profilerFiller.push("tallying");
        long l = Util.getNanos() - nanos;
        int i1 = this.tickCount % 100;
        this.aggregatedTickTimesNanos -= this.tickTimesNanos[i1];
        this.aggregatedTickTimesNanos += l;
        this.tickTimesNanos[i1] = l;
        this.smoothedTickTimeMillis = this.smoothedTickTimeMillis * 0.8f + (float)l / (float)TimeUtil.NANOSECONDS_PER_MILLISECOND * 0.19999999f;
        this.logTickMethodTime(nanos);
        profilerFiller.pop();
    }

    private void autoSave() {
        this.ticksUntilAutosave = this.autosavePeriod;
        LOGGER.debug("Autosave started");
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("save");
        this.saveEverything(true, false, false);
        profilerFiller.pop();
        LOGGER.debug("Autosave finished");
    }

    private void logTickMethodTime(long startTime) {
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logPartialSample(Util.getNanos() - startTime, TpsDebugDimensions.TICK_SERVER_METHOD.ordinal());
        }
    }

    private int computeNextAutosaveInterval() {
        float f;
        if (this.tickRateManager.isSprinting()) {
            long l = this.getAverageTickTimeNanos() + 1L;
            f = (float)TimeUtil.NANOSECONDS_PER_SECOND / (float)l;
        } else {
            f = this.tickRateManager.tickrate();
        }
        int i = 300;
        return Math.max(100, (int)(f * 300.0f));
    }

    public void onTickRateChanged() {
        int i = this.computeNextAutosaveInterval();
        if (i < this.ticksUntilAutosave) {
            this.ticksUntilAutosave = i;
        }
    }

    protected abstract SampleLogger getTickTimeLogger();

    public abstract boolean isTickTimeLoggingEnabled();

    private ServerStatus buildServerStatus() {
        ServerStatus.Players players = this.buildPlayerStatus();
        return new ServerStatus(PaperAdventure.asVanilla(this.motd), Optional.of(players), Optional.of(ServerStatus.Version.current()), Optional.ofNullable(this.statusIcon), this.enforceSecureProfile());
    }

    private ServerStatus.Players buildPlayerStatus() {
        List<ServerPlayer> players = this.playerList.getPlayers();
        int maxPlayers = this.getMaxPlayers();
        if (this.hidesOnlinePlayers()) {
            return new ServerStatus.Players(maxPlayers, players.size(), List.of());
        }
        int min = Math.min(players.size(), SpigotConfig.playerSample);
        ObjectArrayList list = new ObjectArrayList(min);
        int randomInt = Mth.nextInt(this.random, 0, players.size() - min);
        for (int i = 0; i < min; ++i) {
            ServerPlayer serverPlayer = players.get(randomInt + i);
            list.add((Object)(serverPlayer.allowsListing() ? serverPlayer.nameAndId() : ANONYMOUS_PLAYER_PROFILE));
        }
        Util.shuffle(list, this.random);
        return new ServerStatus.Players(maxPlayers, players.size(), (List<NameAndId>)list);
    }

    protected void tickChildren(BooleanSupplier hasTimeLeft) {
        ProfilerFiller profilerFiller = Profiler.get();
        this.getPlayerList().getPlayers().forEach(serverPlayer1 -> serverPlayer1.connection.suspendFlushing());
        this.server.getScheduler().mainThreadHeartbeat();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        for (EntityScheduler scheduler : this.entitySchedulerTickList.getAllSchedulers()) {
            if (scheduler.isRetired()) continue;
            scheduler.executeTick();
        }
        ClickCallbackProviderImpl.ADVENTURE_CLICK_MANAGER.handleQueue(this.tickCount);
        ClickCallbackProviderImpl.DIALOG_CLICK_MANAGER.handleQueue(this.tickCount);
        profilerFiller.push("commandFunctions");
        this.getFunctions().tick();
        profilerFiller.popPush("levels");
        this.updateEffectiveRespawnData();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (ServerLevel level : this.getAllLevels()) {
            boolean doDaylight = level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT);
            long dayTime = level.getDayTime();
            long worldTime = level.getGameTime();
            ClientboundSetTimePacket worldPacket = new ClientboundSetTimePacket(worldTime, dayTime, doDaylight);
            for (Player player : level.players()) {
                if (!(player instanceof ServerPlayer) || !level.isForceTime() && (this.tickCount + player.getId()) % 20 != 0) continue;
                ServerPlayer entityplayer = (ServerPlayer)player;
                long playerTime = entityplayer.getPlayerTime();
                boolean relativeTime = entityplayer.relativeTime;
                ClientboundSetTimePacket packet = (relativeTime || !doDaylight) && playerTime == dayTime ? worldPacket : new ClientboundSetTimePacket(worldTime, playerTime, relativeTime && doDaylight);
                entityplayer.connection.send(packet);
            }
        }
        this.isIteratingOverLevels = true;
        for (ServerLevel serverLevel : this.getAllLevels()) {
            serverLevel.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.updateLagCompensationTick();
            HopperBlockEntity.skipHopperEvents = serverLevel.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            serverLevel.hasRidableMoveEvent = RidableMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            profilerFiller.push(() -> String.valueOf(serverLevel) + " " + String.valueOf(serverLevel.dimension().location()));
            profilerFiller.push("tick");
            try {
                serverLevel.tick(hasTimeLeft);
            }
            catch (Throwable var7) {
                CrashReport crashReport = CrashReport.forThrowable(var7, "Exception ticking world");
                serverLevel.fillReportDetails(crashReport);
                throw new ReportedException(crashReport);
            }
            profilerFiller.pop();
            profilerFiller.pop();
            serverLevel.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        profilerFiller.popPush("connection");
        this.tickConnection();
        profilerFiller.popPush("players");
        this.playerList.tick();
        profilerFiller.popPush("debugSubscribers");
        this.debugSubscribers.tick();
        if (this.tickRateManager.runsNormally()) {
            profilerFiller.popPush("gameTests");
            GameTestTicker.SINGLETON.tick();
        }
        profilerFiller.popPush("server gui refresh");
        for (int i = 0; i < this.tickables.size(); ++i) {
            this.tickables.get(i).run();
        }
        profilerFiller.popPush("send chunks");
        for (ServerPlayer serverPlayer : this.playerList.getPlayers()) {
            serverPlayer.connection.chunkSender.sendNextChunks(serverPlayer);
            serverPlayer.connection.resumeFlushing();
        }
        profilerFiller.pop();
    }

    public void updateEffectiveRespawnData() {
        ServerLevel serverLevel = this.findRespawnDimension();
        LevelData.RespawnData respawnData = serverLevel.serverLevelData.getRespawnData();
        respawnData = respawnData.withLevel(serverLevel.dimension());
        this.effectiveRespawnData = serverLevel.getWorldBorderAdjustedRespawnData(respawnData);
    }

    public void tickConnection() {
        this.getConnection().tick();
    }

    private void synchronizeTime(ServerLevel level) {
        this.playerList.broadcastAll(new ClientboundSetTimePacket(level.getGameTime(), level.getDayTime(), level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)), level.dimension());
    }

    public void forceTimeSynchronization() {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("timeSync");
        for (ServerLevel serverLevel : this.getAllLevels()) {
            this.synchronizeTime(serverLevel);
        }
        profilerFiller.pop();
    }

    public boolean isAllowedToEnterPortal(Level level) {
        return level.dimension() != Level.NETHER || this.getGameRules().getBoolean(GameRules.RULE_ALLOW_NETHER);
    }

    public void addTickable(Runnable tickable) {
        this.tickables.add(tickable);
    }

    protected void setId(String serverId) {
        this.serverId = serverId;
    }

    public boolean isShutdown() {
        return !this.serverThread.isAlive();
    }

    public Path getFile(String path) {
        return this.getServerDirectory().resolve(path);
    }

    public final ServerLevel overworld() {
        return this.levels.get(Level.OVERWORLD);
    }

    @Nullable
    public ServerLevel getLevel(ResourceKey<Level> dimension) {
        return this.levels.get(dimension);
    }

    public void addLevel(ServerLevel level) {
        Map<ResourceKey<Level>, ServerLevel> oldLevels = this.levels;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.dimension(), level);
        this.levels = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(ServerLevel level) {
        Map<ResourceKey<Level>, ServerLevel> oldLevels = this.levels;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.dimension());
        this.levels = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<Level>> levelKeys() {
        return this.levels.keySet();
    }

    public Iterable<ServerLevel> getAllLevels() {
        return this.levels.values();
    }

    @Override
    public String getServerVersion() {
        return SharedConstants.getCurrentVersion().name();
    }

    @Override
    public int getPlayerCount() {
        return this.playerList.getPlayerCount();
    }

    public String[] getPlayerNames() {
        return this.playerList.getPlayerNamesArray();
    }

    @DontObfuscate
    public String getServerModName() {
        return PurpurConfig.serverModName;
    }

    public SystemReport fillSystemReport(SystemReport systemReport) {
        systemReport.setDetail("Server Running", () -> Boolean.toString(this.running));
        if (this.playerList != null) {
            systemReport.setDetail("Player Count", () -> this.playerList.getPlayerCount() + " / " + this.playerList.getMaxPlayers() + "; " + String.valueOf(this.playerList.getPlayers()));
        }
        systemReport.setDetail("Active Data Packs", () -> PackRepository.displayPackList(this.packRepository.getSelectedPacks()));
        systemReport.setDetail("Available Data Packs", () -> PackRepository.displayPackList(this.packRepository.getAvailablePacks()));
        systemReport.setDetail("Enabled Feature Flags", () -> FeatureFlags.REGISTRY.toNames(this.worldData.enabledFeatures()).stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        systemReport.setDetail("World Generation", () -> this.worldData.worldGenSettingsLifecycle().toString());
        systemReport.setDetail("World Seed", () -> String.valueOf(this.worldData.worldGenOptions().seed()));
        systemReport.setDetail("Suppressed Exceptions", this.suppressedExceptions::dump);
        if (this.serverId != null) {
            systemReport.setDetail("Server Id", () -> this.serverId);
        }
        return this.fillServerSystemReport(systemReport);
    }

    public abstract SystemReport fillServerSystemReport(SystemReport var1);

    public ModCheck getModdedStatus() {
        return ModCheck.identify(VANILLA_BRAND, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void sendSystemMessage(net.minecraft.network.chat.Component message) {
        LOGGER.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Nullable
    public GameProfile getSingleplayerProfile() {
        return this.singleplayerProfile;
    }

    public void setSingleplayerProfile(@Nullable GameProfile singleplayerProfile) {
        this.singleplayerProfile = singleplayerProfile;
    }

    public boolean isSingleplayer() {
        return this.singleplayerProfile != null;
    }

    protected void initializeKeyPair() {
        LOGGER.info("Generating keypair");
        try {
            this.keyPair = Crypt.generateKeyPair();
        }
        catch (CryptException var2) {
            throw new IllegalStateException("Failed to generate key pair", var2);
        }
    }

    public void setDifficulty(ServerLevel level, Difficulty difficulty, @Nullable net.minecraft.commands.CommandSourceStack source, boolean forced) {
        PrimaryLevelData worldData = level.serverLevelData;
        if (forced || !worldData.isDifficultyLocked()) {
            new WorldDifficultyChangeEvent((World)level.getWorld(), (CommandSourceStack)source, CraftDifficulty.toBukkit(difficulty)).callEvent();
            worldData.setDifficulty(worldData.isHardcore() ? Difficulty.HARD : difficulty);
            level.setSpawnSettings(worldData.getDifficulty() != Difficulty.PEACEFUL && level.getGameRules().getBoolean(GameRules.RULE_SPAWN_MONSTERS));
        }
    }

    public int getScaledTrackingDistance(int trackingDistance) {
        return trackingDistance;
    }

    public void updateMobSpawningFlags() {
        for (ServerLevel serverLevel : this.getAllLevels()) {
            serverLevel.setSpawnSettings(this.isSpawningMonsters());
        }
    }

    public void setDifficultyLocked(boolean locked) {
        this.worldData.setDifficultyLocked(locked);
        this.getPlayerList().getPlayers().forEach(this::sendDifficultyUpdate);
    }

    private void sendDifficultyUpdate(ServerPlayer player) {
        LevelData levelData = player.level().getLevelData();
        player.connection.send(new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked()));
    }

    public boolean isSpawningMonsters() {
        return this.worldData.getDifficulty() != Difficulty.PEACEFUL && this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.getGameRules().getBoolean(GameRules.RULE_SPAWN_MONSTERS);
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean demo) {
        this.isDemo = demo;
    }

    public Map<String, String> getCodeOfConducts() {
        return Map.of();
    }

    public Optional<ServerResourcePackInfo> getServerResourcePack() {
        return Optional.empty();
    }

    public boolean isResourcePackRequired() {
        return this.getServerResourcePack().filter(ServerResourcePackInfo::isRequired).isPresent();
    }

    public abstract boolean isDedicatedServer();

    public abstract int getRateLimitPacketsPerSecond();

    public boolean usesAuthentication() {
        return this.onlineMode;
    }

    public void setUsesAuthentication(boolean online) {
        this.onlineMode = online;
    }

    public boolean getPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public void setPreventProxyConnections(boolean preventProxyConnections) {
        this.preventProxyConnections = preventProxyConnections;
    }

    public abstract boolean isEpollEnabled();

    @DoNotUse
    @Deprecated(forRemoval=true)
    public boolean isPvpAllowed() {
        return this.getGameRules().getBoolean(GameRules.RULE_PVP);
    }

    public boolean allowFlight() {
        return true;
    }

    public boolean isCommandBlockEnabled() {
        return this.getGameRules().getBoolean(GameRules.RULE_COMMAND_BLOCKS_ENABLED);
    }

    public boolean isSpawnerBlockEnabled() {
        return this.getGameRules().getBoolean(GameRules.RULE_SPAWNER_BLOCKS_ENABLED);
    }

    @Override
    public String getMotd() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    public void setMotd(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public void setPlayerList(PlayerList list) {
        this.playerList = list;
    }

    public abstract boolean isPublished();

    public void setDefaultGameType(GameType gameMode) {
        this.worldData.setGameType(gameMode);
    }

    public int enforceGameTypeForPlayers(@Nullable GameType gameMode) {
        if (gameMode == null) {
            return 0;
        }
        int i = 0;
        for (ServerPlayer serverPlayer : this.getPlayerList().getPlayers()) {
            PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null);
            if (event == null || event.isCancelled()) continue;
            ++i;
        }
        return i;
    }

    public ServerConnectionListener getConnection() {
        return this.connection == null ? (this.connection = new ServerConnectionListener(this)) : this.connection;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean publishServer(@Nullable GameType gameMode, boolean commands, int port) {
        return false;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public boolean isUnderSpawnProtection(ServerLevel level, BlockPos pos, Player player) {
        return false;
    }

    public boolean repliesToStatus() {
        return true;
    }

    public boolean hidesOnlinePlayers() {
        return false;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int playerIdleTimeout() {
        return this.playerIdleTimeout;
    }

    public void setPlayerIdleTimeout(int idleTimeout) {
        this.playerIdleTimeout = idleTimeout;
    }

    public Services services() {
        return this.services;
    }

    @Nullable
    public ServerStatus getStatus() {
        return this.status;
    }

    public void invalidateStatus() {
        this.lastServerStatus = 0L;
    }

    public int getAbsoluteMaxWorldSize() {
        return 29999984;
    }

    @Override
    public boolean scheduleExecutables() {
        return super.scheduleExecutables() && !this.isStopped();
    }

    @Override
    public void executeIfPossible(Runnable task) {
        if (this.isStopped()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.executeIfPossible(task);
    }

    @Override
    public Thread getRunningThread() {
        return this.serverThread;
    }

    public int getCompressionThreshold() {
        return 256;
    }

    public boolean enforceSecureProfile() {
        return false;
    }

    public long getNextTickTime() {
        return this.nextTickTimeNanos;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public ServerAdvancementManager getAdvancements() {
        return this.resources.managers.getAdvancements();
    }

    public ServerFunctionManager getFunctions() {
        return this.functionManager;
    }

    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> reloadResources(Collection<String> selectedIds) {
        return this.reloadResources(selectedIds, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> selectedIds, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)selectedIds.stream().map(this.packRepository::getPack).filter(Objects::nonNull).map(Pack::open).collect(ImmutableList.toImmutableList()), this).thenCompose(list -> {
            MultiPackResourceManager closeableResourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, (List<PackResources>)list);
            List<Registry.PendingTags<?>> list1 = TagLoader.loadTagsForExistingRegistries(closeableResourceManager, this.registries.compositeAccess(), ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)ReloadableServerResources.loadResources(closeableResourceManager, this.registries, list1, this.worldData.enabledFeatures(), this.isDedicatedServer() ? Commands.CommandSelection.DEDICATED : Commands.CommandSelection.INTEGRATED, this.getFunctionCompilationLevel(), this.executor, this).whenComplete((reloadableServerResources, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApply(reloadableServerResources -> new ReloadableResources(closeableResourceManager, (ReloadableServerResources)reloadableServerResources));
        })).thenAcceptAsync(reloadableResources -> {
            PaperBrigadier.moveBukkitCommands(this.resources.managers().getCommands(), reloadableResources.managers().commands);
            this.resources.close();
            this.resources = reloadableResources;
            this.packRepository.setSelected(selectedIds, false);
            WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(MinecraftServer.getSelectedPacks(this.packRepository, true), this.worldData.enabledFeatures());
            this.worldData.setDataConfiguration(worldDataConfiguration);
            this.resources.managers.updateStaticRegistryTags();
            this.resources.managers.getRecipeManager().finalizeRecipeLoading(this.worldData.enabledFeatures());
            this.potionBrewing = this.potionBrewing.reload(this.worldData.enabledFeatures());
            if (Thread.currentThread() != this.serverThread) {
                return;
            }
            for (ServerPlayer player : this.getPlayerList().getPlayers()) {
                player.getAdvancements().save();
            }
            this.getPlayerList().reloadResources();
            this.functionManager.replaceLibrary(this.resources.managers.getFunctionLibrary());
            this.structureTemplateManager.onResourceManagerReload(this.resources.resourceManager);
            this.fuelValues = FuelValues.vanillaBurnTimes(this.registries.compositeAccess(), this.worldData.enabledFeatures());
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.isSameThread()) {
            this.managedBlock(((CompletableFuture)completableFuture)::isDone);
        }
        return completableFuture;
    }

    public static WorldDataConfiguration configurePackRepository(PackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean initMode, boolean safeMode) {
        DataPackConfig dataPackConfig = initialDataConfig.dataPacks();
        FeatureFlagSet featureFlagSet = initMode ? FeatureFlagSet.of() : initialDataConfig.enabledFeatures();
        FeatureFlagSet featureFlagSet1 = initMode ? FeatureFlags.REGISTRY.allFlags() : initialDataConfig.enabledFeatures();
        packRepository.reload(true);
        if (safeMode) {
            return MinecraftServer.configureRepositoryWithSelection(packRepository, List.of(VANILLA_BRAND), featureFlagSet, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String string : dataPackConfig.getEnabled()) {
            if (packRepository.isAvailable(string)) {
                set.add(string);
                continue;
            }
            LOGGER.warn("Missing data pack {}", (Object)string);
        }
        for (Pack pack : packRepository.getAvailablePacks()) {
            String id = pack.getId();
            if (dataPackConfig.getDisabled().contains(id)) continue;
            FeatureFlagSet requestedFeatures = pack.getRequestedFeatures();
            boolean flag = set.contains(id);
            if (!flag && pack.getPackSource().shouldAddAutomatically()) {
                if (requestedFeatures.isSubsetOf(featureFlagSet1)) {
                    LOGGER.info("Found new data pack {}, loading it automatically", (Object)id);
                    set.add(id);
                } else {
                    LOGGER.info("Found new data pack {}, but can't load it due to missing features {}", (Object)id, (Object)FeatureFlags.printMissingFlags(featureFlagSet1, requestedFeatures));
                }
            }
            if (!flag || requestedFeatures.isSubsetOf(featureFlagSet1)) continue;
            LOGGER.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)id, (Object)FeatureFlags.printMissingFlags(featureFlagSet1, requestedFeatures));
            set.remove(id);
        }
        if (set.isEmpty()) {
            LOGGER.info("No datapacks selected, forcing vanilla");
            set.add(VANILLA_BRAND);
        }
        return MinecraftServer.configureRepositoryWithSelection(packRepository, set, featureFlagSet, true);
    }

    private static WorldDataConfiguration configureRepositoryWithSelection(PackRepository packRepository, Collection<String> selectedPacks, FeatureFlagSet enabledFeatures, boolean safeMode) {
        packRepository.setSelected(selectedPacks, true);
        MinecraftServer.enableForcedFeaturePacks(packRepository, enabledFeatures);
        DataPackConfig selectedPacks1 = MinecraftServer.getSelectedPacks(packRepository, safeMode);
        FeatureFlagSet featureFlagSet = packRepository.getRequestedFeatureFlags().join(enabledFeatures);
        return new WorldDataConfiguration(selectedPacks1, featureFlagSet);
    }

    private static void enableForcedFeaturePacks(PackRepository packRepository, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet requestedFeatureFlags = packRepository.getRequestedFeatureFlags();
        FeatureFlagSet featureFlagSet = enabledFeatures.subtract(requestedFeatureFlags);
        if (!featureFlagSet.isEmpty()) {
            ObjectArraySet set = new ObjectArraySet(packRepository.getSelectedIds());
            for (Pack pack : packRepository.getAvailablePacks()) {
                if (featureFlagSet.isEmpty()) break;
                if (pack.getPackSource() != PackSource.FEATURE) continue;
                String id = pack.getId();
                FeatureFlagSet requestedFeatures = pack.getRequestedFeatures();
                if (requestedFeatures.isEmpty() || !requestedFeatures.intersects(featureFlagSet) || !requestedFeatures.isSubsetOf(enabledFeatures)) continue;
                if (!set.add(id)) {
                    throw new IllegalStateException("Tried to force '" + id + "', but it was already enabled");
                }
                LOGGER.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)id);
                featureFlagSet = featureFlagSet.subtract(requestedFeatures);
            }
            packRepository.setSelected((Collection<String>)set, true);
        }
    }

    private static DataPackConfig getSelectedPacks(PackRepository packRepository, boolean safeMode) {
        Collection<String> selectedIds = packRepository.getSelectedIds();
        ImmutableList list = ImmutableList.copyOf(selectedIds);
        List<String> list1 = safeMode ? packRepository.getAvailableIds().stream().filter(packId -> !selectedIds.contains(packId)).toList() : List.of();
        return new DataPackConfig((List<String>)list, list1);
    }

    public void kickUnlistedPlayers() {
        if (this.isEnforceWhitelist() && this.isUsingWhitelist()) {
            PlayerList playerList = this.getPlayerList();
            UserWhiteList whiteList = playerList.getWhiteList();
            for (ServerPlayer serverPlayer : Lists.newArrayList(playerList.getPlayers())) {
                if (whiteList.isWhiteListed(serverPlayer.nameAndId()) || this.getPlayerList().isOp(serverPlayer.nameAndId())) continue;
                serverPlayer.connection.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public PackRepository getPackRepository() {
        return this.packRepository;
    }

    public Commands getCommands() {
        return this.resources.managers.getCommands();
    }

    public net.minecraft.commands.CommandSourceStack createCommandSourceStack() {
        ServerLevel serverLevel = this.findRespawnDimension();
        return new net.minecraft.commands.CommandSourceStack(this, serverLevel == null ? Vec3.ZERO : Vec3.atLowerCornerOf(this.getRespawnData().pos()), Vec2.ZERO, serverLevel, 4, "Server", net.minecraft.network.chat.Component.literal("Server"), this, null);
    }

    public ServerLevel findRespawnDimension() {
        ResourceKey<Level> resourceKey = ((PrimaryLevelData)this.getWorldData().overworldData()).respawnDimension;
        ServerLevel level = this.getLevel(resourceKey);
        return level != null ? level : this.overworld();
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public void setRespawnData(LevelData.RespawnData respawnData) {
        ServerLevelData serverLevelData = this.worldData.overworldData();
        LevelData.RespawnData respawnData1 = serverLevelData.getRespawnData();
        if (!respawnData1.equals(respawnData)) {
            serverLevelData.setSpawn(respawnData);
            this.getPlayerList().broadcastAll(new ClientboundSetDefaultSpawnPositionPacket(respawnData));
            this.updateEffectiveRespawnData();
        }
    }

    public LevelData.RespawnData getRespawnData() {
        return this.effectiveRespawnData;
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public abstract boolean shouldInformAdmins();

    public RecipeManager getRecipeManager() {
        return this.resources.managers.getRecipeManager();
    }

    public ServerScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public CommandStorage getCommandStorage() {
        if (this.commandStorage == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.commandStorage;
    }

    public GameRules getGameRules() {
        return this.overworld().getGameRules();
    }

    public CustomBossEvents getCustomBossEvents() {
        return this.customBossEvents;
    }

    public boolean isEnforceWhitelist() {
        return this.enforceWhitelist;
    }

    public void setEnforceWhitelist(boolean enforceWhitelist) {
        this.enforceWhitelist = enforceWhitelist;
    }

    public boolean isUsingWhitelist() {
        return this.usingWhitelist;
    }

    public void setUsingWhitelist(boolean usingWhitelist) {
        this.usingWhitelist = usingWhitelist;
    }

    public float getCurrentSmoothedTickTime() {
        return this.smoothedTickTimeMillis;
    }

    public ServerTickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    public long getAverageTickTimeNanos() {
        return this.aggregatedTickTimesNanos / (long)Math.min(100, Math.max(this.tickCount, 1));
    }

    public long[] getTickTimesNanos() {
        return this.tickTimesNanos;
    }

    public int getProfilePermissions(NameAndId nameAndId) {
        if (this.getPlayerList().isOp(nameAndId)) {
            ServerOpListEntry serverOpListEntry = (ServerOpListEntry)this.getPlayerList().getOps().get(nameAndId);
            if (serverOpListEntry != null) {
                return serverOpListEntry.getLevel();
            }
            if (this.isSingleplayerOwner(nameAndId)) {
                return 4;
            }
            if (this.isSingleplayer()) {
                return this.getPlayerList().isAllowCommandsForAllPlayers() ? 4 : 0;
            }
            return this.operatorUserPermissionLevel();
        }
        return 0;
    }

    public abstract boolean isSingleplayerOwner(NameAndId var1);

    public void dumpServerProperties(Path path) throws IOException {
    }

    private void saveDebugReport(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<Level>, ServerLevel> entry : this.levels.entrySet()) {
                ResourceLocation resourceLocation = entry.getKey().location();
                Path path2 = path1.resolve(resourceLocation.getNamespace()).resolve(resourceLocation.getPath());
                Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().saveDebugReport(path2);
            }
            this.dumpGameRules(path.resolve("gamerules.txt"));
            this.dumpClasspath(path.resolve("classpath.txt"));
            this.dumpMiscStats(path.resolve("stats.txt"));
            this.dumpThreads(path.resolve("threads.txt"));
            this.dumpServerProperties(path.resolve("server.properties.txt"));
            this.dumpNativeModules(path.resolve("modules.txt"));
        }
        catch (IOException var7) {
            LOGGER.warn("Failed to save debug report", (Throwable)var7);
        }
    }

    private void dumpMiscStats(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getPendingTasksCount()));
            bufferedWriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.getCurrentSmoothedTickTime())));
            bufferedWriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.tickTimesNanos)));
            bufferedWriter.write(String.format(Locale.ROOT, "queue: %s\n", Util.backgroundExecutor()));
        }
    }

    private void dumpGameRules(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gameRules = this.getGameRules();
            gameRules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

                @Override
                public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.getId(), gameRules.getRule(key)));
                }
            });
            for (String string : list) {
                bufferedWriter.write(string);
            }
        }
    }

    private void dumpClasspath(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String property = System.getProperty("java.class.path");
            String property1 = System.getProperty("path.separator");
            for (String string : Splitter.on((String)property1).split((CharSequence)property)) {
                bufferedWriter.write(string);
                bufferedWriter.write("\n");
            }
        }
    }

    private void dumpThreads(Path path) throws IOException {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        Arrays.sort(threadInfos, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : threadInfos) {
                bufferedWriter.write(threadInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
    }

    private void dumpNativeModules(Path path) throws IOException {
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(NativeModuleLister.listModules());
            }
            catch (Throwable var7) {
                LOGGER.warn("Failed to list native modules", var7);
                if (bufferedWriter != null) {
                    ((Writer)bufferedWriter).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativeModuleInfo1 -> nativeModuleInfo1.name));
            for (NativeModuleLister.NativeModuleInfo nativeModuleInfo : list) {
                bufferedWriter.write(nativeModuleInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    ((Writer)bufferedWriter).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean isSameThread() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    private ProfilerFiller createProfiler() {
        if (this.willStartRecordingMetrics) {
            this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ServerMetricsSamplersProvider(Util.timeSource, this.isDedicatedServer()), Util.timeSource, Util.ioPool(), new MetricsPersister("server"), this.onMetricsRecordingStopped, path -> {
                this.executeBlocking(() -> this.saveDebugReport(path.resolve("server")));
                this.onMetricsRecordingFinished.accept((Path)path);
            });
            this.willStartRecordingMetrics = false;
        }
        this.metricsRecorder.startTick();
        return SingleTickProfiler.decorateFiller(this.metricsRecorder.getProfiler(), SingleTickProfiler.createTickProfiler("Server"));
    }

    public void endMetricsRecordingTick() {
        this.metricsRecorder.endTick();
    }

    public boolean isRecordingMetrics() {
        return this.metricsRecorder.isRecording();
    }

    public void startRecordingMetrics(Consumer<ProfileResults> output, Consumer<Path> onMetricsRecordingFinished) {
        this.onMetricsRecordingStopped = profileResults -> {
            this.stopRecordingMetrics();
            output.accept((ProfileResults)profileResults);
        };
        this.onMetricsRecordingFinished = onMetricsRecordingFinished;
        this.willStartRecordingMetrics = true;
    }

    public void stopRecordingMetrics() {
        this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    }

    public void finishRecordingMetrics() {
        this.metricsRecorder.end();
    }

    public void cancelRecordingMetrics() {
        this.metricsRecorder.cancel();
    }

    public Path getWorldPath(LevelResource levelResource) {
        return this.storageSource.getLevelPath(levelResource);
    }

    public boolean forceSynchronousWrites() {
        return true;
    }

    public StructureTemplateManager getStructureManager() {
        return this.structureTemplateManager;
    }

    public WorldData getWorldData() {
        return this.worldData;
    }

    public RegistryAccess.Frozen registryAccess() {
        return this.registries.compositeAccess();
    }

    public LayeredRegistryAccess<RegistryLayer> registries() {
        return this.registries;
    }

    public ReloadableServerRegistries.Holder reloadableRegistries() {
        return this.resources.managers.fullRegistries();
    }

    public TextFilter createTextFilterForPlayer(ServerPlayer player) {
        return TextFilter.DUMMY;
    }

    public ServerPlayerGameMode createGameModeForPlayer(ServerPlayer player) {
        return this.isDemo() ? new DemoMode(player) : new ServerPlayerGameMode(player);
    }

    @Nullable
    public GameType getForcedGameType() {
        return null;
    }

    public ResourceManager getResourceManager() {
        return this.resources.resourceManager;
    }

    public boolean isCurrentlySaving() {
        return this.isSaving;
    }

    public boolean isTimeProfilerRunning() {
        return this.debugCommandProfilerDelayStart || this.debugCommandProfiler != null;
    }

    public void startTimeProfiler() {
        this.debugCommandProfilerDelayStart = true;
    }

    public ProfileResults stopTimeProfiler() {
        if (this.debugCommandProfiler == null) {
            return EmptyProfileResults.EMPTY;
        }
        ProfileResults profileResults = this.debugCommandProfiler.stop(Util.getNanos(), this.tickCount);
        this.debugCommandProfiler = null;
        return profileResults;
    }

    public int getMaxChainedNeighborUpdates() {
        return 1000000;
    }

    public void logChatMessage(net.minecraft.network.chat.Component content, ChatType.Bound boundChatType, @Nullable String header) {
        Component string = PaperAdventure.asAdventure(boundChatType.decorate(content));
        if (header != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)header, (Object)string);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)string);
        }
    }

    public ChatDecorator getChatDecorator() {
        return this.improvedChatDecorator;
    }

    public boolean logIPs() {
        return true;
    }

    public void handleCustomClickAction(ResourceLocation id, Optional<Tag> payload) {
        LOGGER.debug("Received custom click action {} with payload {}", (Object)id, payload.orElse(null));
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public LevelLoadListener getLevelLoadListener() {
        throw new UnsupportedOperationException();
    }

    public boolean setAutoSave(boolean autoSave) {
        boolean flag = false;
        for (ServerLevel serverLevel : this.getAllLevels()) {
            if (serverLevel == null || serverLevel.noSave != autoSave) continue;
            serverLevel.noSave = !autoSave;
            flag = true;
        }
        return flag;
    }

    public boolean isAutoSave() {
        for (ServerLevel serverLevel : this.getAllLevels()) {
            if (serverLevel == null || serverLevel.noSave) continue;
            return true;
        }
        return false;
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public void onGameRuleChanged(String key, GameRules.Value<?> value) {
        throw new UnsupportedOperationException();
    }

    public boolean acceptsTransfers() {
        return false;
    }

    private void storeChunkIoError(CrashReport crashReport, ChunkPos chunkPos, RegionStorageInfo regionStorageInfo) {
        Util.ioPool().execute(() -> {
            try {
                Path file = this.getFile("debug");
                FileUtil.createDirectoriesSafe(file);
                String string = FileUtil.sanitizeName(regionStorageInfo.level());
                Path path = file.resolve("chunk-" + string + "-" + Util.getFilenameFormattedDateTime() + "-server.txt");
                FileStore fileStore = Files.getFileStore(file);
                long usableSpace = fileStore.getUsableSpace();
                if (usableSpace < 8192L) {
                    LOGGER.warn("Not storing chunk IO report due to low space on drive {}", (Object)fileStore.name());
                    return;
                }
                CrashReportCategory crashReportCategory = crashReport.addCategory("Chunk Info");
                crashReportCategory.setDetail("Level", regionStorageInfo::level);
                crashReportCategory.setDetail("Dimension", () -> regionStorageInfo.dimension().location().toString());
                crashReportCategory.setDetail("Storage", regionStorageInfo::type);
                crashReportCategory.setDetail("Position", chunkPos::toString);
                crashReport.saveToFile(path, ReportType.CHUNK_IO_ERROR);
                LOGGER.info("Saved details to {}", (Object)crashReport.getSaveFile());
            }
            catch (Exception var11) {
                LOGGER.warn("Failed to store chunk IO exception", (Throwable)var11);
            }
        });
    }

    @Override
    public void reportChunkLoadFailure(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkPos chunkPos) {
        LOGGER.error("Failed to load chunk {},{}", new Object[]{chunkPos.x, chunkPos.z, throwable});
        this.suppressedExceptions.addEntry("chunk/load", throwable);
        this.storeChunkIoError(CrashReport.forThrowable(throwable, "Chunk load failure"), chunkPos, regionStorageInfo);
    }

    @Override
    public void reportChunkSaveFailure(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkPos chunkPos) {
        LOGGER.error("Failed to save chunk {},{}", new Object[]{chunkPos.x, chunkPos.z, throwable});
        this.suppressedExceptions.addEntry("chunk/save", throwable);
        this.storeChunkIoError(CrashReport.forThrowable(throwable, "Chunk save failure"), chunkPos, regionStorageInfo);
    }

    public void reportPacketHandlingException(Throwable throwable, PacketType<?> packetType) {
        this.suppressedExceptions.addEntry("packet/" + packetType.toString(), throwable);
    }

    public PotionBrewing potionBrewing() {
        return this.potionBrewing;
    }

    public FuelValues fuelValues() {
        return this.fuelValues;
    }

    public ServerLinks serverLinks() {
        return ServerLinks.EMPTY;
    }

    protected int pauseWhenEmptySeconds() {
        return 0;
    }

    public PacketProcessor packetProcessor() {
        return this.packetProcessor;
    }

    public ServerDebugSubscribers debugSubscribers() {
        return this.debugSubscribers;
    }

    public boolean isTickPaused() {
        return this.emptyTicks > 0 && this.emptyTicks >= this.pauseWhenEmptySeconds() * 20;
    }

    public void addPluginAllowingSleep(String pluginName, boolean value) {
        if (!value) {
            this.pluginsBlockingSleep.add(pluginName);
        } else {
            this.pluginsBlockingSleep.remove(pluginName);
        }
    }

    private void removeDisabledPluginsBlockingSleep() {
        if (this.pluginsBlockingSleep.isEmpty()) {
            return;
        }
        this.pluginsBlockingSleep.removeIf(plugin -> !PaperPluginManagerImpl.getInstance().isPluginEnabled((String)plugin));
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(ServerLevel level) {
        return level.getChunkSource().chunkMap.hasWork();
    }

    static {
        LOGGER = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)LOGGER.getName());
        OVERLOADED_THRESHOLD_NANOS = 30L * TimeUtil.NANOSECONDS_PER_SECOND / 20L;
        OVERLOADED_WARNING_INTERVAL_NANOS = 10L * TimeUtil.NANOSECONDS_PER_SECOND;
        STATUS_EXPIRE_TIME_NANOS = 5L * TimeUtil.NANOSECONDS_PER_SECOND;
        PREPARE_LEVELS_DEFAULT_DELAY_NANOS = 10L * TimeUtil.NANOSECONDS_PER_MILLISECOND;
        DEMO_SETTINGS = new LevelSettings("Demo World", GameType.SURVIVAL, false, Difficulty.NORMAL, false, new GameRules(FeatureFlags.DEFAULT_FLAGS), WorldDataConfiguration.DEFAULT);
        ANONYMOUS_PLAYER_PROFILE = new NameAndId(Util.NIL_UUID, "Anonymous Player");
        fatalException = new AtomicReference();
        startTimeMillis = System.currentTimeMillis();
        SERVER_INIT = System.nanoTime();
    }

    public record ReloadableResources(CloseableResourceManager resourceManager, ReloadableServerResources managers) implements AutoCloseable
    {
        @Override
        public void close() {
            this.resourceManager.close();
        }
    }

    static class TimeProfiler {
        final long startNanos;
        final int startTick;

        TimeProfiler(long startNanos, int startTick) {
            this.startNanos = startNanos;
            this.startTick = startTick;
        }

        ProfileResults stop(final long endTimeNano, final int endTimeTicks) {
            return new ProfileResults(){

                @Override
                public List<ResultField> getTimes(String sectionPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean saveResults(Path path) {
                    return false;
                }

                @Override
                public long getStartTimeNano() {
                    return startNanos;
                }

                @Override
                public int getStartTimeTicks() {
                    return startTick;
                }

                @Override
                public long getEndTimeNano() {
                    return endTimeNano;
                }

                @Override
                public int getEndTimeTicks() {
                    return endTimeTicks;
                }

                @Override
                public String getProfilerResults() {
                    return "";
                }
            };
        }
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public record ServerResourcePackInfo(UUID id, String url, String hash, boolean isRequired, @Nullable net.minecraft.network.chat.Component prompt) {
    }
}

