/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;

public class CloneCommands {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> Component.translatableEscape("commands.clone.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.failed"));
    public static final Predicate<BlockInWorld> FILTER_AIR = blockInWorld -> !blockInWorld.getState().isAir();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clone").requires(Commands.hasPermission(2))).then(CloneCommands.beginEndDestinationAndModeSuffix(context, input -> ((CommandSourceStack)input.getSource()).getLevel()))).then(Commands.literal("from").then(Commands.argument("sourceDimension", DimensionArgument.dimension()).then(CloneCommands.beginEndDestinationAndModeSuffix(context, context1 -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context1, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> beginEndDestinationAndModeSuffix(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> levelGetter) {
        return Commands.argument("begin", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("end", BlockPosArgument.blockPos()).then(CloneCommands.destinationAndStrictSuffix(buildContext, levelGetter, input -> ((CommandSourceStack)input.getSource()).getLevel()))).then(Commands.literal("to").then(Commands.argument("targetDimension", DimensionArgument.dimension()).then(CloneCommands.destinationAndStrictSuffix(buildContext, levelGetter, context -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "targetDimension"))))));
    }

    private static DimensionAndPosition getLoadedDimensionAndPosition(CommandContext<CommandSourceStack> context, ServerLevel level, String name) throws CommandSyntaxException {
        BlockPos loadedBlockPos = BlockPosArgument.getLoadedBlockPos(context, level, name);
        return new DimensionAndPosition(level, loadedBlockPos);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> destinationAndStrictSuffix(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> sourceLevelGetter, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> destinationLevelGetter) {
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> inCommandFunction = input -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)input, (ServerLevel)sourceLevelGetter.apply((CommandContext<CommandSourceStack>)input), "begin");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> inCommandFunction1 = context -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)context, (ServerLevel)sourceLevelGetter.apply((CommandContext<CommandSourceStack>)context), "end");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> inCommandFunction2 = context -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)context, (ServerLevel)destinationLevelGetter.apply((CommandContext<CommandSourceStack>)context), "destination");
        return CloneCommands.modeSuffix(buildContext, inCommandFunction, inCommandFunction1, inCommandFunction2, false, Commands.argument("destination", BlockPosArgument.blockPos())).then(CloneCommands.modeSuffix(buildContext, inCommandFunction, inCommandFunction1, inCommandFunction2, true, Commands.literal("strict")));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> modeSuffix(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> begin, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> end, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> destination, boolean strict, ArgumentBuilder<CommandSourceStack, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandSourceStack>)((Command)commandContext -> CloneCommands.clone((CommandSourceStack)commandContext.getSource(), (DimensionAndPosition)begin.apply(commandContext), (DimensionAndPosition)end.apply(commandContext), (DimensionAndPosition)destination.apply(commandContext), blockInWorld -> true, Mode.NORMAL, strict)))).then(CloneCommands.wrapWithCloneMode(begin, end, destination, input -> blockInWorld -> true, strict, Commands.literal("replace")))).then(CloneCommands.wrapWithCloneMode(begin, end, destination, context -> FILTER_AIR, strict, Commands.literal("masked")))).then(Commands.literal("filtered").then(CloneCommands.wrapWithCloneMode(begin, end, destination, context -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)context, "filter"), strict, Commands.argument("filter", BlockPredicateArgument.blockPredicate(buildContext)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithCloneMode(InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> begin, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> end, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> destination, InCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> filter, boolean strict, ArgumentBuilder<CommandSourceStack, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandSourceStack>)((Command)commandContext -> CloneCommands.clone((CommandSourceStack)commandContext.getSource(), (DimensionAndPosition)begin.apply(commandContext), (DimensionAndPosition)end.apply(commandContext), (DimensionAndPosition)destination.apply(commandContext), (Predicate)filter.apply(commandContext), Mode.NORMAL, strict)))).then(Commands.literal("force").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)begin.apply(context), (DimensionAndPosition)end.apply(context), (DimensionAndPosition)destination.apply(context), (Predicate)filter.apply(context), Mode.FORCE, strict)))).then(Commands.literal("move").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)begin.apply(context), (DimensionAndPosition)end.apply(context), (DimensionAndPosition)destination.apply(context), (Predicate)filter.apply(context), Mode.MOVE, strict)))).then(Commands.literal("normal").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)begin.apply(context), (DimensionAndPosition)end.apply(context), (DimensionAndPosition)destination.apply(context), (Predicate)filter.apply(context), Mode.NORMAL, strict)));
    }

    private static int clone(CommandSourceStack source, DimensionAndPosition begin, DimensionAndPosition end, DimensionAndPosition destination, Predicate<BlockInWorld> filter, Mode mode, boolean strict) throws CommandSyntaxException {
        int _int;
        BlockPos blockPos = begin.position();
        BlockPos blockPos1 = end.position();
        BoundingBox boundingBox = BoundingBox.fromCorners(blockPos, blockPos1);
        BlockPos blockPos2 = destination.position();
        BlockPos blockPos3 = blockPos2.offset(boundingBox.getLength());
        BoundingBox boundingBox1 = BoundingBox.fromCorners(blockPos2, blockPos3);
        ServerLevel serverLevel = begin.dimension();
        ServerLevel serverLevel1 = destination.dimension();
        if (!mode.canOverlap() && serverLevel == serverLevel1 && boundingBox1.intersects(boundingBox)) {
            throw ERROR_OVERLAP.create();
        }
        int i = boundingBox.getXSpan() * boundingBox.getYSpan() * boundingBox.getZSpan();
        if (i > (_int = source.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)_int, (Object)i);
        }
        if (!serverLevel.hasChunksAt(blockPos, blockPos1) || !serverLevel1.hasChunksAt(blockPos2, blockPos3)) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
        if (serverLevel1.isDebug()) {
            throw ERROR_FAILED.create();
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        LinkedList list3 = Lists.newLinkedList();
        int i1 = 0;
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(LOGGER);){
            int y;
            int z;
            BlockPos blockPos4 = new BlockPos(boundingBox1.minX() - boundingBox.minX(), boundingBox1.minY() - boundingBox.minY(), boundingBox1.minZ() - boundingBox.minZ());
            for (z = boundingBox.minZ(); z <= boundingBox.maxZ(); ++z) {
                for (y = boundingBox.minY(); y <= boundingBox.maxY(); ++y) {
                    for (int x = boundingBox.minX(); x <= boundingBox.maxX(); ++x) {
                        BlockPos blockPos5 = new BlockPos(x, y, z);
                        BlockPos blockPos6 = blockPos5.offset(blockPos4);
                        BlockInWorld blockInWorld = new BlockInWorld(serverLevel, blockPos5, false);
                        BlockState state = blockInWorld.getState();
                        if (!filter.test(blockInWorld)) continue;
                        BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos5);
                        if (blockEntity != null) {
                            TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector.forChild(blockEntity.problemPath()), source.registryAccess());
                            blockEntity.saveCustomOnly(tagValueOutput);
                            CloneBlockEntityInfo cloneBlockEntityInfo = new CloneBlockEntityInfo(tagValueOutput.buildResult(), blockEntity.components());
                            list1.add(new CloneBlockInfo(blockPos6, state, cloneBlockEntityInfo, serverLevel1.getBlockState(blockPos6)));
                            list3.addLast(blockPos5);
                            continue;
                        }
                        if (!state.isSolidRender() && !state.isCollisionShapeFullBlock(serverLevel, blockPos5)) {
                            list2.add(new CloneBlockInfo(blockPos6, state, null, serverLevel1.getBlockState(blockPos6)));
                            list3.addFirst(blockPos5);
                            continue;
                        }
                        list.add(new CloneBlockInfo(blockPos6, state, null, serverLevel1.getBlockState(blockPos6)));
                        list3.addLast(blockPos5);
                    }
                }
            }
            z = 2 | (strict ? 816 : 0);
            if (mode == Mode.MOVE) {
                for (BlockPos blockPos7 : list3) {
                    serverLevel.setBlock(blockPos7, Blocks.BARRIER.defaultBlockState(), z | 0x330);
                }
                y = strict ? z : 3;
                for (BlockPos blockPos5 : list3) {
                    serverLevel.setBlock(blockPos5, Blocks.AIR.defaultBlockState(), y);
                }
            }
            ArrayList list4 = Lists.newArrayList();
            list4.addAll(list);
            list4.addAll(list1);
            list4.addAll(list2);
            List list5 = Lists.reverse((List)list4);
            for (CloneBlockInfo cloneBlockInfo : list5) {
                serverLevel1.setBlock(cloneBlockInfo.pos, Blocks.BARRIER.defaultBlockState(), z | 0x330);
            }
            for (CloneBlockInfo cloneBlockInfo : list4) {
                if (!serverLevel1.setBlock(cloneBlockInfo.pos, cloneBlockInfo.state, z)) continue;
                ++i1;
            }
            for (CloneBlockInfo cloneBlockInfox : list1) {
                BlockEntity blockEntity1 = serverLevel1.getBlockEntity(cloneBlockInfox.pos);
                if (cloneBlockInfox.blockEntityInfo != null && blockEntity1 != null) {
                    blockEntity1.loadCustomOnly(TagValueInput.create(scopedCollector.forChild(blockEntity1.problemPath()), (HolderLookup.Provider)serverLevel1.registryAccess(), cloneBlockInfox.blockEntityInfo.tag));
                    blockEntity1.setComponents(cloneBlockInfox.blockEntityInfo.components);
                    blockEntity1.setChanged();
                }
                serverLevel1.setBlock(cloneBlockInfox.pos, cloneBlockInfox.state, z);
            }
            if (!strict) {
                for (CloneBlockInfo cloneBlockInfox : list5) {
                    serverLevel1.updateNeighboursOnBlockSet(cloneBlockInfox.pos, cloneBlockInfox.previousStateAtDestination);
                }
            }
            ((LevelTicks)serverLevel1.getBlockTicks()).copyAreaFrom(serverLevel.getBlockTicks(), boundingBox, blockPos4);
        }
        if (i1 == 0) {
            throw ERROR_FAILED.create();
        }
        int i2 = i1;
        source.sendSuccess(() -> Component.translatable("commands.clone.success", i2), true);
        return i1;
    }

    record DimensionAndPosition(ServerLevel dimension, BlockPos position) {
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean canOverlap;

        private Mode(boolean canOverlap) {
            this.canOverlap = canOverlap;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }
    }

    record CloneBlockEntityInfo(CompoundTag tag, DataComponentMap components) {
    }

    record CloneBlockInfo(BlockPos pos, BlockState state, @Nullable CloneBlockEntityInfo blockEntityInfo, BlockState previousStateAtDestination) {
    }
}

