/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.purpurmc.purpur.PurpurConfig;

public class GameModeCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("gamemode").requires(Commands.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("gamemode", GameModeArgument.gameMode()).executes(commandContext -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)commandContext, Collections.singleton(((CommandSourceStack)commandContext.getSource()).getPlayerOrException()), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)commandContext, "gamemode")))).then(Commands.argument("target", EntityArgument.players()).executes(context -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)context, "gamemode")))))));
    }

    private static void logGamemodeChange(CommandSourceStack source, ServerPlayer player, GameType gameType) {
        MutableComponent component = Component.translatable("gameMode." + gameType.getName());
        if (source.getEntity() == player) {
            source.sendSuccess(() -> Component.translatable("commands.gamemode.success.self", component), true);
        } else {
            if (source.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                player.sendSystemMessage(Component.translatable("gameMode.changed", component));
            }
            source.sendSuccess(() -> Component.translatable("commands.gamemode.success.other", player.getDisplayName(), component), true);
        }
    }

    private static int setMode(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, GameType gameType) {
        if (PurpurConfig.commandGamemodeRequiresPermission) {
            String gamemode = gameType.getName();
            CommandSourceStack sender = (CommandSourceStack)context.getSource();
            if (!sender.testPermission(2, "minecraft.command.gamemode." + gamemode)) {
                return 0;
            }
            Entity entity = sender.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (!(players.size() <= 1 && players.contains(player) || sender.testPermission(2, "minecraft.command.gamemode." + gamemode + ".other"))) {
                    return 0;
                }
            }
        }
        int i = 0;
        for (ServerPlayer serverPlayer : players) {
            if (!GameModeCommand.setGameMode((CommandSourceStack)context.getSource(), serverPlayer, gameType)) continue;
            ++i;
        }
        return i;
    }

    public static void setGameMode(ServerPlayer player, GameType gameMode) {
        GameModeCommand.setGameMode(player.createCommandSourceStack(), player, gameMode);
    }

    private static boolean setGameMode(CommandSourceStack source, ServerPlayer player, GameType gameMode) {
        return GameModeCommand.setGameMode(source, player, gameMode, PlayerGameModeChangeEvent.Cause.COMMAND);
    }

    public static boolean setGameMode(CommandSourceStack source, ServerPlayer player, GameType gameMode, PlayerGameModeChangeEvent.Cause cause) {
        PlayerGameModeChangeEvent event = player.setGameMode(gameMode, cause, null);
        if (event != null && !event.isCancelled()) {
            GameModeCommand.logGamemodeChange(source, player, gameMode);
            return true;
        }
        if (event != null && event.cancelMessage() != null) {
            source.sendSuccess(() -> PaperAdventure.asVanilla(event.cancelMessage()), true);
            return false;
        }
        return false;
    }
}

