/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.bukkit.entity.Player;

public class ListPlayersCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("list").executes(context -> ListPlayersCommand.listPlayers((CommandSourceStack)context.getSource()))).then(Commands.literal("uuids").executes(context -> ListPlayersCommand.listPlayersWithUuids((CommandSourceStack)context.getSource())))));
    }

    private static int listPlayers(CommandSourceStack source) {
        return ListPlayersCommand.format(source, net.minecraft.world.entity.player.Player::getDisplayName);
    }

    private static int listPlayersWithUuids(CommandSourceStack source) {
        return ListPlayersCommand.format(source, player -> Component.translatable("commands.list.nameAndId", player.getName(), Component.translationArg(player.getGameProfile().id())));
    }

    private static int format(CommandSourceStack source, Function<ServerPlayer, Component> nameExtractor) {
        PlayerList playerList = source.getServer().getPlayerList();
        List<ServerPlayer> playersTemp = playerList.getPlayers();
        if (source.getBukkitSender() instanceof Player) {
            Player sender = (Player)source.getBukkitSender();
            playersTemp = playersTemp.stream().filter(ep -> sender.canSee((Player)ep.getBukkitEntity())).collect(Collectors.toList());
        }
        List<ServerPlayer> players = playersTemp;
        Component component = ComponentUtils.formatList(players, nameExtractor);
        source.sendSuccess(() -> Component.translatable("commands.list.players", players.size(), playerList.getMaxPlayers(), component), false);
        return players.size();
    }
}

