/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class PlaySoundCommand {
    private static final SimpleCommandExceptionType ERROR_TOO_FAR = new SimpleCommandExceptionType((Message)Component.translatable("commands.playsound.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        RequiredArgumentBuilder requiredArgumentBuilder = (RequiredArgumentBuilder)Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.cast(SuggestionProviders.AVAILABLE_SOUNDS)).executes(commandContext -> PlaySoundCommand.playSound((CommandSourceStack)commandContext.getSource(), PlaySoundCommand.getCallingPlayerAsCollection(((CommandSourceStack)commandContext.getSource()).getPlayer()), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandContext, "sound"), SoundSource.MASTER, ((CommandSourceStack)commandContext.getSource()).getPosition(), 1.0f, 1.0f, 0.0f));
        for (SoundSource soundSource : SoundSource.values()) {
            requiredArgumentBuilder.then(PlaySoundCommand.source(soundSource));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("playsound").requires(Commands.hasPermission(2))).then((ArgumentBuilder)requiredArgumentBuilder)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> source(SoundSource source) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal(source.getName()).executes(commandContext -> PlaySoundCommand.playSound((CommandSourceStack)commandContext.getSource(), PlaySoundCommand.getCallingPlayerAsCollection(((CommandSourceStack)commandContext.getSource()).getPlayer()), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandContext, "sound"), source, ((CommandSourceStack)commandContext.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(context -> PlaySoundCommand.playSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sound"), source, ((CommandSourceStack)context.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(context -> PlaySoundCommand.playSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sound"), source, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("volume", FloatArgumentType.floatArg((float)0.0f)).executes(context -> PlaySoundCommand.playSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sound"), source, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(context -> PlaySoundCommand.playSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sound"), source, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), ((Float)context.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(Commands.argument("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(commandContext -> PlaySoundCommand.playSound((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandContext, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandContext, "sound"), source, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandContext, "pos"), ((Float)commandContext.getArgument("volume", Float.class)).floatValue(), ((Float)commandContext.getArgument("pitch", Float.class)).floatValue(), ((Float)commandContext.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static Collection<ServerPlayer> getCallingPlayerAsCollection(@Nullable ServerPlayer player) {
        return player != null ? List.of(player) : List.of();
    }

    private static int playSound(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation sound, SoundSource soundSource, Vec3 pos, float volume, float pitch, float minVolume) throws CommandSyntaxException {
        Holder<SoundEvent> holder = Holder.direct(SoundEvent.createVariableRangeEvent(sound));
        double d = Mth.square(holder.value().getRange(volume));
        ServerLevel level = source.getLevel();
        long randomLong = level.getRandom().nextLong();
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        for (ServerPlayer serverPlayer : targets) {
            if (serverPlayer.level() != level) continue;
            double d1 = pos.x - serverPlayer.getX();
            double d2 = pos.y - serverPlayer.getY();
            double d3 = pos.z - serverPlayer.getZ();
            double d4 = d1 * d1 + d2 * d2 + d3 * d3;
            Vec3 vec3 = pos;
            float f = volume;
            if (d4 > d) {
                if (minVolume <= 0.0f) continue;
                double squareRoot = Math.sqrt(d4);
                vec3 = new Vec3(serverPlayer.getX() + d1 / squareRoot * 2.0, serverPlayer.getY() + d2 / squareRoot * 2.0, serverPlayer.getZ() + d3 / squareRoot * 2.0);
                f = minVolume;
            }
            serverPlayer.connection.send(new ClientboundSoundPacket(holder, soundSource, vec3.x(), vec3.y(), vec3.z(), f, pitch, randomLong));
            list.add(serverPlayer);
        }
        int size = list.size();
        if (size == 0) {
            throw ERROR_TOO_FAR.create();
        }
        if (size == 1) {
            source.sendSuccess(() -> Component.translatable("commands.playsound.success.single", Component.translationArg(sound), ((ServerPlayer)list.getFirst()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.playsound.success.multiple", Component.translationArg(sound), size), true);
        }
        return size;
    }
}

