/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;

public class PublishCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.publish.failed"));
    private static final DynamicCommandExceptionType ERROR_ALREADY_PUBLISHED = new DynamicCommandExceptionType(port -> Component.translatableEscape("commands.publish.alreadyPublished", port));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("publish").requires(Commands.hasPermission(4))).executes(commandContext -> PublishCommand.publish((CommandSourceStack)commandContext.getSource(), HttpUtil.getAvailablePort(), false, null))).then(((RequiredArgumentBuilder)Commands.argument("allowCommands", BoolArgumentType.bool()).executes(context -> PublishCommand.publish((CommandSourceStack)context.getSource(), HttpUtil.getAvailablePort(), BoolArgumentType.getBool((CommandContext)context, (String)"allowCommands"), null))).then(((RequiredArgumentBuilder)Commands.argument("gamemode", GameModeArgument.gameMode()).executes(context -> PublishCommand.publish((CommandSourceStack)context.getSource(), HttpUtil.getAvailablePort(), BoolArgumentType.getBool((CommandContext)context, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)context, "gamemode")))).then(Commands.argument("port", IntegerArgumentType.integer((int)0, (int)65535)).executes(context -> PublishCommand.publish((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"port"), BoolArgumentType.getBool((CommandContext)context, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)context, "gamemode"))))))));
    }

    private static int publish(CommandSourceStack source, int port, boolean cheats, @Nullable GameType gameMode) throws CommandSyntaxException {
        if (source.getServer().isPublished()) {
            throw ERROR_ALREADY_PUBLISHED.create((Object)source.getServer().getPort());
        }
        if (!source.getServer().publishServer(gameMode, cheats, port)) {
            throw ERROR_FAILED.create();
        }
        source.sendSuccess(() -> PublishCommand.getSuccessMessage(port), true);
        return port;
    }

    public static MutableComponent getSuccessMessage(int port) {
        MutableComponent component = ComponentUtils.copyOnClickText(String.valueOf(port));
        return Component.translatable("commands.publish.started", component);
    }
}

