/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        Predicate<BlockInWorld> predicate = block -> block.getLevel().isEmptyBlock(block.getPos());
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(Commands.hasPermission(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block(buildContext)).executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.REPLACE, null, false))).then(Commands.literal("destroy").executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.DESTROY, null, false)))).then(Commands.literal("keep").executes(commandContext -> SetBlockCommand.setBlock((CommandSourceStack)commandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)commandContext, "block"), Mode.REPLACE, predicate, false)))).then(Commands.literal("replace").executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.REPLACE, null, false)))).then(Commands.literal("strict").executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.REPLACE, null, true)))))));
    }

    private static int setBlock(CommandSourceStack source, BlockPos pos, BlockInput block, Mode mode, @Nullable Predicate<BlockInWorld> filter, boolean strict) throws CommandSyntaxException {
        boolean flag;
        ServerLevel level = source.getLevel();
        if (level.isDebug()) {
            throw ERROR_FAILED.create();
        }
        if (filter != null && !filter.test(new BlockInWorld(level, pos, true))) {
            throw ERROR_FAILED.create();
        }
        if (mode == Mode.DESTROY) {
            level.destroyBlock(pos, true);
            flag = !block.getState().isAir() || !level.getBlockState(pos).isAir();
        } else {
            flag = true;
        }
        BlockState blockState = level.getBlockState(pos);
        if (flag && !block.place(level, pos, 2 | (strict ? 816 : 256))) {
            throw ERROR_FAILED.create();
        }
        if (!strict) {
            level.updateNeighboursOnBlockSet(pos, blockState);
        }
        source.sendSuccess(() -> Component.translatable("commands.setblock.success", pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }
}

