/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.RegistryAccess;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class Settings<T extends Settings<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Properties properties;
    private static final boolean skipComments = Boolean.getBoolean("Paper.skipServerPropertiesComments");
    private OptionSet options = null;

    public Settings(Properties properties, OptionSet options) {
        this.properties = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name)) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties loadFromFile(Path filePath) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return new Properties();
        }
        try {
            try {
                Properties var13;
                try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                    CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    Properties map = new Properties();
                    map.load(new InputStreamReader(inputStream, charsetDecoder));
                    var13 = map;
                }
                return var13;
            }
            catch (CharacterCodingException var9) {
                Properties var4;
                LOGGER.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)filePath);
                try (BufferedReader bufferedReader = Files.newBufferedReader(filePath, StandardCharsets.ISO_8859_1);){
                    Properties map = new Properties();
                    map.load(bufferedReader);
                    var4 = map;
                }
                return var4;
            }
        }
        catch (IOException var10) {
            LOGGER.error("Failed to load properties from file: {}", (Object)filePath, (Object)var10);
            return new Properties();
        }
    }

    public void store(Path filePath) {
        try {
            if (filePath.toFile().exists() && !filePath.toFile().canWrite()) {
                LOGGER.warn("Can not write to file {}, skipping.", (Object)filePath);
                return;
            }
            OutputStream outputstream = Files.newOutputStream(filePath, new OpenOption[0]);
            BufferedOutputStream bufferedOutputStream = !skipComments ? new BufferedOutputStream(outputstream) : new BufferedOutputStream(this, outputstream){
                private boolean isRightAfterNewline = true;
                private boolean isComment = false;

                @Override
                public void write(@NotNull byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(@NotNull byte[] bbuf, int off, int len) throws IOException {
                    int latest_offset = off;
                    for (int index = off; index < off + len; ++index) {
                        boolean isNewline;
                        byte c = bbuf[index];
                        boolean bl = isNewline = c == 10 || c == 13;
                        if (isNewline && this.isComment) {
                            this.isComment = false;
                            latest_offset = index + 1;
                        }
                        if (c == 35 && this.isRightAfterNewline) {
                            this.isComment = true;
                            if (index != latest_offset) {
                                super.write(bbuf, latest_offset, index - latest_offset);
                            }
                        }
                        this.isRightAfterNewline = isNewline;
                    }
                    if (latest_offset < off + len && !this.isComment) {
                        super.write(bbuf, latest_offset, off + len - latest_offset);
                    }
                }
            };
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, StandardCharsets.UTF_8.newEncoder()));
            this.properties.store(bufferedWriter, "Minecraft server properties");
        }
        catch (IOException var7) {
            LOGGER.error("Failed to store properties to file: {}", (Object)filePath);
        }
    }

    private static <V extends Number> Function<String, V> wrapNumberDeserializer(Function<String, V> parseFunc) {
        return string -> {
            try {
                return (Number)parseFunc.apply((String)string);
            }
            catch (NumberFormatException var3) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> dispatchNumberOrString(IntFunction<V> byId, Function<String, V> byName) {
        return string -> {
            try {
                return byId.apply(Integer.parseInt(string));
            }
            catch (NumberFormatException var4) {
                return byName.apply((String)string);
            }
        };
    }

    @Nullable
    public String getStringRaw(String key) {
        return this.getOverride(key, this.properties.getProperty(key));
    }

    @Nullable
    protected <V> V getLegacy(String key, Function<String, V> serializer) {
        String stringRaw = this.getStringRaw(key);
        if (stringRaw == null) {
            return null;
        }
        this.properties.remove(key);
        return serializer.apply(stringRaw);
    }

    protected <V> V get(String key, Function<String, V> serializer, Function<V, String> deserializer, V defaultValue) {
        try {
            return this.get0(key, serializer, deserializer, defaultValue);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + key + "'", ex);
        }
    }

    private <V> V get0(String key, Function<String, V> serializer, Function<V, String> deserializer, V defaultValue) {
        String stringRaw = this.getStringRaw(key);
        Object object = MoreObjects.firstNonNull(stringRaw != null ? serializer.apply(stringRaw) : null, defaultValue);
        this.properties.put(key, deserializer.apply(object));
        return (V)object;
    }

    protected <V> MutableValue<V> getMutable(String key, Function<String, V> serializer, Function<V, String> deserializer, V defaultValue) {
        String stringRaw = this.getStringRaw(key);
        Object object = MoreObjects.firstNonNull(stringRaw != null ? serializer.apply(stringRaw) : null, defaultValue);
        this.properties.put(key, deserializer.apply(object));
        return new MutableValue<Object>(key, object, deserializer);
    }

    protected <V> V get(String key, Function<String, V> serializer, UnaryOperator<V> modifier, Function<V, String> deserializer, V defaultValue) {
        return (V)this.get(key, string -> {
            Object object = serializer.apply((String)string);
            return object != null ? modifier.apply(object) : null;
        }, deserializer, defaultValue);
    }

    protected <V> V get(String key, Function<String, V> mapper, V value) {
        return (V)this.get(key, mapper, Objects::toString, value);
    }

    protected <V> MutableValue<V> getMutable(String key, Function<String, V> serializer, V defaultValue) {
        return this.getMutable(key, serializer, Objects::toString, defaultValue);
    }

    protected String get(String key, String defaultValue) {
        return this.get(key, Function.identity(), Function.identity(), defaultValue);
    }

    @Nullable
    protected String getLegacyString(String key) {
        return (String)this.getLegacy(key, Function.identity());
    }

    protected int get(String key, int defaultValue) {
        return this.get(key, Settings.wrapNumberDeserializer(Integer::parseInt), Integer.valueOf(defaultValue));
    }

    protected MutableValue<Integer> getMutable(String key, int defaultValue) {
        return this.getMutable(key, Settings.wrapNumberDeserializer(Integer::parseInt), defaultValue);
    }

    protected MutableValue<String> getMutable(String key, String defaultValue) {
        return this.getMutable(key, String::new, defaultValue);
    }

    protected int get(String key, UnaryOperator<Integer> modifier, int defaultValue) {
        return this.get(key, Settings.wrapNumberDeserializer(Integer::parseInt), modifier, Objects::toString, defaultValue);
    }

    protected long get(String key, long defaultValue) {
        return this.get(key, Settings.wrapNumberDeserializer(Long::parseLong), defaultValue);
    }

    protected boolean get(String key, boolean defaultValue) {
        return this.get(key, Boolean::valueOf, defaultValue);
    }

    protected MutableValue<Boolean> getMutable(String key, boolean defaultValue) {
        return this.getMutable(key, Boolean::valueOf, defaultValue);
    }

    @Nullable
    protected Boolean getLegacyBoolean(String key) {
        return this.getLegacy(key, Boolean::valueOf);
    }

    protected Properties cloneProperties() {
        Properties map = new Properties();
        map.putAll((Map<?, ?>)this.properties);
        return map;
    }

    protected abstract T reload(RegistryAccess var1, Properties var2, OptionSet var3);

    public class MutableValue<V>
    implements Supplier<V> {
        private final String key;
        private final V value;
        private final Function<V, String> serializer;

        MutableValue(String key, V value, Function<V, String> serializer) {
            this.key = key;
            this.value = value;
            this.serializer = serializer;
        }

        @Override
        public V get() {
            return this.value;
        }

        public T update(RegistryAccess registryAccess, V newValue) {
            Properties map = Settings.this.cloneProperties();
            map.put(this.key, this.serializer.apply(newValue));
            return Settings.this.reload(registryAccess, map, Settings.this.options);
        }
    }
}

