/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;

public record NumberRangeInput(int width, Component label, String labelFormat, RangeInfo rangeInfo) implements InputControl
{
    public static final MapCodec<NumberRangeInput> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(NumberRangeInput::width), (App)ComponentSerialization.CODEC.fieldOf("label").forGetter(NumberRangeInput::label), (App)Codec.STRING.optionalFieldOf("label_format", (Object)"options.generic_value").forGetter(NumberRangeInput::labelFormat), (App)RangeInfo.MAP_CODEC.forGetter(NumberRangeInput::rangeInfo)).apply((Applicative)instance, NumberRangeInput::new));

    public MapCodec<NumberRangeInput> mapCodec() {
        return MAP_CODEC;
    }

    public Component computeLabel(String value) {
        return Component.translatable(this.labelFormat, this.label, value);
    }

    public record RangeInfo(float start, float end, Optional<Float> initial, Optional<Float> step) {
        public static final MapCodec<RangeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("start").forGetter(RangeInfo::start), (App)Codec.FLOAT.fieldOf("end").forGetter(RangeInfo::end), (App)Codec.FLOAT.optionalFieldOf("initial").forGetter(RangeInfo::initial), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("step").forGetter(RangeInfo::step)).apply((Applicative)instance, RangeInfo::new)).validate(rangeInfo -> {
            if (rangeInfo.initial.isPresent()) {
                double d = rangeInfo.initial.get().floatValue();
                double d1 = Math.min(rangeInfo.start, rangeInfo.end);
                double d2 = Math.max(rangeInfo.start, rangeInfo.end);
                if (d < d1 || d > d2) {
                    return DataResult.error(() -> "Initial value " + d + " is outside of range [" + d1 + ", " + d2 + "]");
                }
            }
            return DataResult.success((Object)rangeInfo);
        });

        public float computeScaledValue(float value) {
            float f3;
            int rounded;
            float f = Mth.lerp(value, this.start, this.end);
            if (this.step.isEmpty()) {
                return f;
            }
            float f1 = this.step.get().floatValue();
            float f2 = this.initialScaledValue();
            float f4 = f2 + (float)(rounded = Math.round((f3 = f - f2) / f1)) * f1;
            if (!this.isOutOfRange(f4)) {
                return f4;
            }
            int i = rounded - Mth.sign(rounded);
            return f2 + (float)i * f1;
        }

        private boolean isOutOfRange(float value) {
            float f = this.scaledValueToSlider(value);
            return (double)f < 0.0 || (double)f > 1.0;
        }

        private float initialScaledValue() {
            return this.initial.isPresent() ? this.initial.get().floatValue() : (this.start + this.end) / 2.0f;
        }

        public float initialSliderValue() {
            float f = this.initialScaledValue();
            return this.scaledValueToSlider(f);
        }

        private float scaledValueToSlider(float value) {
            return this.start == this.end ? 0.5f : Mth.inverseLerp(value, this.start, this.end);
        }
    }
}

