/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;

public interface IncomingRpcMethod {
    public MethodInfo info();

    public Attributes attributes();

    public JsonElement apply(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> IncomingRpcMethodBuilder<ParameterlessMethod<Result>> method(ParameterlessRpcMethodFunction<Result> supplier, Codec<Result> resultCodec) {
        return new IncomingRpcMethodBuilder<ParameterlessMethod<Result>>((info, attributes) -> {
            if (info.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (info.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod(info, attributes, resultCodec, supplier);
        });
    }

    public static <Params, Result> IncomingRpcMethodBuilder<Method<Params, Result>> method(RpcMethodFunction<Params, Result> function, Codec<Params> paramsCodec, Codec<Result> resultCodec) {
        return new IncomingRpcMethodBuilder<Method<Params, Result>>((info, attributes) -> {
            if (info.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (info.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new Method(info, attributes, paramsCodec, resultCodec, function);
        });
    }

    public static <Result> IncomingRpcMethodBuilder<ParameterlessMethod<Result>> method(Function<MinecraftApi, Result> callback, Codec<Result> resultCodec) {
        return new IncomingRpcMethodBuilder<ParameterlessMethod<Result>>((info, attributes) -> {
            if (info.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (info.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod<Object>(info, attributes, resultCodec, (api, client) -> callback.apply(api));
        });
    }

    public static class IncomingRpcMethodBuilder<T extends IncomingRpcMethod> {
        private final Factory<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;
        private boolean discoverable = true;
        private boolean runOnMainThread = true;

        public IncomingRpcMethodBuilder(Factory<T> method) {
            this.method = method;
        }

        public IncomingRpcMethodBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        public IncomingRpcMethodBuilder<T> response(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            return this;
        }

        public IncomingRpcMethodBuilder<T> param(ParamInfo paramInfo) {
            this.paramInfo = paramInfo;
            return this;
        }

        public IncomingRpcMethodBuilder<T> undiscoverable() {
            this.discoverable = false;
            return this;
        }

        public IncomingRpcMethodBuilder<T> notOnMainThread() {
            this.runOnMainThread = false;
            return this;
        }

        public T build() {
            MethodInfo methodInfo = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create(methodInfo, new Attributes(this.runOnMainThread, this.discoverable));
        }

        public T register(Registry<IncomingRpcMethod> registry, String namespace) {
            return this.register(registry, ResourceLocation.withDefaultNamespace(namespace));
        }

        private T register(Registry<IncomingRpcMethod> registry, ResourceLocation id) {
            return (T)((IncomingRpcMethod)Registry.register(registry, id, this.build()));
        }
    }

    @FunctionalInterface
    public static interface ParameterlessRpcMethodFunction<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface Factory<T extends IncomingRpcMethod> {
        public T create(MethodInfo var1, Attributes var2);
    }

    @FunctionalInterface
    public static interface RpcMethodFunction<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record ParameterlessMethod<Result>(MethodInfo info, Attributes attributes, Codec<Result> resultCodec, ParameterlessRpcMethodFunction<Result> supplier) implements IncomingRpcMethod
    {
        @Override
        public JsonElement apply(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params == null || params.isJsonArray() && params.getAsJsonArray().isEmpty()) {
                if (this.info.params().isPresent()) {
                    throw new IllegalArgumentException("Method defined as not having parameters but is describing them");
                }
                Result object = this.supplier.apply(api, client);
                return (JsonElement)this.resultCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(InvalidParameterJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
        }
    }

    public record Attributes(boolean runOnMainThread, boolean discoverable) {
    }

    public record Method<Params, Result>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec, RpcMethodFunction<Params, Result> function) implements IncomingRpcMethod
    {
        @Override
        public JsonElement apply(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params != null && (params.isJsonArray() || params.isJsonObject())) {
                JsonElement jsonElement1;
                if (this.info.params().isEmpty()) {
                    throw new IllegalArgumentException("Method defined as having parameters without describing them");
                }
                if (params.isJsonObject()) {
                    String string = this.info.params().get().name();
                    JsonElement jsonElement = params.getAsJsonObject().get(string);
                    if (jsonElement == null) {
                        throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", string));
                    }
                    jsonElement1 = jsonElement;
                } else {
                    JsonArray asJsonArray = params.getAsJsonArray();
                    if (asJsonArray.isEmpty() || asJsonArray.size() > 1) {
                        throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                    }
                    jsonElement1 = asJsonArray.get(0);
                }
                Object orThrow = this.paramsCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement1).getOrThrow(InvalidParameterJsonRpcException::new);
                Result object = this.function.apply(api, orThrow, client);
                return (JsonElement)this.resultCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(EncodeJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected params as array or named");
        }
    }
}

