/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;

public interface OutgoingRpcMethod<Params, Result> {
    public static final String NOTIFICATION_PREFIX = "notification/";

    public MethodInfo info();

    public Attributes attributes();

    @Nullable
    default public JsonElement encodeParams(Params params) {
        return null;
    }

    @Nullable
    default public Result decodeResult(JsonElement result) {
        return null;
    }

    public static OutgoingRpcMethodBuilder<ParmeterlessNotification> notification() {
        return new OutgoingRpcMethodBuilder<ParmeterlessNotification>((info, attributes) -> {
            if (info.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (info.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new ParmeterlessNotification(info, attributes);
        });
    }

    public static <Params> OutgoingRpcMethodBuilder<Notification<Params>> notification(Codec<Params> paramsCodec) {
        return new OutgoingRpcMethodBuilder<Notification<Params>>((info, attributes) -> {
            if (info.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (info.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new Notification(info, attributes, paramsCodec);
        });
    }

    public static <Result> OutgoingRpcMethodBuilder<ParameterlessMethod<Result>> request(Codec<Result> resultCodec) {
        return new OutgoingRpcMethodBuilder<ParameterlessMethod<Result>>((info, attributes) -> {
            if (info.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (info.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod(info, attributes, resultCodec);
        });
    }

    public static <Params, Result> OutgoingRpcMethodBuilder<Method<Params, Result>> request(Codec<Params> paramsCodec, Codec<Result> resultCodec) {
        return new OutgoingRpcMethodBuilder<Method<Params, Result>>((info, attributes) -> {
            if (info.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (info.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new Method(info, attributes, paramsCodec, resultCodec);
        });
    }

    public static class OutgoingRpcMethodBuilder<T extends OutgoingRpcMethod<?, ?>> {
        public static final Attributes DEFAULT_ATTRIBUTES = new Attributes(true);
        private final Factory<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;

        public OutgoingRpcMethodBuilder(Factory<T> method) {
            this.method = method;
        }

        public OutgoingRpcMethodBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        public OutgoingRpcMethodBuilder<T> response(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            return this;
        }

        public OutgoingRpcMethodBuilder<T> param(ParamInfo paramInfo) {
            this.paramInfo = paramInfo;
            return this;
        }

        private T build() {
            MethodInfo methodInfo = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create(methodInfo, DEFAULT_ATTRIBUTES);
        }

        public Holder.Reference<T> register(String namespace) {
            return this.register(ResourceLocation.withDefaultNamespace(OutgoingRpcMethod.NOTIFICATION_PREFIX + namespace));
        }

        private Holder.Reference<T> register(ResourceLocation id) {
            return Registry.registerForHolder(BuiltInRegistries.OUTGOING_RPC_METHOD, id, this.build());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends OutgoingRpcMethod<?, ?>> {
        public T create(MethodInfo var1, Attributes var2);
    }

    public record Method<Params, Result>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec) implements OutgoingRpcMethod<Params, Result>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params params) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, params).getOrThrow();
        }

        @Override
        public Result decodeResult(JsonElement result) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)result).getOrThrow();
        }
    }

    public record Attributes(boolean discoverable) {
    }

    public record ParameterlessMethod<Result>(MethodInfo info, Attributes attributes, Codec<Result> resultCodec) implements OutgoingRpcMethod<Void, Result>
    {
        @Override
        public Result decodeResult(JsonElement result) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)result).getOrThrow();
        }
    }

    public record Notification<Params>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec) implements OutgoingRpcMethod<Params, Void>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params params) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, params).getOrThrow();
        }
    }

    public record ParmeterlessNotification(MethodInfo info, Attributes attributes) implements OutgoingRpcMethod<Void, Void>
    {
    }
}

