/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface ChunkResult<T> {
    public static <T> ChunkResult<T> of(T value) {
        return new Success<T>(value);
    }

    public static <T> ChunkResult<T> error(String error) {
        return ChunkResult.error(() -> error);
    }

    public static <T> ChunkResult<T> error(Supplier<String> errorSupplier) {
        return new Fail(errorSupplier);
    }

    public boolean isSuccess();

    @Nullable
    public T orElse(@Nullable T var1);

    @Nullable
    public static <R> R orElse(ChunkResult<? extends R> chunkResult, @Nullable R orElse) {
        R object = chunkResult.orElse(null);
        return object != null ? object : (R)orElse;
    }

    @Nullable
    public String getError();

    public ChunkResult<T> ifSuccess(Consumer<T> var1);

    public <R> ChunkResult<R> map(Function<T, R> var1);

    public <E extends Throwable> T orElseThrow(Supplier<E> var1) throws E;

    public record Success<T>(T value) implements ChunkResult<T>
    {
        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T orElse(@Nullable T value) {
            return this.value;
        }

        @Override
        @Nullable
        public String getError() {
            return null;
        }

        @Override
        public ChunkResult<T> ifSuccess(Consumer<T> action) {
            action.accept(this.value);
            return this;
        }

        @Override
        public <R> ChunkResult<R> map(Function<T, R> mappingFunction) {
            return new Success<R>(mappingFunction.apply(this.value));
        }

        @Override
        public <E extends Throwable> T orElseThrow(Supplier<E> exceptionSupplier) throws E {
            return this.value;
        }
    }

    public record Fail<T>(Supplier<String> error) implements ChunkResult<T>
    {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        @Nullable
        public T orElse(@Nullable T value) {
            return value;
        }

        @Override
        public String getError() {
            return this.error.get();
        }

        @Override
        public ChunkResult<T> ifSuccess(Consumer<T> action) {
            return this;
        }

        @Override
        public <R> ChunkResult<R> map(Function<T, R> mappingFunction) {
            return new Fail<T>(this.error);
        }

        @Override
        public <E extends Throwable> T orElseThrow(Supplier<E> exceptionSupplier) throws E {
            throw (Throwable)exceptionSupplier.get();
        }
    }
}

