/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.world.level.TicketStorage;

class LoadingChunkTracker
extends ChunkTracker {
    private static final int MAX_LEVEL = ChunkLevel.MAX_LEVEL + 1;
    private final DistanceManager distanceManager;
    private final TicketStorage ticketStorage;

    public LoadingChunkTracker(DistanceManager distanceManager, TicketStorage ticketStorage) {
        super(MAX_LEVEL + 1, 16, 256);
        this.distanceManager = distanceManager;
        this.ticketStorage = ticketStorage;
        ticketStorage.setLoadingChunkUpdatedListener(this::update);
    }

    @Override
    protected int getLevelFromSource(long pos) {
        return this.ticketStorage.getTicketLevelAt(pos, false);
    }

    @Override
    protected int getLevel(long chunkPos) {
        ChunkHolder chunk;
        if (!this.distanceManager.isChunkToRemove(chunkPos) && (chunk = this.distanceManager.getChunk(chunkPos)) != null) {
            return chunk.getTicketLevel();
        }
        return MAX_LEVEL;
    }

    @Override
    protected void setLevel(long chunkPos, int level) {
        int i;
        ChunkHolder chunk = this.distanceManager.getChunk(chunkPos);
        int n = i = chunk == null ? MAX_LEVEL : chunk.getTicketLevel();
        if (i == level || (chunk = this.distanceManager.updateChunkScheduling(chunkPos, level, chunk, i)) != null) {
            // empty if block
        }
    }

    public int runDistanceUpdates(int toUpdateCount) {
        return this.runUpdates(toUpdateCount);
    }
}

