/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.LevelDebugSynchronizers;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;

public class ServerLevel
extends Level
implements ServerEntityGetter,
WorldGenLevel,
ChunkSystemServerLevel,
ChunkSystemLevelReader,
ChunkTickServerLevel {
    public static final BlockPos END_SPAWN_POINT = new BlockPos(100, 50, 0);
    public static final IntProvider RAIN_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of(12000, 24000);
    private static final IntProvider THUNDER_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of(3600, 15600);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EMPTY_TIME_NO_TICK = 300;
    private static final int MAX_SCHEDULED_TICKS_PER_TICK = 65536;
    final List<ServerPlayer> players = Lists.newArrayList();
    public final ServerChunkCache chunkSource;
    private final MinecraftServer server;
    public final PrimaryLevelData serverLevelData;
    final EntityTickList entityTickList = new EntityTickList();
    private final ServerWaypointManager waypointManager;
    private final GameEventDispatcher gameEventDispatcher;
    public boolean noSave;
    private final SleepStatus sleepStatus;
    private int emptyTime;
    private final PortalForcer portalForcer;
    private final LevelTicks<Block> blockTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final LevelTicks<Fluid> fluidTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final PathTypeCache pathTypesByPosCache = new PathTypeCache();
    final Set<Mob> navigatingMobs = new ObjectOpenHashSet();
    volatile boolean isUpdatingNavigations;
    protected final Raids raids;
    private final ObjectLinkedOpenHashSet<BlockEventData> blockEvents = new ObjectLinkedOpenHashSet();
    private final List<BlockEventData> blockEventsToReschedule = new ArrayList<BlockEventData>(64);
    private boolean handlingTick;
    private final List<CustomSpawner> customSpawners;
    @Nullable
    private EndDragonFight dragonFight;
    final Int2ObjectMap<EnderDragonPart> dragonParts = new Int2ObjectOpenHashMap();
    private final StructureManager structureManager;
    private final StructureCheck structureCheck;
    private final boolean tickTime;
    private double preciseTime;
    private boolean forceTime;
    private final RandomSequences randomSequences;
    final LevelDebugSynchronizers debugSynchronizers = new LevelDebugSynchronizers(this);
    public final LevelStorageSource.LevelStorageAccess levelStorageAccess;
    public final UUID uuid;
    public final LevelLoadListener levelLoadListener;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    public boolean hasRidableMoveEvent = false;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final LevelChunk[] EMPTY_LEVEL_CHUNKS = new LevelChunk[0];
    private final ReferenceList<LevelChunk> loadedChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<LevelChunk> tickingChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<LevelChunk> entityTickingChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<LevelChunk> playerTickingChunks = new ReferenceList<LevelChunk>(EMPTY_LEVEL_CHUNKS);
    private final Long2IntOpenHashMap playerTickingRequests = new Long2IntOpenHashMap();
    private final SimpleThreadUnsafeRandom simpleRandom = new SimpleThreadUnsafeRandom(RandomSupport.generateUniqueSeed());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;

    @Override
    @Nullable
    public LevelChunk getChunkIfLoaded(int x, int z) {
        return this.chunkSource.getChunkAtIfLoadedImmediately(x, z);
    }

    @Override
    public ResourceKey<LevelStem> getTypeKey() {
        return this.levelStorageAccess.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AABB box) {
        int minBlockX = Mth.floor(box.minX - 1.0E-7) - 3;
        int maxBlockX = Mth.floor(box.maxX + 1.0E-7) + 3;
        int minBlockZ = Mth.floor(box.minZ - 1.0E-7) - 3;
        int maxBlockZ = Mth.floor(box.maxZ + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ServerChunkCache chunkProvider = this.getChunkSource();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AABB box, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        int minBlockX = Mth.floor(box.minX - 1.0E-7) - 3;
        int minBlockZ = Mth.floor(box.minZ - 1.0E-7) - 3;
        int maxBlockX = Mth.floor(box.maxX + 1.0E-7) + 3;
        int maxBlockZ = Mth.floor(box.maxZ + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunks(minChunkX, minChunkZ, maxChunkX, maxChunkZ, priority, onLoad);
    }

    public final void loadChunks(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    @Nullable
    public Player getPlayerByUUID(UUID uuid) {
        ServerPlayer player = this.getServer().getPlayerList().getPlayer(uuid);
        return player != null && ((net.minecraft.world.entity.Entity)player).level() == this ? player : null;
    }

    @Override
    public final LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.chunkSource.getChunkNow(chunkX, chunkZ);
    }

    @Override
    public final ChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final ChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.server.moonrise$executeMidTickTasks();
    }

    @Override
    public final ChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPos pos, int radiusBlocks, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.getX() - radiusBlocks >> 4, pos.getX() + radiusBlocks >> 4, pos.getZ() - radiusBlocks >> 4, pos.getZ() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPos pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.getX() - radiusBlocks >> 4, pos.getX() + radiusBlocks >> 4, pos.getZ() - radiusBlocks >> 4, pos.getZ() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.FULL, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, chunkStatus, priority, onLoad, null);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad, Consumer<ChunkAccess> onEachLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<ChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.getPos(), ticketLevel, holderIdentifier);
            }
            if (onEachLoad != null) {
                onEachLoad.accept((ChunkAccess)chunk);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    if (onLoad != null) {
                        onLoad.accept(Collections.unmodifiableList(ret));
                    }
                }
                finally {
                    int len = ret.size();
                    for (int i = 0; i < len; ++i) {
                        ChunkPos chunkPos = ((ChunkAccess)ret.get(i)).getPos();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                PlatformHooks.get().scheduleChunkLoad(this, cx, cz, ChunkStatus.FULL, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ServerChunkCache chunkSource = this.chunkSource;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void moonrise$issueEmergencySave() {
        this.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(true, true, true, true);
    }

    @Override
    public final ReferenceList<LevelChunk> moonrise$getPlayerTickingChunks() {
        return this.playerTickingChunks;
    }

    @Override
    public final void moonrise$markChunkForPlayerTicking(LevelChunk chunk) {
        ChunkPos pos = chunk.getPos();
        if (!this.playerTickingRequests.containsKey(CoordinateUtils.getChunkKey(pos))) {
            return;
        }
        this.playerTickingChunks.add(chunk);
    }

    @Override
    public final void moonrise$removeChunkForPlayerTicking(LevelChunk chunk) {
        this.playerTickingChunks.remove(chunk);
    }

    @Override
    public final void moonrise$addPlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((Level)this, chunkX, chunkZ, "Cannot add ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (this.playerTickingRequests.addTo(chunkKey, 1) != 0) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.add((LevelChunk)chunkHolder.getCurrentChunk());
    }

    @Override
    public final void moonrise$removePlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((Level)this, chunkX, chunkZ, "Cannot remove ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int val = this.playerTickingRequests.addTo(chunkKey, -1);
        if (val <= 0) {
            throw new IllegalStateException("Negative counter");
        }
        if (val != 1) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.remove((LevelChunk)chunkHolder.getCurrentChunk());
    }

    public ServerLevel(MinecraftServer server, Executor dispatcher, LevelStorageSource.LevelStorageAccess levelStorageAccess, PrimaryLevelData serverLevelData, ResourceKey<Level> dimension, LevelStem levelStem, boolean isDebug, long biomeZoomSeed, List<CustomSpawner> customSpawners, boolean tickTime, @Nullable RandomSequences randomSequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(serverLevelData, dimension, server.registryAccess(), levelStem.type(), false, isDebug, biomeZoomSeed, server.getMaxChainedNeighborUpdates(), gen, biomeProvider, env, spigotConfig -> server.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(levelStorageAccess.levelDirectory.path(), serverLevelData.getLevelName(), dimension.location(), spigotConfig, server.registryAccess(), serverLevelData.getGameRules())), dispatcher);
        this.levelStorageAccess = levelStorageAccess;
        this.uuid = WorldUUID.getOrCreate(levelStorageAccess.levelDirectory.path().toFile());
        this.levelLoadListener = new LoggingLevelLoadListener(false, this);
        this.tickTime = tickTime;
        this.server = server;
        this.customSpawners = new ArrayList<CustomSpawner>();
        this.serverLevelData = serverLevelData;
        if (this.purpurConfig.phantomSpawning) {
            this.customSpawners.add(new PhantomSpawner());
        }
        if (this.purpurConfig.patrolSpawning) {
            this.customSpawners.add(new PatrolSpawner());
        }
        if (this.purpurConfig.catSpawning) {
            this.customSpawners.add(new CatSpawner());
        }
        if (this.purpurConfig.villageSiegeSpawning) {
            this.customSpawners.add(new VillageSiege());
        }
        if (this.purpurConfig.villagerTraderSpawning) {
            this.customSpawners.add(new WanderingTraderSpawner(serverLevelData));
        }
        ChunkGenerator chunkGenerator = levelStem.generator();
        this.serverLevelData.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager biomeSource = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, (Registry<Biome>)this.server.registryAccess().lookupOrThrow(Registries.BIOME), chunkGenerator.getBiomeSource());
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseBased = (NoiseBasedChunkGenerator)chunkGenerator;
                chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)biomeSource, noiseBased.settings);
            } else if (chunkGenerator instanceof FlatLevelSource) {
                FlatLevelSource flatLevel = (FlatLevelSource)chunkGenerator;
                chunkGenerator = new FlatLevelSource(flatLevel.settings(), biomeSource);
            }
        }
        if (gen != null) {
            chunkGenerator = new CustomChunkGenerator(this, chunkGenerator, gen);
        }
        boolean flag = server.forceSynchronousWrites();
        DataFixer fixerUpper = server.getFixerUpper();
        this.chunkSource = new ServerChunkCache(this, levelStorageAccess, fixerUpper, server.getStructureManager(), dispatcher, chunkGenerator, this.spigotConfig.viewDistance, this.spigotConfig.simulationDistance, flag, null, () -> server.overworld().getDataStorage());
        this.chunkSource.getGeneratorState().ensureStructuresGenerated();
        this.portalForcer = new PortalForcer(this);
        this.updateSkyBrightness();
        this.prepareWeather();
        this.raids = this.getDataStorage().computeIfAbsent(Raids.getType(this.dimensionTypeRegistration()));
        if (!server.isSingleplayer()) {
            serverLevelData.setGameType(server.getDefaultGameType());
        }
        long seed = server.getWorldData().worldGenOptions().seed();
        this.structureCheck = new StructureCheck(this.chunkSource.chunkScanner(), this.registryAccess(), server.getStructureManager(), this.getTypeKey(), chunkGenerator, this.chunkSource.randomState(), this, chunkGenerator.getBiomeSource(), seed, fixerUpper);
        this.structureManager = new StructureManager(this, this.serverLevelData.worldGenOptions(), this.structureCheck);
        this.dragonFight = this.dimension() == Level.END && this.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) || env == World.Environment.THE_END ? new EndDragonFight(this, this.serverLevelData.worldGenOptions().seed(), this.serverLevelData.endDragonFightData()) : null;
        this.sleepStatus = new SleepStatus();
        this.gameEventDispatcher = new GameEventDispatcher(this);
        this.randomSequences = Objects.requireNonNullElseGet(randomSequences, () -> this.getDataStorage().computeIfAbsent(RandomSequences.TYPE));
        this.waypointManager = new ServerWaypointManager();
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new EntityCallbacks()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(levelStorageAccess.getLevelId(), dimension, "entities"), levelStorageAccess.getDimensionPath(dimension).resolve("entities"), server.forceSynchronousWrites()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController(this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController(this, this.chunkTaskScheduler);
        this.getCraftServer().addWorld(this.getWorld());
        this.preciseTime = this.serverLevelData.getDayTime();
    }

    @Override
    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.getChunkSource().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void setDragonFight(@Nullable EndDragonFight dragonFight) {
        this.dragonFight = dragonFight;
    }

    public void setWeatherParameters(int clearTime, int weatherTime, boolean isRaining, boolean isThundering) {
        this.serverLevelData.setClearWeatherTime(clearTime);
        this.serverLevelData.setRainTime(weatherTime);
        this.serverLevelData.setThunderTime(weatherTime);
        this.serverLevelData.setRaining(isRaining, WeatherChangeEvent.Cause.COMMAND);
        this.serverLevelData.setThundering(isThundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return this.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(x, y, z, this.getChunkSource().randomState().sampler());
    }

    public StructureManager structureManager() {
        return this.structureManager;
    }

    public void tick(BooleanSupplier hasTimeLeft) {
        boolean hasActiveTickets;
        ProfilerFiller profilerFiller = Profiler.get();
        this.handlingTick = true;
        TickRateManager tickRateManager = this.tickRateManager();
        boolean runsNormally = tickRateManager.runsNormally();
        if (runsNormally) {
            profilerFiller.push("world border");
            this.getWorldBorder().tick();
            profilerFiller.popPush("weather");
            this.advanceWeatherCycle();
            profilerFiller.pop();
        }
        int _int = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
        if (this.purpurConfig.playersSkipNight && this.sleepStatus.areEnoughSleeping(_int) && this.sleepStatus.areEnoughDeepSleeping(_int, this.players)) {
            long newDayTime = this.levelData.getDayTime() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, newDayTime - newDayTime % 24000L - this.getDayTime());
            if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT) && event.callEvent()) {
                this.setDayTime(this.getDayTime() + event.getSkipAmount());
            }
            if (!event.isCancelled()) {
                this.wakeUpAllPlayers();
            }
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && this.isRaining()) {
                this.resetWeatherCycle();
            }
        }
        this.updateSkyBrightness();
        if (runsNormally) {
            this.tickTime();
        }
        profilerFiller.push("tickPending");
        if (!this.isDebug() && runsNormally) {
            long l = this.getGameTime();
            profilerFiller.push("blockTicks");
            this.blockTicks.tick(l, this.paperConfig().environment.maxBlockTicks, this::tickBlock);
            profilerFiller.popPush("fluidTicks");
            this.fluidTicks.tick(l, this.paperConfig().environment.maxFluidTicks, this::tickFluid);
            profilerFiller.pop();
        }
        profilerFiller.popPush("raid");
        if (runsNormally) {
            this.raids.tick(this);
        }
        profilerFiller.popPush("chunkSource");
        this.getChunkSource().tick(hasTimeLeft, true);
        profilerFiller.popPush("blockEvents");
        if (runsNormally) {
            this.runBlockEvents();
        }
        this.handlingTick = false;
        profilerFiller.pop();
        boolean bl = hasActiveTickets = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || this.chunkSource.hasActiveTickets();
        if (hasActiveTickets) {
            this.resetEmptyTime();
        }
        if (runsNormally) {
            ++this.emptyTime;
        }
        if (this.emptyTime < 300) {
            profilerFiller.push("entities");
            if (this.dragonFight != null && runsNormally) {
                profilerFiller.push("dragonFight");
                this.dragonFight.tick();
                profilerFiller.pop();
            }
            ActivationRange.activateEntities(this);
            this.entityTickList.forEach(entity -> {
                if (!entity.isRemoved() && !tickRateManager.isEntityFrozen((net.minecraft.world.entity.Entity)entity)) {
                    profilerFiller.push("checkDespawn");
                    entity.checkDespawn();
                    profilerFiller.pop();
                    net.minecraft.world.entity.Entity vehicle = entity.getVehicle();
                    if (vehicle != null) {
                        if (!vehicle.isRemoved() && vehicle.hasPassenger((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.stopRiding();
                    }
                    profilerFiller.push("tick");
                    this.guardEntityTick(this::tickNonPassenger, entity);
                    profilerFiller.pop();
                }
            });
            profilerFiller.popPush("blockEntities");
            this.tickBlockEntities();
            profilerFiller.pop();
        }
        profilerFiller.push("entityManagement");
        profilerFiller.pop();
        profilerFiller.push("debugSynchronizers");
        if (this.debugSynchronizers.hasAnySubscriberFor(DebugSubscriptions.NEIGHBOR_UPDATES)) {
            this.neighborUpdater.setDebugListener(blockPos -> this.debugSynchronizers.broadcastEventToTracking((BlockPos)blockPos, DebugSubscriptions.NEIGHBOR_UPDATES, blockPos));
        } else {
            this.neighborUpdater.setDebugListener(null);
        }
        this.debugSynchronizers.tick(this.server.debugSubscribers());
        profilerFiller.pop();
    }

    @Override
    public boolean shouldTickBlocksAt(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void tickTime() {
        if (this.tickTime) {
            long l = this.levelData.getGameTime() + 1L;
            this.serverLevelData.setGameTime(l);
            Profiler.get().push("scheduledFunctions");
            this.serverLevelData.getScheduledEvents().tick(this.server, l);
            Profiler.get().pop();
            if (this.serverLevelData.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                int incrementTicks;
                int n = incrementTicks = this.isBrightOutside() ? this.purpurConfig.daytimeTicks : this.purpurConfig.nighttimeTicks;
                if (incrementTicks != 12000) {
                    this.preciseTime += 12000.0 / (double)incrementTicks;
                    this.setDayTime(this.preciseTime);
                } else {
                    this.setDayTime(this.levelData.getDayTime() + 1L);
                }
            }
        }
    }

    public void setDayTime(long time) {
        this.serverLevelData.setDayTime(time);
        this.preciseTime = time;
        this.forceTime = false;
    }

    public void setDayTime(double i) {
        this.serverLevelData.setDayTime((long)i);
        this.forceTime = true;
    }

    public boolean isForceTime() {
        return this.forceTime;
    }

    public void tickCustomSpawners(boolean spawnEnemies) {
        for (CustomSpawner customSpawner : this.customSpawners) {
            customSpawner.tick(this, spawnEnemies);
        }
    }

    private void wakeUpAllPlayers() {
        this.sleepStatus.removeAllSleepers();
        this.players.stream().filter(LivingEntity::isSleeping).collect(Collectors.toList()).forEach(player -> player.stopSleepInBed(false, false));
    }

    private void optimiseRandomTick(LevelChunk chunk, int tickSpeed) {
        LevelChunkSection[] sections = chunk.getSections();
        int minSection = WorldUtil.getMinSection(this);
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkPos cpos = chunk.getPos();
        int offsetX = cpos.x << 4;
        int offsetZ = cpos.z << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            LevelChunkSection section = sections[sectionIndex];
            PalettedContainer<BlockState> states = section.states;
            if (!section.isRandomlyTickingBlocks()) continue;
            ShortList tickList = section.moonrise$getTickingBlockList();
            for (int i = 0; i < tickSpeed; ++i) {
                FluidState fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.nextInt() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                BlockState state = states.get(location);
                BlockPos pos = new BlockPos(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.randomTick(this, pos, simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.getFluidState()).isRandomlyTicking()) continue;
                fluidState.randomTick(this, pos, simpleRandom);
            }
        }
    }

    public void tickChunk(LevelChunk chunk, int randomTickSpeed) {
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        ChunkPos pos = chunk.getPos();
        int minBlockX = pos.getMinBlockX();
        int minBlockZ = pos.getMinBlockZ();
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int i = 0; i < randomTickSpeed; ++i) {
                if (simpleRandom.nextInt(48) != 0) continue;
                this.tickPrecipitation(this.getBlockRandomPos(minBlockX, 0, minBlockZ, 15));
            }
        }
        profilerFiller.popPush("tickBlocks");
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        profilerFiller.pop();
    }

    public void tickThunder(LevelChunk chunk) {
        BlockPos blockPos;
        ChunkPos pos = chunk.getPos();
        boolean isRaining = this.isRaining();
        int minBlockX = pos.getMinBlockX();
        int minBlockZ = pos.getMinBlockZ();
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("thunder");
        if (!this.paperConfig().environment.disableThunder && isRaining && this.isThundering() && this.spigotConfig.thunderChance > 0 && this.random.nextInt(this.spigotConfig.thunderChance) == 0 && this.isRainingAt(blockPos = this.findLightningTargetAround(this.getBlockRandomPos(minBlockX, 0, minBlockZ, 15)))) {
            LightningBolt lightningBolt;
            boolean flag;
            DifficultyInstance currentDifficultyAt = this.getCurrentDifficultyAt(blockPos);
            boolean bl = flag = this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)currentDifficultyAt.getEffectiveDifficulty() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.getBlockState(blockPos.below()).is(BlockTags.LIGHTNING_RODS);
            if (flag) {
                AbstractHorse skeletonHorse;
                if (this.purpurConfig.zombieHorseSpawnChance > 0.0 && this.random.nextDouble() <= this.purpurConfig.zombieHorseSpawnChance) {
                    skeletonHorse = EntityType.ZOMBIE_HORSE.create(this, EntitySpawnReason.EVENT);
                } else {
                    skeletonHorse = EntityType.SKELETON_HORSE.create(this, EntitySpawnReason.EVENT);
                    if (skeletonHorse != null) {
                        ((SkeletonHorse)skeletonHorse).setTrap(true);
                    }
                }
                if (skeletonHorse != null) {
                    skeletonHorse.setAge(0);
                    skeletonHorse.setPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                    this.addFreshEntity(skeletonHorse, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                }
            }
            if ((lightningBolt = EntityType.LIGHTNING_BOLT.create(this, EntitySpawnReason.EVENT)) != null) {
                lightningBolt.snapTo(Vec3.atBottomCenterOf(blockPos));
                lightningBolt.setVisualOnly(flag);
                this.strikeLightning(lightningBolt, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        profilerFiller.pop();
    }

    @VisibleForTesting
    public void tickPrecipitation(BlockPos pos) {
        BlockPos heightmapPos = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
        BlockPos blockPos = heightmapPos.below();
        Biome biome = this.getBiome(heightmapPos).value();
        if (biome.shouldFreeze(this, blockPos)) {
            CraftEventFactory.handleBlockFormEvent(this, blockPos, Blocks.ICE.defaultBlockState(), 3, null);
        }
        if (this.isRaining()) {
            Biome.Precipitation precipitationAt;
            int _int = this.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
            if (_int > 0 && biome.shouldSnow(this, heightmapPos)) {
                BlockState blockState = this.getBlockState(heightmapPos);
                if (blockState.is(Blocks.SNOW)) {
                    int layersValue = blockState.getValue(SnowLayerBlock.LAYERS);
                    if (layersValue < Math.min(_int, 8)) {
                        boolean canSnow = true;
                        if (PurpurConfig.smoothSnowAccumulationStep > 0 && layersValue >= PurpurConfig.smoothSnowAccumulationStep) {
                            int layersValueMin = layersValue - PurpurConfig.smoothSnowAccumulationStep;
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                BlockPos blockPosNeighbor = heightmapPos.relative(direction);
                                BlockState blockStateNeighbor = this.getBlockState(blockPosNeighbor);
                                if (blockStateNeighbor.is(Blocks.SNOW)) {
                                    int layersValueNeighbor = blockStateNeighbor.getValue(SnowLayerBlock.LAYERS);
                                    if (layersValueNeighbor > layersValueMin) continue;
                                    canSnow = false;
                                    break;
                                }
                                if (Block.isFaceFull(blockStateNeighbor.getCollisionShape(this, blockPosNeighbor), direction.getOpposite())) continue;
                                canSnow = false;
                                break;
                            }
                        }
                        if (canSnow) {
                            BlockState blockState1 = (BlockState)blockState.setValue(SnowLayerBlock.LAYERS, layersValue + 1);
                            Block.pushEntitiesUp(blockState, blockState1, this, heightmapPos);
                            CraftEventFactory.handleBlockFormEvent(this, heightmapPos, blockState1, 3, null);
                        }
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent(this, heightmapPos, Blocks.SNOW.defaultBlockState(), 3, null);
                }
            }
            if ((precipitationAt = biome.getPrecipitationAt(blockPos, this.getSeaLevel())) != Biome.Precipitation.NONE) {
                BlockState blockState2 = this.getBlockState(blockPos);
                blockState2.getBlock().handlePrecipitation(blockState2, this, blockPos, precipitationAt);
            }
        }
    }

    public Optional<BlockPos> findLightningRod(BlockPos pos) {
        Optional<BlockPos> optional = this.getPoiManager().findClosest(poiType -> poiType.is(PoiTypes.LIGHTNING_ROD), pos1 -> pos1.getY() == this.getHeight(Heightmap.Types.WORLD_SURFACE, pos1.getX(), pos1.getZ()) - 1, pos, PurpurConfig.lightningRodRange, PoiManager.Occupancy.ANY);
        return optional.map(pos1 -> pos1.above(1));
    }

    protected BlockPos findLightningTargetAround(BlockPos pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPos findLightningTargetAround(BlockPos pos, boolean returnNullWhenNoTarget) {
        BlockPos heightmapPos = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
        Optional<BlockPos> optional = this.findLightningRod(heightmapPos);
        if (optional.isPresent()) {
            return optional.get();
        }
        AABB aabb = AABB.encapsulatingFullBlocks(heightmapPos, heightmapPos.atY(this.getMaxY() + 1)).inflate(3.0);
        List<LivingEntity> entitiesOfClass = this.getEntitiesOfClass(LivingEntity.class, aabb, entity -> entity != null && entity.isAlive() && this.canSeeSky(entity.blockPosition()) && !entity.isSpectator());
        if (!entitiesOfClass.isEmpty()) {
            return entitiesOfClass.get(this.random.nextInt(entitiesOfClass.size())).blockPosition();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (heightmapPos.getY() == this.getMinY() - 1) {
            heightmapPos = heightmapPos.above(2);
        }
        return heightmapPos;
    }

    public boolean isHandlingTick() {
        return this.handlingTick;
    }

    public boolean canSleepThroughNights() {
        return this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE) <= 100;
    }

    private void announceSleepStatus() {
        if (this.canSleepThroughNights() && (!this.getServer().isSingleplayer() || this.getServer().isPublished())) {
            Component component;
            int _int = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
            if (this.sleepStatus.areEnoughSleeping(_int)) {
                if (PurpurConfig.sleepSkippingNight.isBlank()) {
                    return;
                }
                component = !PurpurConfig.sleepSkippingNight.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.sleepSkippingNight)) : Component.translatable("sleep.skipping_night");
            } else {
                if (PurpurConfig.sleepingPlayersPercent.isBlank()) {
                    return;
                }
                component = !PurpurConfig.sleepingPlayersPercent.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize(PurpurConfig.sleepingPlayersPercent, new TagResolver[]{Placeholder.parsed((String)"count", (String)Integer.toString(this.sleepStatus.amountSleeping())), Placeholder.parsed((String)"total", (String)Integer.toString(this.sleepStatus.sleepersNeeded(_int)))})) : Component.translatable("sleep.players_sleeping", this.sleepStatus.amountSleeping(), this.sleepStatus.sleepersNeeded(_int));
            }
            for (ServerPlayer serverPlayer : this.players) {
                serverPlayer.displayClientMessage(component, true);
            }
        }
    }

    public void updateSleepingPlayerList() {
        if (!this.players.isEmpty() && this.sleepStatus.update(this.players)) {
            this.announceSleepStatus();
        }
    }

    @Override
    public ServerScoreboard getScoreboard() {
        return this.server.getScoreboard();
    }

    public ServerWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    private void advanceWeatherCycle() {
        boolean isRaining = this.isRaining();
        if (this.dimensionType().hasSkyLight()) {
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                int clearWeatherTime = this.serverLevelData.getClearWeatherTime();
                int thunderTime = this.serverLevelData.getThunderTime();
                int rainTime = this.serverLevelData.getRainTime();
                boolean isThundering = this.levelData.isThundering();
                boolean isRaining1 = this.levelData.isRaining();
                if (clearWeatherTime > 0) {
                    --clearWeatherTime;
                    thunderTime = isThundering ? 0 : 1;
                    rainTime = isRaining1 ? 0 : 1;
                    isThundering = false;
                    isRaining1 = false;
                } else {
                    if (thunderTime > 0) {
                        if (--thunderTime == 0) {
                            isThundering = !isThundering;
                        }
                    } else {
                        thunderTime = isThundering ? THUNDER_DURATION.sample(this.random) : THUNDER_DELAY.sample(this.random);
                    }
                    if (rainTime > 0) {
                        if (--rainTime == 0) {
                            isRaining1 = !isRaining1;
                        }
                    } else {
                        rainTime = isRaining1 ? RAIN_DURATION.sample(this.random) : RAIN_DELAY.sample(this.random);
                    }
                }
                this.serverLevelData.setThunderTime(thunderTime);
                this.serverLevelData.setRainTime(rainTime);
                this.serverLevelData.setClearWeatherTime(clearWeatherTime);
                this.serverLevelData.setThundering(isThundering, ThunderChangeEvent.Cause.NATURAL);
                this.serverLevelData.setRaining(isRaining1, WeatherChangeEvent.Cause.NATURAL);
            }
            this.oThunderLevel = this.thunderLevel;
            this.thunderLevel = this.levelData.isThundering() ? (this.thunderLevel += 0.01f) : (this.thunderLevel -= 0.01f);
            this.thunderLevel = Mth.clamp(this.thunderLevel, 0.0f, 1.0f);
            this.oRainLevel = this.rainLevel;
            this.rainLevel = this.levelData.isRaining() ? (this.rainLevel += 0.01f) : (this.rainLevel -= 0.01f);
            this.rainLevel = Mth.clamp(this.rainLevel, 0.0f, 1.0f);
        }
        for (ServerPlayer player : this.players) {
            if (player.level() != this) continue;
            player.tickWeather();
        }
        if (isRaining != this.isRaining()) {
            for (ServerPlayer player : this.players) {
                if (player.level() != this) continue;
                player.setPlayerWeather(!isRaining ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (ServerPlayer player : this.players) {
            if (player.level() != this) continue;
            player.updateWeather(this.oRainLevel, this.rainLevel, this.oThunderLevel, this.thunderLevel);
        }
    }

    @VisibleForTesting
    public void resetWeatherCycle() {
        if (this.purpurConfig.rainStopsAfterSleep) {
            this.serverLevelData.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        }
        if (!this.serverLevelData.isRaining()) {
            this.serverLevelData.setRainTime(0);
        }
        if (this.purpurConfig.thunderStopsAfterSleep) {
            this.serverLevelData.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        }
        if (!this.serverLevelData.isThundering()) {
            this.serverLevelData.setThunderTime(0);
        }
    }

    public void resetEmptyTime() {
        this.emptyTime = 0;
    }

    private void tickFluid(BlockPos pos, Fluid fluid) {
        BlockState blockState = this.getBlockState(pos);
        FluidState fluidState = blockState.getFluidState();
        if (fluidState.is(fluid)) {
            fluidState.tick(this, pos, blockState);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.server.moonrise$executeMidTickTasks();
        }
    }

    private void tickBlock(BlockPos pos, Block block) {
        BlockState blockState = this.getBlockState(pos);
        if (blockState.is(block)) {
            blockState.tick(this, pos, this.random);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.server.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickNonPassenger(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            entity.setOldPosAndRot();
            ProfilerFiller profilerFiller = Profiler.get();
            ++entity.tickCount;
            ++entity.totalEntityAge;
            profilerFiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString());
            profilerFiller.incrementCounter("tickNonPassenger");
            boolean isActive = ActivationRange.checkIfActive(entity);
            if (isActive) {
                entity.tick();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            profilerFiller.pop();
            for (net.minecraft.world.entity.Entity entity1 : entity.getPassengers()) {
                this.tickPassenger(entity, entity1, isActive);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void tickPassenger(net.minecraft.world.entity.Entity ridingEntity, net.minecraft.world.entity.Entity passengerEntity, boolean isActive) {
        if (passengerEntity.isRemoved() || passengerEntity.getVehicle() != ridingEntity) {
            passengerEntity.stopRiding();
        } else if (passengerEntity instanceof Player || this.entityTickList.contains(passengerEntity)) {
            passengerEntity.setOldPosAndRot();
            ++passengerEntity.tickCount;
            ++passengerEntity.totalEntityAge;
            ProfilerFiller profilerFiller = Profiler.get();
            profilerFiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(passengerEntity.getType()).toString());
            profilerFiller.incrementCounter("tickPassenger");
            if (isActive) {
                passengerEntity.rideTick();
                passengerEntity.postTick();
            } else {
                passengerEntity.setDeltaMovement(Vec3.ZERO);
                passengerEntity.inactiveTick();
                ridingEntity.positionRider(passengerEntity);
            }
            profilerFiller.pop();
            for (net.minecraft.world.entity.Entity entity : passengerEntity.getPassengers()) {
                this.tickPassenger(passengerEntity, entity, isActive);
            }
        }
    }

    public void updateNeighboursOnBlockSet(BlockPos pos, BlockState state) {
        boolean flag;
        BlockState blockState = this.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean bl = flag = !state.is(block);
        if (flag) {
            state.affectNeighborsAfterRemoval(this, pos, false);
        }
        this.updateNeighborsAt(pos, blockState.getBlock());
        if (blockState.hasAnalogOutputSignal()) {
            this.updateNeighbourForOutputSignal(pos, block);
        }
    }

    @Override
    public boolean mayInteract(net.minecraft.world.entity.Entity entity, BlockPos pos) {
        Player player;
        return !(entity instanceof Player && (this.server.isUnderSpawnProtection(this, pos, player = (Player)entity) || !this.getWorldBorder().isWithinBounds(pos)));
    }

    public void saveIncrementally(boolean doFull) {
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.saveLevelData(false);
        }
        if (doFull) {
            this.serverLevelData.setCustomBossEvents(this.server.getCustomBossEvents().save(this.registryAccess()));
            this.levelStorageAccess.saveDataTag(this.server.registryAccess(), this.serverLevelData, this.server.getPlayerList().getSingleplayerData());
        }
    }

    public void save(@Nullable ProgressListener progress, boolean flush, boolean skipSave) {
        this.save(progress, flush, skipSave, false);
    }

    public void save(@Nullable ProgressListener progress, boolean flush, boolean skipSave, boolean close) {
        ServerChunkCache chunkSource = this.getChunkSource();
        if (!skipSave) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progress != null) {
                progress.progressStartNoAbort(Component.translatable("menu.savingLevel"));
            }
            this.saveLevelData(flush);
            if (progress != null) {
                progress.progressStage(Component.translatable("menu.savingChunks"));
            }
            if (!close) {
                chunkSource.save(flush);
            }
        }
        if (close) {
            try {
                chunkSource.close(!skipSave);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        ServerLevel serverLevel1 = this;
        this.serverLevelData.setCustomBossEvents(this.server.getCustomBossEvents().save(this.registryAccess()));
        this.levelStorageAccess.saveDataTag(this.server.registryAccess(), this.serverLevelData, this.server.getPlayerList().getSingleplayerData());
    }

    private void saveLevelData(boolean join) {
        if (this.dragonFight != null) {
            this.serverLevelData.setEndDragonFightData(this.dragonFight.saveData());
        }
        DimensionDataStorage dataStorage = this.getChunkSource().getDataStorage();
        if (join) {
            dataStorage.saveAndJoin();
        } else {
            dataStorage.scheduleSave();
        }
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(typeTest, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output) {
        this.getEntities(typeTest, predicate, output, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output, int maxResults) {
        this.getEntities().get(typeTest, entity -> {
            if (predicate.test(entity)) {
                output.add((Object)entity);
                if (output.size() >= maxResults) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
    }

    public List<? extends EnderDragon> getDragons() {
        return this.getEntities(EntityType.ENDER_DRAGON, LivingEntity::isAlive);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> predicate) {
        return this.getPlayers(predicate, Integer.MAX_VALUE);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> predicate, int maxResults) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayer serverPlayer : this.players) {
            if (!predicate.test(serverPlayer)) continue;
            list.add(serverPlayer);
            if (list.size() < maxResults) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public ServerPlayer getRandomPlayer() {
        List<ServerPlayer> players = this.getPlayers(LivingEntity::isAlive);
        return players.isEmpty() ? null : players.get(this.random.nextInt(players.size()));
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.addPlayer(serverPlayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void addNewPlayer(ServerPlayer player) {
        this.addPlayer(player);
    }

    public void addRespawnedPlayer(ServerPlayer player) {
        this.addPlayer(player);
    }

    private void addPlayer(ServerPlayer player) {
        net.minecraft.world.entity.Entity entity = this.getEntity(player.getUUID());
        if (entity != null) {
            LOGGER.warn("Force-added player with duplicate UUID {}", (Object)player.getUUID());
            entity.unRide();
            this.removePlayerImmediately((ServerPlayer)entity, Entity.RemovalReason.DISCARDED);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason spawnReason) {
        ItemEntity itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.LOGGER.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.isRemoved()) {
            return false;
        }
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).getItem().isEmpty()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof ItemEntity) {
            this.captureDrops.add((ItemEntity)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.getSelfAndPassengers().map(net.minecraft.world.entity.Entity::getUUID).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void unload(LevelChunk chunk) {
        for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
            if (!(blockEntity instanceof Container)) continue;
            for (HumanEntity human : Lists.newArrayList(((Container)((Object)blockEntity)).getViewers())) {
                ((CraftHumanEntity)human).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.clearAllBlockEntities();
        chunk.unregisterTickContainerFromLevel(this);
        this.debugSynchronizers.dropChunk(chunk.getPos());
    }

    public void removePlayerImmediately(ServerPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.addFreshEntity(entitylightning);
    }

    @Override
    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress) {
        Player breakerPlayer = null;
        net.minecraft.world.entity.Entity entity = this.getEntity(breakerId);
        if (entity instanceof Player) {
            breakerPlayer = (Player)entity;
        }
        if (entity != null) {
            float progressFloat = (float)Mth.clamp(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        for (ServerPlayer serverPlayer : this.server.getPlayerList().getPlayers()) {
            if (serverPlayer == null || serverPlayer.level() != this || serverPlayer.getId() == breakerId) continue;
            double d = (double)pos.getX() - serverPlayer.getX();
            double d1 = (double)pos.getY() - serverPlayer.getY();
            double d2 = (double)pos.getZ() - serverPlayer.getZ();
            if (breakerPlayer != null && !serverPlayer.getBukkitEntity().canSee(breakerPlayer.getBukkitEntity()) || !(d * d + d1 * d1 + d2 * d2 < 1024.0)) continue;
            serverPlayer.connection.send(new ClientboundBlockDestructionPacket(breakerId, pos, progress));
        }
    }

    @Override
    public void playSeededSound(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
        Player player;
        this.server.getPlayerList().broadcast(entity instanceof Player ? (player = (Player)entity) : null, x, y, z, sound.value().getRange(volume), this.dimension(), new ClientboundSoundPacket(sound, source, x, y, z, volume, pitch, seed));
    }

    @Override
    public void playSeededSound(@Nullable net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity sourceEntity, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
        Player player;
        this.server.getPlayerList().broadcast(entity instanceof Player ? (player = (Player)entity) : null, sourceEntity.getX(), sourceEntity.getY(), sourceEntity.getZ(), sound.value().getRange(volume), this.dimension(), new ClientboundSoundEntityPacket(sound, source, sourceEntity, volume, pitch, seed));
    }

    @Override
    public void globalLevelEvent(int id, BlockPos pos, int data) {
        if (this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS)) {
            this.server.getPlayerList().getPlayers().forEach(player -> {
                Vec3 vec31;
                if (player.level() == this) {
                    Vec3 vec3 = Vec3.atCenterOf(pos);
                    if (player.distanceToSqr(vec3) < (double)Mth.square(32)) {
                        vec31 = vec3;
                    } else {
                        Vec3 vec32 = vec3.subtract(player.position()).normalize();
                        vec31 = player.position().add(vec32.scale(32.0));
                    }
                } else {
                    vec31 = player.position();
                }
                player.connection.send(new ClientboundLevelEventPacket(id, BlockPos.containing(vec31), data, true));
            });
        } else {
            this.levelEvent(null, id, pos, data);
        }
    }

    @Override
    public void levelEvent(@Nullable net.minecraft.world.entity.Entity entity, int type, BlockPos pos, int data) {
        Player player;
        this.server.getPlayerList().broadcast(entity instanceof Player ? (player = (Player)entity) : null, pos.getX(), pos.getY(), pos.getZ(), 64.0, this.dimension(), new ClientboundLevelEventPacket(type, pos, data, false));
    }

    public int getLogicalHeight() {
        return this.dimensionType().logicalHeight();
    }

    @Override
    public void gameEvent(Holder<GameEvent> gameEvent, Vec3 pos, GameEvent.Context context) {
        if (this.getChunkIfLoadedImmediately(Mth.floor(pos.x) >> 4, Mth.floor(pos.z) >> 4) == null) {
            return;
        }
        this.gameEventDispatcher.post(gameEvent, pos, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlockUpdated(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        VoxelShape collisionShape1;
        VoxelShape collisionShape;
        if (this.isUpdatingNavigations) {
            String string = "recursive call to sendBlockUpdated";
            Util.logAndPauseIfInIde("recursive call to sendBlockUpdated", new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.getChunkSource().blockChanged(pos);
        this.pathTypesByPosCache.invalidate(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && Shapes.joinIsNotEmpty(collisionShape = oldState.getCollisionShape(this, pos), collisionShape1 = newState.getCollisionShape(this, pos), BooleanOp.NOT_SAME)) {
            ObjectArrayList list = new ObjectArrayList();
            try {
                for (Mob mob : this.navigatingMobs) {
                    PathNavigation navigation = mob.getNavigation();
                    if (!navigation.shouldRecomputePath(pos)) continue;
                    list.add(navigation);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.sendBlockUpdated(pos, oldState, newState, flags);
                return;
            }
            try {
                this.isUpdatingNavigations = true;
                for (PathNavigation pathNavigation : list) {
                    pathNavigation.recomputePath();
                }
            }
            finally {
                this.isUpdatingNavigations = false;
            }
        }
    }

    @Override
    public void updateNeighborsAt(BlockPos pos, Block block) {
        if (this.populating) {
            return;
        }
        if (this.captureBlockStates) {
            return;
        }
        this.updateNeighborsAt(pos, block, ExperimentalRedstoneUtils.initialOrientation(this, null, null));
    }

    @Override
    public void updateNeighborsAt(BlockPos pos, Block block, @Nullable Orientation orientation) {
        if (this.captureBlockStates) {
            return;
        }
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(pos, block, null, orientation);
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block block, Direction facing, @Nullable Orientation orientation) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(pos, block, facing, orientation);
    }

    @Override
    public void neighborChanged(BlockPos pos, Block block, @Nullable Orientation orientation) {
        this.neighborUpdater.neighborChanged(pos, block, orientation);
    }

    @Override
    public void neighborChanged(BlockState state, BlockPos pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) {
        this.neighborUpdater.neighborChanged(state, pos, block, orientation, movedByPiston);
    }

    @Override
    public void broadcastEntityEvent(net.minecraft.world.entity.Entity entity, byte state) {
        this.getChunkSource().sendToTrackingPlayersAndSelf(entity, new ClientboundEntityEventPacket(entity, state));
    }

    @Override
    public void broadcastDamageEvent(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.getChunkSource().sendToTrackingPlayersAndSelf(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    @Override
    public ServerChunkCache getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public void explode(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEvent> explosionSound) {
        this.explode0(source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, blockParticles, explosionSound);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEvent> explosionSound) {
        return this.explode0(source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, blockParticles, explosionSound, null);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEvent> explosionSound, @Nullable Consumer<ServerExplosion> configurator) {
        Explosion.BlockInteraction blockInteraction = switch (explosionInteraction) {
            default -> throw new MatchException(null, null);
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> this.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.MOB -> {
                if (source instanceof LargeFireball && this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING, this.purpurConfig.fireballsMobGriefingOverride) || this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    yield this.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> this.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.TRIGGER -> Explosion.BlockInteraction.TRIGGER_BLOCK;
            case Level.ExplosionInteraction.STANDARD -> Explosion.BlockInteraction.DESTROY;
        };
        Vec3 vec3 = new Vec3(x, y, z);
        ServerExplosion serverExplosion = new ServerExplosion(this, source, damageSource, damageCalculator, vec3, radius, fire, blockInteraction);
        if (configurator != null) {
            configurator.accept(serverExplosion);
        }
        int i = serverExplosion.explode();
        if (serverExplosion.wasCanceled) {
            return serverExplosion;
        }
        ParticleOptions particleOptions = serverExplosion.isSmall() ? smallExplosionParticles : largeExplosionParticles;
        for (ServerPlayer serverPlayer : this.players) {
            if (!(serverPlayer.distanceToSqr(vec3) < 4096.0)) continue;
            Optional<Vec3> optional = Optional.ofNullable(serverExplosion.getHitPlayers().get(serverPlayer));
            serverPlayer.connection.send(new ClientboundExplodePacket(vec3, radius, i, optional, particleOptions, explosionSound, blockParticles));
        }
        return serverExplosion;
    }

    private Explosion.BlockInteraction getDestroyType(GameRules.Key<GameRules.BooleanValue> decayGameRule) {
        return this.getGameRules().getBoolean(decayGameRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    @Override
    public void blockEvent(BlockPos pos, Block block, int eventId, int eventParam) {
        this.blockEvents.add((Object)new BlockEventData(pos, block, eventId, eventParam));
    }

    private void runBlockEvents() {
        this.blockEventsToReschedule.clear();
        while (!this.blockEvents.isEmpty()) {
            BlockEventData blockEventData = (BlockEventData)this.blockEvents.removeFirst();
            if (this.shouldTickBlocksAt(blockEventData.pos())) {
                if (!this.doBlockEvent(blockEventData)) continue;
                this.server.getPlayerList().broadcast(null, blockEventData.pos().getX(), blockEventData.pos().getY(), blockEventData.pos().getZ(), 64.0, this.dimension(), new ClientboundBlockEventPacket(blockEventData.pos(), blockEventData.block(), blockEventData.paramA(), blockEventData.paramB()));
                continue;
            }
            this.blockEventsToReschedule.add(blockEventData);
        }
        this.blockEvents.addAll(this.blockEventsToReschedule);
    }

    private boolean doBlockEvent(BlockEventData event) {
        BlockState blockState = this.getBlockState(event.pos());
        return blockState.is(event.block()) && blockState.triggerEvent(this, event.pos(), event.paramA(), event.paramB());
    }

    public LevelTicks<Block> getBlockTicks() {
        return this.blockTicks;
    }

    public LevelTicks<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    @Nonnull
    public MinecraftServer getServer() {
        return this.server;
    }

    public PortalForcer getPortalForcer() {
        return this.portalForcer;
    }

    public StructureTemplateManager getStructureManager() {
        return this.server.getStructureManager();
    }

    public <T extends ParticleOptions> int sendParticles(T options, double x, double y, double z, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(null, options, false, false, x, y, z, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleOptions> int sendParticles(T options, boolean overrideLimiter, boolean alwaysShow, double x, double y, double z, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(null, options, overrideLimiter, alwaysShow, x, y, z, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleOptions> int sendParticlesSource(@Nullable net.minecraft.world.entity.Entity sender, T options, boolean overrideLimiter, boolean alwaysShow, double x, double y, double z, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(this.players, sender, options, overrideLimiter, alwaysShow, x, y, z, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleOptions> int sendParticlesSource(List<ServerPlayer> receivers, @Nullable net.minecraft.world.entity.Entity sender, T options, boolean overrideLimiter, boolean alwaysShow, double x, double y, double z, int count, double xDist, double yDist, double zDist, double speed) {
        ClientboundLevelParticlesPacket clientboundLevelParticlesPacket = new ClientboundLevelParticlesPacket(options, overrideLimiter, alwaysShow, x, y, z, (float)xDist, (float)yDist, (float)zDist, (float)speed, count);
        int i = 0;
        for (int i1 = 0; i1 < receivers.size(); ++i1) {
            ServerPlayer serverPlayer = receivers.get(i1);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.sendParticles(serverPlayer, overrideLimiter, x, y, z, clientboundLevelParticlesPacket)) continue;
            ++i;
        }
        return i;
    }

    public <T extends ParticleOptions> boolean sendParticles(ServerPlayer player, T particle, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int count, double xDist, double yDist, double zDist, double maxSpeed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particle, overrideLimiter, alwaysShow, posX, posY, posZ, (float)xDist, (float)yDist, (float)zDist, (float)maxSpeed, count);
        return this.sendParticles(player, overrideLimiter, posX, posY, posZ, packet);
    }

    private boolean sendParticles(ServerPlayer player, boolean overrideLimiter, double x, double y, double z, Packet<?> packet) {
        if (player.level() != this) {
            return false;
        }
        BlockPos blockPos = player.blockPosition();
        if (blockPos.closerToCenterThan(new Vec3(x, y, z), overrideLimiter ? 512.0 : 32.0)) {
            player.connection.send(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity getEntity(int id) {
        return this.getEntities().get(id);
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity getEntityInAnyDimension(UUID id) {
        net.minecraft.world.entity.Entity entity = this.getEntity(id);
        if (entity != null) {
            return entity;
        }
        for (ServerLevel serverLevel : this.getServer().getAllLevels()) {
            net.minecraft.world.entity.Entity entity1;
            if (serverLevel == this || (entity1 = serverLevel.getEntity(id)) == null) continue;
            return entity1;
        }
        return null;
    }

    @Override
    @Nullable
    public Player getPlayerInAnyDimension(UUID id) {
        return this.getServer().getPlayerList().getPlayer(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity getEntityOrPart(int id) {
        net.minecraft.world.entity.Entity entity = this.getEntities().get(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.dragonParts.get(id);
    }

    @Override
    public Collection<EnderDragonPart> dragonParts() {
        return this.dragonParts.values();
    }

    @Nullable
    public BlockPos findNearestMapStructure(TagKey<Structure> structureTag, BlockPos pos, int radius, boolean skipKnownStructures) {
        if (!this.serverLevelData.worldGenOptions().generateStructures()) {
            return null;
        }
        Optional optional = this.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<Structure>> pair = this.getChunkSource().getGenerator().findNearestMapStructure(this, (HolderSet)optional.get(), pos, radius, skipKnownStructures);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(Predicate<Holder<Biome>> biomePredicate, BlockPos pos, int radius, int horizontalStep, int verticalStep) {
        return this.getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(pos, radius, horizontalStep, verticalStep, biomePredicate, this.getChunkSource().randomState().sampler(), this);
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.getDataStorage().computeIfAbsent(WorldBorder.TYPE);
    }

    @Override
    public RecipeManager recipeAccess() {
        return this.server.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.server.tickRateManager();
    }

    @Override
    public boolean noSave() {
        return this.noSave;
    }

    public DimensionDataStorage getDataStorage() {
        return this.getChunkSource().getDataStorage();
    }

    @Override
    @Nullable
    public MapItemSavedData getMapData(MapId mapId) {
        DimensionDataStorage storage = this.getServer().overworld().getDataStorage();
        Optional<SavedData> cacheEntry = storage.cache.get(MapItemSavedData.type(mapId));
        if (cacheEntry == null) {
            MapItemSavedData mapData = storage.get(MapItemSavedData.type(mapId));
            if (mapData != null) {
                mapData.id = mapId;
                new MapInitializeEvent((MapView)mapData.mapView).callEvent();
                return mapData;
            }
            return null;
        }
        Object var5_6 = cacheEntry.orElse(null);
        if (var5_6 instanceof MapItemSavedData) {
            MapItemSavedData mapItemSavedData = var5_6;
            mapItemSavedData.id = mapId;
            return mapItemSavedData;
        }
        return null;
    }

    public void setMapData(MapId mapId, MapItemSavedData data) {
        data.id = mapId;
        MapInitializeEvent event = new MapInitializeEvent((MapView)data.mapView);
        event.callEvent();
        this.getServer().overworld().getDataStorage().set(MapItemSavedData.type(mapId), data);
    }

    public MapId getFreeMapId() {
        return this.getServer().overworld().getDataStorage().computeIfAbsent(MapIndex.TYPE).getNextMapId();
    }

    @Override
    public void setRespawnData(LevelData.RespawnData respawnData) {
        if (!this.serverLevelData.getRespawnData().positionEquals(respawnData)) {
            Location previousLocation = this.getWorld().getSpawnLocation();
            this.serverLevelData.setSpawn(respawnData);
            this.server.getPlayerList().broadcastAll(new ClientboundSetDefaultSpawnPositionPacket(respawnData), this.dimension());
            this.server.updateEffectiveRespawnData();
            new SpawnChangeEvent((World)this.getWorld(), previousLocation).callEvent();
        }
        if (this.server.overworld().serverLevelData.respawnDimension != this.dimension()) {
            this.server.overworld().serverLevelData.respawnDimension = this.dimension();
            this.server.updateEffectiveRespawnData();
        }
    }

    @Override
    public LevelData.RespawnData getRespawnData() {
        return this.getServer().getRespawnData();
    }

    public LongSet getForceLoadedChunks() {
        return this.chunkSource.getForceLoadedChunks();
    }

    public boolean setChunkForced(int chunkX, int chunkZ, boolean add) {
        boolean flag = this.chunkSource.updateChunkForced(new ChunkPos(chunkX, chunkZ), add);
        if (add && flag) {
            this.getChunk(chunkX, chunkZ);
        }
        return flag;
    }

    public List<ServerPlayer> players() {
        return this.players;
    }

    @Override
    public void updatePOIOnBlockStateChange(BlockPos pos, BlockState oldState, BlockState newState) {
        Optional<Holder<PoiType>> optional1;
        Optional<Holder<PoiType>> optional = PoiTypes.forState(oldState);
        if (!Objects.equals(optional, optional1 = PoiTypes.forState(newState))) {
            BlockPos blockPos = pos.immutable();
            optional.ifPresent(holder -> this.getServer().execute(() -> {
                this.getPoiManager().remove(blockPos);
                this.debugSynchronizers.dropPoi(blockPos);
            }));
            optional1.ifPresent(holder -> this.getServer().execute(() -> {
                PoiRecord poiRecord;
                if (optional.isEmpty() && this.getPoiManager().exists(blockPos, ignored -> true)) {
                    this.getPoiManager().remove(blockPos);
                }
                if ((poiRecord = this.getPoiManager().add(blockPos, (Holder<PoiType>)holder)) != null) {
                    this.debugSynchronizers.registerPoi(poiRecord);
                }
            }));
        }
    }

    public PoiManager getPoiManager() {
        return this.getChunkSource().getPoiManager();
    }

    public boolean isVillage(BlockPos pos) {
        return this.isCloseToVillage(pos, 1);
    }

    public boolean isVillage(SectionPos pos) {
        return this.isVillage(pos.center());
    }

    public boolean isCloseToVillage(BlockPos pos, int sections) {
        return sections <= 6 && this.sectionsToVillage(SectionPos.of(pos)) <= sections;
    }

    public int sectionsToVillage(SectionPos pos) {
        return this.getPoiManager().sectionsToVillage(pos);
    }

    public Raids getRaids() {
        return this.raids;
    }

    @Nullable
    public Raid getRaidAt(BlockPos pos) {
        return this.raids.getNearbyRaid(pos, 9216);
    }

    public boolean isRaided(BlockPos pos) {
        return this.getRaidAt(pos) != null;
    }

    public void onReputationEvent(ReputationEventType type, net.minecraft.world.entity.Entity target, ReputationEventHandler host) {
        host.onReputationEventFrom(type, target);
    }

    public void saveDebugReport(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedWriter3;
        ChunkMap chunkMap = this.getChunkSource().chunkMap;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", chunkMap.getDistanceManager().getNaturalSpawnChunkCount()));
            NaturalSpawner.SpawnState lastSpawnState = this.getChunkSource().getLastSpawnState();
            if (lastSpawnState != null) {
                for (Object2IntMap.Entry entry : lastSpawnState.getMobCategoryCounts().object2IntEntrySet()) {
                    bufferedWriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((MobCategory)entry.getKey()).getName(), entry.getIntValue()));
                }
            }
            bufferedWriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.blockEntityTickers.size()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", ((LevelTicks)this.getBlockTicks()).count()));
            bufferedWriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", ((LevelTicks)this.getFluidTicks()).count()));
            bufferedWriter.write("distance_manager: " + chunkMap.getDistanceManager().getDebugStatus() + "\n");
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getChunkSource().getPendingTasksCount()));
        }
        CrashReport crashReport = new CrashReport("Level dump", new Exception("dummy"));
        this.fillReportDetails(crashReport);
        try (BufferedWriter bufferedWriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedWriter1.write(crashReport.getFriendlyReport(ReportType.TEST));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedWriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedWriter2 != null) {
            ((Writer)bufferedWriter2).close();
        }
        if ((bufferedWriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            ((Writer)bufferedWriter3).close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedWriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            ServerLevel.dumpEntities(bufferedWriter4, this.getEntities().getAll());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedWriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.dumpBlockEntityTickers(bufferedWriter5);
        }
    }

    private static void dumpEntities(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CsvOutput csvOutput = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("uuid").addColumn("type").addColumn("alive").addColumn("display_name").addColumn("custom_name").build(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            Component customName = entity.getCustomName();
            Component displayName = entity.getDisplayName();
            csvOutput.writeRow(entity.getX(), entity.getY(), entity.getZ(), entity.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()), entity.isAlive(), displayName.getString(), customName != null ? customName.getString() : null);
        }
    }

    private void dumpBlockEntityTickers(Writer output) throws IOException {
        CsvOutput csvOutput = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("type").build(output);
        for (TickingBlockEntity tickingBlockEntity : this.blockEntityTickers) {
            BlockPos pos = tickingBlockEntity.getPos();
            csvOutput.writeRow(pos.getX(), pos.getY(), pos.getZ(), tickingBlockEntity.getType());
        }
    }

    @VisibleForTesting
    public void clearBlockEvents(BoundingBox boundingBox) {
        this.blockEvents.removeIf(blockEventData -> boundingBox.isInside(blockEventData.pos()));
    }

    @Override
    public float getShade(Direction direction, boolean shade) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> getAllEntities() {
        return this.getEntities().getAll();
    }

    public String toString() {
        return "ServerLevel[" + this.serverLevelData.getLevelName() + "]";
    }

    public boolean isFlat() {
        return this.serverLevelData.isFlatWorld();
    }

    @Override
    public long getSeed() {
        return this.serverLevelData.worldGenOptions().seed();
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public ServerLevel getLevel() {
        return this;
    }

    @VisibleForTesting
    public String getWatchdogStats() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.players.size(), this.moonrise$getEntityLookup().getDebugInfo(), ServerLevel.getTypeCount(this.moonrise$getEntityLookup().getAll(), entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString()), this.blockEntityTickers.size(), ServerLevel.getTypeCount(this.blockEntityTickers, TickingBlockEntity::getType), ((LevelTicks)this.getBlockTicks()).count(), ((LevelTicks)this.getFluidTicks()).count(), this.gatherChunkSourceStats());
    }

    private static <T> String getTypeCount(Iterable<T> objects, Function<T, String> typeGetter) {
        try {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap();
            for (T object : objects) {
                String string = typeGetter.apply(object);
                map.addTo((Object)string, 1);
            }
            return map.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> (String)entry.getKey() + ":" + entry.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception var6) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> getEntities() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkPos chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkPos chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void startTickingChunk(LevelChunk chunk) {
        chunk.unpackTicks(this.getLevelData().getGameTime());
    }

    public void onStructureStartsAvailable(ChunkAccess chunk) {
        this.server.execute(() -> this.structureCheck.onStructureLoad(chunk.getPos(), chunk.getAllStarts()));
    }

    public PathTypeCache getPathTypeCache() {
        return this.pathTypesByPosCache;
    }

    public void waitForEntities(ChunkPos chunkPos, int radius) {
        List<ChunkPos> list = ChunkPos.rangeClosed(chunkPos, radius).toList();
        this.chunkSource.mainThreadProcessor.managedBlock(() -> {
            for (ChunkPos chunkPos1 : list) {
                if (this.areEntitiesLoaded(chunkPos1.toLong())) continue;
                return false;
            }
            return true;
        });
    }

    public boolean isSpawningMonsters() {
        return this.server.isSpawningMonsters();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String gatherChunkSourceStats() {
        return "Chunks[S] W: " + this.chunkSource.gatherStats() + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean areEntitiesLoaded(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    public boolean isPositionTickingWithEntitiesLoaded(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean isPositionEntityTicking(BlockPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean areEntitiesActuallyLoadedAndTicking(ChunkPos chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean anyPlayerCloseEnoughForSpawning(BlockPos pos) {
        return this.anyPlayerCloseEnoughForSpawning(new ChunkPos(pos));
    }

    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkPos) {
        return this.chunkSource.chunkMap.anyPlayerCloseEnoughForSpawning(chunkPos);
    }

    public boolean canSpawnEntitiesInChunk(ChunkPos chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady() && this.getWorldBorder().isWithinBounds(chunkPos);
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.server.getWorldData().enabledFeatures();
    }

    @Override
    public PotionBrewing potionBrewing() {
        return this.server.potionBrewing();
    }

    @Override
    public FuelValues fuelValues() {
        return this.server.fuelValues();
    }

    public RandomSource getRandomSequence(ResourceLocation location) {
        return this.randomSequences.get(location);
    }

    public RandomSequences getRandomSequences() {
        return this.randomSequences;
    }

    public GameRules getGameRules() {
        return this.serverLevelData.getGameRules();
    }

    public List<ServerPlayer> getPlayersForGlobalSoundGamerule() {
        return this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS) ? this.getServer().getPlayerList().players : this.players();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    @Deprecated
    public void checkCapturedTreeStateForObserverNotify(BlockPos pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().getY() == pos.getY() && this.getBlockState(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlags(), 512);
        }
    }

    @Override
    public CrashReportCategory fillReportDetails(CrashReport report) {
        CrashReportCategory crashReportCategory = super.fillReportDetails(report);
        crashReportCategory.setDetail("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashReportCategory;
    }

    @Override
    public int getSeaLevel() {
        return this.chunkSource.getGenerator().getSeaLevel();
    }

    @Override
    public void onBlockEntityAdded(BlockEntity entity) {
        super.onBlockEntityAdded(entity);
        this.debugSynchronizers.registerBlockEntity(entity);
    }

    public LevelDebugSynchronizers debugSynchronizers() {
        return this.debugSynchronizers;
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public Player getGlobalPlayerByUUID(UUID uuid) {
        return this.server.getPlayerList().getPlayer(uuid);
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    final class EntityCallbacks
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        EntityCallbacks() {
        }

        @Override
        public void onCreated(net.minecraft.world.entity.Entity entity) {
            WaypointTransmitter waypointTransmitter;
            if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).isTransmittingWaypoint()) {
                ServerLevel.this.getWaypointManager().trackWaypoint(waypointTransmitter);
            }
            entity.setOldPosAndRot();
        }

        @Override
        public void onDestroyed(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof WaypointTransmitter) {
                WaypointTransmitter waypointTransmitter = (WaypointTransmitter)((Object)entity);
                ServerLevel.this.getWaypointManager().untrackWaypoint(waypointTransmitter);
            }
            ServerLevel.this.getScoreboard().entityRemoved(entity);
        }

        @Override
        public void onTickingStart(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !ServerLevel.this.paperConfig().entities.markers.tick) {
                return;
            }
            ServerLevel.this.entityTickList.add(entity);
        }

        @Override
        public void onTickingEnd(net.minecraft.world.entity.Entity entity) {
            ServerLevel.this.entityTickList.remove(entity);
            if (ServerLevel.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && ServerLevel.this.paperConfig().misc.legacyEnderPearlBehavior && entity instanceof ThrownEnderpearl) {
                ThrownEnderpearl pearl = (ThrownEnderpearl)entity;
                pearl.setOwner((net.minecraft.world.entity.Entity)null);
            }
        }

        @Override
        public void onTrackingStart(net.minecraft.world.entity.Entity entity) {
            WaypointTransmitter waypointTransmitter;
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ServerLevel.this.players.add(serverPlayer);
                if (serverPlayer.isReceivingWaypoints()) {
                    ServerLevel.this.getWaypointManager().addPlayer(serverPlayer);
                }
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).isTransmittingWaypoint()) {
                ServerLevel.this.getWaypointManager().trackWaypoint(waypointTransmitter);
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                ServerLevel.this.navigatingMobs.add(mob);
            }
            if (entity instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)entity;
                for (EnderDragonPart enderDragonPart : enderDragon.getSubEntities()) {
                    ServerLevel.this.dragonParts.put(enderDragonPart.getId(), (Object)enderDragonPart);
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::add);
            entity.inWorld = true;
            entity.valid = true;
            ServerLevel.this.getChunkSource().addEntity(entity);
            if (entity.origin == null) {
                entity.origin = entity.position();
            }
            if (entity.originWorld == null) {
                entity.originWorld = ServerLevel.this.getWorld().getUID();
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)ServerLevel.this.getWorld()).callEvent();
        }

        @Override
        public void onTrackingEnd(net.minecraft.world.entity.Entity entity) {
            Object object;
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof Player) {
                Player player = (Player)entity;
                object = ServerLevel.this.getServer().getAllLevels().iterator();
                while (object.hasNext()) {
                    ServerLevel level = object.next();
                    for (Optional<SavedData> savedData : level.getDataStorage().cache.values()) {
                        SavedData savedData2;
                        if (savedData.isEmpty() || !((savedData2 = savedData.get()) instanceof MapItemSavedData)) continue;
                        MapItemSavedData map = (MapItemSavedData)savedData2;
                        map.carriedByPlayers.remove(player);
                        if (!map.carriedBy.removeIf(holdingPlayer -> holdingPlayer.player == player)) continue;
                        map.decorations.remove(player.getName().getString());
                    }
                }
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof ServerPlayer) || entity.getRemovalReason() != Entity.RemovalReason.KILLED)) {
                Merchant merchant;
                if (!entity.level().purpurConfig.playerVoidTrading && (object = entity.getBukkitEntity()) instanceof Merchant && (merchant = (Merchant)object).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            ServerLevel.this.getChunkSource().removeEntity(entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ServerLevel.this.players.remove(serverPlayer);
                ServerLevel.this.getWaypointManager().removePlayer(serverPlayer);
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                ServerLevel.this.navigatingMobs.remove(mob);
            }
            if (entity instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)entity;
                for (HumanEntity enderDragonPart : enderDragon.getSubEntities()) {
                    ServerLevel.this.dragonParts.remove(enderDragonPart.getId());
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::remove);
            ServerLevel.this.debugSynchronizers.dropEntity(entity);
            entity.valid = false;
            if (!(entity instanceof ServerPlayer)) {
                for (ServerPlayer player : ServerLevel.this.server.getPlayerList().players) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)ServerLevel.this.getWorld()).callEvent();
        }

        @Override
        public void onSectionChange(net.minecraft.world.entity.Entity entity) {
            entity.updateDynamicGameEventListener(DynamicGameEventListener::move);
        }
    }
}

