/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.connection.PaperPlayerGameConnection;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.connection.configuration.PlayerConnectionReconfigureEvent;
import io.papermc.paper.event.packet.ClientTickEndEvent;
import io.papermc.paper.event.packet.UncheckedSignChangeEvent;
import io.papermc.paper.event.player.CartographyItemEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickBlockEvent;
import io.papermc.paper.event.player.PlayerPickEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.translation.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetHeldSlotPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSubscriptionRequestPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.GameModeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.FutureChain;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.StringUtil;
import net.minecraft.util.TickThrottler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftInput;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.craftbukkit.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.player.PlayerBookTooLargeEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class ServerGamePacketListenerImpl
extends ServerCommonPacketListenerImpl
implements GameProtocols.Context,
ServerGamePacketListener,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final int MAXIMUM_FLYING_TICKS = 80;
    private static final net.minecraft.network.chat.Component CHAT_VALIDATION_FAILED = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final net.minecraft.network.chat.Component INVALID_COMMAND_SIGNATURE = net.minecraft.network.chat.Component.translatable("chat.disabled.invalid_command_signature").withStyle(ChatFormatting.RED);
    private static final int MAX_COMMAND_SUGGESTIONS = 1000;
    public ServerPlayer player;
    public final PlayerChunkSender chunkSender;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private final TickThrottler chatSpamThrottler = new TickThrottler(20, 200);
    private final TickThrottler tabSpamThrottler;
    private final TickThrottler dropSpamThrottler;
    private final TickThrottler recipeSpamPackets;
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private net.minecraft.world.entity.Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3 awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    private boolean receivedMovementThisTick;
    private int lastTick;
    private int allowedPlayerTicks;
    private int lastDropTick;
    private int lastBookTick;
    private int dropCount;
    private boolean hasMoved;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private float lastPitch;
    private float lastYaw;
    private boolean justTeleported;
    @Nullable
    private RemoteChatSession chatSession;
    private boolean hasLoggedExpiry;
    private SignedMessageChain.Decoder signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages;
    private int nextChatIndex;
    private final MessageSignatureCache messageSignatureCache;
    private final FutureChain chatMessageChain;
    private boolean waitingForSwitchToConfig;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private final ClientTickEndEvent tickEndEvent;
    public final PaperPlayerGameConnection playerGameConnection;
    private final LoadingCache<CraftPlayer, Boolean> kickPermissionCache;
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(MinecraftServer.LOGGER)).build());
    private int limitedPackets;
    private long lastLimitedPacket;

    public ServerGamePacketListenerImpl(MinecraftServer server, Connection connection, ServerPlayer player, CommonListenerCookie cookie) {
        super(server, connection, cookie);
        this.tabSpamThrottler = new TickThrottler(GlobalConfiguration.get().spamLimiter.tabSpamIncrement, GlobalConfiguration.get().spamLimiter.tabSpamLimit);
        this.dropSpamThrottler = new TickThrottler(20, 1480);
        this.recipeSpamPackets = new TickThrottler(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement, GlobalConfiguration.get().spamLimiter.recipeSpamLimit);
        this.lastTick = MinecraftServer.currentTick;
        this.allowedPlayerTicks = 1;
        this.lastDropTick = MinecraftServer.currentTick;
        this.lastBookTick = MinecraftServer.currentTick;
        this.dropCount = 0;
        this.hasMoved = false;
        this.lastPosX = Double.MAX_VALUE;
        this.lastPosY = Double.MAX_VALUE;
        this.lastPosZ = Double.MAX_VALUE;
        this.lastPitch = Float.MAX_VALUE;
        this.lastYaw = Float.MAX_VALUE;
        this.justTeleported = false;
        this.hasLoggedExpiry = false;
        this.lastSeenMessages = new LastSeenMessagesValidator(20);
        this.messageSignatureCache = MessageSignatureCache.createDefault();
        this.kickPermissionCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<CraftPlayer, Boolean>(this){

            public Boolean load(CraftPlayer player) {
                return player.hasPermission("purpur.bypassIdleKick");
            }
        });
        this.lastLimitedPacket = -1L;
        this.chunkSender = new PlayerChunkSender(connection.isMemoryConnection());
        this.player = player;
        player.connection = this;
        player.getTextFilter().join();
        this.signedMessageDecoder = SignedMessageChain.Decoder.unsigned(player.getUUID(), server::enforceSecureProfile);
        this.chatMessageChain = new FutureChain(server.chatExecutor);
        this.tickEndEvent = new ClientTickEndEvent((org.bukkit.entity.Player)player.getBukkitEntity());
        this.playerGameConnection = new PaperPlayerGameConnection(this);
    }

    @Override
    public PlayerCommonConnection getApiConnection() {
        return this.playerGameConnection;
    }

    @Override
    public Audience getAudience() {
        return this.getCraftPlayer();
    }

    @Override
    public void tick() {
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        if (this.server.isPaused() || !this.tickPlayer()) {
            this.keepConnectionAlive();
            this.chatSpamThrottler.tick();
            this.dropSpamThrottler.tick();
            this.tabSpamThrottler.tick();
            this.recipeSpamPackets.tick();
            if (this.player.getLastActionTime() > 0L && this.server.playerIdleTimeout() > 0 && Util.getMillis() - this.player.getLastActionTime() > TimeUnit.MINUTES.toMillis(this.server.playerIdleTimeout()) && !this.player.wonGame) {
                this.player.setAfk(true);
                if (!this.player.level().purpurConfig.idleTimeoutKick || !Boolean.parseBoolean(System.getenv("PURPUR_FORCE_IDLE_KICK")) && ((Boolean)this.kickPermissionCache.getUnchecked((Object)this.player.getBukkitEntity())).booleanValue()) {
                    return;
                }
                this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
            }
        }
    }

    private boolean tickPlayer() {
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absSnapTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > this.getMaximumFlyingTicks(this.player)) {
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return true;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle != this.player && this.lastVehicle.getControllingPassenger() == this.player) {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.lastVehicle.getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > this.getMaximumFlyingTicks(this.lastVehicle)) {
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return true;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        } else {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        }
        if (!this.hasLoggedExpiry && this.chatSession != null && this.chatSession.profilePublicKey().data().hasExpired()) {
            LOGGER.info("Player profile key for {} has expired!", (Object)this.player.getPlainTextName());
            this.hasLoggedExpiry = true;
        }
        return false;
    }

    private int getMaximumFlyingTicks(net.minecraft.world.entity.Entity entity) {
        double gravity = entity.getGravity();
        if (gravity < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d = 0.08 / gravity;
        return Mth.ceil(80.0 * Math.max(d, 1.0));
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.waitingForSwitchToConfig;
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> packet) {
        return super.shouldHandleMessage(packet) || this.waitingForSwitchToConfig && this.connection.isConnected() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile playerProfile() {
        return this.player.getGameProfile();
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T message, BiFunction<TextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(this.player.getTextFilter(), (TextFilter)message).thenApply(result -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return result;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String text) {
        return this.filterTextPacket(text, TextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> texts) {
        return this.filterTextPacket(texts, TextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(ServerboundPlayerInputPacket packet) {
        Input lastInput;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (!packet.input().equals(this.player.getLastClientInput())) {
            PlayerInputEvent event = new PlayerInputEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), (org.bukkit.Input)new CraftInput(packet.input()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if ((lastInput = this.player.getLastClientInput()).shift() != packet.input().shift()) {
            PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packet.input().shift());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled() && this.player.hasClientLoaded()) {
                this.player.setShiftKeyDown(packet.input().shift());
            }
        }
        this.player.setLastClientInput(packet.input());
        if (this.player.hasClientLoaded()) {
            this.player.resetLastActionTime();
        }
        if (packet.input().shift() && this.player.level().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.player.removeEntitiesOnShoulder();
        }
    }

    private static boolean containsInvalidValues(double x, double y, double z, float yRot, float xRot) {
        return Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || !Floats.isFinite((float)xRot) || !Floats.isFinite((float)yRot);
    }

    private static double clampHorizontal(double value) {
        return Mth.clamp(value, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double value) {
        return Mth.clamp(value, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(ServerboundMoveVehiclePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (ServerGamePacketListenerImpl.containsInvalidValues(packet.position().x(), packet.position().y(), packet.position().z(), packet.yRot(), packet.xRot())) {
            this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else if (!this.updateAwaitingTeleport() && this.player.hasClientLoaded()) {
            net.minecraft.world.entity.Entity rootVehicle = this.player.getRootVehicle();
            if (this.awaitingPositionFromClient != null || this.player.isImmobile() || rootVehicle.isRemoved()) {
                return;
            }
            if (rootVehicle != this.player && rootVehicle.getControllingPassenger() == this.player && rootVehicle == this.lastVehicle) {
                boolean teleportBack;
                LivingEntity livingEntity;
                double d2;
                double d1;
                double d;
                ServerLevel serverLevel = this.player.level();
                double prevX = this.player.getX();
                double prevY = this.player.getY();
                double prevZ = this.player.getZ();
                float prevYaw = this.player.getYRot();
                float prevPitch = this.player.getXRot();
                double x = rootVehicle.getX();
                double y = rootVehicle.getY();
                double z = rootVehicle.getZ();
                double toX = d = ServerGamePacketListenerImpl.clampHorizontal(packet.position().x());
                double toY = d1 = ServerGamePacketListenerImpl.clampVertical(packet.position().y());
                double toZ = d2 = ServerGamePacketListenerImpl.clampHorizontal(packet.position().z());
                float f = Mth.wrapDegrees(packet.yRot());
                float f1 = Mth.wrapDegrees(packet.xRot());
                double d3 = d - this.vehicleFirstGoodX;
                double d4 = d1 - this.vehicleFirstGoodY;
                double d5 = d2 - this.vehicleFirstGoodZ;
                double d6 = rootVehicle.getDeltaMovement().lengthSqr();
                double d7 = d3 * d3 + d4 * d4 + d5 * d5;
                double currDeltaX = toX - x;
                double currDeltaY = toY - y;
                double currDeltaZ = toZ - z;
                d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = toX - this.vehicleLastGoodX;
                double otherFieldY = toY - this.vehicleLastGoodY;
                double otherFieldZ = toZ - this.vehicleLastGoodZ;
                d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.receivedMovePacketCount;
                int i = this.receivedMovePacketCount - this.knownMovePacketCount;
                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                    LOGGER.debug(this.player.getScoreboardName() + " is sending move packets too frequently (" + i + " packets since last tick)");
                    i = 1;
                }
                this.allowedPlayerTicks = d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
                speed *= 2.0;
                if (!(!this.player.level().paperConfig().chunks.preventMovingIntoUnloadedChunks || serverLevel.areChunksLoadedForMove(this.player.getBoundingBox().expandTowards(new Vec3(toX, toY, toZ).subtract(this.player.position()))) && serverLevel.areChunksLoadedForMove(rootVehicle.getBoundingBox().expandTowards(new Vec3(toX, toY, toZ).subtract(rootVehicle.position()))))) {
                    this.connection.send(ClientboundMoveVehiclePacket.fromEntity(rootVehicle));
                    return;
                }
                if (d7 - d6 > Math.max(100.0, Mth.square(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed)) && !this.isSingleplayerOwner()) {
                    LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{rootVehicle.getPlainTextName(), this.player.getPlainTextName(), d3, d4, d5});
                    this.send(ClientboundMoveVehiclePacket.fromEntity(rootVehicle));
                    return;
                }
                AABB boundingBox = rootVehicle.getBoundingBox();
                d3 = d - this.vehicleLastGoodX;
                d4 = d1 - this.vehicleLastGoodY;
                d5 = d2 - this.vehicleLastGoodZ;
                boolean flag = rootVehicle.verticalCollisionBelow;
                if (rootVehicle instanceof LivingEntity && (livingEntity = (LivingEntity)rootVehicle).onClimbable()) {
                    livingEntity.resetFallDistance();
                }
                rootVehicle.move(MoverType.PLAYER, new Vec3(d3, d4, d5));
                boolean didCollide = toX != rootVehicle.getX() || toY != rootVehicle.getY() || toZ != rootVehicle.getZ();
                double verticalDelta = d4;
                d3 = d - rootVehicle.getX();
                d4 = d1 - rootVehicle.getY();
                if (d4 > -0.5 || d4 < 0.5) {
                    d4 = 0.0;
                }
                d5 = d2 - rootVehicle.getZ();
                d7 = d3 * d3 + d4 * d4 + d5 * d5;
                boolean flag1 = false;
                if (d7 > SpigotConfig.movedWronglyThreshold) {
                    flag1 = true;
                    LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{rootVehicle.getPlainTextName(), this.player.getPlainTextName(), Math.sqrt(d7)});
                }
                if (!(teleportBack = flag1)) {
                    AABB newBox = rootVehicle.getBoundingBox();
                    if (didCollide || !boundingBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(serverLevel, rootVehicle, boundingBox, newBox);
                    }
                }
                if (teleportBack) {
                    rootVehicle.absSnapTo(x, y, z, f, f1);
                    this.send(ClientboundMoveVehiclePacket.fromEntity(rootVehicle));
                    rootVehicle.removeLatestMovementRecording();
                    return;
                }
                rootVehicle.absSnapTo(d, d1, d2, f, f1);
                this.player.absSnapTo(d, d1, d2, this.player.getYRot(), this.player.getXRot());
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = prevX;
                    this.lastPosY = prevY;
                    this.lastPosZ = prevZ;
                    this.lastYaw = prevYaw;
                    this.lastPitch = prevPitch;
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = CraftLocation.toBukkit(packet.position(), player.getWorld(), packet.yRot(), packet.xRot());
                double delta = Mth.square(this.lastPosX - to.getX()) + Mth.square(this.lastPosY - to.getY()) + Mth.square(this.lastPosZ - to.getZ());
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    if (!to.getWorld().getUID().equals(from.getWorld().getUID()) || to.getBlockX() != from.getBlockX() || to.getBlockY() != from.getBlockY() || to.getBlockZ() != from.getBlockZ() || to.getYaw() != from.getYaw() || to.getPitch() != from.getPitch()) {
                        this.player.resetLastActionTime();
                    }
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.internalTeleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.player.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.player.level().getChunkSource().move(this.player);
                Vec3 vec3 = new Vec3(rootVehicle.getX() - x, rootVehicle.getY() - y, rootVehicle.getZ() - z);
                this.handlePlayerKnownMovement(vec3);
                rootVehicle.setOnGroundWithMovement(packet.onGround(), vec3);
                rootVehicle.doCheckFallDamage(vec3.x, vec3.y, vec3.z, packet.onGround());
                this.player.checkMovementStatistics(vec3.x, vec3.y, vec3.z);
                this.clientVehicleIsFloating = verticalDelta >= -0.03125 && !flag && !this.server.allowFlight() && !rootVehicle.isFlyingVehicle() && !rootVehicle.isNoGravity() && this.noBlocksAround(rootVehicle);
                this.vehicleLastGoodX = rootVehicle.getX();
                this.vehicleLastGoodY = rootVehicle.getY();
                this.vehicleLastGoodZ = rootVehicle.getZ();
            }
        }
    }

    private boolean noBlocksAround(net.minecraft.world.entity.Entity entity) {
        AABB box = entity.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0);
        int minX = Mth.floor(box.minX);
        int minY = Mth.floor(box.minY);
        int minZ = Mth.floor(box.minZ);
        int maxX = Mth.floor(box.maxX);
        int maxY = Mth.floor(box.maxY);
        int maxZ = Mth.floor(box.maxZ);
        Level level = entity.level();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    pos.set(x, y, z);
                    BlockState blockState = level.getBlockStateIfLoaded(pos);
                    if (blockState == null || blockState.isAir()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void handleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (packet.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                LOGGER.warn("Disconnected on accept teleport packet. Was not expecting position data from client at this time");
                this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.player.absSnapTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            this.player.hasChangedDimension();
            this.awaitingPositionFromClient = null;
            this.player.level().getChunkSource().move(this.player);
        }
    }

    @Override
    public void handleAcceptPlayerLoad(ServerboundPlayerLoadedPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.hasClientLoaded()) {
            return;
        }
        PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), false);
        event.callEvent();
        this.player.setClientLoaded(true);
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(ServerboundRecipeBookSeenRecipePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        RecipeManager.ServerDisplayInfo recipeFromDisplay = this.server.getRecipeManager().getRecipeFromDisplay(packet.recipe());
        if (recipeFromDisplay != null) {
            this.player.getRecipeBook().removeHighlight(recipeFromDisplay.parent().id());
        }
    }

    @Override
    public void handleBundleItemSelectedPacket(ServerboundSelectBundleItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        this.player.containerMenu.setSelectedBundleItemIndex(packet.slotId(), packet.selectedItemIndex());
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(ServerboundRecipeBookChangeSettingsPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        CraftEventFactory.callRecipeBookSettingsEvent(this.player, packet.getBookType(), packet.isOpen(), packet.isFiltering());
        this.player.getRecipeBook().setBookSetting(packet.getBookType(), packet.isOpen(), packet.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(ServerboundSeenAdvancementsPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (packet.getAction() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourceLocation = Objects.requireNonNull(packet.getTab());
            AdvancementHolder advancementHolder = this.server.getAdvancements().get(resourceLocation);
            if (advancementHolder != null) {
                this.player.getAdvancements().setSelectedTab(advancementHolder);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(ServerboundCommandSuggestionPacket packet) {
        int index;
        if (!(this.tabSpamThrottler.isIncrementAndUnderThreshold() || this.server.getPlayerList().isOp(this.player.nameAndId()) || this.server.isSingleplayerOwner(this.player.nameAndId()))) {
            this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        if (packet.getCommand().length() > 64 && ((index = packet.getCommand().indexOf(32)) == -1 || index >= 64)) {
            this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> this.handleCustomCommandSuggestions0(packet));
    }

    private void handleCustomCommandSuggestions0(ServerboundCommandSuggestionPacket packet) {
        Object completions;
        StringReader stringReader = new StringReader(packet.getCommand());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), packet.getCommand(), true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (event.isCancelled()) {
                return;
            }
            this.server.scheduleOnMain(() -> this.sendServerSuggestions(packet, stringReader));
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.getCommand(), stringReader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            Iterator iterator = completions.iterator();
            while (iterator.hasNext()) {
                AsyncTabCompleteEvent.Completion completion = (AsyncTabCompleteEvent.Completion)iterator.next();
                Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                if (intSuggestion != null) {
                    builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    continue;
                }
                builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
            }
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), suggestions, packet.getCommand());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.connection.send(new ClientboundCommandSuggestionsPacket(packet.getId(), ServerGamePacketListenerImpl.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        }
    }

    private static Suggestions limitTo(Suggestions suggestions, int size) {
        return suggestions.getList().size() <= size ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, size));
    }

    private void sendServerSuggestions(ServerboundCommandSuggestionPacket packet, StringReader stringReader) {
        ParseResults<CommandSourceStack> parseResults = this.server.getCommands().getDispatcher().parse(stringReader, this.player.createCommandSourceStack());
        if (!parseResults.getExceptions().isEmpty() && parseResults.getExceptions().values().stream().anyMatch(e -> e instanceof TagParseCommandSyntaxException)) {
            this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        this.server.getCommands().getDispatcher().getCompletionSuggestions(parseResults).thenAccept(suggestions -> {
            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
            }
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), suggestions, packet.getCommand());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.send(new ClientboundCommandSuggestionsPacket(packet.getId(), ServerGamePacketListenerImpl.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        });
    }

    @Override
    public void handleSetCommandBlock(ServerboundSetCommandBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notEnabled"));
        } else if (!(this.player.canUseGameMasterBlocks() || this.player.isCreative() && this.player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notAllowed"));
        } else {
            BaseCommandBlock baseCommandBlock = null;
            CommandBlockEntity commandBlockEntity = null;
            BlockPos pos = packet.getPos();
            BlockEntity blockEntity = this.player.level().getBlockEntity(pos);
            if (blockEntity instanceof CommandBlockEntity) {
                commandBlockEntity = (CommandBlockEntity)blockEntity;
                baseCommandBlock = commandBlockEntity.getCommandBlock();
            }
            String command = packet.getCommand();
            boolean isTrackOutput = packet.isTrackOutput();
            if (baseCommandBlock != null) {
                CommandBlockEntity.Mode mode = commandBlockEntity.getMode();
                BlockState blockState = this.player.level().getBlockState(pos);
                Direction direction = blockState.getValue(CommandBlock.FACING);
                BlockState blockState1 = switch (packet.getMode()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                    default -> Blocks.COMMAND_BLOCK.defaultBlockState();
                };
                BlockState blockState2 = (BlockState)((BlockState)blockState1.setValue(CommandBlock.FACING, direction)).setValue(CommandBlock.CONDITIONAL, packet.isConditional());
                if (blockState2 != blockState) {
                    this.player.level().setBlock(pos, blockState2, 2);
                    blockEntity.setBlockState(blockState2);
                    this.player.level().getChunkAt(pos).setBlockEntity(blockEntity);
                }
                baseCommandBlock.setCommand(command);
                baseCommandBlock.setTrackOutput(isTrackOutput);
                if (!isTrackOutput) {
                    baseCommandBlock.setLastOutput(null);
                }
                commandBlockEntity.setAutomatic(packet.isAutomatic());
                if (mode != packet.getMode()) {
                    commandBlockEntity.onModeSwitch();
                }
                baseCommandBlock.onUpdated();
                if (!StringUtil.isNullOrEmpty(command)) {
                    this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.setCommand.success", command));
                }
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(ServerboundSetCommandMinecartPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notEnabled"));
        } else if (!(this.player.canUseGameMasterBlocks() || this.player.isCreative() && this.player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notAllowed"));
        } else {
            BaseCommandBlock commandBlock = packet.getCommandBlock(this.player.level());
            if (commandBlock != null) {
                commandBlock.setCommand(packet.getCommand());
                commandBlock.setTrackOutput(packet.isTrackOutput());
                if (!packet.isTrackOutput()) {
                    commandBlock.setLastOutput(null);
                }
                commandBlock.onUpdated();
                this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.setCommand.success", packet.getCommand()));
            }
        }
    }

    @Override
    public void handlePickItemFromBlock(ServerboundPickItemFromBlockPacket packet) {
        boolean flag;
        BlockState blockState;
        net.minecraft.world.item.ItemStack cloneItemStack;
        ServerLevel serverLevel = this.player.level();
        PacketUtils.ensureRunningOnSameThread(packet, this, serverLevel);
        BlockPos blockPos = packet.pos();
        if (this.player.canInteractWithBlock(blockPos, 1.0) && serverLevel.isLoaded(blockPos) && !(cloneItemStack = (blockState = serverLevel.getBlockState(blockPos)).getCloneItemStack(serverLevel, blockPos, flag = this.player.hasInfiniteMaterials() && packet.includeData())).isEmpty()) {
            if (flag && this.player.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                ServerGamePacketListenerImpl.addBlockDataToItem(blockState, serverLevel, blockPos, cloneItemStack);
            }
            this.tryPickItem(cloneItemStack, blockPos, null, packet.includeData());
        }
    }

    private static void addBlockDataToItem(BlockState state, ServerLevel level, BlockPos pos, net.minecraft.world.item.ItemStack stack) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        if (blockEntity != null) {
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), LOGGER);){
                TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, level.registryAccess());
                blockEntity.saveCustomOnly(tagValueOutput);
                blockEntity.removeComponentsFromTag(tagValueOutput);
                BlockItem.setBlockEntityData(stack, blockEntity.getType(), tagValueOutput);
                stack.applyComponents(blockEntity.collectComponents());
            }
        }
    }

    @Override
    public void handlePickItemFromEntity(ServerboundPickItemFromEntityPacket packet) {
        net.minecraft.world.item.ItemStack pickResult;
        ServerLevel serverLevel = this.player.level();
        PacketUtils.ensureRunningOnSameThread(packet, this, serverLevel);
        net.minecraft.world.entity.Entity entityOrPart = serverLevel.getEntityOrPart(packet.id());
        if (entityOrPart != null && this.player.canInteractWithEntity(entityOrPart, 3.0) && (pickResult = entityOrPart.getPickResult()) != null && !pickResult.isEmpty()) {
            this.tryPickItem(pickResult, null, entityOrPart, packet.includeData());
        }
    }

    private void tryPickItem(net.minecraft.world.item.ItemStack stack, @Nullable BlockPos blockPos, @Nullable net.minecraft.world.entity.Entity entity, boolean includeData) {
        if (stack.isItemEnabled(this.player.level().enabledFeatures())) {
            PlayerPickEntityEvent event;
            net.minecraft.world.entity.player.Inventory inventory = this.player.getInventory();
            int i = inventory.findSlotMatchingItem(stack);
            int sourceSlot = i;
            int targetSlot = net.minecraft.world.entity.player.Inventory.isHotbarSlot(sourceSlot) ? sourceSlot : inventory.getSuitableHotbarSlot();
            CraftPlayer bukkitPlayer = this.player.getBukkitEntity();
            Object object = event = entity != null ? new PlayerPickEntityEvent((org.bukkit.entity.Player)bukkitPlayer, (Entity)entity.getBukkitEntity(), includeData, targetSlot, sourceSlot) : new PlayerPickBlockEvent((org.bukkit.entity.Player)bukkitPlayer, (Block)CraftBlock.at(this.player.level(), blockPos), includeData, targetSlot, sourceSlot);
            if (!event.callEvent()) {
                return;
            }
            i = event.getSourceSlot();
            if (i != -1) {
                if (net.minecraft.world.entity.player.Inventory.isHotbarSlot(i) && net.minecraft.world.entity.player.Inventory.isHotbarSlot(event.getTargetSlot())) {
                    inventory.setSelectedSlot(event.getTargetSlot());
                } else {
                    inventory.pickSlot(i, event.getTargetSlot());
                }
            } else if (this.player.hasInfiniteMaterials()) {
                inventory.addAndPickItem(stack, event.getTargetSlot());
            }
            this.send(new ClientboundSetHeldSlotPacket(inventory.getSelectedSlot()));
            this.player.inventoryMenu.broadcastChanges();
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.player.detectEquipmentUpdates();
            }
        }
    }

    @Override
    public void handleRenameItem(ServerboundRenameItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof AnvilMenu) {
            AnvilMenu anvilMenu = (AnvilMenu)abstractContainerMenu;
            if (!anvilMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)anvilMenu);
                return;
            }
            anvilMenu.setItemName(packet.getName());
        }
    }

    @Override
    public void handleSetBeaconPacket(ServerboundSetBeaconPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof BeaconMenu) {
            BeaconMenu beaconMenu = (BeaconMenu)abstractContainerMenu;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            beaconMenu.updateEffects(packet.primary(), packet.secondary());
        }
    }

    @Override
    public void handleSetStructureBlock(ServerboundSetStructureBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos pos = packet.getPos();
            BlockState blockState = this.player.level().getBlockState(pos);
            BlockEntity blockEntity = this.player.level().getBlockEntity(pos);
            if (blockEntity instanceof StructureBlockEntity) {
                StructureBlockEntity structureBlockEntity = (StructureBlockEntity)blockEntity;
                structureBlockEntity.setMode(packet.getMode());
                structureBlockEntity.setStructureName(packet.getName());
                structureBlockEntity.setStructurePos(packet.getOffset());
                structureBlockEntity.setStructureSize(packet.getSize());
                structureBlockEntity.setMirror(packet.getMirror());
                structureBlockEntity.setRotation(packet.getRotation());
                structureBlockEntity.setMetaData(packet.getData());
                structureBlockEntity.setIgnoreEntities(packet.isIgnoreEntities());
                structureBlockEntity.setStrict(packet.isStrict());
                structureBlockEntity.setShowAir(packet.isShowAir());
                structureBlockEntity.setShowBoundingBox(packet.isShowBoundingBox());
                structureBlockEntity.setIntegrity(packet.getIntegrity());
                structureBlockEntity.setSeed(packet.getSeed());
                if (structureBlockEntity.hasStructureName()) {
                    String structureName = structureBlockEntity.getStructureName();
                    if (packet.getUpdateType() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (structureBlockEntity.saveStructure()) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.save_success", structureName), false);
                        } else {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.save_failure", structureName), false);
                        }
                    } else if (packet.getUpdateType() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!structureBlockEntity.isStructureLoadable()) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.load_not_found", structureName), false);
                        } else if (structureBlockEntity.placeStructureIfSameSize(this.player.level())) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.load_success", structureName), false);
                        } else {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.load_prepare", structureName), false);
                        }
                    } else if (packet.getUpdateType() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (structureBlockEntity.detectSize()) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.size_success", structureName), false);
                        } else {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.invalid_structure_name", packet.getName()), false);
                }
                structureBlockEntity.setChanged();
                this.player.level().sendBlockUpdated(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void handleSetTestBlock(ServerboundSetTestBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockPos = packet.position();
            BlockState blockState = this.player.level().getBlockState(blockPos);
            BlockEntity blockEntity = this.player.level().getBlockEntity(blockPos);
            if (blockEntity instanceof TestBlockEntity) {
                TestBlockEntity testBlockEntity = (TestBlockEntity)blockEntity;
                testBlockEntity.setMode(packet.mode());
                testBlockEntity.setMessage(packet.message());
                testBlockEntity.setChanged();
                this.player.level().sendBlockUpdated(blockPos, blockState, testBlockEntity.getBlockState(), 3);
            }
        }
    }

    @Override
    public void handleTestInstanceBlockAction(ServerboundTestInstanceBlockActionPacket packet) {
        BlockEntity blockEntity;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        BlockPos blockPos = packet.pos();
        if (this.player.canUseGameMasterBlocks() && (blockEntity = this.player.level().getBlockEntity(blockPos)) instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testInstanceBlockEntity = (TestInstanceBlockEntity)blockEntity;
            if (packet.action() != ServerboundTestInstanceBlockActionPacket.Action.QUERY && packet.action() != ServerboundTestInstanceBlockActionPacket.Action.INIT) {
                testInstanceBlockEntity.set(packet.data());
                if (packet.action() == ServerboundTestInstanceBlockActionPacket.Action.RESET) {
                    testInstanceBlockEntity.resetTest(this.player::sendSystemMessage);
                } else if (packet.action() == ServerboundTestInstanceBlockActionPacket.Action.SAVE) {
                    testInstanceBlockEntity.saveTest(this.player::sendSystemMessage);
                } else if (packet.action() == ServerboundTestInstanceBlockActionPacket.Action.EXPORT) {
                    testInstanceBlockEntity.exportTest(this.player::sendSystemMessage);
                } else if (packet.action() == ServerboundTestInstanceBlockActionPacket.Action.RUN) {
                    testInstanceBlockEntity.runTest(this.player::sendSystemMessage);
                }
                BlockState blockState = this.player.level().getBlockState(blockPos);
                this.player.level().sendBlockUpdated(blockPos, Blocks.AIR.defaultBlockState(), blockState, 3);
            } else {
                HolderLookup.RegistryLookup registry = this.player.registryAccess().lookupOrThrow(Registries.TEST_INSTANCE);
                Optional optional = packet.data().test().flatMap(((Registry)registry)::get);
                net.minecraft.network.chat.Component component = optional.isPresent() ? ((GameTestInstance)((Holder.Reference)optional.get()).value()).describe() : net.minecraft.network.chat.Component.translatable("test_instance.description.no_test").withStyle(ChatFormatting.RED);
                Optional<Object> optional1 = packet.action() == ServerboundTestInstanceBlockActionPacket.Action.QUERY ? packet.data().test().flatMap(resourceKey -> TestInstanceBlockEntity.getStructureSize(this.player.level(), resourceKey)) : Optional.empty();
                this.connection.send(new ClientboundTestInstanceBlockStatus(component, optional1));
            }
        }
    }

    @Override
    public void handleSetJigsawBlock(ServerboundSetJigsawBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos pos = packet.getPos();
            BlockState blockState = this.player.level().getBlockState(pos);
            BlockEntity blockEntity = this.player.level().getBlockEntity(pos);
            if (blockEntity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)blockEntity;
                jigsawBlockEntity.setName(packet.getName());
                jigsawBlockEntity.setTarget(packet.getTarget());
                jigsawBlockEntity.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, packet.getPool()));
                jigsawBlockEntity.setFinalState(packet.getFinalState());
                jigsawBlockEntity.setJoint(packet.getJoint());
                jigsawBlockEntity.setPlacementPriority(packet.getPlacementPriority());
                jigsawBlockEntity.setSelectionPriority(packet.getSelectionPriority());
                jigsawBlockEntity.setChanged();
                this.player.level().sendBlockUpdated(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void handleJigsawGenerate(ServerboundJigsawGeneratePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos pos = packet.getPos();
            BlockEntity blockEntity = this.player.level().getBlockEntity(pos);
            if (blockEntity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)blockEntity;
                jigsawBlockEntity.generate(this.player.level(), packet.levels(), packet.keepJigsaws());
            }
        }
    }

    @Override
    public void handleSelectTrade(ServerboundSelectTradePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        int item = packet.getItem();
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof MerchantMenu) {
            MerchantMenu merchantMenu = (MerchantMenu)abstractContainerMenu;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(item, merchantMenu);
            if (tradeSelectEvent.isCancelled()) {
                this.player.containerMenu.sendAllDataToRemote();
                return;
            }
            if (!merchantMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)merchantMenu);
                return;
            }
            merchantMenu.setSelectionHint(item);
            merchantMenu.tryMoveItems(item);
        }
    }

    @Override
    public void handleEditBook(ServerboundEditBookPacket packet) {
        IntOr.Disabled pageMax = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
        if (!this.cserver.isPrimaryThread() && pageMax.enabled()) {
            List<String> pageList = packet.pages();
            long byteTotal = 0L;
            int maxBookPageSize = pageMax.intValue();
            double multiplier = Math.clamp(GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier, 0.3, 1.0);
            long byteAllowed = maxBookPageSize;
            int slot = packet.slot();
            net.minecraft.world.item.ItemStack itemstack = net.minecraft.world.entity.player.Inventory.isHotbarSlot(slot) || slot == 40 ? this.player.getInventory().getItem(slot) : net.minecraft.world.item.ItemStack.EMPTY;
            for (String page : pageList) {
                int byteLength = page.getBytes(StandardCharsets.UTF_8).length;
                byteTotal += (long)byteLength;
                int length = page.length();
                int multiByteCharacters = 0;
                if (byteLength != length) {
                    for (char c : page.toCharArray()) {
                        if (c <= '\u007f') continue;
                        ++multiByteCharacters;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.clamp((double)length / 255.0, 0.1, 1.0) * multiplier);
                if (multiByteCharacters <= 1) continue;
                byteAllowed -= (long)multiByteCharacters;
            }
            if (byteTotal > byteAllowed) {
                LOGGER.warn("{} tried to send too large of a book. Book size: {} - Allowed: {} - Pages: {}", new Object[]{this.player.getScoreboardName(), byteTotal, byteAllowed, pageList.size()});
                PlayerBookTooLargeEvent event = new PlayerBookTooLargeEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), itemstack.asBukkitCopy());
                if (event.shouldKickPlayer()) {
                    this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("Book too large!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                }
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("Book edited too quickly!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int slot = packet.slot();
        if (net.minecraft.world.entity.player.Inventory.isHotbarSlot(slot) || slot == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.title();
            optional.ifPresent(list::add);
            list.addAll(packet.pages());
            boolean hasEditPerm = this.getCraftPlayer().hasPermission("purpur.book.color.edit");
            boolean hasSignPerm = hasEditPerm || this.getCraftPlayer().hasPermission("purpur.book.color.sign");
            Consumer<List> consumer = optional.isPresent() ? texts -> this.signBook((FilteredText)texts.get(0), texts.subList(1, texts.size()), slot, hasSignPerm) : list1 -> this.updateBookContents((List<FilteredText>)list1, slot, hasEditPerm);
            this.filterTextPacket(list).thenAcceptAsync(consumer, (Executor)this.server);
        }
    }

    private void updateBookContents(List<FilteredText> pages, int index) {
        this.updateBookContents(pages, index, false);
    }

    private void updateBookContents(List<FilteredText> pages, int index, boolean hasPerm) {
        net.minecraft.world.item.ItemStack handItem = this.player.getInventory().getItem(index);
        net.minecraft.world.item.ItemStack item = handItem.copy();
        if (item.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            List<Filterable<String>> list = pages.stream().map(filteredText -> this.filterableFromOutgoing((FilteredText)filteredText).map(s -> this.color((String)s, hasPerm))).toList();
            item.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(list));
            this.player.getInventory().setItem(index, CraftEventFactory.handleEditBookEvent(this.player, index, handItem, item));
        }
    }

    private void signBook(FilteredText title, List<FilteredText> pages, int index) {
        this.signBook(title, pages, index, false);
    }

    private void signBook(FilteredText title, List<FilteredText> pages, int index, boolean hasPerm) {
        net.minecraft.world.item.ItemStack item = this.player.getInventory().getItem(index);
        if (item.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            net.minecraft.world.item.ItemStack itemStack = item.transmuteCopy(Items.WRITTEN_BOOK);
            itemStack.remove(DataComponents.WRITABLE_BOOK_CONTENT);
            List<Filterable<net.minecraft.network.chat.Component>> list = pages.stream().map(filteredText -> this.filterableFromOutgoing((FilteredText)filteredText).map(s -> this.hexColor((String)s, hasPerm))).toList();
            itemStack.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(this.filterableFromOutgoing(title), this.player.getPlainTextName(), 0, list, true));
            CraftEventFactory.handleEditBookEvent(this.player, index, item, itemStack);
            this.player.getInventory().setItem(index, item);
        }
    }

    private Filterable<String> filterableFromOutgoing(FilteredText filteredText) {
        return this.player.isTextFilteringEnabled() ? Filterable.passThrough(filteredText.filteredOrEmpty()) : Filterable.from(filteredText);
    }

    private net.minecraft.network.chat.Component hexColor(String str, boolean hasPerm) {
        return hasPerm ? PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(str)) : net.minecraft.network.chat.Component.literal(str);
    }

    private String color(String str, boolean hasPerm) {
        return hasPerm ? ChatColor.color((String)str, (boolean)false) : str;
    }

    @Override
    public void handleEntityTagQuery(ServerboundEntityTagQueryPacket packet) {
        net.minecraft.world.entity.Entity entity;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.hasPermissions(2) && (entity = this.player.level().getEntity(packet.getEntityId())) != null) {
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), LOGGER);){
                TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, entity.registryAccess());
                entity.saveWithoutId(tagValueOutput);
                CompoundTag compoundTag = tagValueOutput.buildResult();
                this.send(new ClientboundTagQueryPacket(packet.getTransactionId(), compoundTag));
            }
        }
    }

    @Override
    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket packet) {
        CrafterMenu crafterMenu;
        Object object;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (!this.player.isSpectator() && packet.containerId() == this.player.containerMenu.containerId && (object = this.player.containerMenu) instanceof CrafterMenu && (object = (crafterMenu = (CrafterMenu)object).getContainer()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)object;
            crafterBlockEntity.setSlotState(packet.slotId(), packet.newState());
        }
    }

    @Override
    public void handleBlockEntityTagQuery(ServerboundBlockEntityTagQueryPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.hasPermissions(2)) {
            BlockEntity blockEntity = this.player.level().getBlockEntity(packet.getPos());
            CompoundTag compoundTag = blockEntity != null ? blockEntity.saveWithoutMetadata(this.player.registryAccess()) : null;
            this.send(new ClientboundTagQueryPacket(packet.getTransactionId(), compoundTag));
        }
    }

    @Override
    public void handleMovePlayer(ServerboundMovePlayerPacket packet) {
        boolean invalidPitch;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        boolean invalidX = Double.isNaN(packet.getX(0.0));
        boolean invalidY = Double.isNaN(packet.getY(0.0));
        boolean invalidZ = Double.isNaN(packet.getZ(0.0));
        boolean invalidYaw = !Floats.isFinite((float)packet.getYRot(0.0f));
        boolean bl = invalidPitch = !Floats.isFinite((float)packet.getXRot(0.0f));
        if (invalidX || invalidY || invalidZ || invalidYaw || invalidPitch) {
            LOGGER.warn(String.format("Disconnected on move player packet. Invalid data: x=%b, y=%b, z=%b, yaw=%b, pitch=%b", invalidX, invalidY, invalidZ, invalidYaw, invalidPitch));
            this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            ServerLevel serverLevel = this.player.level();
            if (!this.player.wonGame && !this.player.isImmobile()) {
                if (this.tickCount == 0) {
                    this.resetPosition();
                }
                if (this.player.hasClientLoaded()) {
                    float f1;
                    float f;
                    float toYaw = f = Mth.wrapDegrees(packet.getYRot(this.player.getYRot()));
                    float toPitch = f1 = Mth.wrapDegrees(packet.getXRot(this.player.getXRot()));
                    if (this.updateAwaitingTeleport()) {
                        this.player.absSnapRotationTo(f, f1);
                    } else {
                        double d2;
                        double d1;
                        double d;
                        double toX = d = ServerGamePacketListenerImpl.clampHorizontal(packet.getX(this.player.getX()));
                        double toY = d1 = ServerGamePacketListenerImpl.clampVertical(packet.getY(this.player.getY()));
                        double toZ = d2 = ServerGamePacketListenerImpl.clampHorizontal(packet.getZ(this.player.getZ()));
                        if (this.player.isPassenger()) {
                            this.player.absSnapTo(this.player.getX(), this.player.getY(), this.player.getZ(), f, f1);
                            this.player.level().getChunkSource().move(this.player);
                            this.allowedPlayerTicks = 20;
                        } else {
                            double prevX = this.player.getX();
                            double prevY = this.player.getY();
                            double prevZ = this.player.getZ();
                            float prevYaw = this.player.getYRot();
                            float prevPitch = this.player.getXRot();
                            double x = this.player.getX();
                            double y = this.player.getY();
                            double z = this.player.getZ();
                            double d3 = d - this.firstGoodX;
                            double d4 = d1 - this.firstGoodY;
                            double d5 = d2 - this.firstGoodZ;
                            double d6 = this.player.getDeltaMovement().lengthSqr();
                            double d7 = d3 * d3 + d4 * d4 + d5 * d5;
                            double currDeltaX = toX - prevX;
                            double currDeltaY = toY - prevY;
                            double currDeltaZ = toZ - prevZ;
                            d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                            double otherFieldX = d - this.lastGoodX;
                            double otherFieldY = d1 - this.lastGoodY;
                            double otherFieldZ = d2 - this.lastGoodZ;
                            d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                            if (this.player.isSleeping()) {
                                if (d7 > 1.0) {
                                    this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), f, f1);
                                }
                            } else {
                                PlayerFailMoveEvent event;
                                PlayerFailMoveEvent event2;
                                boolean didCollide;
                                boolean flag;
                                boolean isFallFlying = this.player.isFallFlying();
                                if (serverLevel.tickRateManager().runsNormally()) {
                                    PlayerFailMoveEvent event3;
                                    ++this.receivedMovePacketCount;
                                    int i = this.receivedMovePacketCount - this.knownMovePacketCount;
                                    this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                    this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                    this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                    if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                        LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getPlainTextName(), (Object)i);
                                        i = 1;
                                    }
                                    this.allowedPlayerTicks = packet.hasRot || d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                                    double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
                                    if (!(!this.player.level().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.player.getX() == toX && this.player.getZ() == toZ || serverLevel.areChunksLoadedForMove(this.player.getBoundingBox().expandTowards(new Vec3(toX, toY, toZ).subtract(this.player.position()))) || (event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                        this.internalTeleport(PositionMoveRotation.of(this.player), Collections.emptySet());
                                        return;
                                    }
                                    if (this.shouldCheckPlayerMovement(isFallFlying)) {
                                        PlayerFailMoveEvent event4;
                                        float f2;
                                        float f3 = f2 = isFallFlying ? 300.0f : 100.0f;
                                        if (d7 - d6 > Math.max((double)f2, Mth.square(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed)) && !(event4 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                            if (event4.getLogWarning()) {
                                                LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getPlainTextName(), d3, d4, d5});
                                            }
                                            this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                                            return;
                                        }
                                    }
                                }
                                AABB boundingBox = this.player.getBoundingBox();
                                d3 = d - this.lastGoodX;
                                d4 = d1 - this.lastGoodY;
                                d5 = d2 - this.lastGoodZ;
                                boolean bl2 = flag = d4 > 0.0;
                                if (this.player.onGround() && !packet.isOnGround() && flag) {
                                    PlayerJumpEvent event5;
                                    CraftPlayer player = this.getCraftPlayer();
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packet.hasPos) {
                                        to.setX(packet.x);
                                        to.setY(packet.y);
                                        to.setZ(packet.z);
                                    }
                                    if (packet.hasRot) {
                                        to.setYaw(packet.yRot);
                                        to.setPitch(packet.xRot);
                                    }
                                    if ((event5 = new PlayerJumpEvent((org.bukkit.entity.Player)player, from, to)).callEvent()) {
                                        this.player.jumpFromGround();
                                    } else {
                                        from = event5.getFrom();
                                        this.internalTeleport(new PositionMoveRotation(CraftLocation.toVec3(from), Vec3.ZERO, from.getYaw(), from.getPitch()), Collections.emptySet());
                                        return;
                                    }
                                }
                                boolean flag1 = this.player.verticalCollisionBelow;
                                this.player.move(MoverType.PLAYER, new Vec3(d3, d4, d5));
                                this.player.onGround = packet.isOnGround();
                                boolean bl3 = didCollide = toX != this.player.getX() || toY != this.player.getY() || toZ != this.player.getZ();
                                if (this.awaitingPositionFromClient != null) {
                                    return;
                                }
                                double verticalDelta = d4;
                                d3 = d - this.player.getX();
                                d4 = d1 - this.player.getY();
                                if (d4 > -0.5 || d4 < 0.5) {
                                    d4 = 0.0;
                                }
                                d5 = d2 - this.player.getZ();
                                d7 = d3 * d3 + d4 * d4 + d5 * d5;
                                boolean movedWrongly = false;
                                if (!(this.player.isChangingDimension() || !(d7 > SpigotConfig.movedWronglyThreshold) || this.player.isSleeping() || this.player.isCreative() || this.player.isSpectator() || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                    movedWrongly = true;
                                    if (event2.getLogWarning()) {
                                        LOGGER.warn("{} moved wrongly!, ({})", (Object)this.player.getPlainTextName(), (Object)verticalDelta);
                                    }
                                }
                                boolean allowMovement = this.player.noPhysics || this.player.isSleeping() || !movedWrongly;
                                this.player.absSnapTo(d, d1, d2, f, f1);
                                if (!this.player.noPhysics && !this.player.isSleeping() && allowMovement) {
                                    AABB newBox = this.player.getBoundingBox();
                                    if (didCollide || !boundingBox.equals(newBox)) {
                                        boolean bl4 = allowMovement = !this.hasNewCollision(serverLevel, this.player, boundingBox, newBox);
                                    }
                                }
                                if (!allowMovement && (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                    allowMovement = true;
                                }
                                if (allowMovement) {
                                    this.player.absSnapTo(prevX, prevY, prevZ, prevYaw, prevPitch);
                                    CraftPlayer player = this.getCraftPlayer();
                                    if (!this.hasMoved) {
                                        this.lastPosX = prevX;
                                        this.lastPosY = prevY;
                                        this.lastPosZ = prevZ;
                                        this.lastYaw = prevYaw;
                                        this.lastPitch = prevPitch;
                                        this.hasMoved = true;
                                    }
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packet.hasPos) {
                                        to.setX(packet.x);
                                        to.setY(packet.y);
                                        to.setZ(packet.z);
                                    }
                                    if (packet.hasRot) {
                                        to.setYaw(packet.yRot);
                                        to.setPitch(packet.xRot);
                                    }
                                    double delta = Mth.square(this.lastPosX - to.getX()) + Mth.square(this.lastPosY - to.getY()) + Mth.square(this.lastPosZ - to.getZ());
                                    float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                    if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                                        this.lastPosX = to.getX();
                                        this.lastPosY = to.getY();
                                        this.lastPosZ = to.getZ();
                                        this.lastYaw = to.getYaw();
                                        this.lastPitch = to.getPitch();
                                        if (!to.getWorld().getUID().equals(from.getWorld().getUID()) || to.getBlockX() != from.getBlockX() || to.getBlockY() != from.getBlockY() || to.getBlockZ() != from.getBlockZ() || to.getYaw() != from.getYaw() || to.getPitch() != from.getPitch()) {
                                            this.player.resetLastActionTime();
                                        }
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event6 = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event6);
                                        if (event6.isCancelled()) {
                                            this.internalTeleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                            this.player.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                    this.player.absSnapTo(d, d1, d2, f, f1);
                                    boolean isAutoSpinAttack = this.player.isAutoSpinAttack();
                                    this.clientIsFloating = verticalDelta >= -0.03125 && !flag1 && !this.player.isSpectator() && !this.server.allowFlight() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !isFallFlying && !isAutoSpinAttack && this.noBlocksAround(this.player);
                                    this.player.level().getChunkSource().move(this.player);
                                    Vec3 vec3 = new Vec3(this.player.getX() - x, this.player.getY() - y, this.player.getZ() - z);
                                    this.player.setOnGroundWithMovement(packet.isOnGround(), packet.horizontalCollision(), vec3);
                                    this.player.doCheckFallDamage(vec3.x, vec3.y, vec3.z, packet.isOnGround());
                                    this.handlePlayerKnownMovement(vec3);
                                    if (flag) {
                                        this.player.resetFallDistance();
                                    }
                                    if (packet.isOnGround() || this.player.hasLandedInLiquid() || this.player.onClimbable() || this.player.isSpectator() || isFallFlying || isAutoSpinAttack) {
                                        this.player.tryResetCurrentImpulseContext();
                                    }
                                    if (!(!this.player.level().purpurConfig.dontRunWithScissors || !this.player.isSprinting() || this.player.level().purpurConfig.ignoreScissorsInWater && this.player.isInWater() || this.player.level().purpurConfig.ignoreScissorsInLava && this.player.isInLava() || !this.isScissors(this.player.getItemInHand(InteractionHand.MAIN_HAND)) && !this.isScissors(this.player.getItemInHand(InteractionHand.OFF_HAND)) || (int)(Math.random() * 10.0) != 0)) {
                                        this.player.hurtServer(this.player.level(), this.player.damageSources().scissors(), (float)this.player.level().purpurConfig.scissorsRunningDamage);
                                        if (!PurpurConfig.dontRunWithScissors.isBlank()) {
                                            this.player.sendActionBarMessage(PurpurConfig.dontRunWithScissors);
                                        }
                                    }
                                    this.player.checkMovementStatistics(this.player.getX() - x, this.player.getY() - y, this.player.getZ() - z);
                                    this.lastGoodX = this.player.getX();
                                    this.lastGoodY = this.player.getY();
                                    this.lastGoodZ = this.player.getZ();
                                } else {
                                    this.internalTeleport(x, y, z, f, f1);
                                    this.player.doCheckFallDamage(this.player.getX() - x, this.player.getY() - y, this.player.getZ() - z, packet.isOnGround());
                                    this.player.removeLatestMovementRecording();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isScissors(net.minecraft.world.item.ItemStack stack) {
        if (!stack.is(Items.SHEARS)) {
            return false;
        }
        ResourceLocation itemModelReference = stack.get(DataComponents.ITEM_MODEL);
        if (itemModelReference != null && itemModelReference.equals(this.player.level().purpurConfig.dontRunWithScissorsItemModelReference)) {
            return true;
        }
        return stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, CustomModelData.EMPTY).equals(CustomModelData.EMPTY);
    }

    private boolean shouldCheckPlayerMovement(boolean isElytraMovement) {
        if (this.isSingleplayerOwner()) {
            return false;
        }
        if (this.player.isChangingDimension()) {
            return false;
        }
        GameRules gameRules = this.player.level().getGameRules();
        return !gameRules.getBoolean(GameRules.RULE_DISABLE_PLAYER_MOVEMENT_CHECK) && (!isElytraMovement || !gameRules.getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK));
    }

    private boolean updateAwaitingTeleport() {
        if (this.awaitingPositionFromClient != null) {
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.awaitingTeleportTime = this.tickCount;
        return false;
    }

    private boolean hasNewCollision(ServerLevel level, net.minecraft.world.entity.Entity entity, AABB oldBox, AABB newBox) {
        int i;
        ArrayList<AABB> collisionsBB = new ArrayList<AABB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(level, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i = 0; i < len; ++i) {
            AABB box = (AABB)collisionsBB.get(i);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i = 0; i < len; ++i) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    private boolean isEntityCollidingWithAnythingNew(LevelReader level, net.minecraft.world.entity.Entity entity, AABB box, double x, double y, double z) {
        AABB aabb = entity.getBoundingBox().move(x - entity.getX(), y - entity.getY(), z - entity.getZ());
        Iterable<VoxelShape> preMoveCollisions = level.getPreMoveCollisions(entity, aabb.deflate(1.0E-5f), box.getBottomCenter());
        VoxelShape voxelShape = Shapes.create(box.deflate(1.0E-5f));
        for (VoxelShape voxelShape1 : preMoveCollisions) {
            if (Shapes.joinIsNotEmpty(voxelShape1, voxelShape, BooleanOp.AND)) continue;
            return true;
        }
        return false;
    }

    public void teleport(double x, double y, double z, float yRot, float xRot) {
        this.teleport(x, y, z, yRot, xRot, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double x, double y, double z, float yRot, float xRot, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3(x, y, z), Vec3.ZERO, yRot, xRot), Collections.emptySet(), cause);
    }

    public void teleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        this.teleport(posMoveRotation, relatives, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this.player), posMoveRotation, relatives)).position(), (Level)this.player.level(), absolutePosition.yRot(), absolutePosition.xRot())))) {
            this.internalTeleport(posMoveRotation, relatives);
            return true;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (Relative relativeArgument : relatives) {
            TeleportFlag.Relative flag = CraftEntity.deltaRelativeToAPI(relativeArgument);
            if (flag == null) continue;
            relativeFlags.add(flag);
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((org.bukkit.entity.Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            relatives = Set.of();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            posMoveRotation = new PositionMoveRotation(CraftLocation.toVec3(to), Vec3.ZERO, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(posMoveRotation, relatives);
        return !event.isCancelled();
    }

    public void internalTeleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    public void internalTeleport(double x, double y, double z, float yRot, float xRot) {
        this.internalTeleport(new PositionMoveRotation(new Vec3(x, y, z), Vec3.ZERO, yRot, xRot), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        AsyncCatcher.catchOp("teleport");
        if (this.player.isRemoved()) {
            LOGGER.info("Attempt to teleport removed player {} restricted", (Object)this.player.getScoreboardName());
            if (this.server.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(posMoveRotation.yRot())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.position(), posMoveRotation.deltaMovement(), 0.0f, posMoveRotation.xRot());
        }
        if (Float.isNaN(posMoveRotation.xRot())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.position(), posMoveRotation.deltaMovement(), posMoveRotation.yRot(), 0.0f);
        }
        this.justTeleported = true;
        this.awaitingTeleportTime = this.tickCount;
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.player.teleportSetPosition(posMoveRotation, relatives);
        this.awaitingPositionFromClient = this.player.position();
        this.lastPosX = this.awaitingPositionFromClient.x;
        this.lastPosY = this.awaitingPositionFromClient.y;
        this.lastPosZ = this.awaitingPositionFromClient.z;
        this.lastYaw = this.player.getYRot();
        this.lastPitch = this.player.getXRot();
        this.send(ClientboundPlayerPositionPacket.of(this.awaitingTeleport, posMoveRotation, relatives));
    }

    @Override
    public void handlePlayerAction(ServerboundPlayerActionPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            BlockPos pos = packet.getPos();
            this.player.resetLastActionTime();
            ServerboundPlayerActionPacket.Action action = packet.getAction();
            switch (action) {
                case SWAP_ITEM_WITH_OFFHAND: {
                    if (!this.player.isSpectator()) {
                        net.minecraft.world.item.ItemStack itemInHand = this.player.getItemInHand(InteractionHand.OFF_HAND);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemInHand);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.player.getItemInHand(InteractionHand.MAIN_HAND));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (ItemStack)mainHand.clone(), (ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.player.setItemInHand(InteractionHand.OFF_HAND, this.player.getItemInHand(InteractionHand.MAIN_HAND));
                        } else {
                            this.player.setItemInHand(InteractionHand.OFF_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.player.setItemInHand(InteractionHand.MAIN_HAND, itemInHand);
                        } else {
                            this.player.setItemInHand(InteractionHand.MAIN_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.player.stopUsingItem();
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.player.detectEquipmentUpdates();
                        }
                    }
                    return;
                }
                case DROP_ITEM: {
                    if (!this.player.isSpectator()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                LOGGER.warn(this.player.getScoreboardName() + " dropped their items too quickly!");
                                this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("You dropped your items too quickly (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                                return;
                            }
                        }
                        this.player.drop(false);
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.player.detectEquipmentUpdates();
                        }
                    }
                    return;
                }
                case DROP_ALL_ITEMS: {
                    if (!this.player.isSpectator()) {
                        this.player.drop(true);
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.player.detectEquipmentUpdates();
                        }
                    }
                    return;
                }
                case RELEASE_USE_ITEM: {
                    this.player.releaseUsingItem();
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.player.detectEquipmentUpdates();
                    }
                    return;
                }
                case START_DESTROY_BLOCK: 
                case ABORT_DESTROY_BLOCK: 
                case STOP_DESTROY_BLOCK: {
                    if (this.player.level().getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4) == null || !this.player.canInteractWithBlock(pos, 1.0)) {
                        this.player.connection.ackBlockChangesUpTo(packet.getSequence());
                        return;
                    }
                    this.player.gameMode.capturedBlockEntity = false;
                    this.player.gameMode.captureSentBlockEntities = true;
                    this.player.gameMode.handleBlockBreakAction(pos, action, packet.getDirection(), this.player.level().getMaxY(), packet.getSequence());
                    this.ackBlockChangesUpTo(packet.getSequence());
                    this.player.gameMode.captureSentBlockEntities = false;
                    if (this.player.gameMode.capturedBlockEntity) {
                        this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
                        this.player.connection.ackBlockChangesUpTo = -1;
                        this.player.gameMode.capturedBlockEntity = false;
                        BlockEntity blockEntity = this.player.level().getBlockEntity(pos);
                        if (blockEntity != null) {
                            this.player.connection.send(blockEntity.getUpdatePacket());
                        }
                    }
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.player.detectEquipmentUpdates();
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean wasBlockPlacementAttempt(ServerPlayer player, net.minecraft.world.item.ItemStack stack) {
        BucketItem bucketItem;
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return (item instanceof BlockItem || item instanceof BucketItem && (bucketItem = (BucketItem)item).getContent() != Fluids.EMPTY) && !player.getCooldowns().isOnCooldown(stack);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)ServerGamePacketListenerImpl.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)ServerGamePacketListenerImpl.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void handleUseItemOn(ServerboundUseItemOnPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            this.ackBlockChangesUpTo(packet.getSequence());
            ServerLevel serverLevel = this.player.level();
            InteractionHand hand = packet.getHand();
            net.minecraft.world.item.ItemStack itemInHand = this.player.getItemInHand(hand);
            if (itemInHand.isItemEnabled(serverLevel.enabledFeatures())) {
                BlockHitResult hitResult = packet.getHitResult();
                Vec3 location = hitResult.getLocation();
                if (!(Double.isFinite(location.x()) && Double.isFinite(location.y()) && Double.isFinite(location.z()))) {
                    return;
                }
                BlockPos blockPos = hitResult.getBlockPos();
                if (this.player.canInteractWithBlock(blockPos, 1.0)) {
                    Vec3 vec3 = location.subtract(Vec3.atCenterOf(blockPos));
                    double d = 1.0000001;
                    if (Math.abs(vec3.x()) < 1.0000001 && Math.abs(vec3.y()) < 1.0000001 && Math.abs(vec3.z()) < 1.0000001) {
                        Direction direction = hitResult.getDirection();
                        this.player.resetLastActionTime();
                        int maxY = this.player.level().getMaxY();
                        if (blockPos.getY() <= maxY) {
                            if (this.awaitingPositionFromClient == null && (serverLevel.mayInteract(this.player, blockPos) || serverLevel.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && serverLevel.getBlockState(blockPos).getBlock() instanceof SignBlock)) {
                                InteractionResult.Success success;
                                this.player.stopUsingItem();
                                InteractionResult interactionResult = this.player.gameMode.useItemOn(this.player, serverLevel, itemInHand, hand, hitResult);
                                if (interactionResult.consumesAction()) {
                                    CriteriaTriggers.ANY_BLOCK_USE.trigger(this.player, hitResult.getBlockPos(), itemInHand.copy());
                                }
                                if (direction == Direction.UP && !interactionResult.consumesAction() && blockPos.getY() >= maxY && ServerGamePacketListenerImpl.wasBlockPlacementAttempt(this.player, itemInHand)) {
                                    MutableComponent component = net.minecraft.network.chat.Component.translatable("build.tooHigh", maxY).withStyle(ChatFormatting.RED);
                                    this.player.sendSystemMessage(component, true);
                                } else if (interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).swingSource() == InteractionResult.SwingSource.SERVER && !this.player.gameMode.interactResult) {
                                    this.player.swing(hand, true);
                                }
                            } else {
                                this.player.containerMenu.forceHeldSlot(hand);
                            }
                        } else {
                            MutableComponent component1 = net.minecraft.network.chat.Component.translatable("build.tooHigh", maxY).withStyle(ChatFormatting.RED);
                            this.player.sendSystemMessage(component1, true);
                        }
                        this.send(new ClientboundBlockUpdatePacket(serverLevel, blockPos));
                        this.send(new ClientboundBlockUpdatePacket(serverLevel, blockPos.relative(direction)));
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.player.detectEquipmentUpdates();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleUseItem(ServerboundUseItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            this.ackBlockChangesUpTo(packet.getSequence());
            ServerLevel serverLevel = this.player.level();
            InteractionHand hand = packet.getHand();
            net.minecraft.world.item.ItemStack itemInHand = this.player.getItemInHand(hand);
            this.player.resetLastActionTime();
            if (!itemInHand.isEmpty() && itemInHand.isItemEnabled(serverLevel.enabledFeatures())) {
                InteractionResult.Success success;
                boolean cancelled;
                float f = Mth.wrapDegrees(packet.getYRot());
                float f1 = Mth.wrapDegrees(packet.getXRot());
                if (f1 != this.player.getXRot() || f != this.player.getYRot()) {
                    this.player.absSnapRotationTo(f, f1);
                }
                double x = this.player.getX();
                double eyeY = this.player.getEyeY();
                double z = this.player.getZ();
                Vec3 from = new Vec3(x, eyeY, z);
                float f3 = Mth.cos(-f * ((float)Math.PI / 180) - (float)Math.PI);
                float f4 = Mth.sin(-f * ((float)Math.PI / 180) - (float)Math.PI);
                float f5 = -Mth.cos(-f1 * ((float)Math.PI / 180));
                float f6 = Mth.sin(-f1 * ((float)Math.PI / 180));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.player.blockInteractionRange();
                Vec3 to = from.add((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                BlockHitResult hitResult = this.player.level().clip(new ClipContext(from, to, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, this.player));
                if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
                    if (this.player.gameMode.shiftClickMended(itemInHand)) {
                        return;
                    }
                    event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_AIR, itemInHand, hand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    cancelled = this.player.gameMode.firedInteract && this.player.gameMode.interactPosition.equals(hitResult.getBlockPos()) && this.player.gameMode.interactHand == hand && net.minecraft.world.item.ItemStack.isSameItemSameComponents(this.player.gameMode.interactItemStack, itemInHand) ? this.player.gameMode.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_BLOCK, hitResult.getBlockPos(), hitResult.getDirection(), itemInHand, true, hand, hitResult.getLocation())).useItemInHand() == Event.Result.DENY;
                    this.player.gameMode.firedInteract = false;
                }
                if (cancelled) {
                    this.player.resyncUsingItem(this.player);
                    this.player.containerMenu.forceHeldSlotAndArmor(hand);
                    return;
                }
                itemInHand = this.player.getItemInHand(hand);
                if (itemInHand.isEmpty()) {
                    return;
                }
                InteractionResult interactionResult = this.player.gameMode.useItem(this.player, serverLevel, itemInHand, hand);
                if (interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).swingSource() == InteractionResult.SwingSource.SERVER) {
                    this.player.swing(hand, true);
                }
            }
        }
    }

    @Override
    public void handleTeleportToEntityPacket(ServerboundTeleportToEntityPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isSpectator()) {
            for (ServerLevel serverLevel : this.server.getAllLevels()) {
                net.minecraft.world.entity.Entity entity = packet.getEntity(serverLevel);
                if (entity == null) continue;
                this.player.teleportTo(serverLevel, entity.getX(), entity.getY(), entity.getZ(), Set.of(), entity.getYRot(), entity.getXRot(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void handlePaddleBoat(ServerboundPaddleBoatPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractBoat = (AbstractBoat)entity;
            abstractBoat.setPaddleState(packet.getLeft(), packet.getRight());
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails details) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        LOGGER.info("{} lost connection: {}", (Object)this.player.getPlainTextName(), (Object)details.reason().getString());
        Component quitMessage = details.quitMessage().map(PaperAdventure::asAdventure).orElse(null);
        this.removePlayerFromWorld(quitMessage);
        super.onDisconnect(details);
    }

    private void removePlayerFromWorld() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.chatMessageChain.close();
        this.player.disconnect();
        Component component = quitMessage = quitMessage == null ? this.server.getPlayerList().remove(this.player) : this.server.getPlayerList().remove(this.player, quitMessage);
        if (quitMessage != null && !quitMessage.equals((Object)Component.empty())) {
            this.server.getPlayerList().broadcastSystemMessage(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.player.getTextFilter().leave();
    }

    public void ackBlockChangesUpTo(int sequence) {
        if (sequence < 0) {
            this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("Expected packet sequence nr >= 0"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(sequence, this.ackBlockChangesUpTo);
    }

    @Override
    public void handleSetCarriedItem(ServerboundSetCarriedItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (packet.getSlot() >= 0 && packet.getSlot() < net.minecraft.world.entity.player.Inventory.getSelectionSize()) {
            if (packet.getSlot() == this.player.getInventory().getSelectedSlot()) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((org.bukkit.entity.Player)this.getCraftPlayer(), this.player.getInventory().getSelectedSlot(), packet.getSlot());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.send(new ClientboundSetHeldSlotPacket(this.player.getInventory().getSelectedSlot()));
                this.player.resetLastActionTime();
                return;
            }
            if (this.player.getInventory().getSelectedSlot() != packet.getSlot() && this.player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
                this.player.stopUsingItem();
            }
            this.player.getInventory().setSelectedSlot(packet.getSlot());
            this.player.resetLastActionTime();
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.player.detectEquipmentUpdates();
            }
        } else {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getPlainTextName());
            this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("Invalid hotbar selection (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void handleChat(ServerboundChatPacket packet) {
        if (this.server.isStopped()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(packet.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.message(), false, () -> {
                PlayerChatMessage signedMessage;
                try {
                    signedMessage = this.getSignedMessage(packet, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.DecodeException var6) {
                    this.handleMessageDecodeFailure(var6);
                    return;
                }
                CompletionStage completableFuture = this.filterTextPacket(signedMessage.signedContent()).thenApplyAsync(Function.identity(), (Executor)this.server.chatExecutor);
                CompletableFuture<net.minecraft.network.chat.Component> componentFuture = this.server.getChatDecorator().decorate(this.player, null, signedMessage.decoratedContent());
                this.chatMessageChain.append(CompletableFuture.allOf(new CompletableFuture[]{completableFuture, componentFuture}), arg_0 -> this.lambda$handleChat$13(signedMessage, componentFuture, (CompletableFuture)completableFuture, arg_0));
            }, false);
        }
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket packet) {
        this.tryHandleChat(packet.command(), true, () -> {
            if (this.player.hasDisconnected()) {
                return;
            }
            this.performUnsignedChatCommand(packet.command());
            this.detectRateSpam("/" + packet.command());
        }, true);
    }

    private void performUnsignedChatCommand(String command) {
        String prefixedCommand = "/" + command;
        if (SpigotConfig.logCommands) {
            LOGGER.info("{} issued server command: {}", (Object)this.player.getScoreboardName(), (Object)prefixedCommand);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), prefixedCommand, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseResults = this.parseCommand(command);
        if (this.server.enforceSecureProfile() && SignableCommand.hasSignableArguments(parseResults)) {
            LOGGER.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.player.getGameProfile().name(), (Object)command);
            this.player.sendSystemMessage(INVALID_COMMAND_SIGNATURE);
        } else {
            this.server.getCommands().performCommand(parseResults, command);
        }
    }

    @Override
    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket packet) {
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(packet.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.command(), true, () -> {
                if (this.player.hasDisconnected()) {
                    return;
                }
                this.performSignedChatCommand(packet, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + packet.command());
            }, true);
        }
    }

    private void performSignedChatCommand(ServerboundChatCommandSignedPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.command();
        if (SpigotConfig.logCommands) {
            LOGGER.info("{} issued server command: {}", (Object)this.player.getScoreboardName(), command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        command = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseResults = this.parseCommand(packet.command());
        try {
            map = this.collectSignedArguments(packet, SignableCommand.of(parseResults), lastSeenMessages);
        }
        catch (SignedMessageChain.DecodeException var6) {
            this.handleMessageDecodeFailure(var6);
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!((String)command).equals(packet.command())) {
            parseResults = this.parseCommand((String)command);
            map = Collections.emptyMap();
        }
        CommandSigningContext.SignedArguments commandSigningContext = new CommandSigningContext.SignedArguments(map);
        parseResults = Commands.mapSource(parseResults, commandSourceStack -> commandSourceStack.withSigningContext(commandSigningContext, this.chatMessageChain));
        this.server.getCommands().performCommand(parseResults, (String)command);
    }

    private void handleMessageDecodeFailure(SignedMessageChain.DecodeException exception) {
        LOGGER.warn("Failed to update secure chat state for {}: '{}'", (Object)this.player.getGameProfile().name(), (Object)exception.getComponent().getString());
        this.player.sendSystemMessage(exception.getComponent().copy().withStyle(ChatFormatting.RED));
    }

    private <S> Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandSignedPacket packet, SignableCommand<S> command, LastSeenMessages lastSeenMessages) throws SignedMessageChain.DecodeException {
        List<ArgumentSignatures.Entry> list = packet.argumentSignatures().entries();
        List<SignableCommand.Argument<S>> list1 = command.arguments();
        if (list.isEmpty()) {
            return this.collectUnsignedArguments(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.Entry entry : list) {
            SignableCommand.Argument<S> argument = command.getArgument(entry.name());
            if (argument == null) {
                this.signedMessageDecoder.setChainBroken();
                throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(packet.command(), list, list1);
            }
            SignedMessageBody signedMessageBody = new SignedMessageBody(argument.value(), packet.timeStamp(), packet.salt(), lastSeenMessages);
            map.put(argument.name(), this.signedMessageDecoder.unpack(entry.signature(), signedMessageBody));
        }
        for (SignableCommand.Argument argument : list1) {
            if (map.containsKey(argument.name())) continue;
            throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(packet.command(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> collectUnsignedArguments(List<SignableCommand.Argument<S>> arguments) throws SignedMessageChain.DecodeException {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.Argument<S> argument : arguments) {
            SignedMessageBody signedMessageBody = SignedMessageBody.unsigned(argument.value());
            map.put(argument.name(), this.signedMessageDecoder.unpack(null, signedMessageBody));
        }
        return map;
    }

    private static <S> SignedMessageChain.DecodeException createSignedArgumentMismatchException(String command, List<ArgumentSignatures.Entry> signedArguments, List<SignableCommand.Argument<S>> unsignedArguments) {
        String string = signedArguments.stream().map(ArgumentSignatures.Entry::name).collect(Collectors.joining(", "));
        String string1 = unsignedArguments.stream().map(SignableCommand.Argument::name).collect(Collectors.joining(", "));
        LOGGER.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{command, string, string1});
        return new SignedMessageChain.DecodeException(INVALID_COMMAND_SIGNATURE);
    }

    private ParseResults<CommandSourceStack> parseCommand(String command) {
        CommandDispatcher<CommandSourceStack> dispatcher = this.server.getCommands().getDispatcher();
        return dispatcher.parse(command, this.player.createCommandSourceStack());
    }

    private void tryHandleChat(String message, boolean bypassHiddenChat, Runnable handler, boolean sync) {
        if (ServerGamePacketListenerImpl.isChatMessageIllegal(message)) {
            this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (this.player.isRemoved() || !bypassHiddenChat && this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(net.minecraft.network.chat.Component.translatable("chat.disabled.options").withStyle(ChatFormatting.RED), false));
        } else {
            this.player.resetLastActionTime();
            if (sync) {
                this.server.execute(handler);
            } else {
                handler.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.Update update) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> var10000;
            try {
                LastSeenMessages lastSeenMessages = this.lastSeenMessages.applyUpdate(update);
                var10000 = Optional.of(lastSeenMessages);
            }
            catch (LastSeenMessagesValidator.ValidationException var5) {
                LOGGER.error("Failed to validate message acknowledgements from {}: {}", (Object)this.player.getPlainTextName(), (Object)var5.getMessage());
                this.disconnectAsync(CHAT_VALIDATION_FAILED, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
                return Optional.empty();
            }
            return var10000;
        }
    }

    public static boolean isChatMessageIllegal(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (StringUtil.isAllowedChatCharacter(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public void chat(String msg, PlayerChatMessage original, boolean async) {
        if (msg.isEmpty() || this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            return;
        }
        if (this.player.getChatVisibility() != ChatVisiblity.SYSTEM) {
            if (!async && !Bukkit.isPrimaryThread()) {
                AsyncCatcher.catchOp("Asynchronous player chat is not allowed here");
            }
            new ChatProcessor(this.server, this.player, original, async).process();
        }
    }

    @Deprecated
    public void handleCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        this.performUnsignedChatCommand(command);
    }

    private PlayerChatMessage getSignedMessage(ServerboundChatPacket packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.DecodeException {
        SignedMessageBody signedMessageBody = new SignedMessageBody(packet.message(), packet.timeStamp(), packet.salt(), lastSeenMessages);
        return this.signedMessageDecoder.unpack(packet.signature(), signedMessageBody);
    }

    private void broadcastChatMessage(PlayerChatMessage message) {
        String rawMessage = message.signedContent();
        if (rawMessage.isEmpty()) {
            LOGGER.warn("{} tried to send an empty message", (Object)this.player.getScoreboardName());
        } else if (this.getCraftPlayer().isConversing()) {
            String conversationInput = rawMessage;
            this.server.processQueue.add(() -> this.getCraftPlayer().acceptConversationInput(conversationInput));
        } else if (this.player.getChatVisibility() == ChatVisiblity.SYSTEM) {
            this.send(new ClientboundSystemChatPacket(net.minecraft.network.chat.Component.translatable("chat.cannotSend").withStyle(ChatFormatting.RED), false));
        } else {
            this.chat(rawMessage, message, true);
        }
        this.detectRateSpam(rawMessage);
    }

    private void detectRateSpam(String message) {
        if (SpigotConfig.enableSpamExclusions) {
            for (String exclude : SpigotConfig.spamExclusions) {
                if (exclude == null || !message.startsWith(exclude)) continue;
                return;
            }
        }
        if (!(this.chatSpamThrottler.isIncrementAndUnderThreshold() || this.server.getPlayerList().isOp(this.player.nameAndId()) || this.server.isSingleplayerOwner(this.player.nameAndId()))) {
            this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.lastSeenMessages.applyOffset(packet.offset());
            }
            catch (LastSeenMessagesValidator.ValidationException var5) {
                LOGGER.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.player.getPlainTextName(), (Object)var5.getMessage());
                this.disconnectAsync(CHAT_VALIDATION_FAILED, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(ServerboundSwingPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        float f1 = this.player.getXRot();
        float f2 = this.player.getYRot();
        double d0 = this.player.getX();
        double d1 = this.player.getY() + (double)this.player.getEyeHeight();
        double d2 = this.player.getZ();
        Location origin = new Location((World)this.player.level().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.player.blockInteractionRange(), this.player.entityInteractionRange());
        RayTraceResult result = this.player.level().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.player.getBukkitEntity() && this.player.getBukkitEntity().canSee((Entity)entity) && !handle.isSpectator() && handle.isPickable() && !handle.isPassengerOfSameVehicle(this.player);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_AIR, this.player.getInventory().getSelectedItem(), InteractionHand.MAIN_HAND);
        } else {
            GameType gameType = this.player.gameMode.getGameModeForPlayer();
            if (gameType == GameType.ADVENTURE && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, ((CraftBlock)result.getHitBlock()).getPosition(), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.player.getInventory().getSelectedItem(), InteractionHand.MAIN_HAND);
            } else if (gameType != GameType.CREATIVE && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > this.player.entityInteractionRange() * this.player.entityInteractionRange()) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_AIR, this.player.getInventory().getSelectedItem(), InteractionHand.MAIN_HAND);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((org.bukkit.entity.Player)this.getCraftPlayer(), CraftEquipmentSlot.getHand(packet.getHand()));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.player.swing(packet.getHand());
    }

    @Override
    public void handlePlayerCommand(ServerboundPlayerCommandPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.hasClientLoaded()) {
            if (this.player.isRemoved()) {
                return;
            }
            switch (packet.getAction()) {
                case START_SPRINTING: 
                case STOP_SPRINTING: {
                    PlayerToggleSprintEvent event = new PlayerToggleSprintEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packet.getAction() == ServerboundPlayerCommandPacket.Action.START_SPRINTING);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) break;
                    return;
                }
            }
            this.player.resetLastActionTime();
            switch (packet.getAction()) {
                case START_SPRINTING: {
                    this.player.setSprinting(true);
                    break;
                }
                case STOP_SPRINTING: {
                    this.player.setSprinting(false);
                    break;
                }
                case STOP_SLEEPING: {
                    if (!this.player.isSleeping()) break;
                    this.player.stopSleepInBed(false, true);
                    this.awaitingPositionFromClient = this.player.position();
                    break;
                }
                case START_RIDING_JUMP: {
                    net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                    if (!(entity instanceof PlayerRideableJumping)) break;
                    PlayerRideableJumping playerRideableJumping = (PlayerRideableJumping)((Object)entity);
                    int data = packet.getData();
                    if (!playerRideableJumping.canJump() || data <= 0) break;
                    playerRideableJumping.handleStartJump(data);
                    break;
                }
                case STOP_RIDING_JUMP: {
                    net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                    if (!(entity instanceof PlayerRideableJumping)) break;
                    PlayerRideableJumping playerRideableJumping = (PlayerRideableJumping)((Object)entity);
                    playerRideableJumping.handleStopJump();
                    break;
                }
                case OPEN_INVENTORY: {
                    net.minecraft.world.entity.Entity entity = this.player.getVehicle();
                    if (!(entity instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hasCustomInventoryScreen = (HasCustomInventoryScreen)((Object)entity);
                    hasCustomInventoryScreen.openCustomInventoryScreen(this.player);
                    break;
                }
                case START_FALL_FLYING: {
                    if (this.player.tryToStartFallFlying()) break;
                    this.player.stopFallFlying();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPlayerChatMessage(PlayerChatMessage chatMessage, ChatType.Bound boundChatType) {
        if (!this.getCraftPlayer().canSeePlayer(chatMessage.link().sender())) {
            this.sendDisguisedChatMessage(chatMessage.decoratedContent(), boundChatType);
            return;
        }
        MessageSignatureCache messageSignatureCache = this.messageSignatureCache;
        synchronized (messageSignatureCache) {
            this.send(new ClientboundPlayerChatPacket(this.nextChatIndex++, chatMessage.link().sender(), chatMessage.link().index(), chatMessage.signature(), chatMessage.signedBody().pack(this.messageSignatureCache), chatMessage.unsignedContent(), chatMessage.filterMask(), boundChatType));
            MessageSignature messageSignature = chatMessage.signature();
            if (messageSignature != null) {
                int i;
                this.messageSignatureCache.push(chatMessage.signedBody(), chatMessage.signature());
                LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
                synchronized (lastSeenMessagesValidator) {
                    this.lastSeenMessages.addPending(messageSignature);
                    i = this.lastSeenMessages.trackedMessagesCount();
                }
                if (i > 4096) {
                    this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
                }
            }
        }
    }

    public void sendDisguisedChatMessage(net.minecraft.network.chat.Component message, ChatType.Bound boundChatType) {
        this.send(new ClientboundDisguisedChatPacket(message, boundChatType));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public SocketAddress getRawAddress() {
        if (this.connection.channel.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.connection.channel.remoteAddress();
    }

    public void switchToConfig() {
        this.waitingForSwitchToConfig = true;
        this.removePlayerFromWorld();
        this.send(ClientboundStartConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket packet) {
        this.connection.send(new ClientboundPongResponsePacket(packet.getTime()));
    }

    @Override
    public void handleInteract(final ServerboundInteractPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            final ServerLevel serverLevel = this.player.level();
            final net.minecraft.world.entity.Entity target = packet.getTarget(serverLevel);
            if (target == this.player && !this.player.isSpectator()) {
                this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("Cannot interact with self!"), PlayerKickEvent.Cause.SELF_INTERACTION);
                return;
            }
            this.player.resetLastActionTime();
            this.player.setShiftKeyDown(packet.isUsingSecondaryAction());
            if (target != null) {
                if (!serverLevel.getWorldBorder().isWithinBounds(target.blockPosition())) {
                    return;
                }
                AABB boundingBox = target.getBoundingBox();
                if (this.player.canInteractWithEntity(boundingBox, GlobalConfiguration.get().misc.clientInteractionLeniencyDistance.or(3.0))) {
                    if (target instanceof Mob) {
                        Mob mob = (Mob)target;
                        mob.ticksSinceLastInteraction = 0;
                    }
                    packet.dispatch(new ServerboundInteractPacket.Handler(){

                        private void performInteraction(InteractionHand hand, EntityInteraction entityInteraction, PlayerInteractEntityEvent event) {
                            net.minecraft.world.item.ItemStack itemInHand = ServerGamePacketListenerImpl.this.player.getItemInHand(hand);
                            if (itemInHand.isItemEnabled(serverLevel.enabledFeatures())) {
                                net.minecraft.world.item.ItemStack itemStack = itemInHand.copy();
                                Item itemType = itemInHand.getItem();
                                boolean triggerLeashUpdate = itemStack.is(Items.LEAD) && target instanceof Leashable;
                                ServerGamePacketListenerImpl.this.cserver.getPluginManager().callEvent((Event)event);
                                boolean resendData = event.isCancelled() || !ServerGamePacketListenerImpl.this.player.getItemInHand(hand).is(itemType);
                                ServerGamePacketListenerImpl.this.player.processClick(hand);
                                if (itemType == Items.WATER_BUCKET && target instanceof Bucketable && target instanceof LivingEntity && resendData) {
                                    target.resendPossiblyDesyncedEntityData(ServerGamePacketListenerImpl.this.player);
                                    ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                }
                                if (triggerLeashUpdate && resendData) {
                                    ServerGamePacketListenerImpl.this.send(new ClientboundSetEntityLinkPacket(target, ((Leashable)((Object)target)).getLeashHolder()));
                                }
                                if (resendData) {
                                    target.refreshEntityData(ServerGamePacketListenerImpl.this.player);
                                    if (target instanceof Allay || target instanceof AbstractHorse) {
                                        ServerGamePacketListenerImpl.this.send(new ClientboundSetEquipmentPacket(target.getId(), Arrays.stream(EquipmentSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((LivingEntity)target).getItemBySlot((EquipmentSlot)slot).copy())).collect(Collectors.toList()), true));
                                        ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                    } else {
                                        ServerGamePacketListenerImpl.this.player.containerMenu.forceHeldSlot(hand);
                                    }
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                InteractionResult result = entityInteraction.run(ServerGamePacketListenerImpl.this.player, target, hand);
                                if (result instanceof InteractionResult.Success) {
                                    InteractionResult.Success success = (InteractionResult.Success)result;
                                    net.minecraft.world.item.ItemStack itemStack1 = success.wasItemInteraction() ? itemStack : net.minecraft.world.item.ItemStack.EMPTY;
                                    CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(ServerGamePacketListenerImpl.this.player, itemStack1, target);
                                    if (success.swingSource() == InteractionResult.SwingSource.SERVER) {
                                        ServerGamePacketListenerImpl.this.player.swing(hand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void onInteraction(InteractionHand hand) {
                            this.performInteraction(hand, Player::interactOn, new PlayerInteractEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void onInteraction(InteractionHand hand, Vec3 interactionLocation) {
                            this.performInteraction(hand, (player, entity, interactionHand) -> entity.interactAt(player, interactionLocation, interactionHand), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftVector.toBukkit(interactionLocation), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void onAttack() {
                            AbstractArrow abstractArrow;
                            if (!(target instanceof ItemEntity || target instanceof ExperienceOrb || target == ServerGamePacketListenerImpl.this.player && !ServerGamePacketListenerImpl.this.player.isSpectator() || target instanceof AbstractArrow && !(abstractArrow = (AbstractArrow)target).isAttackable())) {
                                net.minecraft.world.item.ItemStack itemInHand = ServerGamePacketListenerImpl.this.player.getItemInHand(InteractionHand.MAIN_HAND);
                                if (itemInHand.isItemEnabled(serverLevel.enabledFeatures())) {
                                    ServerGamePacketListenerImpl.this.player.attack(target);
                                }
                            } else {
                                ServerGamePacketListenerImpl.this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                                LOGGER.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.player.getPlainTextName());
                            }
                        }
                    });
                }
            } else {
                packet.dispatch(new ServerboundInteractPacket.Handler(){

                    @Override
                    public void onInteraction(InteractionHand hand) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(ServerGamePacketListenerImpl.this.player, packet, hand, null);
                    }

                    @Override
                    public void onInteraction(InteractionHand hand, Vec3 pos) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(ServerGamePacketListenerImpl.this.player, packet, hand, pos);
                    }

                    @Override
                    public void onAttack() {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(ServerGamePacketListenerImpl.this.player, packet, InteractionHand.MAIN_HAND, null);
                    }
                });
            }
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.player.detectEquipmentUpdates();
            }
        }
    }

    @Override
    public void handleClientCommand(ServerboundClientCommandPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        this.player.resetLastActionTime();
        ServerboundClientCommandPacket.Action action = packet.getAction();
        switch (action) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true, Entity.RemovalReason.CHANGED_DIMENSION, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.resetPosition();
                    CriteriaTriggers.CHANGED_DIMENSION.trigger(this.player, Level.END, Level.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false, Entity.RemovalReason.KILLED, PlayerRespawnEvent.RespawnReason.DEATH);
                this.resetPosition();
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(GameType.SPECTATOR, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.player.level().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.player.level());
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(ServerboundContainerClosePacket packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(ServerboundContainerClosePacket packet, InventoryCloseEvent.Reason reason) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.player, reason);
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(ServerboundContainerClickPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packet.containerId() && this.player.containerMenu.stillValid(this.player)) {
            boolean cancelled = this.player.isSpectator();
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                short slotNum = packet.slotNum();
                if (!this.player.containerMenu.isValidSlotIndex(slotNum)) {
                    LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getPlainTextName(), (int)slotNum, this.player.containerMenu.slots.size()});
                } else {
                    boolean flag = packet.stateId() != this.player.containerMenu.getStateId();
                    this.player.containerMenu.suppressRemoteUpdates();
                    if (slotNum < -1 && slotNum != -999) {
                        return;
                    }
                    InventoryView inventory = this.player.containerMenu.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType((int)slotNum);
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    switch (packet.clickType()) {
                        case PICKUP: {
                            if (packet.buttonNum() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.buttonNum() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.buttonNum() != 0 && packet.buttonNum() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (slotNum == -999) {
                                if (this.player.containerMenu.getCarried().isEmpty()) break;
                                action = packet.buttonNum() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(slotNum);
                            if (slot == null) break;
                            net.minecraft.world.item.ItemStack clickedItem = slot.getItem();
                            net.minecraft.world.item.ItemStack cursor = this.player.containerMenu.getCarried();
                            if (clickedItem.isEmpty()) {
                                if (cursor.isEmpty()) break;
                                if (cursor.getItem() instanceof BundleItem && cursor.has(DataComponents.BUNDLE_CONTENTS) && packet.buttonNum() != 0) {
                                    action = cursor.get(DataComponents.BUNDLE_CONTENTS).isEmpty() ? InventoryAction.NOTHING : InventoryAction.PLACE_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.buttonNum() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.mayPickup(this.player)) break;
                            if (cursor.isEmpty()) {
                                if (slot.getItem().getItem() instanceof BundleItem && slot.getItem().has(DataComponents.BUNDLE_CONTENTS) && packet.buttonNum() != 0) {
                                    action = slot.getItem().get(DataComponents.BUNDLE_CONTENTS).isEmpty() ? InventoryAction.NOTHING : InventoryAction.PICKUP_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.buttonNum() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.mayPlace(cursor)) {
                                int toPickup;
                                if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(clickedItem, cursor)) {
                                    int toPlace = packet.buttonNum() == 0 ? cursor.getCount() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.getMaxStackSize() - clickedItem.getCount());
                                    if ((toPlace = Math.min(toPlace, slot.container.getMaxStackSize() - clickedItem.getCount())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.getCount()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.getCount() > slot.getMaxStackSize()) break;
                                if (cursor.getItem() instanceof BundleItem && cursor.has(DataComponents.BUNDLE_CONTENTS) && packet.buttonNum() == 0) {
                                    toPickup = cursor.get(DataComponents.BUNDLE_CONTENTS).getMaxAmountToAdd(slot.getItem());
                                    if (toPickup >= slot.getItem().getCount()) {
                                        action = InventoryAction.PICKUP_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PICKUP_SOME_INTO_BUNDLE;
                                    break;
                                }
                                if (slot.getItem().getItem() instanceof BundleItem && slot.getItem().has(DataComponents.BUNDLE_CONTENTS) && packet.buttonNum() == 0) {
                                    toPickup = slot.getItem().get(DataComponents.BUNDLE_CONTENTS).getMaxAmountToAdd(cursor);
                                    if (toPickup >= cursor.getCount()) {
                                        action = InventoryAction.PLACE_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PLACE_SOME_INTO_BUNDLE;
                                    break;
                                }
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!net.minecraft.world.item.ItemStack.isSameItemSameComponents(cursor, clickedItem) || clickedItem.getCount() < 0 || clickedItem.getCount() + cursor.getCount() > cursor.getMaxStackSize()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case QUICK_MOVE: {
                            if (packet.buttonNum() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.buttonNum() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.buttonNum() != 0 && packet.buttonNum() != 1) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(slotNum);
                            if (slot != null && slot.mayPickup(this.player) && slot.hasItem()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case SWAP: {
                            if ((packet.buttonNum() < 0 || packet.buttonNum() >= 9) && packet.buttonNum() != 40) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.buttonNum() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.player.containerMenu.getSlot(slotNum);
                            if (clickedSlot.mayPickup(this.player)) {
                                net.minecraft.world.item.ItemStack hotbar = this.player.getInventory().getItem(packet.buttonNum());
                                if (!hotbar.isEmpty() && clickedSlot.mayPlace(hotbar) || hotbar.isEmpty() && clickedSlot.hasItem()) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case CLONE: {
                            Slot slot;
                            if (packet.buttonNum() == 2) {
                                click = ClickType.MIDDLE;
                                if (slotNum < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.player.containerMenu.getSlot(slotNum);
                                if (slot != null && slot.hasItem() && this.player.getAbilities().instabuild && this.player.containerMenu.getCarried().isEmpty()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case THROW: {
                            Slot slot;
                            if (slotNum >= 0) {
                                if (packet.buttonNum() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.player.containerMenu.getSlot(slotNum);
                                    if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Items.AIR) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.buttonNum() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.player.containerMenu.getSlot(slotNum);
                                if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Items.AIR) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.buttonNum() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case QUICK_CRAFT: {
                            AbstractContainerMenu containerMenu = this.player.containerMenu;
                            int currentStatus = this.player.containerMenu.quickcraftStatus;
                            int newStatus = AbstractContainerMenu.getQuickcraftHeader(packet.buttonNum());
                            if (!(currentStatus != 1 || newStatus != 2 && currentStatus != newStatus || containerMenu.getCarried().isEmpty() || newStatus == 0 || newStatus == 1 || newStatus != 2 || this.player.containerMenu.quickcraftSlots.isEmpty() || this.player.containerMenu.quickcraftSlots.size() != 1)) {
                                int index = containerMenu.quickcraftSlots.iterator().next().index;
                                containerMenu.resetQuickCraft();
                                this.handleContainerClick(new ServerboundContainerClickPacket(packet.containerId(), packet.stateId(), (short)index, (byte)containerMenu.quickcraftType, net.minecraft.world.inventory.ClickType.PICKUP, packet.changedSlots(), packet.carriedItem()));
                                return;
                            }
                            this.player.containerMenu.clicked(slotNum, packet.buttonNum(), packet.clickType(), this.player);
                            break;
                        }
                        case PICKUP_ALL: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (slotNum < 0 || this.player.containerMenu.getCarried().isEmpty()) break;
                            net.minecraft.world.item.ItemStack cursor = this.player.containerMenu.getCarried();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.clickType() != net.minecraft.world.inventory.ClickType.QUICK_CRAFT) {
                        CartographyInventory cartographyInventory;
                        SmithingInventory smithingInv;
                        ItemStack result;
                        CraftingInventory craftingInv;
                        Recipe recipe;
                        if (this.player.containerMenu.quickcraftStatus != 0) {
                            action = InventoryAction.NOTHING;
                        }
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, (int)slotNum, click, action, (int)packet.buttonNum()) : new InventoryClickEvent(inventory, type, (int)slotNum, click, action);
                        Inventory top = inventory.getTopInventory();
                        if (slotNum == 0 && top instanceof CraftingInventory && (recipe = (craftingInv = (CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, (int)slotNum, click, action, (int)packet.buttonNum()) : new CraftItemEvent(recipe, inventory, type, (int)slotNum, click, action);
                        }
                        if (slotNum == 3 && top instanceof SmithingInventory && (result = (smithingInv = (SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, (int)slotNum, click, action, (int)packet.buttonNum()) : new SmithItemEvent(inventory, type, (int)slotNum, click, action);
                        }
                        if (slotNum == 2 && top instanceof CartographyInventory && (result = (cartographyInventory = (CartographyInventory)top).getResult()) != null && !result.isEmpty()) {
                            event = click == ClickType.NUMBER_KEY ? new CartographyItemEvent(inventory, type, (int)slotNum, click, action, (int)packet.buttonNum()) : new CartographyItemEvent(inventory, type, (int)slotNum, click, action);
                        }
                        event.setCancelled(cancelled);
                        AbstractContainerMenu oldContainer = this.player.containerMenu;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.player.containerMenu != oldContainer) {
                            this.player.containerMenu.resumeRemoteUpdates();
                            this.player.containerMenu.broadcastFullState();
                            return;
                        }
                        if (event.getResult() != Event.Result.DENY) {
                            this.player.containerMenu.clicked(slotNum, packet.buttonNum(), packet.clickType(), this.player);
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.player.containerMenu.sendAllDataToRemote();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.changedSlots())) {
                        this.player.containerMenu.setRemoteSlotUnsafe(entry.getIntKey(), (HashedStack)entry.getValue());
                    }
                    this.player.containerMenu.setRemoteCarried(packet.carriedItem());
                    this.player.containerMenu.resumeRemoteUpdates();
                    if (flag) {
                        this.player.containerMenu.broadcastFullState();
                    } else {
                        this.player.containerMenu.broadcastChanges();
                    }
                    if (packet.buttonNum() == 40 && this.player.containerMenu != this.player.inventoryMenu) {
                        this.player.containerSynchronizer.sendOffHandSlotChange();
                    }
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.player.detectEquipmentUpdates();
                    }
                }
            }
        }
    }

    @Override
    public void handlePlaceRecipe(ServerboundPlaceRecipePacket packet) {
        if (!Bukkit.isPrimaryThread() && !this.recipeSpamPackets.isIncrementAndUnderThreshold()) {
            this.disconnectAsync((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        this.player.resetLastActionTime();
        if (!this.player.isSpectator() && this.player.containerMenu.containerId == packet.containerId()) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                RecipeManager.ServerDisplayInfo recipeFromDisplay = this.server.getRecipeManager().getRecipeFromDisplay(packet.recipe());
                if (recipeFromDisplay != null) {
                    AbstractContainerMenu abstractContainerMenu;
                    RecipeHolder recipeHolder = recipeFromDisplay.parent();
                    if (this.player.getRecipeBook().contains(recipeHolder.id()) && (abstractContainerMenu = this.player.containerMenu) instanceof RecipeBookMenu) {
                        RecipeBookMenu recipeBookMenu = (RecipeBookMenu)abstractContainerMenu;
                        if (recipeHolder.value().placementInfo().isImpossibleToPlace()) {
                            LOGGER.debug("Player {} tried to place impossible recipe {}", (Object)this.player, (Object)recipeHolder.id().location());
                            return;
                        }
                        NamespacedKey recipeName = CraftNamespacedKey.fromMinecraft(recipeHolder.id().location());
                        boolean makeAll = packet.useMaxItems();
                        com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent paperEvent = new com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), recipeName, makeAll);
                        if (!paperEvent.callEvent()) {
                            return;
                        }
                        recipeName = paperEvent.getRecipe();
                        makeAll = paperEvent.isMakeAll();
                        if (PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                            Recipe recipe = this.cserver.getRecipe(recipeName);
                            if (recipe == null) {
                                return;
                            }
                            PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.player, recipe, makeAll);
                            recipeName = ((Keyed)event.getRecipe()).getKey();
                            makeAll = event.isShiftClick();
                        }
                        if (!(this.player.containerMenu instanceof RecipeBookMenu)) {
                            return;
                        }
                        recipeHolder = this.server.getRecipeManager().byKey(ResourceKey.create(Registries.RECIPE, CraftNamespacedKey.toMinecraft(recipeName))).orElse(null);
                        if (recipeHolder == null) {
                            return;
                        }
                        RecipeBookMenu.PostPlaceAction postPlaceAction = recipeBookMenu.handlePlacement(makeAll, this.player.isCreative(), recipeHolder, this.player.level(), this.player.getInventory());
                        if (postPlaceAction == RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE) {
                            this.send(new ClientboundPlaceGhostRecipePacket(this.player.containerMenu.containerId, recipeFromDisplay.display().display()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleContainerButtonClick(ServerboundContainerButtonClickPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packet.containerId() && !this.player.isSpectator()) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                boolean flag = this.player.containerMenu.clickMenuButton(this.player, packet.buttonId());
                if (flag) {
                    this.player.containerMenu.broadcastChanges();
                }
                if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                    this.player.detectEquipmentUpdates();
                }
            }
        }
    }

    @Override
    public void handleSetCreativeModeSlot(ServerboundSetCreativeModeSlotPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.hasInfiniteMaterials()) {
            boolean flag2;
            boolean flag = packet.slotNum() < 0;
            net.minecraft.world.item.ItemStack itemStack = packet.itemStack();
            if (!itemStack.isItemEnabled(this.player.level().enabledFeatures())) {
                return;
            }
            boolean flag1 = packet.slotNum() >= 1 && packet.slotNum() <= 45;
            boolean bl = flag2 = itemStack.isEmpty() || itemStack.getCount() <= itemStack.getMaxStackSize();
            if (flag || flag1 && !net.minecraft.world.item.ItemStack.matches(this.player.inventoryMenu.getSlot(packet.slotNum()).getItem(), packet.itemStack())) {
                CraftInventoryView inventory = this.player.inventoryMenu.getBukkitView();
                ItemStack item = CraftItemStack.asBukkitCopy(packet.itemStack());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.slotNum() < 36) {
                    type = packet.slotNum() >= 5 && packet.slotNum() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packet.slotNum(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemStack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.slotNum() >= 0) {
                            this.player.connection.send(new ClientboundContainerSetSlotPacket(this.player.inventoryMenu.containerId, this.player.inventoryMenu.incrementStateId(), packet.slotNum(), this.player.inventoryMenu.getSlot(packet.slotNum()).getItem()));
                            this.player.connection.send(new ClientboundSetCursorItemPacket(net.minecraft.world.item.ItemStack.EMPTY.copy()));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.player.inventoryMenu.getSlot(packet.slotNum()).setByPlayer(itemStack);
                this.player.inventoryMenu.setRemoteSlot(packet.slotNum(), itemStack);
                this.player.inventoryMenu.broadcastChanges();
                if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                    this.player.detectEquipmentUpdates();
                }
            } else if (flag && flag2) {
                if (this.dropSpamThrottler.isUnderThreshold()) {
                    this.dropSpamThrottler.increment();
                    this.player.drop(itemStack, true);
                } else {
                    LOGGER.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.player.getPlainTextName());
                }
            }
        }
    }

    @Override
    public void handleSignUpdate(ServerboundSignUpdatePacket packet) {
        String[] lines = packet.getLines();
        for (int i = 0; i < lines.length; ++i) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i].length()) continue;
            lines[i] = lines[i].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(ChatFormatting::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(list).thenAcceptAsync(texts -> this.updateSignText(packet, (List<FilteredText>)texts), (Executor)this.server);
    }

    private void updateSignText(ServerboundSignUpdatePacket packet, List<FilteredText> filteredText) {
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        ServerLevel serverLevel = this.player.level();
        BlockPos pos = packet.getPos();
        if (serverLevel.hasChunkAt(pos)) {
            if (!new UncheckedSignChangeEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), MCUtil.toPosition(pos), packet.isFrontText() ? Side.FRONT : Side.BACK, filteredText.stream().map(line -> Component.text((String)line.raw())).toList()).callEvent()) {
                return;
            }
            BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
            if (!(blockEntity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
            signBlockEntity.updateSignText(this.player, packet.isFrontText(), filteredText);
        }
    }

    @Override
    public void handlePlayerAbilities(ServerboundPlayerAbilitiesPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.getAbilities().mayfly && this.player.getAbilities().flying != packet.isFlying()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), packet.isFlying());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.player.getAbilities().flying = packet.isFlying();
            } else {
                this.player.onUpdateAbilities();
            }
        }
    }

    @Override
    public void handleClientInformation(ServerboundClientInformationPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (packet.information().viewDistance() < 0) {
            LOGGER.warn("Disconnecting {} for invalid view distance: {}", (Object)this.player.getScoreboardName(), (Object)packet.information().viewDistance());
            this.disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal("Invalid client settings"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        boolean isModelPartShown = this.player.isModelPartShown(PlayerModelPart.HAT);
        this.player.updateOptions(packet.information());
        this.connection.channel.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.information().language()));
        if (this.player.isModelPartShown(PlayerModelPart.HAT) != isModelPartShown) {
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_HAT, this.player));
        }
    }

    @Override
    public void handleChangeDifficulty(ServerboundChangeDifficultyPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            LOGGER.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.player.getGameProfile().name(), (Object)packet.difficulty().getDisplayName());
        }
    }

    @Override
    public void handleChangeGameMode(ServerboundChangeGameModePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (!this.player.hasPermissions(2) && !this.player.getBukkitEntity().hasPermission("purpur.debug.f3n")) {
            LOGGER.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.player.getGameProfile().name(), (Object)packet.mode().getShortDisplayName().getString());
        } else {
            GameModeCommand.setGameMode(this.player.createCommandSourceStack(), this.player, packet.mode(), PlayerGameModeChangeEvent.Cause.GAMEMODE_SWITCHER);
        }
    }

    @Override
    public void handleLockDifficulty(ServerboundLockDifficultyPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        if (this.player.hasPermissions(2) || this.isSingleplayerOwner()) {
            this.server.setDifficultyLocked(packet.isLocked());
        }
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        RemoteChatSession.Data data = packet.chatSession();
        ProfilePublicKey.Data data1 = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.Data data2 = data.profilePublicKey();
        if (!Objects.equals(data1, data2)) {
            if (data1 != null && data2.expiresAt().isBefore(data1.expiresAt())) {
                this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signatureValidator = this.server.services().profileKeySignatureValidator();
                    if (signatureValidator == null) {
                        LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.player.getGameProfile().name());
                        return;
                    }
                    this.resetPlayerChatState(data.validate(this.player.getGameProfile(), signatureValidator));
                }
                catch (ProfilePublicKey.ValidationException var6) {
                    this.disconnect(var6.getComponent(), var6.kickCause);
                }
            }
        }
    }

    @Override
    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.waitingForSwitchToConfig) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        ServerConfigurationPacketListenerImpl listener = new ServerConfigurationPacketListenerImpl(this.server, this.connection, this.createCookie(this.player.clientInformation()));
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, listener);
        new PlayerConnectionReconfigureEvent((PlayerConfigurationConnection)listener.paperConnection).callEvent();
    }

    @Override
    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        this.chunkSender.onChunkBatchReceivedByClient(packet.desiredChunksPerTick());
    }

    @Override
    public void handleDebugSubscriptionRequest(ServerboundDebugSubscriptionRequestPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        this.player.requestDebugSubscriptions(packet.subscriptions());
    }

    private void resetPlayerChatState(RemoteChatSession chatSession) {
        this.chatSession = chatSession;
        this.hasLoggedExpiry = false;
        this.signedMessageDecoder = chatSession.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(() -> this.server.executeBlocking(() -> {
            this.player.setChatSession(chatSession);
            this.server.getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.INITIALIZE_CHAT), (Collection<ServerPlayer>)List.of(this.player)), this.player);
        }));
    }

    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket packet) {
        super.handleCustomPayload(packet);
    }

    @Override
    public void handleClientTickEnd(ServerboundClientTickEndPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.level());
        this.tickEndEvent.callEvent();
        if (!this.receivedMovementThisTick) {
            this.player.setKnownMovement(Vec3.ZERO);
        }
        this.receivedMovementThisTick = false;
    }

    private void handlePlayerKnownMovement(Vec3 movement) {
        if (movement.lengthSqr() > (double)1.0E-5f) {
            this.player.resetLastActionTime();
        }
        this.player.setKnownMovement(movement);
        this.receivedMovementThisTick = true;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.player.hasInfiniteMaterials();
    }

    @Override
    public ServerPlayer getPlayer() {
        return this.player;
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((org.bukkit.entity.Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : this.player.getBukkitEntity();
    }

    @Override
    public void disconnectAsync(DisconnectionDetails disconnectionInfo) {
        if (this.cserver.isPrimaryThread()) {
            this.disconnect(disconnectionInfo);
            return;
        }
        this.connection.setReadOnly();
        this.server.scheduleOnMain(() -> {
            this.disconnect(disconnectionInfo);
            if (this.player.quitReason == null) {
                this.connection.enableAutoRead();
            }
        });
    }

    public final boolean isDisconnected() {
        return !this.player.joining && !this.connection.isConnected() || this.processedDisconnect;
    }

    @Override
    public void handleResourcePackResponse(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        super.handleResourcePackResponse(packet);
        this.connection.resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.action().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packet.id(), packStatus));
    }

    public void disconnect(Component reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asVanilla(reason), DisconnectionReason.game(cause));
    }

    public void disconnect(net.minecraft.network.chat.Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(reason, DisconnectionReason.game(cause));
    }

    public void disconnectAsync(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(PaperAdventure.asVanilla(reason), cause);
    }

    public void disconnectAsync(net.minecraft.network.chat.Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(reason, DisconnectionReason.game(cause));
    }

    public PaperPlayerGameConnection paperConnection() {
        return this.playerGameConnection;
    }

    private /* synthetic */ void lambda$handleChat$13(PlayerChatMessage signedMessage, CompletableFuture componentFuture, CompletableFuture completableFuture, Void $) {
        PlayerChatMessage playerChatMessage = signedMessage.withUnsignedContent((net.minecraft.network.chat.Component)componentFuture.join()).filter(((FilteredText)completableFuture.join()).mask());
        this.broadcastChatMessage(playerChatMessage);
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, net.minecraft.world.entity.Entity var2, InteractionHand var3);
    }
}

