/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Splitter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.LinkFSFileStore;
import net.minecraft.server.packs.linkfs.LinkFSPath;
import net.minecraft.server.packs.linkfs.LinkFSProvider;
import net.minecraft.server.packs.linkfs.PathContents;

public class LinkFileSystem
extends FileSystem {
    private static final Set<String> VIEWS = Set.of("basic");
    public static final String PATH_SEPARATOR = "/";
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');
    private final FileStore store;
    private final FileSystemProvider provider = new LinkFSProvider();
    private final LinkFSPath root;

    LinkFileSystem(String name, DirectoryEntry root) {
        this.store = new LinkFSFileStore(name);
        this.root = LinkFileSystem.buildPath(root, this, "", null);
    }

    private static LinkFSPath buildPath(DirectoryEntry directory, LinkFileSystem fileSystem, String name, @Nullable LinkFSPath parent) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        LinkFSPath linkFsPath = new LinkFSPath(fileSystem, name, parent, new PathContents.DirectoryContents((Map<String, LinkFSPath>)map));
        directory.files.forEach((fileName, path) -> map.put(fileName, (Object)new LinkFSPath(fileSystem, (String)fileName, linkFsPath, new PathContents.FileContents((Path)path))));
        directory.children.forEach((fileName, directory1) -> map.put(fileName, (Object)LinkFileSystem.buildPath(directory1, fileSystem, fileName, linkFsPath)));
        map.trim();
        return linkFsPath;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return PATH_SEPARATOR;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return List.of(this.store);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        String string;
        Stream<String> stream = Stream.of(first);
        if (more.length > 0) {
            stream = Stream.concat(stream, Stream.of(more));
        }
        if ((string = stream.collect(Collectors.joining(PATH_SEPARATOR))).equals(PATH_SEPARATOR)) {
            return this.root;
        }
        if (string.startsWith(PATH_SEPARATOR)) {
            LinkFSPath linkFsPath = this.root;
            for (String string1 : PATH_SPLITTER.split((CharSequence)string.substring(1))) {
                if (string1.isEmpty()) {
                    throw new IllegalArgumentException("Empty paths not allowed");
                }
                linkFsPath = linkFsPath.resolveName(string1);
            }
            return linkFsPath;
        }
        LinkFSPath linkFsPath = null;
        for (String string1 : PATH_SPLITTER.split((CharSequence)string)) {
            if (string1.isEmpty()) {
                throw new IllegalArgumentException("Empty paths not allowed");
            }
            linkFsPath = new LinkFSPath(this, string1, linkFsPath, PathContents.RELATIVE);
        }
        if (linkFsPath == null) {
            throw new IllegalArgumentException("Empty paths not allowed");
        }
        return linkFsPath;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public FileStore store() {
        return this.store;
    }

    public LinkFSPath rootPath() {
        return this.root;
    }

    public static Builder builder() {
        return new Builder();
    }

    record DirectoryEntry(Map<String, DirectoryEntry> children, Map<String, Path> files) {
        public DirectoryEntry() {
            this(new HashMap<String, DirectoryEntry>(), new HashMap<String, Path>());
        }
    }

    public static class Builder {
        private final DirectoryEntry root = new DirectoryEntry();

        public Builder put(List<String> pathString, String fileName, Path filePath) {
            DirectoryEntry directoryEntry = this.root;
            for (String string : pathString) {
                directoryEntry = directoryEntry.children.computeIfAbsent(string, string1 -> new DirectoryEntry());
            }
            directoryEntry.files.put(fileName, filePath);
            return this;
        }

        public Builder put(List<String> pathString, Path filePath) {
            if (pathString.isEmpty()) {
                throw new IllegalArgumentException("Path can't be empty");
            }
            int i = pathString.size() - 1;
            return this.put(pathString.subList(0, i), pathString.get(i), filePath);
        }

        public FileSystem build(String name) {
            return new LinkFileSystem(name, this.root);
        }
    }
}

