/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;

public record NameAndId(UUID id, String name) {
    public static final Codec<NameAndId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(NameAndId::id), (App)Codec.STRING.fieldOf("name").forGetter(NameAndId::name)).apply((Applicative)instance, NameAndId::new));

    public NameAndId(GameProfile profile) {
        this(profile.id(), profile.name());
    }

    public NameAndId(com.mojang.authlib.yggdrasil.response.NameAndId nameAndId) {
        this(nameAndId.id(), nameAndId.name());
    }

    @Nullable
    public static NameAndId fromJson(JsonObject json) {
        if (json.has("uuid") && json.has("name")) {
            UUID uuid;
            String asString = json.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(asString);
            }
            catch (Throwable var4) {
                return null;
            }
            return new NameAndId(uuid, json.get("name").getAsString());
        }
        return null;
    }

    public void appendTo(JsonObject json) {
        json.addProperty("uuid", this.id().toString());
        json.addProperty("name", this.name());
    }

    public static NameAndId createOffline(String name) {
        UUID uuid = UUIDUtil.createOfflinePlayerUUID(name);
        return new NameAndId(uuid, name);
    }

    public GameProfile toUncompletedGameProfile() {
        return new GameProfile(this.id, this.name);
    }
}

