/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.event.player.PlayerServerFullCheckEvent;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHeldSlotPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.NotNull;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final net.minecraft.network.chat.Component CHAT_FILTERED_FULL = net.minecraft.network.chat.Component.translatable("chat.filtered_full");
    public static final net.minecraft.network.chat.Component DUPLICATE_LOGIN_DISCONNECT_MESSAGE = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.duplicate_login");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    public final List<ServerPlayer> players = new CopyOnWriteArrayList<ServerPlayer>();
    private final Map<UUID, ServerPlayer> playersByUUID = Maps.newHashMap();
    private final UserBanList bans;
    private final IpBanList ipBans;
    private final ServerOpList ops;
    private final UserWhiteList whitelist;
    public final PlayerDataStorage playerIo;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCommandsForAllPlayers;
    private int sendAllPlayerInfoIn;
    private CraftServer cserver;
    private final Map<String, ServerPlayer> playersByName = new HashMap<String, ServerPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public PlayerList(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registries, PlayerDataStorage playerIo, NotificationService notificationService) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.server = server;
        this.registries = registries;
        this.playerIo = playerIo;
        this.whitelist = new UserWhiteList(WHITELIST_FILE, notificationService);
        this.ops = new ServerOpList(OPLIST_FILE, notificationService);
        this.bans = new UserBanList(USERBANLIST_FILE, notificationService);
        this.ipBans = new IpBanList(IPBANLIST_FILE, notificationService);
    }

    public abstract void loadAndSaveFiles();

    public void placeNewPlayer(Connection connection, ServerPlayer player, CommonListenerCookie cookie) {
        player.isRealPlayer = true;
        player.loginTime = System.currentTimeMillis();
        NameAndId nameAndId = player.nameAndId();
        UserNameToIdResolver userNameToIdResolver = this.server.services().nameToIdCache();
        Optional<NameAndId> optional = userNameToIdResolver.get(nameAndId.id());
        String string = optional.map(NameAndId::name).orElse(nameAndId.name());
        if (player.lastKnownName != null) {
            string = player.lastKnownName;
            player.lastKnownName = null;
        }
        userNameToIdResolver.add(nameAndId);
        ServerLevel serverLevel = player.level();
        String loggableAddress = connection.getLoggableAddress(this.server.logIPs());
        LevelData levelData = serverLevel.getLevelData();
        ServerGamePacketListenerImpl serverGamePacketListenerImpl = new ServerGamePacketListenerImpl(this.server, connection, player, cookie);
        connection.setupInboundProtocol(GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator(this.server.registryAccess()), serverGamePacketListenerImpl), serverGamePacketListenerImpl);
        GameRules gameRules = serverLevel.getGameRules();
        boolean _boolean = gameRules.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean _boolean1 = gameRules.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        boolean _boolean2 = gameRules.getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        serverGamePacketListenerImpl.send(new ClientboundLoginPacket(player.getId(), levelData.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), serverLevel.spigotConfig.viewDistance, serverLevel.spigotConfig.simulationDistance, _boolean1, !_boolean, _boolean2, player.createCommonSpawnInfo(serverLevel), this.server.enforceSecureProfile()));
        player.getBukkitEntity().sendSupportedChannels();
        serverGamePacketListenerImpl.send(new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked()));
        serverGamePacketListenerImpl.send(new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        serverGamePacketListenerImpl.send(new ClientboundSetHeldSlotPacket(player.getInventory().getSelectedSlot()));
        RecipeManager recipeManager = this.server.getRecipeManager();
        serverGamePacketListenerImpl.send(new ClientboundUpdateRecipesPacket(recipeManager.getSynchronizedItemProperties(), recipeManager.getSynchronizedStonecutterRecipes()));
        this.sendPlayerPermissionLevel(player);
        player.getStats().markAllDirty();
        player.getRecipeBook().sendInitialRecipeBook(player);
        this.updateEntireScoreboard(serverLevel.getScoreboard(), player);
        this.server.invalidateStatus();
        MutableComponent mutableComponent = player.getGameProfile().name().equalsIgnoreCase(string) ? net.minecraft.network.chat.Component.translatable("multiplayer.player.joined", player.getDisplayName()) : net.minecraft.network.chat.Component.translatable("multiplayer.player.joined.renamed", player.getDisplayName(), string);
        mutableComponent.withStyle(ChatFormatting.YELLOW);
        net.minecraft.network.chat.Component joinMessage = mutableComponent;
        serverGamePacketListenerImpl.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        ServerStatus status = this.server.getStatus();
        if (status != null && !cookie.transferred()) {
            player.sendServerStatus(status);
        }
        this.players.add(player);
        this.playersByName.put(player.getScoreboardName().toLowerCase(Locale.ROOT), player);
        this.playersByUUID.put(player.getUUID(), player);
        player.suppressTrackerForLogin = true;
        this.sendLevelInfo(player, serverLevel);
        serverLevel.addNewPlayer(player);
        this.server.getCustomBossEvents().onPlayerConnect(player);
        player.initInventoryMenu();
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.containerMenu.transferTo(player.containerMenu, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((org.bukkit.entity.Player)bukkitPlayer, PaperAdventure.asAdventure(mutableComponent));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.connection.isAcceptingMessages()) {
            return;
        }
        Component jm = playerJoinEvent.joinMessage();
        if (jm != null && !jm.equals((Object)Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.server.getPlayerList().broadcastSystemMessage(joinMessage, false);
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(player));
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.players.size() - 1));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer1 = this.players.get(i);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                if (entityplayer1.getBukkitEntity().isListed(bukkitPlayer)) {
                    entityplayer1.connection.send(packet);
                } else {
                    entityplayer1.connection.send(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing(player, false));
                }
            }
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.suppressTrackerForLogin = false;
        player.level().getChunkSource().chunkMap.addEntity(player);
        this.sendLevelInfo(player, serverLevel);
        if (player.level() == serverLevel && !serverLevel.players().contains(player)) {
            serverLevel.addNewPlayer(player);
            this.server.getCustomBossEvents().onPlayerConnect(player);
        }
        serverLevel = player.level();
        this.sendActivePlayerEffects(player);
        player.initInventoryMenu();
        this.server.notificationManager().playerJoined(player);
        ServerScoreboard scoreboard = this.getServer().getLevel(Level.OVERWORLD).getScoreboard();
        PlayerTeam collideRuleTeam = scoreboard.getPlayerTeam(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.getTeam() == null) {
            ((Scoreboard)scoreboard).addPlayerToTeam(player.getScoreboardName(), collideRuleTeam);
        }
        BossBarTask.addToAll(player);
        LOGGER.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{player.getPlainTextName(), loggableAddress, player.getId(), serverLevel.serverLevelData.getLevelName(), player.getX(), player.getY(), player.getZ()});
        if (player.isDeadOrDying()) {
            Holder.Reference plains = serverLevel.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
            player.connection.send(new ClientboundLevelChunkWithLightPacket(new EmptyLevelChunk((Level)serverLevel, player.chunkPosition(), plains), serverLevel.getLightEngine(), null, null, true));
        }
    }

    public void updateEntireScoreboard(ServerScoreboard scoreboard, ServerPlayer player) {
        HashSet set = Sets.newHashSet();
        for (PlayerTeam playerTeam : scoreboard.getPlayerTeams()) {
            player.connection.send(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(playerTeam, true));
        }
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            Objective displayObjective = scoreboard.getDisplayObjective(displaySlot);
            if (displayObjective == null || set.contains(displayObjective)) continue;
            for (Packet<?> packet : scoreboard.getStartTrackingPackets(displayObjective)) {
                player.connection.send(packet);
            }
            set.add(displayObjective);
        }
    }

    private void broadcastWorldborder(Packet<?> packet, ResourceKey<Level> dimension) {
        for (ServerPlayer serverPlayer : this.players) {
            if (serverPlayer.level().dimension() != dimension || serverPlayer.getBukkitEntity().getWorldBorder() != null) continue;
            serverPlayer.connection.send(packet);
        }
    }

    public void addWorldborderListener(final ServerLevel level) {
        level.getWorldBorder().addListener(new BorderChangeListener(){

            @Override
            public void onSetSize(WorldBorder border, double size) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderSizePacket(border), level.dimension());
            }

            @Override
            public void onLerpSize(WorldBorder border, double oldSize, double newSize, long time) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderLerpSizePacket(border), level.dimension());
            }

            @Override
            public void onSetCenter(WorldBorder border, double x, double z) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderCenterPacket(border), level.dimension());
            }

            @Override
            public void onSetWarningTime(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderWarningDelayPacket(border), level.dimension());
            }

            @Override
            public void onSetWarningBlocks(WorldBorder border, int warningBlocks) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderWarningDistancePacket(border), level.dimension());
            }

            @Override
            public void onSetDamagePerBlock(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void onSetSafeZone(WorldBorder border, double safeZone) {
            }
        });
    }

    public Optional<CompoundTag> loadPlayerData(NameAndId nameAndId) {
        CompoundTag loadedPlayerTag = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(nameAndId) && loadedPlayerTag != null) {
            LOGGER.debug("loading single player");
            return Optional.of(loadedPlayerTag);
        }
        return this.playerIo.load(nameAndId);
    }

    protected void save(ServerPlayer player) {
        PlayerAdvancements playerAdvancements;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        player.lastSave = MinecraftServer.currentTick;
        this.playerIo.save(player);
        ServerStatsCounter serverStatsCounter = player.getStats();
        if (serverStatsCounter != null) {
            serverStatsCounter.save();
        }
        if ((playerAdvancements = player.getAdvancements()) != null) {
            playerAdvancements.save();
        }
    }

    @Nullable
    public Component remove(ServerPlayer player) {
        return this.remove(player, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? player.getBukkitEntity().displayName() : PaperAdventure.asAdventure(player.getDisplayName())}));
    }

    @Nullable
    public Component remove(ServerPlayer player, Component leaveMessage) {
        Object rootVehicle;
        BossBarTask.removeFromAll(player.getBukkitEntity());
        ServerLevel serverLevel = player.level();
        player.awardStat(Stats.LEAVE_GAME);
        if (player.containerMenu != player.inventoryMenu) {
            player.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((org.bukkit.entity.Player)player.getBukkitEntity(), leaveMessage, player.quitReason);
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        player.getBukkitEntity().disconnect();
        if (this.server.isSameThread()) {
            player.doTick();
        }
        if (this.collideRuleTeamName != null) {
            ServerScoreboard scoreBoard = this.server.getLevel(Level.OVERWORLD).getScoreboard();
            PlayerTeam team = scoreBoard.getPlayersTeam(this.collideRuleTeamName);
            if (player.getTeam() == team && team != null) {
                ((Scoreboard)scoreBoard).removePlayerFromTeam(player.getScoreboardName(), team);
            }
        }
        if (!player.containerMenu.getCarried().isEmpty()) {
            ItemStack carried = player.containerMenu.getCarried();
            player.containerMenu.setCarried(ItemStack.EMPTY);
            player.drop(carried, false);
        }
        this.save(player);
        if (player.isPassenger() && ((Entity)(rootVehicle = player.getRootVehicle())).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            player.stopRiding();
            ((Entity)rootVehicle).getPassengersAndSelf().forEach(entity -> {
                AbstractVillager villager;
                Player human;
                if (entity instanceof AbstractVillager && (human = (villager = (AbstractVillager)entity).getTradingPlayer()) != null) {
                    villager.setTradingPlayer(null);
                }
                entity.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER, EntityRemoveEvent.Cause.PLAYER_QUIT);
            });
        }
        player.unRide();
        for (ThrownEnderpearl thrownEnderpearl : player.getEnderPearls()) {
            if (thrownEnderpearl.level().paperConfig().misc.legacyEnderPearlBehavior) continue;
            thrownEnderpearl.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER, EntityRemoveEvent.Cause.PLAYER_QUIT);
        }
        serverLevel.removePlayerImmediately(player, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        player.retireScheduler();
        player.getAdvancements().stopListening();
        this.players.remove(player);
        this.playersByName.remove(player.getScoreboardName().toLowerCase(Locale.ROOT));
        this.server.getCustomBossEvents().onPlayerDisconnect(player);
        UUID uuid = player.getUUID();
        ServerPlayer serverPlayer = this.playersByUUID.get(uuid);
        if (serverPlayer == player) {
            this.playersByUUID.remove(uuid);
            this.server.notificationManager().playerLeft(player);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(player.getUUID()));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer otherPlayer = this.players.get(i);
            if (otherPlayer.getBukkitEntity().canSee(player.getBukkitEntity())) {
                otherPlayer.connection.send(packet);
                continue;
            }
            otherPlayer.getBukkitEntity().onEntityRemove(player);
        }
        this.cserver.getScoreboardManager().removePlayer(player.getBukkitEntity());
        return playerQuitEvent.quitMessage();
    }

    public LoginResult canPlayerLogin(SocketAddress socketAddress, NameAndId nameAndId) {
        UserBanListEntry userBanListEntry;
        if (this.bans.isBanned(nameAndId) && (userBanListEntry = (UserBanListEntry)this.bans.get(nameAndId)) != null) {
            MutableComponent mutableComponent = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned.reason", userBanListEntry.getReasonMessage());
            if (userBanListEntry.getExpires() != null) {
                mutableComponent.append(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format(userBanListEntry.getExpires())));
            }
            return new LoginResult(mutableComponent, PlayerLoginEvent.Result.KICK_BANNED);
        }
        LoginResult whitelistEventResult = this.isWhiteListedLogin(nameAndId);
        if (whitelistEventResult.result == PlayerLoginEvent.Result.KICK_WHITELIST) {
            return whitelistEventResult;
        }
        if (this.ipBans.isBanned(socketAddress)) {
            IpBanListEntry ipBanListEntry = this.ipBans.get(socketAddress);
            MutableComponent mutableComponent = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned_ip.reason", ipBanListEntry.getReasonMessage());
            if (ipBanListEntry.getExpires() != null) {
                mutableComponent.append(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format(ipBanListEntry.getExpires())));
            }
            return new LoginResult(mutableComponent, PlayerLoginEvent.Result.KICK_BANNED);
        }
        return this.canBypassFullServerLogin(nameAndId, new LoginResult(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.server_full"), PlayerLoginEvent.Result.KICK_FULL));
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile profile) {
        UUID profileId = profile.id();
        Set set = Sets.newIdentityHashSet();
        for (ServerPlayer serverPlayer : this.players) {
            if (!serverPlayer.getUUID().equals(profileId) && (!GlobalConfiguration.get().proxies.isProxyOnlineMode() || !serverPlayer.getGameProfile().name().equalsIgnoreCase(profile.name()))) continue;
            set.add(serverPlayer);
        }
        ServerPlayer serverPlayer1 = this.playersByUUID.get(profileId);
        if (serverPlayer1 != null) {
            set.add(serverPlayer1);
        }
        for (ServerPlayer serverPlayer2 : set) {
            serverPlayer2.connection.disconnect(DUPLICATE_LOGIN_DISCONNECT_MESSAGE, DisconnectionReason.DUPLICATE_LOGIN_MESSAGE);
        }
        return !set.isEmpty();
    }

    public ServerPlayer respawn(ServerPlayer player, boolean keepInventory, Entity.RemovalReason reason, PlayerRespawnEvent.RespawnReason respawnReason) {
        BlockPos blockPos;
        BlockState blockState;
        LevelData.RespawnData respawnData;
        ServerLevel level1;
        ServerPlayer.RespawnResult result = player.findRespawnPositionAndUseSpawnBlock0(!keepInventory, TeleportTransition.DO_NOTHING, respawnReason);
        if (result == null) {
            return player;
        }
        TeleportTransition teleportTransition = result.transition();
        ServerLevel fromLevel = player.level();
        this.players.remove(player);
        this.playersByName.remove(player.getScoreboardName().toLowerCase(Locale.ROOT));
        player.level().removePlayerImmediately(player, reason);
        ServerLevel level = teleportTransition.newLevel();
        ServerPlayer serverPlayer = player;
        serverPlayer.connection = player.connection;
        serverPlayer.restoreFrom(player, keepInventory);
        serverPlayer.setId(player.getId());
        serverPlayer.setMainArm(player.getMainArm());
        for (String string : player.getTags()) {
            serverPlayer.addTag(string);
        }
        if (!keepInventory) {
            player.reset();
        }
        serverPlayer.spawnIn(level);
        serverPlayer.unsetRemoved();
        serverPlayer.setShiftKeyDown(false);
        Vec3 vec3 = teleportTransition.position();
        serverPlayer.snapTo(vec3.x, vec3.y, vec3.z, teleportTransition.yRot(), teleportTransition.xRot());
        serverPlayer.connection.resetPosition();
        level.getChunkSource().addTicketWithRadius(TicketType.POST_TELEPORT, new ChunkPos(Mth.floor(vec3.x()) >> 4, Mth.floor(vec3.z()) >> 4), 1);
        if (teleportTransition.missingRespawnBlock()) {
            serverPlayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
            serverPlayer.setRespawnPosition(null, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
        }
        byte b = keepInventory ? (byte)1 : 0;
        ServerLevel serverLevel = serverPlayer.level();
        LevelData levelData = serverLevel.getLevelData();
        serverPlayer.connection.send(new ClientboundRespawnPacket(serverPlayer.createCommonSpawnInfo(serverLevel), b));
        serverPlayer.connection.internalTeleport(serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), serverPlayer.getYRot(), serverPlayer.getXRot());
        serverPlayer.connection.send(new ClientboundSetDefaultSpawnPositionPacket(level.getRespawnData()));
        serverPlayer.connection.send(new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked()));
        serverPlayer.connection.send(new ClientboundSetExperiencePacket(serverPlayer.experienceProgress, serverPlayer.totalExperience, serverPlayer.experienceLevel));
        this.sendActivePlayerEffects(serverPlayer);
        this.sendLevelInfo(serverPlayer, level);
        this.sendPlayerPermissionLevel(serverPlayer);
        level.addRespawnedPlayer(serverPlayer);
        this.players.add(serverPlayer);
        this.playersByName.put(serverPlayer.getScoreboardName().toLowerCase(Locale.ROOT), serverPlayer);
        this.playersByUUID.put(serverPlayer.getUUID(), serverPlayer);
        serverPlayer.initInventoryMenu();
        serverPlayer.setHealth(serverPlayer.getHealth());
        this.sendAllPlayerInfo(player);
        player.onUpdateAbilities();
        ServerPlayer.RespawnConfig respawnConfig = serverPlayer.getRespawnConfig();
        if (!keepInventory && respawnConfig != null && (level1 = this.server.getLevel((respawnData = respawnConfig.respawnData()).dimension())) != null && (blockState = level1.getBlockState(blockPos = respawnData.pos())).is(Blocks.RESPAWN_ANCHOR)) {
            serverPlayer.connection.send(new ClientboundSoundPacket(SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.BLOCKS, blockPos.getX(), blockPos.getY(), blockPos.getZ(), 1.0f, 1.0f, level.getRandom().nextLong()));
        }
        if (serverPlayer.connection.isDisconnected()) {
            this.save(serverPlayer);
        }
        if (fromLevel != level) {
            new PlayerChangedWorldEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (World)fromLevel.getWorld()).callEvent();
            serverPlayer.triggerDimensionChangeTriggers(level);
        }
        new PlayerPostRespawnEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), CraftLocation.toBukkit(teleportTransition.position(), (Level)level, teleportTransition.yRot(), teleportTransition.xRot()), result.isBedSpawn(), result.isAnchorSpawn(), teleportTransition.missingRespawnBlock(), respawnReason).callEvent();
        return serverPlayer;
    }

    public void sendActivePlayerEffects(ServerPlayer player) {
        this.sendActiveEffects((LivingEntity)player, player.connection);
    }

    public void sendActiveEffects(LivingEntity entity, ServerGamePacketListenerImpl connection) {
        this.sendActiveEffects(entity, connection::send);
    }

    public void sendActiveEffects(LivingEntity entity, Consumer<Packet<? super ClientGamePacketListener>> packetConsumer) {
        for (MobEffectInstance mobEffectInstance : entity.getActiveEffects()) {
            packetConsumer.accept(new ClientboundUpdateMobEffectPacket(entity.getId(), mobEffectInstance, false));
        }
    }

    public void sendPlayerPermissionLevel(ServerPlayer player) {
        this.sendPlayerPermissionLevel(player, true);
    }

    public void sendPlayerPermissionLevel(ServerPlayer player, boolean recalculatePermissions) {
        int profilePermissions = this.server.getProfilePermissions(player.nameAndId());
        this.sendPlayerPermissionLevel(player, profilePermissions, recalculatePermissions);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            for (int i = 0; i < this.players.size(); ++i) {
                ServerPlayer target = this.players.get(i);
                target.connection.send(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY), Collections2.filter(this.players, t -> target.getBukkitEntity().canSee(t.getBukkitEntity()))));
            }
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet packet, Player entityhuman) {
        for (ServerPlayer entityplayer : this.players) {
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, Level world) {
        for (int i = 0; i < world.players().size(); ++i) {
            ((ServerPlayer)world.players().get((int)i)).connection.send(packet);
        }
    }

    public void broadcastAll(Packet<?> packet) {
        for (ServerPlayer serverPlayer : this.players) {
            serverPlayer.connection.send(packet);
        }
    }

    public void broadcastMiniMessage(@Nullable String message, boolean overlay) {
        if (message != null && !message.isEmpty()) {
            this.broadcastMessage(MiniMessage.miniMessage().deserialize((Object)message), overlay);
        }
    }

    public void broadcastMessage(@Nullable Component message, boolean overlay) {
        if (message != null) {
            this.broadcastSystemMessage(PaperAdventure.asVanilla(message), overlay);
        }
    }

    public void broadcastAll(Packet<?> packet, ResourceKey<Level> dimension) {
        for (ServerPlayer serverPlayer : this.players) {
            if (serverPlayer.level().dimension() != dimension) continue;
            serverPlayer.connection.send(packet);
        }
    }

    public void broadcastSystemToTeam(Player player, net.minecraft.network.chat.Component message) {
        PlayerTeam team = player.getTeam();
        if (team != null) {
            for (String string : ((Team)team).getPlayers()) {
                ServerPlayer playerByName = this.getPlayerByName(string);
                if (playerByName == null || playerByName == player) continue;
                playerByName.sendSystemMessage(message);
            }
        }
    }

    public void broadcastSystemToAllExceptTeam(Player player, net.minecraft.network.chat.Component message) {
        PlayerTeam team = player.getTeam();
        if (team == null) {
            this.broadcastSystemMessage(message, false);
        } else {
            for (int i = 0; i < this.players.size(); ++i) {
                ServerPlayer serverPlayer = this.players.get(i);
                if (serverPlayer.getTeam() == team) continue;
                serverPlayer.sendSystemMessage(message);
            }
        }
    }

    public String[] getPlayerNamesArray() {
        String[] strings = new String[this.players.size()];
        for (int i = 0; i < this.players.size(); ++i) {
            strings[i] = this.players.get(i).getGameProfile().name();
        }
        return strings;
    }

    public UserBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(NameAndId nameAndId) {
        this.op(nameAndId, Optional.empty(), Optional.empty());
    }

    public void op(NameAndId nameAndId, Optional<Integer> level, Optional<Boolean> bypassesPlayerLimit) {
        this.ops.add(new ServerOpListEntry(nameAndId, level.orElse(this.server.operatorUserPermissionLevel()), bypassesPlayerLimit.orElse(this.ops.canBypassPlayerLimit(nameAndId))));
        ServerPlayer player = this.getPlayer(nameAndId.id());
        if (player != null) {
            this.sendPlayerPermissionLevel(player);
        }
    }

    public void deop(NameAndId nameAndId) {
        ServerPlayer player;
        if (this.ops.remove(nameAndId) && (player = this.getPlayer(nameAndId.id())) != null) {
            this.sendPlayerPermissionLevel(player);
        }
    }

    private void sendPlayerPermissionLevel(ServerPlayer player, int permLevel) {
        this.sendPlayerPermissionLevel(player, permLevel, true);
    }

    public void sendPlayerPermissionLevel(ServerPlayer player, int permLevel, boolean recalculatePermissions) {
        if (player.connection != null) {
            byte b = permLevel <= 0 ? (byte)24 : (permLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permLevel)));
            if (b < 28 && player.getBukkitEntity().hasPermission("purpur.debug.f3n")) {
                b = 28;
            }
            player.connection.send(new ClientboundEntityEventPacket(player, b));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.server.getCommands().sendCommands(player);
        }
        if (PurpurConfig.enderChestSixRows && PurpurConfig.enderChestPermissionRows) {
            CraftPlayer bukkit = player.getBukkitEntity();
            if (bukkit.hasPermission("purpur.enderchest.rows.six")) {
                player.sixRowEnderchestSlotCount = 54;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.five")) {
                player.sixRowEnderchestSlotCount = 45;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.four")) {
                player.sixRowEnderchestSlotCount = 36;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.three")) {
                player.sixRowEnderchestSlotCount = 27;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.two")) {
                player.sixRowEnderchestSlotCount = 18;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.one")) {
                player.sixRowEnderchestSlotCount = 9;
            }
        } else {
            player.sixRowEnderchestSlotCount = -1;
        }
    }

    public LoginResult canBypassFullServerLogin(NameAndId nameAndId, LoginResult currentResult) {
        boolean shouldKick = this.players.size() >= this.getMaxPlayers() && !this.canBypassPlayerLimit(nameAndId);
        PlayerServerFullCheckEvent fullCheckEvent = new PlayerServerFullCheckEvent((PlayerProfile)new CraftPlayerProfile(nameAndId), PaperAdventure.asAdventure(currentResult.message), shouldKick);
        fullCheckEvent.callEvent();
        if (fullCheckEvent.isAllowed()) {
            return LoginResult.ALLOW;
        }
        return new LoginResult(PaperAdventure.asVanilla(fullCheckEvent.kickMessage()), currentResult.result);
    }

    public LoginResult isWhiteListedLogin(NameAndId nameAndId) {
        boolean isOp = this.ops.contains(nameAndId);
        boolean isWhitelisted = !this.isUsingWhitelist() || isOp || this.whitelist.contains(nameAndId);
        TextComponent configuredMessage = LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.whitelistMessage);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent((PlayerProfile)new CraftPlayerProfile(nameAndId), this.isUsingWhitelist(), isWhitelisted, isOp, (Component)configuredMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            return new LoginResult(PaperAdventure.asVanilla((Component)(event.kickMessage() == null ? configuredMessage : event.kickMessage())), PlayerLoginEvent.Result.KICK_WHITELIST);
        }
        return LoginResult.ALLOW;
    }

    @DoNotUse
    public boolean isWhiteListed(NameAndId nameAndId) {
        return !this.isUsingWhitelist() || this.ops.contains(nameAndId) || this.whitelist.contains(nameAndId);
    }

    public boolean isOp(NameAndId nameAndId) {
        return this.ops.contains(nameAndId) || this.server.isSingleplayerOwner(nameAndId) && this.server.getWorldData().isAllowCommands() || this.allowCommandsForAllPlayers;
    }

    @Nullable
    public ServerPlayer getPlayerByName(String username) {
        return this.playersByName.get(username.toLowerCase(Locale.ROOT));
    }

    public void broadcast(@Nullable Player except, double x, double y, double z, double radius, ResourceKey<Level> dimension, Packet<?> packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            double d2;
            double d1;
            double d;
            ServerPlayer serverPlayer = this.players.get(i);
            if (except != null && !serverPlayer.getBukkitEntity().canSee(except.getBukkitEntity()) || serverPlayer == except || serverPlayer.level().dimension() != dimension || !((d = x - serverPlayer.getX()) * d + (d1 = y - serverPlayer.getY()) * d1 + (d2 = z - serverPlayer.getZ()) * d2 < radius * radius)) continue;
            serverPlayer.connection.send(packet);
        }
    }

    public void saveAll() {
        this.saveAll(-1);
    }

    public void saveAll(int interval) {
        MCUtil.ensureMain("Save Players", () -> {
            int numSaved = 0;
            long now = MinecraftServer.currentTick;
            for (int i = 0; i < this.players.size(); ++i) {
                ServerPlayer player = this.players.get(i);
                if (interval != -1 && now - player.lastSave < (long)interval) continue;
                this.save(player);
                if (interval != -1 && ++numSaved >= GlobalConfiguration.get().playerAutoSave.maxPerTick()) break;
            }
            return null;
        });
    }

    public UserWhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public ServerOpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(ServerPlayer player, ServerLevel level) {
        WorldBorder worldBorder = level.getWorldBorder();
        player.connection.send(new ClientboundInitializeBorderPacket(worldBorder));
        player.connection.send(new ClientboundSetTimePacket(level.getGameTime(), level.getDayTime(), level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        player.connection.send(new ClientboundSetDefaultSpawnPositionPacket(level.getRespawnData()));
        player.connection.send(new ClientboundSetChunkCacheRadiusPacket(level.spigotConfig.viewDistance));
        player.connection.send(new ClientboundSetSimulationDistancePacket(level.spigotConfig.simulationDistance));
        if (level.isRaining()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-level.rainLevel, level.rainLevel, -level.thunderLevel, level.thunderLevel);
        }
        player.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.server.tickRateManager().updateJoiningPlayer(player);
    }

    public void sendAllPlayerInfo(ServerPlayer player) {
        player.inventoryMenu.sendAllDataToRemote();
        Collection<AttributeInstance> syncableAttributes = player.getAttributes().getSyncableAttributes();
        player.getBukkitEntity().injectScaledMaxHealth(syncableAttributes, true);
        player.connection.send(new ClientboundUpdateAttributesPacket(player.getId(), syncableAttributes));
        player.refreshEntityData(player);
        player.connection.send(new ClientboundSetHeldSlotPacket(player.getInventory().getSelectedSlot()));
        int i = player.level().getGameRules().getBoolean(GameRules.RULE_REDUCEDDEBUGINFO) ? 22 : 23;
        player.connection.send(new ClientboundEntityEventPacket(player, (byte)i));
        float immediateRespawn = player.level().getGameRules().getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN) ? 1.0f : 0.0f;
        player.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, immediateRespawn));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    public boolean isUsingWhitelist() {
        return this.server.isUsingWhitelist();
    }

    public List<ServerPlayer> getPlayersWithAddress(String address) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayer serverPlayer : this.players) {
            if (!serverPlayer.getIpAddress().equals(address)) continue;
            list.add(serverPlayer);
        }
        return list;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public CompoundTag getSingleplayerData() {
        return null;
    }

    public void setAllowCommandsForAllPlayers(boolean allowCommandsForAllPlayers) {
        this.allowCommandsForAllPlayers = allowCommandsForAllPlayers;
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ServerScoreboard scoreboard;
        PlayerTeam team;
        for (ServerPlayer player : this.players) {
            if (isRestarting) {
                player.connection.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.restartMessage), PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.connection.disconnect(Objects.requireNonNullElseGet(this.server.server.shutdownMessage(), Component::empty));
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.getServer().getLevel(Level.OVERWORLD).getScoreboard()).getPlayersTeam(this.collideRuleTeamName)) != null) {
            scoreboard.removePlayerTeam(team);
        }
    }

    public void broadcastSystemMessage(net.minecraft.network.chat.Component message, boolean overlay) {
        this.broadcastSystemMessage(message, serverPlayer -> message, overlay);
    }

    public void broadcastSystemMessage(net.minecraft.network.chat.Component serverMessage, Function<ServerPlayer, net.minecraft.network.chat.Component> playerMessageFactory, boolean overlay) {
        this.server.sendSystemMessage(serverMessage);
        for (ServerPlayer serverPlayer : this.players) {
            net.minecraft.network.chat.Component component = playerMessageFactory.apply(serverPlayer);
            if (component == null) continue;
            serverPlayer.sendSystemMessage(component, overlay);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage message, CommandSourceStack sender, ChatType.Bound boundChatType) {
        this.broadcastChatMessage(message, sender::shouldFilterMessageTo, sender.getPlayer(), boundChatType);
    }

    public void broadcastChatMessage(PlayerChatMessage message, ServerPlayer sender, ChatType.Bound boundChatType) {
        this.broadcastChatMessage(message, sender, boundChatType, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, ServerPlayer sender, ChatType.Bound boundChatType, @Nullable Function<Audience, net.minecraft.network.chat.Component> unsignedFunction) {
        this.broadcastChatMessage(message, sender::shouldFilterMessageTo, sender, boundChatType, unsignedFunction);
    }

    private void broadcastChatMessage(PlayerChatMessage message, Predicate<ServerPlayer> shouldFilterMessageTo, @Nullable ServerPlayer sender, ChatType.Bound boundChatType) {
        this.broadcastChatMessage(message, shouldFilterMessageTo, sender, boundChatType, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, Predicate<ServerPlayer> shouldFilterMessageTo, @Nullable ServerPlayer sender, ChatType.Bound boundChatType, @Nullable Function<Audience, net.minecraft.network.chat.Component> unsignedFunction) {
        boolean flag = this.verifyChatTrusted(message);
        this.server.logChatMessage(unsignedFunction == null ? message.decoratedContent() : unsignedFunction.apply((Audience)this.server.console), boundChatType, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.create(message);
        boolean flag1 = false;
        ClientboundDisguisedChatPacket disguised = sender != null && unsignedFunction == null ? new ClientboundDisguisedChatPacket(outgoingChatMessage.content(), boundChatType) : null;
        for (ServerPlayer serverPlayer : this.players) {
            boolean flag2 = shouldFilterMessageTo.test(serverPlayer);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity())) {
                serverPlayer.connection.send(unsignedFunction != null ? new ClientboundDisguisedChatPacket(unsignedFunction.apply((Audience)serverPlayer.getBukkitEntity()), boundChatType) : disguised);
                continue;
            }
            serverPlayer.sendChatMessage(outgoingChatMessage, flag2, boundChatType, unsignedFunction == null ? null : unsignedFunction.apply((Audience)serverPlayer.getBukkitEntity()));
            flag1 |= flag2 && message.isFullyFiltered();
        }
        if (flag1 && sender != null) {
            sender.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    public boolean verifyChatTrusted(PlayerChatMessage message) {
        return message.hasSignature() && !message.hasExpiredServer(Instant.now());
    }

    public ServerStatsCounter getPlayerStats(ServerPlayer player) {
        ServerStatsCounter serverstatisticmanager = player.getStats();
        return serverstatisticmanager == null ? this.getPlayerStats(player.getUUID(), player.getGameProfile().name()) : serverstatisticmanager;
    }

    public ServerStatsCounter getPlayerStats(UUID uuid, String displayName) {
        ServerStatsCounter serverStatsCounter;
        ServerPlayer player = this.getPlayer(uuid);
        ServerStatsCounter serverStatsCounter2 = serverStatsCounter = player == null ? null : player.getStats();
        if (serverStatsCounter == null) {
            File file2;
            Path path;
            File file = this.server.getWorldPath(LevelResource.PLAYER_STATS_DIR).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtil.isPathNormalized(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtil.isPathPortable(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverStatsCounter = new ServerStatsCounter(this.server, file1);
        }
        return serverStatsCounter;
    }

    public PlayerAdvancements getPlayerAdvancements(ServerPlayer player) {
        UUID uuid = player.getUUID();
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        if (playerAdvancements == null) {
            Path path = this.server.getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR).resolve(String.valueOf(uuid) + ".json");
            playerAdvancements = new PlayerAdvancements(this.server.getFixerUpper(), this, this.server.getAdvancements(), path, player);
        }
        playerAdvancements.setPlayer(player);
        return playerAdvancements;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        for (ServerLevel serverLevel : this.server.getAllLevels()) {
            if (serverLevel == null) continue;
            serverLevel.getChunkSource().setViewDistance(viewDistance);
        }
    }

    public void setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
        for (ServerLevel serverLevel : this.server.getAllLevels()) {
            if (serverLevel == null) continue;
            serverLevel.getChunkSource().setSimulationDistance(simulationDistance);
        }
    }

    public List<ServerPlayer> getPlayers() {
        return this.players;
    }

    @Nullable
    public ServerPlayer getPlayer(UUID playerUUID) {
        return this.playersByUUID.get(playerUUID);
    }

    @Nullable
    public ServerPlayer getPlayer(String name) {
        for (ServerPlayer serverPlayer : this.players) {
            if (!serverPlayer.getGameProfile().name().equalsIgnoreCase(name)) continue;
            return serverPlayer;
        }
        return null;
    }

    public boolean canBypassPlayerLimit(NameAndId nameAndId) {
        return false;
    }

    public void reloadResources() {
        this.reloadAdvancementData();
        this.reloadTagData();
        this.reloadRecipes();
    }

    public void reloadAdvancementData() {
        for (ServerPlayer player : this.players) {
            player.getAdvancements().reload(this.server.getAdvancements());
            player.getAdvancements().flushDirty(player, false);
        }
    }

    public void reloadTagData() {
        this.broadcastAll(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
    }

    public void reloadRecipes() {
        RecipeManager recipeManager = this.server.getRecipeManager();
        ClientboundUpdateRecipesPacket clientboundUpdateRecipesPacket = new ClientboundUpdateRecipesPacket(recipeManager.getSynchronizedItemProperties(), recipeManager.getSynchronizedStonecutterRecipes());
        for (ServerPlayer serverPlayer : this.players) {
            serverPlayer.connection.send(clientboundUpdateRecipesPacket);
            serverPlayer.getRecipeBook().sendInitialRecipeBook(serverPlayer);
        }
    }

    public boolean isAllowCommandsForAllPlayers() {
        return this.allowCommandsForAllPlayers;
    }

    public record LoginResult(@Nullable net.minecraft.network.chat.Component message, @NotNull PlayerLoginEvent.Result result) {
        public static LoginResult ALLOW = new LoginResult(null, PlayerLoginEvent.Result.ALLOWED);

        public boolean isAllowed() {
            return this == ALLOW;
        }
    }
}

