/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.profile.PaperFilledProfileCache;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.StringUtil;

public interface ProfileResolver {
    public Optional<GameProfile> fetchByName(String var1);

    public Optional<GameProfile> fetchById(UUID var1);

    default public Optional<GameProfile> fetchByNameOrId(Either<String, UUID> nameOrId) {
        return nameOrId.map(this::fetchByName, this::fetchById);
    }

    public static class Cached
    implements ProfileResolver {
        private final LoadingCache<String, Optional<GameProfile>> profileCacheByName;
        final LoadingCache<UUID, Optional<GameProfile>> profileCacheById;

        public Cached(final MinecraftSessionService sessionService, final UserNameToIdResolver resolver, final PaperFilledProfileCache paperCache) {
            this.profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, Optional<GameProfile>>(this){

                public Optional<GameProfile> load(UUID id) {
                    ProfileResult profileResult = sessionService.fetchProfile(id, true);
                    return Optional.ofNullable(profileResult).map(ProfileResult::profile).map(profile -> {
                        paperCache.add((GameProfile)profile);
                        return profile;
                    });
                }
            });
            this.profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, Optional<GameProfile>>(){

                public Optional<GameProfile> load(String name) {
                    return resolver.get(name).flatMap(nameAndId -> (Optional)profileCacheById.getUnchecked((Object)nameAndId.id()));
                }
            });
        }

        @Override
        public Optional<GameProfile> fetchByName(String name) {
            return StringUtil.isValidPlayerName(name) ? (Optional)this.profileCacheByName.getUnchecked((Object)name) : Optional.empty();
        }

        @Override
        public Optional<GameProfile> fetchById(UUID id) {
            return (Optional)this.profileCacheById.getUnchecked((Object)id);
        }
    }
}

