/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.StoredUserEntry;

public class ServerOpListEntry
extends StoredUserEntry<NameAndId> {
    private final int level;
    private final boolean bypassesPlayerLimit;

    public ServerOpListEntry(NameAndId user, int level, boolean bypassesPlayerLimit) {
        super(user);
        this.level = level;
        this.bypassesPlayerLimit = bypassesPlayerLimit;
    }

    public ServerOpListEntry(JsonObject user) {
        super(NameAndId.fromJson(user));
        this.level = user.has("level") ? user.get("level").getAsInt() : 0;
        this.bypassesPlayerLimit = user.has("bypassesPlayerLimit") && user.get("bypassesPlayerLimit").getAsBoolean();
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getBypassesPlayerLimit() {
        return this.bypassesPlayerLimit;
    }

    @Override
    protected void serialize(JsonObject data) {
        if (this.getUser() != null) {
            ((NameAndId)this.getUser()).appendTo(data);
            data.addProperty("level", (Number)this.level);
            data.addProperty("bypassesPlayerLimit", Boolean.valueOf(this.bypassesPlayerLimit));
        }
    }
}

