/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.rcon.PktUtils;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.server.rcon.thread.GenericThread;
import org.slf4j.Logger;

public class RconClient
extends GenericThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SERVERDATA_AUTH = 3;
    private static final int SERVERDATA_EXECCOMMAND = 2;
    private static final int SERVERDATA_RESPONSE_VALUE = 0;
    private static final int SERVERDATA_AUTH_RESPONSE = 2;
    private static final int SERVERDATA_AUTH_FAILURE = -1;
    private boolean authed;
    private final Socket client;
    private final byte[] buf = new byte[1460];
    private final String rconPassword;
    private final DedicatedServer serverInterface;
    private final RconConsoleSource rconConsoleSource;

    RconClient(ServerInterface serverInterface, String rconPassword, Socket client) {
        super("RCON Client " + String.valueOf(client.getInetAddress()));
        this.serverInterface = (DedicatedServer)serverInterface;
        this.client = client;
        try {
            this.client.setSoTimeout(0);
        }
        catch (Exception var5) {
            this.running = false;
        }
        this.rconPassword = rconPassword;
        this.rconConsoleSource = new RconConsoleSource(this.serverInterface, client.getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block14: while (this.running) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.client.getInputStream());
                int i = bufferedInputStream.read(this.buf, 0, 1460);
                if (10 > i) {
                    return;
                }
                int i1 = 0;
                int i2 = PktUtils.intFromByteArray(this.buf, 0, i);
                if (i2 != i - 4) {
                    return;
                }
                int i3 = PktUtils.intFromByteArray(this.buf, i1 += 4, i);
                int i4 = PktUtils.intFromByteArray(this.buf, i1 += 4);
                i1 += 4;
                switch (i4) {
                    case 2: {
                        if (this.authed) {
                            String string1 = PktUtils.stringFromByteArray(this.buf, i1, i);
                            try {
                                this.sendCmdResponse(i3, this.serverInterface.runCommand(this.rconConsoleSource, string1));
                            }
                            catch (Exception var15) {
                                this.sendCmdResponse(i3, "Error executing: " + string1 + " (" + var15.getMessage() + ")");
                            }
                            continue block14;
                        }
                        this.sendAuthFailure();
                        continue block14;
                    }
                    case 3: {
                        String string = PktUtils.stringFromByteArray(this.buf, i1, i);
                        i1 += string.length();
                        if (!string.isEmpty() && string.equals(this.rconPassword)) {
                            this.authed = true;
                            this.send(i3, 2, "");
                            continue block14;
                        }
                        this.authed = false;
                        this.sendAuthFailure();
                        continue block14;
                    }
                }
                this.sendCmdResponse(i3, String.format(Locale.ROOT, "Unknown request %s", Integer.toHexString(i4)));
            }
            return;
        }
        catch (IOException bufferedInputStream) {
        }
        catch (Exception var17) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)var17);
        }
        finally {
            this.closeSocket();
            LOGGER.info("Thread {} shutting down", (Object)this.name);
            this.running = false;
        }
    }

    private void send(int id, int type, String message) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1248);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        dataOutputStream.writeInt(Integer.reverseBytes(bytes.length + 10));
        dataOutputStream.writeInt(Integer.reverseBytes(id));
        dataOutputStream.writeInt(Integer.reverseBytes(type));
        dataOutputStream.write(bytes);
        dataOutputStream.write(0);
        dataOutputStream.write(0);
        this.client.getOutputStream().write(byteArrayOutputStream.toByteArray());
    }

    private void sendAuthFailure() throws IOException {
        this.send(-1, 2, "");
    }

    private void sendCmdResponse(int id, String message) throws IOException {
        int i;
        int len = message.length();
        do {
            i = 4096 <= len ? 4096 : len;
            this.send(id, 0, message.substring(0, i));
        } while (0 != (len = (message = message.substring(i)).length()));
    }

    @Override
    public void stop() {
        this.running = false;
        this.closeSocket();
        super.stop();
    }

    private void closeSocket() {
        try {
            this.client.close();
        }
        catch (IOException var2) {
            LOGGER.warn("Failed to close socket", (Throwable)var2);
        }
    }
}

