/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;

public class BinaryAnimator {
    private final int animationLength;
    private final EasingFunction easingFunction;
    private int ticks;
    private int ticksOld;

    public BinaryAnimator(int animationLength, EasingFunction easingFunction) {
        this.animationLength = animationLength;
        this.easingFunction = easingFunction;
    }

    public BinaryAnimator(int animationLength) {
        this(animationLength, ticks -> ticks);
    }

    public void tick(boolean condition) {
        this.ticksOld = this.ticks;
        if (condition) {
            if (this.ticks < this.animationLength) {
                ++this.ticks;
            }
        } else if (this.ticks > 0) {
            --this.ticks;
        }
    }

    public float getFactor(float partialTick) {
        float f = Mth.lerp(partialTick, this.ticksOld, this.ticks) / (float)this.animationLength;
        return this.easingFunction.apply(f);
    }

    public static interface EasingFunction {
        public float apply(float var1);
    }
}

