/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

@FunctionalInterface
public interface FormattedCharSequence {
    public static final FormattedCharSequence EMPTY = sink -> true;

    public boolean accept(FormattedCharSink var1);

    public static FormattedCharSequence codepoint(int codePoint, Style style) {
        return sink -> sink.accept(0, style, codePoint);
    }

    public static FormattedCharSequence forward(String text, Style style) {
        return text.isEmpty() ? EMPTY : sink -> StringDecomposer.iterate(text, style, sink);
    }

    public static FormattedCharSequence forward(String text, Style style, Int2IntFunction codePointMapper) {
        return text.isEmpty() ? EMPTY : sink -> StringDecomposer.iterate(text, style, FormattedCharSequence.decorateOutput(sink, codePointMapper));
    }

    public static FormattedCharSequence backward(String text, Style style) {
        return text.isEmpty() ? EMPTY : sink -> StringDecomposer.iterateBackwards(text, style, sink);
    }

    public static FormattedCharSequence backward(String text, Style style, Int2IntFunction codePointMapper) {
        return text.isEmpty() ? EMPTY : sink -> StringDecomposer.iterateBackwards(text, style, FormattedCharSequence.decorateOutput(sink, codePointMapper));
    }

    public static FormattedCharSink decorateOutput(FormattedCharSink sink, Int2IntFunction codePointMapper) {
        return (index, style, codePoint) -> sink.accept(index, style, (Integer)codePointMapper.apply((Object)codePoint));
    }

    public static FormattedCharSequence composite() {
        return EMPTY;
    }

    public static FormattedCharSequence composite(FormattedCharSequence sequence) {
        return sequence;
    }

    public static FormattedCharSequence composite(FormattedCharSequence first, FormattedCharSequence second) {
        return FormattedCharSequence.fromPair(first, second);
    }

    public static FormattedCharSequence composite(FormattedCharSequence ... parts) {
        return FormattedCharSequence.fromList((List<FormattedCharSequence>)ImmutableList.copyOf((Object[])parts));
    }

    public static FormattedCharSequence composite(List<FormattedCharSequence> parts) {
        int size = parts.size();
        switch (size) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return parts.get(0);
            }
            case 2: {
                return FormattedCharSequence.fromPair(parts.get(0), parts.get(1));
            }
        }
        return FormattedCharSequence.fromList((List<FormattedCharSequence>)ImmutableList.copyOf(parts));
    }

    public static FormattedCharSequence fromPair(FormattedCharSequence first, FormattedCharSequence second) {
        return sink -> first.accept(sink) && second.accept(sink);
    }

    public static FormattedCharSequence fromList(List<FormattedCharSequence> parts) {
        return sink -> {
            for (FormattedCharSequence formattedCharSequence : parts) {
                if (formattedCharSequence.accept(sink)) continue;
                return false;
            }
            return true;
        };
    }
}

