/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class Graph {
    private Graph() {
    }

    public static <T> boolean depthFirstSearch(Map<T, Set<T>> graph, Set<T> nonCyclicalNodes, Set<T> pathSet, Consumer<T> onNonCyclicalNodeFound, T currentNode) {
        if (nonCyclicalNodes.contains(currentNode)) {
            return false;
        }
        if (pathSet.contains(currentNode)) {
            return true;
        }
        pathSet.add(currentNode);
        for (Object object : (Set)graph.getOrDefault(currentNode, (Set<T>)ImmutableSet.of())) {
            if (!Graph.depthFirstSearch(graph, nonCyclicalNodes, pathSet, onNonCyclicalNodeFound, object)) continue;
            return true;
        }
        pathSet.remove(currentNode);
        nonCyclicalNodes.add(currentNode);
        onNonCyclicalNodeFound.accept(currentNode);
        return false;
    }
}

