/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.CrashReportCategory;
import org.slf4j.Logger;

public class NativeModuleLister {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int LANG_MASK = 65535;
    private static final int DEFAULT_LANG = 1033;
    private static final int CODEPAGE_MASK = -65536;
    private static final int DEFAULT_CODEPAGE = 0x4B00000;

    public static List<NativeModuleInfo> listModules() {
        if (!Platform.isWindows()) {
            return ImmutableList.of();
        }
        int i = Kernel32.INSTANCE.GetCurrentProcessId();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tlhelp32.MODULEENTRY32W moduleentry32w : Kernel32Util.getModules((int)i)) {
            String string = moduleentry32w.szModule();
            Optional<NativeModuleVersion> optional = NativeModuleLister.tryGetVersion(moduleentry32w.szExePath());
            builder.add((Object)new NativeModuleInfo(string, optional));
        }
        return builder.build();
    }

    private static Optional<NativeModuleVersion> tryGetVersion(String filename) {
        try {
            IntByReference intByReference = new IntByReference();
            int i = Version.INSTANCE.GetFileVersionInfoSize(filename, intByReference);
            if (i == 0) {
                int lastError = Native.getLastError();
                if (lastError != 1813 && lastError != 1812) {
                    throw new Win32Exception(lastError);
                }
                return Optional.empty();
            }
            Memory pointer = new Memory((long)i);
            if (!Version.INSTANCE.GetFileVersionInfo(filename, 0, i, (Pointer)pointer)) {
                throw new Win32Exception(Native.getLastError());
            }
            IntByReference intByReference1 = new IntByReference();
            Pointer pointer1 = NativeModuleLister.queryVersionValue((Pointer)pointer, "\\VarFileInfo\\Translation", intByReference1);
            int[] intArray = pointer1.getIntArray(0L, intByReference1.getValue() / 4);
            OptionalInt optionalInt = NativeModuleLister.findLangAndCodepage(intArray);
            if (optionalInt.isEmpty()) {
                return Optional.empty();
            }
            int asInt = optionalInt.getAsInt();
            int i1 = asInt & 0xFFFF;
            int i2 = (asInt & 0xFFFF0000) >> 16;
            String string = NativeModuleLister.queryVersionString((Pointer)pointer, NativeModuleLister.langTableKey("FileDescription", i1, i2), intByReference1);
            String string1 = NativeModuleLister.queryVersionString((Pointer)pointer, NativeModuleLister.langTableKey("CompanyName", i1, i2), intByReference1);
            String string2 = NativeModuleLister.queryVersionString((Pointer)pointer, NativeModuleLister.langTableKey("FileVersion", i1, i2), intByReference1);
            return Optional.of(new NativeModuleVersion(string, string2, string1));
        }
        catch (Exception var14) {
            LOGGER.info("Failed to find module info for {}", (Object)filename, (Object)var14);
            return Optional.empty();
        }
    }

    private static String langTableKey(String key, int lang, int codepage) {
        return String.format(Locale.ROOT, "\\StringFileInfo\\%04x%04x\\%s", lang, codepage, key);
    }

    private static OptionalInt findLangAndCodepage(int[] versionValue) {
        OptionalInt optionalInt = OptionalInt.empty();
        for (int i : versionValue) {
            if ((i & 0xFFFF0000) == 0x4B00000 && (i & 0xFFFF) == 1033) {
                return OptionalInt.of(i);
            }
            optionalInt = OptionalInt.of(i);
        }
        return optionalInt;
    }

    private static Pointer queryVersionValue(Pointer block, String subBlock, IntByReference size) {
        PointerByReference pointerByReference = new PointerByReference();
        if (!Version.INSTANCE.VerQueryValue(block, subBlock, pointerByReference, size)) {
            throw new UnsupportedOperationException("Can't get version value " + subBlock);
        }
        return pointerByReference.getValue();
    }

    private static String queryVersionString(Pointer block, String subBlock, IntByReference size) {
        try {
            Pointer pointer = NativeModuleLister.queryVersionValue(block, subBlock, size);
            byte[] byteArray = pointer.getByteArray(0L, (size.getValue() - 1) * 2);
            return new String(byteArray, StandardCharsets.UTF_16LE);
        }
        catch (Exception var5) {
            return "";
        }
    }

    public static void addCrashSection(CrashReportCategory crashSection) {
        crashSection.setDetail("Modules", () -> NativeModuleLister.listModules().stream().sorted(Comparator.comparing(nativeModuleInfo -> nativeModuleInfo.name)).map(nativeModuleInfo -> "\n\t\t" + String.valueOf(nativeModuleInfo)).collect(Collectors.joining()));
    }

    public static class NativeModuleInfo {
        public final String name;
        public final Optional<NativeModuleVersion> version;

        public NativeModuleInfo(String name, Optional<NativeModuleVersion> version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return this.version.map(nativeModuleVersion -> this.name + ":" + String.valueOf(nativeModuleVersion)).orElse(this.name);
        }
    }

    public static class NativeModuleVersion {
        public final String description;
        public final String version;
        public final String company;

        public NativeModuleVersion(String description, String version, String company) {
            this.description = description;
            this.version = version;
            this.company = company;
        }

        public String toString() {
            return this.description + ":" + this.version + ":" + this.company;
        }
    }
}

