/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Deque;
import javax.annotation.Nullable;

public final class SequencedPriorityIterator<T>
extends AbstractIterator<T> {
    private static final int MIN_PRIO = Integer.MIN_VALUE;
    @Nullable
    private Deque<T> highestPrioQueue = null;
    private int highestPrio = Integer.MIN_VALUE;
    private final Int2ObjectMap<Deque<T>> queuesByPriority = new Int2ObjectOpenHashMap();

    public void add(T value, int priority) {
        if (priority == this.highestPrio && this.highestPrioQueue != null) {
            this.highestPrioQueue.addLast(value);
        } else {
            Deque deque = (Deque)this.queuesByPriority.computeIfAbsent(priority, i -> Queues.newArrayDeque());
            deque.addLast(value);
            if (priority >= this.highestPrio) {
                this.highestPrioQueue = deque;
                this.highestPrio = priority;
            }
        }
    }

    @Nullable
    protected T computeNext() {
        if (this.highestPrioQueue == null) {
            return (T)this.endOfData();
        }
        T object = this.highestPrioQueue.removeFirst();
        if (object == null) {
            return (T)this.endOfData();
        }
        if (this.highestPrioQueue.isEmpty()) {
            this.switchCacheToNextHighestPrioQueue();
        }
        return object;
    }

    private void switchCacheToNextHighestPrioQueue() {
        int i = Integer.MIN_VALUE;
        Deque deque = null;
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.queuesByPriority)) {
            Deque deque1 = (Deque)entry.getValue();
            int intKey = entry.getIntKey();
            if (intKey <= i || deque1.isEmpty()) continue;
            i = intKey;
            deque = deque1;
            if (intKey != this.highestPrio - 1) continue;
            break;
        }
        this.highestPrio = i;
        this.highestPrioQueue = deque;
    }
}

