/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;

public class ExtraDataFixUtils {
    public static Dynamic<?> fixBlockPos(Dynamic<?> data) {
        Optional optional = data.get("X").asNumber().result();
        Optional optional1 = data.get("Y").asNumber().result();
        Optional optional2 = data.get("Z").asNumber().result();
        return !optional.isEmpty() && !optional1.isEmpty() && !optional2.isEmpty() ? ExtraDataFixUtils.createBlockPos(data, ((Number)optional.get()).intValue(), ((Number)optional1.get()).intValue(), ((Number)optional2.get()).intValue()) : data;
    }

    public static Dynamic<?> fixInlineBlockPos(Dynamic<?> data, String xField, String yField, String zField, String newPosField) {
        Optional optional = data.get(xField).asNumber().result();
        Optional optional1 = data.get(yField).asNumber().result();
        Optional optional2 = data.get(zField).asNumber().result();
        return !optional.isEmpty() && !optional1.isEmpty() && !optional2.isEmpty() ? data.remove(xField).remove(yField).remove(zField).set(newPosField, ExtraDataFixUtils.createBlockPos(data, ((Number)optional.get()).intValue(), ((Number)optional1.get()).intValue(), ((Number)optional2.get()).intValue())) : data;
    }

    public static Dynamic<?> createBlockPos(Dynamic<?> data, int x, int y, int z) {
        return data.createIntList(IntStream.of(x, y, z));
    }

    public static <T, R> Typed<R> cast(Type<R> type, Typed<T> data) {
        return new Typed(type, data.getOps(), data.getValue());
    }

    public static <T> Typed<T> cast(Type<T> type, Object data, DynamicOps<?> ops) {
        return new Typed(type, ops, data);
    }

    public static Type<?> patchSubType(Type<?> type, Type<?> oldSubType, Type<?> newSubType) {
        return type.all(ExtraDataFixUtils.typePatcher(oldSubType, newSubType), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> oldType, Type<B> newType) {
        RewriteResult rewriteResult = RewriteResult.create((View)View.create((String)"Patcher", oldType, newType, dynamicOps -> object -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(oldType, (RewriteResult)rewriteResult), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> chainAllFilters(Function<Typed<?>, Typed<?>> ... filters) {
        return typed -> {
            for (Function function : filters) {
                typed = (Typed)function.apply(typed);
            }
            return typed;
        };
    }

    public static Dynamic<?> blockState(String blockId, Map<String, String> properties) {
        Dynamic<CompoundTag> dynamic = new Dynamic<CompoundTag>(NbtOps.INSTANCE, new CompoundTag());
        Dynamic<CompoundTag> dynamic1 = dynamic.set("Name", dynamic.createString(blockId));
        if (!properties.isEmpty()) {
            dynamic1 = dynamic1.set("Properties", dynamic.createMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> dynamic.createString((String)entry.getKey()), entry -> dynamic.createString((String)entry.getValue())))));
        }
        return dynamic1;
    }

    public static Dynamic<?> blockState(String blockId) {
        return ExtraDataFixUtils.blockState(blockId, Map.of());
    }

    public static Dynamic<?> fixStringField(Dynamic<?> data, String fieldName, UnaryOperator<String> fixer) {
        return data.update(fieldName, dynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic.asString().map((Function)fixer).map(arg_0 -> ((Dynamic)data).createString(arg_0)).result(), (Object)dynamic))));
    }

    public static String dyeColorIdToName(int colorId) {
        return switch (colorId) {
            case 1 -> "orange";
            case 2 -> "magenta";
            case 3 -> "light_blue";
            case 4 -> "yellow";
            case 5 -> "lime";
            case 6 -> "pink";
            case 7 -> "gray";
            case 8 -> "light_gray";
            case 9 -> "cyan";
            case 10 -> "purple";
            case 11 -> "blue";
            case 12 -> "brown";
            case 13 -> "green";
            case 14 -> "red";
            case 15 -> "black";
            default -> "white";
        };
    }

    public static <T> Typed<?> readAndSet(Typed<?> typed, OpticFinder<T> optic, Dynamic<?> data) {
        return typed.set(optic, Util.readTypedOrThrow(optic.type(), data, true));
    }
}

