/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class FurnaceRecipeFix
extends DataFix {
    public FurnaceRecipeFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        return this.cap(this.getOutputSchema().getTypeRaw(References.RECIPE));
    }

    private <R> TypeRewriteRule cap(Type<R> type) {
        Type type1 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"RecipesUsed", (Type)DSL.and((Type)DSL.compoundList(type, (Type)DSL.intType()), (Type)DSL.remainderType()))), (Type)DSL.remainderType());
        OpticFinder opticFinder = DSL.namedChoice((String)"minecraft:furnace", (Type)this.getInputSchema().getChoiceType(References.BLOCK_ENTITY, "minecraft:furnace"));
        OpticFinder opticFinder1 = DSL.namedChoice((String)"minecraft:blast_furnace", (Type)this.getInputSchema().getChoiceType(References.BLOCK_ENTITY, "minecraft:blast_furnace"));
        OpticFinder opticFinder2 = DSL.namedChoice((String)"minecraft:smoker", (Type)this.getInputSchema().getChoiceType(References.BLOCK_ENTITY, "minecraft:smoker"));
        Type choiceType = this.getOutputSchema().getChoiceType(References.BLOCK_ENTITY, "minecraft:furnace");
        Type choiceType1 = this.getOutputSchema().getChoiceType(References.BLOCK_ENTITY, "minecraft:blast_furnace");
        Type choiceType2 = this.getOutputSchema().getChoiceType(References.BLOCK_ENTITY, "minecraft:smoker");
        Type type2 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type type3 = this.getOutputSchema().getType(References.BLOCK_ENTITY);
        return this.fixTypeEverywhereTyped("FurnaceRecipesFix", type2, type3, typed -> typed.updateTyped(opticFinder, choiceType, typed1 -> this.updateFurnaceContents(type, (Type)type1, (Typed<?>)typed1)).updateTyped(opticFinder1, choiceType1, typed1 -> this.updateFurnaceContents(type, (Type)type1, (Typed<?>)typed1)).updateTyped(opticFinder2, choiceType2, typed1 -> this.updateFurnaceContents(type, (Type)type1, (Typed<?>)typed1)));
    }

    private <R> Typed<?> updateFurnaceContents(Type<R> type, Type<Pair<Either<Pair<List<Pair<R, Integer>>, Dynamic<?>>, Unit>, Dynamic<?>>> recipesUsed, Typed<?> data) {
        Dynamic dynamic = (Dynamic)((Object)data.getOrCreate(DSL.remainderFinder()));
        int _int = dynamic.get("RecipesUsedSize").asInt(0);
        dynamic = dynamic.remove("RecipesUsedSize");
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < _int; ++i) {
            String string = "RecipeLocation" + i;
            String string1 = "RecipeAmount" + i;
            Optional optional = dynamic.get(string).result();
            int _int1 = dynamic.get(string1).asInt(0);
            if (_int1 > 0) {
                optional.ifPresent(dynamic1 -> {
                    Optional optional1 = type.read(dynamic1).result();
                    optional1.ifPresent(pair -> list.add(Pair.of((Object)pair.getFirst(), (Object)_int1)));
                });
            }
            dynamic = dynamic.remove(string).remove(string1);
        }
        return data.set(DSL.remainderFinder(), recipesUsed, (Object)Pair.of(Either.left(Pair.of((Object)list, (Object)((Object)dynamic.emptyMap()))), dynamic));
    }
}

